<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketFeeDetail StructType
 * Meta information extracted from the WSDL
 * - documentation: The currency code for all of the ticketing fees. | The ticket fee information for this passsenger type code.
 * @subpackage Structs
 */
class TicketFeeDetail extends AbstractStructBase
{
    /**
     * The Fee
     * Meta information extracted from the WSDL
     * - maxOccurs: 9
     * @var \StructType\Fee[]
     */
    public $Fee;
    /**
     * The Total
     * Meta information extracted from the WSDL
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \StructType\Total[]
     */
    public $Total;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - documentation: Used for an Alpha String, length exactly 3.
     * - base: xs:string
     * - pattern: [a-zA-Z]{3}
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DecimalPlaces
     * @var int
     */
    public $DecimalPlaces;
    /**
     * Constructor method for TicketFeeDetail
     * @uses TicketFeeDetail::setFee()
     * @uses TicketFeeDetail::setTotal()
     * @uses TicketFeeDetail::setCurrencyCode()
     * @uses TicketFeeDetail::setDecimalPlaces()
     * @param \StructType\Fee[] $fee
     * @param \StructType\Total[] $total
     * @param string $currencyCode
     * @param int $decimalPlaces
     */
    public function __construct(array $fee = array(), array $total = array(), $currencyCode = null, $decimalPlaces = null)
    {
        $this
            ->setFee($fee)
            ->setTotal($total)
            ->setCurrencyCode($currencyCode)
            ->setDecimalPlaces($decimalPlaces);
    }
    /**
     * Get Fee value
     * @return \StructType\Fee[]|null
     */
    public function getFee()
    {
        return $this->Fee;
    }
    /**
     * This method is responsible for validating the values passed to the setFee method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFee method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFeeForArrayConstraintsFromSetFee(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ticketFeeDetailFeeItem) {
            // validation for constraint: itemType
            if (!$ticketFeeDetailFeeItem instanceof \StructType\Fee) {
                $invalidValues[] = is_object($ticketFeeDetailFeeItem) ? get_class($ticketFeeDetailFeeItem) : sprintf('%s(%s)', gettype($ticketFeeDetailFeeItem), var_export($ticketFeeDetailFeeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Fee property can only contain items of type \StructType\Fee, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Fee value
     * @throws \InvalidArgumentException
     * @param \StructType\Fee[] $fee
     * @return \StructType\TicketFeeDetail
     */
    public function setFee(array $fee = array())
    {
        // validation for constraint: array
        if ('' !== ($feeArrayErrorMessage = self::validateFeeForArrayConstraintsFromSetFee($fee))) {
            throw new \InvalidArgumentException($feeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($fee) && count($fee) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($fee)), __LINE__);
        }
        $this->Fee = $fee;
        return $this;
    }
    /**
     * Add item to Fee value
     * @throws \InvalidArgumentException
     * @param \StructType\Fee $item
     * @return \StructType\TicketFeeDetail
     */
    public function addToFee(\StructType\Fee $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Fee) {
            throw new \InvalidArgumentException(sprintf('The Fee property can only contain items of type \StructType\Fee, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->Fee) && count($this->Fee) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->Fee)), __LINE__);
        }
        $this->Fee[] = $item;
        return $this;
    }
    /**
     * Get Total value
     * @return \StructType\Total[]|null
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * This method is responsible for validating the values passed to the setTotal method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTotal method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTotalForArrayConstraintsFromSetTotal(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ticketFeeDetailTotalItem) {
            // validation for constraint: itemType
            if (!$ticketFeeDetailTotalItem instanceof \StructType\Total) {
                $invalidValues[] = is_object($ticketFeeDetailTotalItem) ? get_class($ticketFeeDetailTotalItem) : sprintf('%s(%s)', gettype($ticketFeeDetailTotalItem), var_export($ticketFeeDetailTotalItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Total property can only contain items of type \StructType\Total, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Total value
     * @throws \InvalidArgumentException
     * @param \StructType\Total[] $total
     * @return \StructType\TicketFeeDetail
     */
    public function setTotal(array $total = array())
    {
        // validation for constraint: array
        if ('' !== ($totalArrayErrorMessage = self::validateTotalForArrayConstraintsFromSetTotal($total))) {
            throw new \InvalidArgumentException($totalArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($total) && count($total) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($total)), __LINE__);
        }
        $this->Total = $total;
        return $this;
    }
    /**
     * Add item to Total value
     * @throws \InvalidArgumentException
     * @param \StructType\Total $item
     * @return \StructType\TicketFeeDetail
     */
    public function addToTotal(\StructType\Total $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Total) {
            throw new \InvalidArgumentException(sprintf('The Total property can only contain items of type \StructType\Total, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->Total) && count($this->Total) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->Total)), __LINE__);
        }
        $this->Total[] = $item;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\TicketFeeDetail
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z]{3})
        if (!is_null($currencyCode) && !preg_match('/[a-zA-Z]{3}/', $currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z]{3}', var_export($currencyCode, true)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get DecimalPlaces value
     * @return int|null
     */
    public function getDecimalPlaces()
    {
        return $this->DecimalPlaces;
    }
    /**
     * Set DecimalPlaces value
     * @param int $decimalPlaces
     * @return \StructType\TicketFeeDetail
     */
    public function setDecimalPlaces($decimalPlaces = null)
    {
        // validation for constraint: int
        if (!is_null($decimalPlaces) && !(is_int($decimalPlaces) || ctype_digit($decimalPlaces))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($decimalPlaces, true), gettype($decimalPlaces)), __LINE__);
        }
        $this->DecimalPlaces = $decimalPlaces;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TicketFeeDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
