<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketDesignator StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains the discount code and a flight reference applicable to the fare.
 * @subpackage Structs
 */
class TicketDesignator extends AbstractStructBase
{
    /**
     * The FlightRefRPH
     * Meta information extracted from the WSDL
     * - documentation: Identifies the flight to which this ticket designator applies. | The Reference Place Holder (RPH) is an index code used to identify an instance in a collection of like items (e.g. used to assign individual passengers or clients to
     * particular itinerary items).
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string
     */
    public $FlightRefRPH;
    /**
     * The TicketDesignatorCode
     * Meta information extracted from the WSDL
     * - documentation: Specifies a discount code applicable to the fare. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $TicketDesignatorCode;
    /**
     * The TicketDesignatorExtension
     * Meta information extracted from the WSDL
     * - documentation: Specifies an extension that a carrier may apply to a ticket designator. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $TicketDesignatorExtension;
    /**
     * Constructor method for TicketDesignator
     * @uses TicketDesignator::setFlightRefRPH()
     * @uses TicketDesignator::setTicketDesignatorCode()
     * @uses TicketDesignator::setTicketDesignatorExtension()
     * @param string $flightRefRPH
     * @param string $ticketDesignatorCode
     * @param string $ticketDesignatorExtension
     */
    public function __construct($flightRefRPH = null, $ticketDesignatorCode = null, $ticketDesignatorExtension = null)
    {
        $this
            ->setFlightRefRPH($flightRefRPH)
            ->setTicketDesignatorCode($ticketDesignatorCode)
            ->setTicketDesignatorExtension($ticketDesignatorExtension);
    }
    /**
     * Get FlightRefRPH value
     * @return string|null
     */
    public function getFlightRefRPH()
    {
        return $this->FlightRefRPH;
    }
    /**
     * Set FlightRefRPH value
     * @param string $flightRefRPH
     * @return \StructType\TicketDesignator
     */
    public function setFlightRefRPH($flightRefRPH = null)
    {
        // validation for constraint: string
        if (!is_null($flightRefRPH) && !is_string($flightRefRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flightRefRPH, true), gettype($flightRefRPH)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($flightRefRPH) && !preg_match('/[0-9]{1,8}/', $flightRefRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($flightRefRPH, true)), __LINE__);
        }
        $this->FlightRefRPH = $flightRefRPH;
        return $this;
    }
    /**
     * Get TicketDesignatorCode value
     * @return string|null
     */
    public function getTicketDesignatorCode()
    {
        return $this->TicketDesignatorCode;
    }
    /**
     * Set TicketDesignatorCode value
     * @param string $ticketDesignatorCode
     * @return \StructType\TicketDesignator
     */
    public function setTicketDesignatorCode($ticketDesignatorCode = null)
    {
        // validation for constraint: string
        if (!is_null($ticketDesignatorCode) && !is_string($ticketDesignatorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketDesignatorCode, true), gettype($ticketDesignatorCode)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($ticketDesignatorCode) && mb_strlen($ticketDesignatorCode) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($ticketDesignatorCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($ticketDesignatorCode) && mb_strlen($ticketDesignatorCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($ticketDesignatorCode)), __LINE__);
        }
        $this->TicketDesignatorCode = $ticketDesignatorCode;
        return $this;
    }
    /**
     * Get TicketDesignatorExtension value
     * @return string|null
     */
    public function getTicketDesignatorExtension()
    {
        return $this->TicketDesignatorExtension;
    }
    /**
     * Set TicketDesignatorExtension value
     * @param string $ticketDesignatorExtension
     * @return \StructType\TicketDesignator
     */
    public function setTicketDesignatorExtension($ticketDesignatorExtension = null)
    {
        // validation for constraint: string
        if (!is_null($ticketDesignatorExtension) && !is_string($ticketDesignatorExtension)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketDesignatorExtension, true), gettype($ticketDesignatorExtension)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($ticketDesignatorExtension) && mb_strlen($ticketDesignatorExtension) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($ticketDesignatorExtension)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($ticketDesignatorExtension) && mb_strlen($ticketDesignatorExtension) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($ticketDesignatorExtension)), __LINE__);
        }
        $this->TicketDesignatorExtension = $ticketDesignatorExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TicketDesignator
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
