<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticket StructType
 * Meta information extracted from the WSDL
 * - documentation: Details of a ticket to be exchanged.
 * @subpackage Structs
 */
class Ticket extends AbstractStructBase
{
    /**
     * The ConjunctionTicketNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 16
     * - minOccurs: 0
     * @var \StructType\ConjunctionTicketNbr[]
     */
    public $ConjunctionTicketNbr;
    /**
     * The TicketNumber
     * Meta information extracted from the WSDL
     * - documentation: The ticket number which is exchanged. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $TicketNumber;
    /**
     * The ReroutingType
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ReroutingType;
    /**
     * The ReasonForReroute
     * Meta information extracted from the WSDL
     * - documentation: Gives more information about the rerouting. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $ReasonForReroute;
    /**
     * The OriginalTicketNumber
     * Meta information extracted from the WSDL
     * - documentation: The original ticket number in a series if reissuances. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - type: StringLength1to32
     * - use: optional
     * @var string
     */
    public $OriginalTicketNumber;
    /**
     * The OriginalIssuePlace
     * Meta information extracted from the WSDL
     * - documentation: Place where the original ticket was issued. | Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - type: StringLength1to8
     * - use: optional
     * @var string
     */
    public $OriginalIssuePlace;
    /**
     * The OriginalIssueDate
     * Meta information extracted from the WSDL
     * - documentation: Date when the original ticket was issued.
     * - type: xs:date
     * - use: optional
     * @var string
     */
    public $OriginalIssueDate;
    /**
     * The OriginalIssueIATA
     * Meta information extracted from the WSDL
     * - documentation: IATA office number, which issued original ticket. | Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - type: StringLength1to8
     * - use: optional
     * @var string
     */
    public $OriginalIssueIATA;
    /**
     * The OriginalPaymentForm
     * Meta information extracted from the WSDL
     * - documentation: Payment type for the original ticket. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - type: StringLength1to64
     * - use: optional
     * @var string
     */
    public $OriginalPaymentForm;
    /**
     * The CheckInhibitorType
     * @var string
     */
    public $CheckInhibitorType;
    /**
     * The CouponRPHs
     * Meta information extracted from the WSDL
     * - documentation: Gives a list of references to coupon numbers of the ticket which will be taken for payment. | The Reference Place Holder (RPH) is an index code used to identify an instance in a collection of like items (e.g. used to assign
     * individual passengers or clients to particular itinerary items). | List of Reference Place Holders.
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - type: ListOfRPH
     * - use: optional
     * @var string[]
     */
    public $CouponRPHs;
    /**
     * Constructor method for Ticket
     * @uses Ticket::setConjunctionTicketNbr()
     * @uses Ticket::setTicketNumber()
     * @uses Ticket::setReroutingType()
     * @uses Ticket::setReasonForReroute()
     * @uses Ticket::setOriginalTicketNumber()
     * @uses Ticket::setOriginalIssuePlace()
     * @uses Ticket::setOriginalIssueDate()
     * @uses Ticket::setOriginalIssueIATA()
     * @uses Ticket::setOriginalPaymentForm()
     * @uses Ticket::setCheckInhibitorType()
     * @uses Ticket::setCouponRPHs()
     * @param \StructType\ConjunctionTicketNbr[] $conjunctionTicketNbr
     * @param string $ticketNumber
     * @param string $reroutingType
     * @param string $reasonForReroute
     * @param string $originalTicketNumber
     * @param string $originalIssuePlace
     * @param string $originalIssueDate
     * @param string $originalIssueIATA
     * @param string $originalPaymentForm
     * @param string $checkInhibitorType
     * @param string[] $couponRPHs
     */
    public function __construct(array $conjunctionTicketNbr = array(), $ticketNumber = null, $reroutingType = null, $reasonForReroute = null, $originalTicketNumber = null, $originalIssuePlace = null, $originalIssueDate = null, $originalIssueIATA = null, $originalPaymentForm = null, $checkInhibitorType = null, array $couponRPHs = array())
    {
        $this
            ->setConjunctionTicketNbr($conjunctionTicketNbr)
            ->setTicketNumber($ticketNumber)
            ->setReroutingType($reroutingType)
            ->setReasonForReroute($reasonForReroute)
            ->setOriginalTicketNumber($originalTicketNumber)
            ->setOriginalIssuePlace($originalIssuePlace)
            ->setOriginalIssueDate($originalIssueDate)
            ->setOriginalIssueIATA($originalIssueIATA)
            ->setOriginalPaymentForm($originalPaymentForm)
            ->setCheckInhibitorType($checkInhibitorType)
            ->setCouponRPHs($couponRPHs);
    }
    /**
     * Get ConjunctionTicketNbr value
     * @return \StructType\ConjunctionTicketNbr[]|null
     */
    public function getConjunctionTicketNbr()
    {
        return $this->ConjunctionTicketNbr;
    }
    /**
     * This method is responsible for validating the values passed to the setConjunctionTicketNbr method
     * This method is willingly generated in order to preserve the one-line inline validation within the setConjunctionTicketNbr method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateConjunctionTicketNbrForArrayConstraintsFromSetConjunctionTicketNbr(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ticketConjunctionTicketNbrItem) {
            // validation for constraint: itemType
            if (!$ticketConjunctionTicketNbrItem instanceof \StructType\ConjunctionTicketNbr) {
                $invalidValues[] = is_object($ticketConjunctionTicketNbrItem) ? get_class($ticketConjunctionTicketNbrItem) : sprintf('%s(%s)', gettype($ticketConjunctionTicketNbrItem), var_export($ticketConjunctionTicketNbrItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ConjunctionTicketNbr property can only contain items of type \StructType\ConjunctionTicketNbr, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ConjunctionTicketNbr value
     * @throws \InvalidArgumentException
     * @param \StructType\ConjunctionTicketNbr[] $conjunctionTicketNbr
     * @return \StructType\Ticket
     */
    public function setConjunctionTicketNbr(array $conjunctionTicketNbr = array())
    {
        // validation for constraint: array
        if ('' !== ($conjunctionTicketNbrArrayErrorMessage = self::validateConjunctionTicketNbrForArrayConstraintsFromSetConjunctionTicketNbr($conjunctionTicketNbr))) {
            throw new \InvalidArgumentException($conjunctionTicketNbrArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(16)
        if (is_array($conjunctionTicketNbr) && count($conjunctionTicketNbr) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 16', count($conjunctionTicketNbr)), __LINE__);
        }
        $this->ConjunctionTicketNbr = $conjunctionTicketNbr;
        return $this;
    }
    /**
     * Add item to ConjunctionTicketNbr value
     * @throws \InvalidArgumentException
     * @param \StructType\ConjunctionTicketNbr $item
     * @return \StructType\Ticket
     */
    public function addToConjunctionTicketNbr(\StructType\ConjunctionTicketNbr $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ConjunctionTicketNbr) {
            throw new \InvalidArgumentException(sprintf('The ConjunctionTicketNbr property can only contain items of type \StructType\ConjunctionTicketNbr, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(16)
        if (is_array($this->ConjunctionTicketNbr) && count($this->ConjunctionTicketNbr) >= 16) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 16', count($this->ConjunctionTicketNbr)), __LINE__);
        }
        $this->ConjunctionTicketNbr[] = $item;
        return $this;
    }
    /**
     * Get TicketNumber value
     * @return string|null
     */
    public function getTicketNumber()
    {
        return $this->TicketNumber;
    }
    /**
     * Set TicketNumber value
     * @param string $ticketNumber
     * @return \StructType\Ticket
     */
    public function setTicketNumber($ticketNumber = null)
    {
        // validation for constraint: string
        if (!is_null($ticketNumber) && !is_string($ticketNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketNumber, true), gettype($ticketNumber)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($ticketNumber) && mb_strlen($ticketNumber) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($ticketNumber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($ticketNumber) && mb_strlen($ticketNumber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($ticketNumber)), __LINE__);
        }
        $this->TicketNumber = $ticketNumber;
        return $this;
    }
    /**
     * Get ReroutingType value
     * @return string|null
     */
    public function getReroutingType()
    {
        return $this->ReroutingType;
    }
    /**
     * Set ReroutingType value
     * @param string $reroutingType
     * @return \StructType\Ticket
     */
    public function setReroutingType($reroutingType = null)
    {
        // validation for constraint: string
        if (!is_null($reroutingType) && !is_string($reroutingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reroutingType, true), gettype($reroutingType)), __LINE__);
        }
        $this->ReroutingType = $reroutingType;
        return $this;
    }
    /**
     * Get ReasonForReroute value
     * @return string|null
     */
    public function getReasonForReroute()
    {
        return $this->ReasonForReroute;
    }
    /**
     * Set ReasonForReroute value
     * @param string $reasonForReroute
     * @return \StructType\Ticket
     */
    public function setReasonForReroute($reasonForReroute = null)
    {
        // validation for constraint: string
        if (!is_null($reasonForReroute) && !is_string($reasonForReroute)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reasonForReroute, true), gettype($reasonForReroute)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($reasonForReroute) && mb_strlen($reasonForReroute) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($reasonForReroute)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($reasonForReroute) && mb_strlen($reasonForReroute) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($reasonForReroute)), __LINE__);
        }
        $this->ReasonForReroute = $reasonForReroute;
        return $this;
    }
    /**
     * Get OriginalTicketNumber value
     * @return string|null
     */
    public function getOriginalTicketNumber()
    {
        return $this->OriginalTicketNumber;
    }
    /**
     * Set OriginalTicketNumber value
     * @param string $originalTicketNumber
     * @return \StructType\Ticket
     */
    public function setOriginalTicketNumber($originalTicketNumber = null)
    {
        // validation for constraint: string
        if (!is_null($originalTicketNumber) && !is_string($originalTicketNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalTicketNumber, true), gettype($originalTicketNumber)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($originalTicketNumber) && mb_strlen($originalTicketNumber) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($originalTicketNumber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($originalTicketNumber) && mb_strlen($originalTicketNumber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($originalTicketNumber)), __LINE__);
        }
        $this->OriginalTicketNumber = $originalTicketNumber;
        return $this;
    }
    /**
     * Get OriginalIssuePlace value
     * @return string|null
     */
    public function getOriginalIssuePlace()
    {
        return $this->OriginalIssuePlace;
    }
    /**
     * Set OriginalIssuePlace value
     * @param string $originalIssuePlace
     * @return \StructType\Ticket
     */
    public function setOriginalIssuePlace($originalIssuePlace = null)
    {
        // validation for constraint: string
        if (!is_null($originalIssuePlace) && !is_string($originalIssuePlace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalIssuePlace, true), gettype($originalIssuePlace)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($originalIssuePlace) && mb_strlen($originalIssuePlace) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($originalIssuePlace)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($originalIssuePlace) && mb_strlen($originalIssuePlace) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($originalIssuePlace)), __LINE__);
        }
        $this->OriginalIssuePlace = $originalIssuePlace;
        return $this;
    }
    /**
     * Get OriginalIssueDate value
     * @return string|null
     */
    public function getOriginalIssueDate()
    {
        return $this->OriginalIssueDate;
    }
    /**
     * Set OriginalIssueDate value
     * @param string $originalIssueDate
     * @return \StructType\Ticket
     */
    public function setOriginalIssueDate($originalIssueDate = null)
    {
        // validation for constraint: string
        if (!is_null($originalIssueDate) && !is_string($originalIssueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalIssueDate, true), gettype($originalIssueDate)), __LINE__);
        }
        $this->OriginalIssueDate = $originalIssueDate;
        return $this;
    }
    /**
     * Get OriginalIssueIATA value
     * @return string|null
     */
    public function getOriginalIssueIATA()
    {
        return $this->OriginalIssueIATA;
    }
    /**
     * Set OriginalIssueIATA value
     * @param string $originalIssueIATA
     * @return \StructType\Ticket
     */
    public function setOriginalIssueIATA($originalIssueIATA = null)
    {
        // validation for constraint: string
        if (!is_null($originalIssueIATA) && !is_string($originalIssueIATA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalIssueIATA, true), gettype($originalIssueIATA)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($originalIssueIATA) && mb_strlen($originalIssueIATA) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($originalIssueIATA)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($originalIssueIATA) && mb_strlen($originalIssueIATA) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($originalIssueIATA)), __LINE__);
        }
        $this->OriginalIssueIATA = $originalIssueIATA;
        return $this;
    }
    /**
     * Get OriginalPaymentForm value
     * @return string|null
     */
    public function getOriginalPaymentForm()
    {
        return $this->OriginalPaymentForm;
    }
    /**
     * Set OriginalPaymentForm value
     * @param string $originalPaymentForm
     * @return \StructType\Ticket
     */
    public function setOriginalPaymentForm($originalPaymentForm = null)
    {
        // validation for constraint: string
        if (!is_null($originalPaymentForm) && !is_string($originalPaymentForm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalPaymentForm, true), gettype($originalPaymentForm)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($originalPaymentForm) && mb_strlen($originalPaymentForm) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($originalPaymentForm)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($originalPaymentForm) && mb_strlen($originalPaymentForm) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($originalPaymentForm)), __LINE__);
        }
        $this->OriginalPaymentForm = $originalPaymentForm;
        return $this;
    }
    /**
     * Get CheckInhibitorType value
     * @return string|null
     */
    public function getCheckInhibitorType()
    {
        return $this->CheckInhibitorType;
    }
    /**
     * Set CheckInhibitorType value
     * @param string $checkInhibitorType
     * @return \StructType\Ticket
     */
    public function setCheckInhibitorType($checkInhibitorType = null)
    {
        // validation for constraint: string
        if (!is_null($checkInhibitorType) && !is_string($checkInhibitorType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkInhibitorType, true), gettype($checkInhibitorType)), __LINE__);
        }
        $this->CheckInhibitorType = $checkInhibitorType;
        return $this;
    }
    /**
     * Get CouponRPHs value
     * @return string[]|null
     */
    public function getCouponRPHs()
    {
        return $this->CouponRPHs;
    }
    /**
     * This method is responsible for validating the values passed to the setCouponRPHs method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCouponRPHs method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCouponRPHsForArrayConstraintsFromSetCouponRPHs(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ticketCouponRPHsItem) {
            // validation for constraint: itemType
            if (!is_string($ticketCouponRPHsItem)) {
                $invalidValues[] = is_object($ticketCouponRPHsItem) ? get_class($ticketCouponRPHsItem) : sprintf('%s(%s)', gettype($ticketCouponRPHsItem), var_export($ticketCouponRPHsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CouponRPHs property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CouponRPHs value
     * @param string[] $couponRPHs
     * @return \StructType\Ticket
     */
    public function setCouponRPHs(array $couponRPHs = array())
    {
        // validation for constraint: list
        if ('' !== ($couponRPHsArrayErrorMessage = self::validateCouponRPHsForArrayConstraintsFromSetCouponRPHs($couponRPHs))) {
            throw new \InvalidArgumentException($couponRPHsArrayErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($couponRPHs) && !preg_match('/[0-9]{1,8}/', $couponRPHs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($couponRPHs, true)), __LINE__);
        }
        $this->CouponRPHs = is_array($couponRPHs) ? implode(' ', $couponRPHs) : null;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Ticket
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
