<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TextDescriptionType StructType
 * Meta information extracted from the WSDL
 * - documentation: Generic information about the text multimedia item. | Describes a text item.
 * @subpackage Structs
 */
class TextDescriptionType extends AbstractStructBase
{
    /**
     * The URL
     * Meta information extracted from the WSDL
     * - documentation: The URL for a specific text item.
     * - choice: URL | Description
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $URL;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - choice: URL | Description
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Description[]
     */
    public $Description;
    /**
     * The Category
     * Meta information extracted from the WSDL
     * - documentation: Specifies the text category. Refer to OpenTravel Code list Picture Category Code (PIC). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string
     */
    public $Category;
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - documentation: The language of the text item.
     * - use: optional
     * @var string
     */
    public $Language;
    /**
     * The ContentID
     * Meta information extracted from the WSDL
     * - documentation: The content ID of a file attachment with the prefix 'cid:'. The value of this can be used to retrieve the corresponding attachment by the receiving system. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - type: StringLength1to64
     * - use: optional
     * @var string
     */
    public $ContentID;
    /**
     * The Title
     * Meta information extracted from the WSDL
     * - documentation: The title of the multimedia object. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - type: StringLength1to64
     * - use: optional
     * @var string
     */
    public $Title;
    /**
     * The Author
     * Meta information extracted from the WSDL
     * - documentation: The author of the multimedia object. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - type: StringLength1to64
     * - use: optional
     * @var string
     */
    public $Author;
    /**
     * The CopyrightNotice
     * Meta information extracted from the WSDL
     * - documentation: A copyright notice for the multimedia object. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - type: StringLength1to64
     * - use: optional
     * @var string
     */
    public $CopyrightNotice;
    /**
     * The CopyrightOwner
     * Meta information extracted from the WSDL
     * - documentation: Owner of the copyright for the multimedia content. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - type: StringLength1to64
     * - use: optional
     * @var string
     */
    public $CopyrightOwner;
    /**
     * The CopyrightStart
     * Meta information extracted from the WSDL
     * - documentation: The start date for which the multimedia content rights are claimed. | A construct to validate either a date or a dateTime value.
     * - type: DateOrDateTimeType
     * - union: date | dateTime
     * - use: optional
     * @var string
     */
    public $CopyrightStart;
    /**
     * The CopyrightEnd
     * Meta information extracted from the WSDL
     * - documentation: The end date for which the multimedia content rights are claimed. | A construct to validate either a date or a dateTime value.
     * - type: DateOrDateTimeType
     * - union: date | dateTime
     * - use: optional
     * @var string
     */
    public $CopyrightEnd;
    /**
     * The EffectiveStart
     * Meta information extracted from the WSDL
     * - documentation: The start date for which the content is considered valid. | A construct to validate either a date or a dateTime value.
     * - type: DateOrDateTimeType
     * - union: date | dateTime
     * - use: optional
     * @var string
     */
    public $EffectiveStart;
    /**
     * The EffectiveEnd
     * Meta information extracted from the WSDL
     * - documentation: The end date for which the content is considered valid. | A construct to validate either a date or a dateTime value.
     * - type: DateOrDateTimeType
     * - union: date | dateTime
     * - use: optional
     * @var string
     */
    public $EffectiveEnd;
    /**
     * The ApplicableStart
     * Meta information extracted from the WSDL
     * - documentation: Start month and day or date for which the multimedia content is relevent (e.g. the start of a season or the start of an event). When a year is not used (i.e. only the month and day) it signifies a recurring event. | A construct to
     * validate either a date or a month and day value.
     * - type: DateOrMonthDay
     * - union: date | gMonthDay
     * - use: optional
     * @var string
     */
    public $ApplicableStart;
    /**
     * The ApplicableEnd
     * Meta information extracted from the WSDL
     * - documentation: End month and day or date for which the multimedia content is relevent (e.g. the end of a season or the start of an event). When a year is not used (i.e. only the month and day) it signifies a recurring event. | A construct to
     * validate either a date or a month and day value.
     * - type: DateOrMonthDay
     * - union: date | gMonthDay
     * - use: optional
     * @var string
     */
    public $ApplicableEnd;
    /**
     * The RecordID
     * Meta information extracted from the WSDL
     * - documentation: Uniquely identifies this file in the message. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - type: StringLength1to32
     * - use: optional
     * @var string
     */
    public $RecordID;
    /**
     * The SourceID
     * Meta information extracted from the WSDL
     * - documentation: Unique identifier for the source of the multimedia object (e.g., the original image file). | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - type: StringLength1to32
     * - use: optional
     * @var string
     */
    public $SourceID;
    /**
     * Constructor method for TextDescriptionType
     * @uses TextDescriptionType::setURL()
     * @uses TextDescriptionType::setDescription()
     * @uses TextDescriptionType::setCategory()
     * @uses TextDescriptionType::setLanguage()
     * @uses TextDescriptionType::setContentID()
     * @uses TextDescriptionType::setTitle()
     * @uses TextDescriptionType::setAuthor()
     * @uses TextDescriptionType::setCopyrightNotice()
     * @uses TextDescriptionType::setCopyrightOwner()
     * @uses TextDescriptionType::setCopyrightStart()
     * @uses TextDescriptionType::setCopyrightEnd()
     * @uses TextDescriptionType::setEffectiveStart()
     * @uses TextDescriptionType::setEffectiveEnd()
     * @uses TextDescriptionType::setApplicableStart()
     * @uses TextDescriptionType::setApplicableEnd()
     * @uses TextDescriptionType::setRecordID()
     * @uses TextDescriptionType::setSourceID()
     * @param string $uRL
     * @param \StructType\Description[] $description
     * @param string $category
     * @param string $language
     * @param string $contentID
     * @param string $title
     * @param string $author
     * @param string $copyrightNotice
     * @param string $copyrightOwner
     * @param string $copyrightStart
     * @param string $copyrightEnd
     * @param string $effectiveStart
     * @param string $effectiveEnd
     * @param string $applicableStart
     * @param string $applicableEnd
     * @param string $recordID
     * @param string $sourceID
     */
    public function __construct($uRL = null, array $description = array(), $category = null, $language = null, $contentID = null, $title = null, $author = null, $copyrightNotice = null, $copyrightOwner = null, $copyrightStart = null, $copyrightEnd = null, $effectiveStart = null, $effectiveEnd = null, $applicableStart = null, $applicableEnd = null, $recordID = null, $sourceID = null)
    {
        $this
            ->setURL($uRL)
            ->setDescription($description)
            ->setCategory($category)
            ->setLanguage($language)
            ->setContentID($contentID)
            ->setTitle($title)
            ->setAuthor($author)
            ->setCopyrightNotice($copyrightNotice)
            ->setCopyrightOwner($copyrightOwner)
            ->setCopyrightStart($copyrightStart)
            ->setCopyrightEnd($copyrightEnd)
            ->setEffectiveStart($effectiveStart)
            ->setEffectiveEnd($effectiveEnd)
            ->setApplicableStart($applicableStart)
            ->setApplicableEnd($applicableEnd)
            ->setRecordID($recordID)
            ->setSourceID($sourceID);
    }
    /**
     * Get URL value
     * @return string|null
     */
    public function getURL()
    {
        return isset($this->URL) ? $this->URL : null;
    }
    /**
     * This method is responsible for validating the value passed to the setURL method
     * This method is willingly generated in order to preserve the one-line inline validation within the setURL method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateURLForChoiceConstraintsFromSetURL($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Description',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property URL can\'t be set as the property %s is already set. Only one property must be set among these properties: URL, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set URL value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $uRL
     * @return \StructType\TextDescriptionType
     */
    public function setURL($uRL = null)
    {
        // validation for constraint: string
        if (!is_null($uRL) && !is_string($uRL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uRL, true), gettype($uRL)), __LINE__);
        }
        // validation for constraint: choice(URL, Description)
        if ('' !== ($uRLChoiceErrorMessage = self::validateURLForChoiceConstraintsFromSetURL($uRL))) {
            throw new \InvalidArgumentException($uRLChoiceErrorMessage, __LINE__);
        }
        if (is_null($uRL) || (is_array($uRL) && empty($uRL))) {
            unset($this->URL);
        } else {
            $this->URL = $uRL;
        }
        return $this;
    }
    /**
     * Get Description value
     * @return \StructType\Description[]|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $textDescriptionTypeDescriptionItem) {
            // validation for constraint: itemType
            if (!$textDescriptionTypeDescriptionItem instanceof \StructType\Description) {
                $invalidValues[] = is_object($textDescriptionTypeDescriptionItem) ? get_class($textDescriptionTypeDescriptionItem) : sprintf('%s(%s)', gettype($textDescriptionTypeDescriptionItem), var_export($textDescriptionTypeDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Description property can only contain items of type \StructType\Description, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDescriptionForChoiceConstraintsFromSetDescription($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'URL',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Description can\'t be set as the property %s is already set. Only one property must be set among these properties: Description, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Description value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\Description[] $description
     * @return \StructType\TextDescriptionType
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(URL, Description)
        if ('' !== ($descriptionChoiceErrorMessage = self::validateDescriptionForChoiceConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionChoiceErrorMessage, __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToDescription method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToDescription($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'URL',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Description can\'t be set as the property %s is already set. Only one property must be set among these properties: Description, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \StructType\Description $item
     * @return \StructType\TextDescriptionType
     */
    public function addToDescription(\StructType\Description $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Description) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of type \StructType\Description, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(URL, Description)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToDescription($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get Category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @param string $category
     * @return \StructType\TextDescriptionType
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($category) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($category, true)), __LINE__);
        }
        $this->Category = $category;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\TextDescriptionType
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get ContentID value
     * @return string|null
     */
    public function getContentID()
    {
        return $this->ContentID;
    }
    /**
     * Set ContentID value
     * @param string $contentID
     * @return \StructType\TextDescriptionType
     */
    public function setContentID($contentID = null)
    {
        // validation for constraint: string
        if (!is_null($contentID) && !is_string($contentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contentID, true), gettype($contentID)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($contentID) && mb_strlen($contentID) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($contentID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($contentID) && mb_strlen($contentID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($contentID)), __LINE__);
        }
        $this->ContentID = $contentID;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\TextDescriptionType
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($title) && mb_strlen($title) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($title)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($title) && mb_strlen($title) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get Author value
     * @return string|null
     */
    public function getAuthor()
    {
        return $this->Author;
    }
    /**
     * Set Author value
     * @param string $author
     * @return \StructType\TextDescriptionType
     */
    public function setAuthor($author = null)
    {
        // validation for constraint: string
        if (!is_null($author) && !is_string($author)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($author, true), gettype($author)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($author) && mb_strlen($author) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($author)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($author) && mb_strlen($author) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($author)), __LINE__);
        }
        $this->Author = $author;
        return $this;
    }
    /**
     * Get CopyrightNotice value
     * @return string|null
     */
    public function getCopyrightNotice()
    {
        return $this->CopyrightNotice;
    }
    /**
     * Set CopyrightNotice value
     * @param string $copyrightNotice
     * @return \StructType\TextDescriptionType
     */
    public function setCopyrightNotice($copyrightNotice = null)
    {
        // validation for constraint: string
        if (!is_null($copyrightNotice) && !is_string($copyrightNotice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($copyrightNotice, true), gettype($copyrightNotice)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($copyrightNotice) && mb_strlen($copyrightNotice) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($copyrightNotice)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($copyrightNotice) && mb_strlen($copyrightNotice) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($copyrightNotice)), __LINE__);
        }
        $this->CopyrightNotice = $copyrightNotice;
        return $this;
    }
    /**
     * Get CopyrightOwner value
     * @return string|null
     */
    public function getCopyrightOwner()
    {
        return $this->CopyrightOwner;
    }
    /**
     * Set CopyrightOwner value
     * @param string $copyrightOwner
     * @return \StructType\TextDescriptionType
     */
    public function setCopyrightOwner($copyrightOwner = null)
    {
        // validation for constraint: string
        if (!is_null($copyrightOwner) && !is_string($copyrightOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($copyrightOwner, true), gettype($copyrightOwner)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($copyrightOwner) && mb_strlen($copyrightOwner) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($copyrightOwner)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($copyrightOwner) && mb_strlen($copyrightOwner) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($copyrightOwner)), __LINE__);
        }
        $this->CopyrightOwner = $copyrightOwner;
        return $this;
    }
    /**
     * Get CopyrightStart value
     * @return string|null
     */
    public function getCopyrightStart()
    {
        return $this->CopyrightStart;
    }
    /**
     * This method is responsible for validating the value passed to the setCopyrightStart method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCopyrightStart method
     * This is a set of validation rules based on the union types associated to the property being set by the setCopyrightStart method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCopyrightStartForUnionConstraintsFromSetCopyrightStart($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set CopyrightStart value
     * @param string $copyrightStart
     * @return \StructType\TextDescriptionType
     */
    public function setCopyrightStart($copyrightStart = null)
    {
        // validation for constraint: string
        if (!is_null($copyrightStart) && !is_string($copyrightStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($copyrightStart, true), gettype($copyrightStart)), __LINE__);
        }
        // validation for constraint: union(date, dateTime)
        if ('' !== ($copyrightStartUnionErrorMessage = self::validateCopyrightStartForUnionConstraintsFromSetCopyrightStart($copyrightStart))) {
            throw new \InvalidArgumentException($copyrightStartUnionErrorMessage, __LINE__);
        }
        $this->CopyrightStart = $copyrightStart;
        return $this;
    }
    /**
     * Get CopyrightEnd value
     * @return string|null
     */
    public function getCopyrightEnd()
    {
        return $this->CopyrightEnd;
    }
    /**
     * This method is responsible for validating the value passed to the setCopyrightEnd method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCopyrightEnd method
     * This is a set of validation rules based on the union types associated to the property being set by the setCopyrightEnd method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCopyrightEndForUnionConstraintsFromSetCopyrightEnd($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set CopyrightEnd value
     * @param string $copyrightEnd
     * @return \StructType\TextDescriptionType
     */
    public function setCopyrightEnd($copyrightEnd = null)
    {
        // validation for constraint: string
        if (!is_null($copyrightEnd) && !is_string($copyrightEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($copyrightEnd, true), gettype($copyrightEnd)), __LINE__);
        }
        // validation for constraint: union(date, dateTime)
        if ('' !== ($copyrightEndUnionErrorMessage = self::validateCopyrightEndForUnionConstraintsFromSetCopyrightEnd($copyrightEnd))) {
            throw new \InvalidArgumentException($copyrightEndUnionErrorMessage, __LINE__);
        }
        $this->CopyrightEnd = $copyrightEnd;
        return $this;
    }
    /**
     * Get EffectiveStart value
     * @return string|null
     */
    public function getEffectiveStart()
    {
        return $this->EffectiveStart;
    }
    /**
     * This method is responsible for validating the value passed to the setEffectiveStart method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEffectiveStart method
     * This is a set of validation rules based on the union types associated to the property being set by the setEffectiveStart method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEffectiveStartForUnionConstraintsFromSetEffectiveStart($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set EffectiveStart value
     * @param string $effectiveStart
     * @return \StructType\TextDescriptionType
     */
    public function setEffectiveStart($effectiveStart = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveStart) && !is_string($effectiveStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveStart, true), gettype($effectiveStart)), __LINE__);
        }
        // validation for constraint: union(date, dateTime)
        if ('' !== ($effectiveStartUnionErrorMessage = self::validateEffectiveStartForUnionConstraintsFromSetEffectiveStart($effectiveStart))) {
            throw new \InvalidArgumentException($effectiveStartUnionErrorMessage, __LINE__);
        }
        $this->EffectiveStart = $effectiveStart;
        return $this;
    }
    /**
     * Get EffectiveEnd value
     * @return string|null
     */
    public function getEffectiveEnd()
    {
        return $this->EffectiveEnd;
    }
    /**
     * This method is responsible for validating the value passed to the setEffectiveEnd method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEffectiveEnd method
     * This is a set of validation rules based on the union types associated to the property being set by the setEffectiveEnd method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEffectiveEndForUnionConstraintsFromSetEffectiveEnd($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set EffectiveEnd value
     * @param string $effectiveEnd
     * @return \StructType\TextDescriptionType
     */
    public function setEffectiveEnd($effectiveEnd = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveEnd) && !is_string($effectiveEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveEnd, true), gettype($effectiveEnd)), __LINE__);
        }
        // validation for constraint: union(date, dateTime)
        if ('' !== ($effectiveEndUnionErrorMessage = self::validateEffectiveEndForUnionConstraintsFromSetEffectiveEnd($effectiveEnd))) {
            throw new \InvalidArgumentException($effectiveEndUnionErrorMessage, __LINE__);
        }
        $this->EffectiveEnd = $effectiveEnd;
        return $this;
    }
    /**
     * Get ApplicableStart value
     * @return string|null
     */
    public function getApplicableStart()
    {
        return $this->ApplicableStart;
    }
    /**
     * This method is responsible for validating the value passed to the setApplicableStart method
     * This method is willingly generated in order to preserve the one-line inline validation within the setApplicableStart method
     * This is a set of validation rules based on the union types associated to the property being set by the setApplicableStart method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateApplicableStartForUnionConstraintsFromSetApplicableStart($value)
    {
        $message = '';
        // validation for constraint: int
        if (!is_null($value) && !(is_int($value) || ctype_digit($value))) {
            $exception0 = new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        if (isset($exception0)) {
            $message = sprintf("The value %s does not match any of the union rules: date, gMonthDay. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [$exception0])));
        }
        unset($exception0);
        return $message;
    }
    /**
     * Set ApplicableStart value
     * @param string $applicableStart
     * @return \StructType\TextDescriptionType
     */
    public function setApplicableStart($applicableStart = null)
    {
        // validation for constraint: string
        if (!is_null($applicableStart) && !is_string($applicableStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicableStart, true), gettype($applicableStart)), __LINE__);
        }
        // validation for constraint: union(date, gMonthDay)
        if ('' !== ($applicableStartUnionErrorMessage = self::validateApplicableStartForUnionConstraintsFromSetApplicableStart($applicableStart))) {
            throw new \InvalidArgumentException($applicableStartUnionErrorMessage, __LINE__);
        }
        $this->ApplicableStart = $applicableStart;
        return $this;
    }
    /**
     * Get ApplicableEnd value
     * @return string|null
     */
    public function getApplicableEnd()
    {
        return $this->ApplicableEnd;
    }
    /**
     * This method is responsible for validating the value passed to the setApplicableEnd method
     * This method is willingly generated in order to preserve the one-line inline validation within the setApplicableEnd method
     * This is a set of validation rules based on the union types associated to the property being set by the setApplicableEnd method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateApplicableEndForUnionConstraintsFromSetApplicableEnd($value)
    {
        $message = '';
        // validation for constraint: int
        if (!is_null($value) && !(is_int($value) || ctype_digit($value))) {
            $exception0 = new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        if (isset($exception0)) {
            $message = sprintf("The value %s does not match any of the union rules: date, gMonthDay. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [$exception0])));
        }
        unset($exception0);
        return $message;
    }
    /**
     * Set ApplicableEnd value
     * @param string $applicableEnd
     * @return \StructType\TextDescriptionType
     */
    public function setApplicableEnd($applicableEnd = null)
    {
        // validation for constraint: string
        if (!is_null($applicableEnd) && !is_string($applicableEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicableEnd, true), gettype($applicableEnd)), __LINE__);
        }
        // validation for constraint: union(date, gMonthDay)
        if ('' !== ($applicableEndUnionErrorMessage = self::validateApplicableEndForUnionConstraintsFromSetApplicableEnd($applicableEnd))) {
            throw new \InvalidArgumentException($applicableEndUnionErrorMessage, __LINE__);
        }
        $this->ApplicableEnd = $applicableEnd;
        return $this;
    }
    /**
     * Get RecordID value
     * @return string|null
     */
    public function getRecordID()
    {
        return $this->RecordID;
    }
    /**
     * Set RecordID value
     * @param string $recordID
     * @return \StructType\TextDescriptionType
     */
    public function setRecordID($recordID = null)
    {
        // validation for constraint: string
        if (!is_null($recordID) && !is_string($recordID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recordID, true), gettype($recordID)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($recordID) && mb_strlen($recordID) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($recordID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($recordID) && mb_strlen($recordID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($recordID)), __LINE__);
        }
        $this->RecordID = $recordID;
        return $this;
    }
    /**
     * Get SourceID value
     * @return string|null
     */
    public function getSourceID()
    {
        return $this->SourceID;
    }
    /**
     * Set SourceID value
     * @param string $sourceID
     * @return \StructType\TextDescriptionType
     */
    public function setSourceID($sourceID = null)
    {
        // validation for constraint: string
        if (!is_null($sourceID) && !is_string($sourceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceID, true), gettype($sourceID)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($sourceID) && mb_strlen($sourceID) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($sourceID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($sourceID) && mb_strlen($sourceID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($sourceID)), __LINE__);
        }
        $this->SourceID = $sourceID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TextDescriptionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
