<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Telephone StructType
 * Meta information extracted from the WSDL
 * - documentation: Used to provide phone numbers for a card holder. | Card holder's telephone number used for additional authorization checks. | Detailed telephone information for the search. | Telephone number(s) used in the search. | Information
 * about a telephone number, including the actual number and its usage. | Telephone number associated with company to whom remittance is being directed. | The first and last dates between which this telephone number is in effect. | Information on a
 * telephone number for the customer. | Information about a contact's telephone number, including the actual number and its usage. | Identifies a telephone number. | Telephone number for the person traveling. | Information about the telephone numbers
 * for thislocation. | Phone number for the contact person for the off location service.
 * @subpackage Structs
 */
class Telephone extends AbstractStructBase
{
    /**
     * The PhoneNumber
     * Meta information extracted from the WSDL
     * - documentation: Telephone number assigned to a single location. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - type: StringLength1to32
     * - use: required
     * @var string
     */
    public $PhoneNumber;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: Used elsewhere in the message to reference a specific telephone number (including faxes). | The Reference Place Holder (RPH) is an index code used to identify an instance in a collection of like items (e.g. used to assign individual
     * passengers or clients to particular itinerary items).
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - type: RPH_Type
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The PhoneLocationType
     * Meta information extracted from the WSDL
     * - documentation: Refer to OpenTravel Code List Phone Location Type (PLT). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - type: OTA_CodeType
     * - use: optional
     * @var string
     */
    public $PhoneLocationType;
    /**
     * The PhoneTechType
     * Meta information extracted from the WSDL
     * - documentation: Indicates type of technology associated with this telephone number, such as Voice, Data, Fax, Pager, Mobile, TTY, etc. Refer to OpenTravel Code List Phone Technology Type (PTT). | Used for codes in the OpenTravel Code tables.
     * Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - type: OTA_CodeType
     * - use: optional
     * @var string
     */
    public $PhoneTechType;
    /**
     * The PhoneUseType
     * Meta information extracted from the WSDL
     * - documentation: Describes the type of telephone number, in the context of its general use (e.g. Home, Business, Emergency Contact, Travel Arranger, Day, Evening). Refer to OpenTravel Code List Phone Use Type (PUT). | Used for codes in the OpenTravel
     * Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - type: OTA_CodeType
     * - use: optional
     * @var string
     */
    public $PhoneUseType;
    /**
     * The CountryAccessCode
     * Meta information extracted from the WSDL
     * - documentation: Code assigned by telecommunications authorities for international country access identifier. | Used for Numeric Strings length 1 to 3.
     * - base: xs:string
     * - pattern: [0-9]{1,3}
     * - type: NumericStringLength1to3
     * - use: optional
     * @var string
     */
    public $CountryAccessCode;
    /**
     * The AreaCityCode
     * Meta information extracted from the WSDL
     * - documentation: Code assigned for telephones in a specific region, city, or area. | Used for Numeric Strings, length 1 to 8.
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - type: NumericStringLength1to8
     * - use: optional
     * @var string
     */
    public $AreaCityCode;
    /**
     * The Extension
     * Meta information extracted from the WSDL
     * - documentation: Extension to reach a specific party at the phone number. | Used for Numeric Strings, length 1 to 5.
     * - base: xs:string
     * - pattern: [0-9]{1,5}
     * - type: NumericStringLength1to5
     * - use: optional
     * @var string
     */
    public $Extension;
    /**
     * The PIN
     * Meta information extracted from the WSDL
     * - documentation: Additional codes used for pager or telephone access rights. | Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - type: StringLength1to8
     * - use: optional
     * @var string
     */
    public $PIN;
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - documentation: A remark associated with the telephone number. | Used for Character Strings, length 1 to 128.
     * - base: xs:string
     * - maxLength: 128
     * - minLength: 1
     * - type: StringLength1to128
     * - use: optional
     * @var string
     */
    public $Remark;
    /**
     * The FormattedInd
     * Meta information extracted from the WSDL
     * - documentation: false | Specifies if the associated data is formatted or not. When true, then it is formatted; when false, then not formatted.
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $FormattedInd;
    /**
     * The DefaultInd
     * Meta information extracted from the WSDL
     * - documentation: false | When true, indicates a default value should be used.
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $DefaultInd;
    /**
     * The TransferAction
     * Meta information extracted from the WSDL
     * - documentation: Indicates under what conditions the element will be transfered to the booking.
     * - use: optional
     * @var string
     */
    public $TransferAction;
    /**
     * The ParentCompanyRef
     * Meta information extracted from the WSDL
     * - documentation: A reference to the company from which this element has been inherited. | Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $ParentCompanyRef;
    /**
     * The EffectiveDate
     * Meta information extracted from the WSDL
     * - documentation: Indicates the starting date.
     * - type: xs:date
     * - use: optional
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * Meta information extracted from the WSDL
     * - documentation: Indicates the ending date.
     * - type: xs:date
     * - use: optional
     * @var string
     */
    public $ExpireDate;
    /**
     * The ExpireDateExclusiveIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, indicates that the ExpireDate is the first day after the applicable period (e.g. when expire date is Oct 15 the last date of the period is Oct 14).
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $ExpireDateExclusiveIndicator;
    /**
     * The Operation
     * Meta information extracted from the WSDL
     * - documentation: Indicates the required modification to the element.
     * - use: optional
     * @var string
     */
    public $Operation;
    /**
     * The LocationCode
     * Meta information extracted from the WSDL
     * - documentation: A 3 character ATA/ IATA city code of telephone location. | Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $LocationCode;
    /**
     * Constructor method for Telephone
     * @uses Telephone::setPhoneNumber()
     * @uses Telephone::setRPH()
     * @uses Telephone::setShareSynchInd()
     * @uses Telephone::setShareMarketInd()
     * @uses Telephone::setPhoneLocationType()
     * @uses Telephone::setPhoneTechType()
     * @uses Telephone::setPhoneUseType()
     * @uses Telephone::setCountryAccessCode()
     * @uses Telephone::setAreaCityCode()
     * @uses Telephone::setExtension()
     * @uses Telephone::setPIN()
     * @uses Telephone::setRemark()
     * @uses Telephone::setFormattedInd()
     * @uses Telephone::setDefaultInd()
     * @uses Telephone::setTransferAction()
     * @uses Telephone::setParentCompanyRef()
     * @uses Telephone::setEffectiveDate()
     * @uses Telephone::setExpireDate()
     * @uses Telephone::setExpireDateExclusiveIndicator()
     * @uses Telephone::setOperation()
     * @uses Telephone::setLocationCode()
     * @param string $phoneNumber
     * @param string $rPH
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param string $phoneLocationType
     * @param string $phoneTechType
     * @param string $phoneUseType
     * @param string $countryAccessCode
     * @param string $areaCityCode
     * @param string $extension
     * @param string $pIN
     * @param string $remark
     * @param bool $formattedInd
     * @param bool $defaultInd
     * @param string $transferAction
     * @param string $parentCompanyRef
     * @param string $effectiveDate
     * @param string $expireDate
     * @param bool $expireDateExclusiveIndicator
     * @param string $operation
     * @param string $locationCode
     */
    public function __construct($phoneNumber = null, $rPH = null, $shareSynchInd = null, $shareMarketInd = null, $phoneLocationType = null, $phoneTechType = null, $phoneUseType = null, $countryAccessCode = null, $areaCityCode = null, $extension = null, $pIN = null, $remark = null, $formattedInd = null, $defaultInd = null, $transferAction = null, $parentCompanyRef = null, $effectiveDate = null, $expireDate = null, $expireDateExclusiveIndicator = null, $operation = null, $locationCode = null)
    {
        $this
            ->setPhoneNumber($phoneNumber)
            ->setRPH($rPH)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setPhoneLocationType($phoneLocationType)
            ->setPhoneTechType($phoneTechType)
            ->setPhoneUseType($phoneUseType)
            ->setCountryAccessCode($countryAccessCode)
            ->setAreaCityCode($areaCityCode)
            ->setExtension($extension)
            ->setPIN($pIN)
            ->setRemark($remark)
            ->setFormattedInd($formattedInd)
            ->setDefaultInd($defaultInd)
            ->setTransferAction($transferAction)
            ->setParentCompanyRef($parentCompanyRef)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate)
            ->setExpireDateExclusiveIndicator($expireDateExclusiveIndicator)
            ->setOperation($operation)
            ->setLocationCode($locationCode);
    }
    /**
     * Get PhoneNumber value
     * @return string
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }
    /**
     * Set PhoneNumber value
     * @param string $phoneNumber
     * @return \StructType\Telephone
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneNumber, true), gettype($phoneNumber)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($phoneNumber) && mb_strlen($phoneNumber) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($phoneNumber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($phoneNumber) && mb_strlen($phoneNumber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($phoneNumber)), __LINE__);
        }
        $this->PhoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\Telephone
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($rPH) && !preg_match('/[0-9]{1,8}/', $rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($rPH, true)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \StructType\Telephone
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareSynchInd, true), gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \StructType\Telephone
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareMarketInd, true), gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get PhoneLocationType value
     * @return string|null
     */
    public function getPhoneLocationType()
    {
        return $this->PhoneLocationType;
    }
    /**
     * Set PhoneLocationType value
     * @param string $phoneLocationType
     * @return \StructType\Telephone
     */
    public function setPhoneLocationType($phoneLocationType = null)
    {
        // validation for constraint: string
        if (!is_null($phoneLocationType) && !is_string($phoneLocationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneLocationType, true), gettype($phoneLocationType)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($phoneLocationType) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $phoneLocationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($phoneLocationType, true)), __LINE__);
        }
        $this->PhoneLocationType = $phoneLocationType;
        return $this;
    }
    /**
     * Get PhoneTechType value
     * @return string|null
     */
    public function getPhoneTechType()
    {
        return $this->PhoneTechType;
    }
    /**
     * Set PhoneTechType value
     * @param string $phoneTechType
     * @return \StructType\Telephone
     */
    public function setPhoneTechType($phoneTechType = null)
    {
        // validation for constraint: string
        if (!is_null($phoneTechType) && !is_string($phoneTechType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneTechType, true), gettype($phoneTechType)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($phoneTechType) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $phoneTechType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($phoneTechType, true)), __LINE__);
        }
        $this->PhoneTechType = $phoneTechType;
        return $this;
    }
    /**
     * Get PhoneUseType value
     * @return string|null
     */
    public function getPhoneUseType()
    {
        return $this->PhoneUseType;
    }
    /**
     * Set PhoneUseType value
     * @param string $phoneUseType
     * @return \StructType\Telephone
     */
    public function setPhoneUseType($phoneUseType = null)
    {
        // validation for constraint: string
        if (!is_null($phoneUseType) && !is_string($phoneUseType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneUseType, true), gettype($phoneUseType)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($phoneUseType) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $phoneUseType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($phoneUseType, true)), __LINE__);
        }
        $this->PhoneUseType = $phoneUseType;
        return $this;
    }
    /**
     * Get CountryAccessCode value
     * @return string|null
     */
    public function getCountryAccessCode()
    {
        return $this->CountryAccessCode;
    }
    /**
     * Set CountryAccessCode value
     * @param string $countryAccessCode
     * @return \StructType\Telephone
     */
    public function setCountryAccessCode($countryAccessCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryAccessCode) && !is_string($countryAccessCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryAccessCode, true), gettype($countryAccessCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,3})
        if (!is_null($countryAccessCode) && !preg_match('/[0-9]{1,3}/', $countryAccessCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,3}', var_export($countryAccessCode, true)), __LINE__);
        }
        $this->CountryAccessCode = $countryAccessCode;
        return $this;
    }
    /**
     * Get AreaCityCode value
     * @return string|null
     */
    public function getAreaCityCode()
    {
        return $this->AreaCityCode;
    }
    /**
     * Set AreaCityCode value
     * @param string $areaCityCode
     * @return \StructType\Telephone
     */
    public function setAreaCityCode($areaCityCode = null)
    {
        // validation for constraint: string
        if (!is_null($areaCityCode) && !is_string($areaCityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaCityCode, true), gettype($areaCityCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($areaCityCode) && !preg_match('/[0-9]{1,8}/', $areaCityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($areaCityCode, true)), __LINE__);
        }
        $this->AreaCityCode = $areaCityCode;
        return $this;
    }
    /**
     * Get Extension value
     * @return string|null
     */
    public function getExtension()
    {
        return $this->Extension;
    }
    /**
     * Set Extension value
     * @param string $extension
     * @return \StructType\Telephone
     */
    public function setExtension($extension = null)
    {
        // validation for constraint: string
        if (!is_null($extension) && !is_string($extension)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extension, true), gettype($extension)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,5})
        if (!is_null($extension) && !preg_match('/[0-9]{1,5}/', $extension)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,5}', var_export($extension, true)), __LINE__);
        }
        $this->Extension = $extension;
        return $this;
    }
    /**
     * Get PIN value
     * @return string|null
     */
    public function getPIN()
    {
        return $this->PIN;
    }
    /**
     * Set PIN value
     * @param string $pIN
     * @return \StructType\Telephone
     */
    public function setPIN($pIN = null)
    {
        // validation for constraint: string
        if (!is_null($pIN) && !is_string($pIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pIN, true), gettype($pIN)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($pIN) && mb_strlen($pIN) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($pIN)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($pIN) && mb_strlen($pIN) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($pIN)), __LINE__);
        }
        $this->PIN = $pIN;
        return $this;
    }
    /**
     * Get Remark value
     * @return string|null
     */
    public function getRemark()
    {
        return $this->Remark;
    }
    /**
     * Set Remark value
     * @param string $remark
     * @return \StructType\Telephone
     */
    public function setRemark($remark = null)
    {
        // validation for constraint: string
        if (!is_null($remark) && !is_string($remark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remark, true), gettype($remark)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($remark) && mb_strlen($remark) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($remark)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($remark) && mb_strlen($remark) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($remark)), __LINE__);
        }
        $this->Remark = $remark;
        return $this;
    }
    /**
     * Get FormattedInd value
     * @return bool|null
     */
    public function getFormattedInd()
    {
        return $this->FormattedInd;
    }
    /**
     * Set FormattedInd value
     * @param bool $formattedInd
     * @return \StructType\Telephone
     */
    public function setFormattedInd($formattedInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($formattedInd) && !is_bool($formattedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($formattedInd, true), gettype($formattedInd)), __LINE__);
        }
        $this->FormattedInd = $formattedInd;
        return $this;
    }
    /**
     * Get DefaultInd value
     * @return bool|null
     */
    public function getDefaultInd()
    {
        return $this->DefaultInd;
    }
    /**
     * Set DefaultInd value
     * @param bool $defaultInd
     * @return \StructType\Telephone
     */
    public function setDefaultInd($defaultInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($defaultInd) && !is_bool($defaultInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($defaultInd, true), gettype($defaultInd)), __LINE__);
        }
        $this->DefaultInd = $defaultInd;
        return $this;
    }
    /**
     * Get TransferAction value
     * @return string|null
     */
    public function getTransferAction()
    {
        return $this->TransferAction;
    }
    /**
     * Set TransferAction value
     * @uses \EnumType\TransferActionType::valueIsValid()
     * @uses \EnumType\TransferActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transferAction
     * @return \StructType\Telephone
     */
    public function setTransferAction($transferAction = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransferActionType::valueIsValid($transferAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TransferActionType', is_array($transferAction) ? implode(', ', $transferAction) : var_export($transferAction, true), implode(', ', \EnumType\TransferActionType::getValidValues())), __LINE__);
        }
        $this->TransferAction = $transferAction;
        return $this;
    }
    /**
     * Get ParentCompanyRef value
     * @return string|null
     */
    public function getParentCompanyRef()
    {
        return $this->ParentCompanyRef;
    }
    /**
     * Set ParentCompanyRef value
     * @param string $parentCompanyRef
     * @return \StructType\Telephone
     */
    public function setParentCompanyRef($parentCompanyRef = null)
    {
        // validation for constraint: string
        if (!is_null($parentCompanyRef) && !is_string($parentCompanyRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentCompanyRef, true), gettype($parentCompanyRef)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($parentCompanyRef) && mb_strlen($parentCompanyRef) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($parentCompanyRef)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($parentCompanyRef) && mb_strlen($parentCompanyRef) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($parentCompanyRef)), __LINE__);
        }
        $this->ParentCompanyRef = $parentCompanyRef;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\Telephone
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \StructType\Telephone
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expireDate, true), gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get ExpireDateExclusiveIndicator value
     * @return bool|null
     */
    public function getExpireDateExclusiveIndicator()
    {
        return $this->ExpireDateExclusiveIndicator;
    }
    /**
     * Set ExpireDateExclusiveIndicator value
     * @param bool $expireDateExclusiveIndicator
     * @return \StructType\Telephone
     */
    public function setExpireDateExclusiveIndicator($expireDateExclusiveIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($expireDateExclusiveIndicator) && !is_bool($expireDateExclusiveIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($expireDateExclusiveIndicator, true), gettype($expireDateExclusiveIndicator)), __LINE__);
        }
        $this->ExpireDateExclusiveIndicator = $expireDateExclusiveIndicator;
        return $this;
    }
    /**
     * Get Operation value
     * @return string|null
     */
    public function getOperation()
    {
        return $this->Operation;
    }
    /**
     * Set Operation value
     * @uses \EnumType\ActionType::valueIsValid()
     * @uses \EnumType\ActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operation
     * @return \StructType\Telephone
     */
    public function setOperation($operation = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActionType::valueIsValid($operation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ActionType', is_array($operation) ? implode(', ', $operation) : var_export($operation, true), implode(', ', \EnumType\ActionType::getValidValues())), __LINE__);
        }
        $this->Operation = $operation;
        return $this;
    }
    /**
     * Get LocationCode value
     * @return string|null
     */
    public function getLocationCode()
    {
        return $this->LocationCode;
    }
    /**
     * Set LocationCode value
     * @param string $locationCode
     * @return \StructType\Telephone
     */
    public function setLocationCode($locationCode = null)
    {
        // validation for constraint: string
        if (!is_null($locationCode) && !is_string($locationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locationCode, true), gettype($locationCode)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($locationCode) && mb_strlen($locationCode) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($locationCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($locationCode) && mb_strlen($locationCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($locationCode)), __LINE__);
        }
        $this->LocationCode = $locationCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Telephone
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
