<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SystemCodes StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of system codes.
 * @subpackage Structs
 */
class SystemCodes extends AbstractStructBase
{
    /**
     * The SystemCode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\SystemCode[]
     */
    public $SystemCode;
    /**
     * The SystemCodesInclusive
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether the collection of System Codes is inclusive or exclusive. Values: false=Exclusive, true=Inclusive.
     * - use: optional
     * @var bool
     */
    public $SystemCodesInclusive;
    /**
     * Constructor method for SystemCodes
     * @uses SystemCodes::setSystemCode()
     * @uses SystemCodes::setSystemCodesInclusive()
     * @param \StructType\SystemCode[] $systemCode
     * @param bool $systemCodesInclusive
     */
    public function __construct(array $systemCode = array(), $systemCodesInclusive = null)
    {
        $this
            ->setSystemCode($systemCode)
            ->setSystemCodesInclusive($systemCodesInclusive);
    }
    /**
     * Get SystemCode value
     * @return \StructType\SystemCode[]|null
     */
    public function getSystemCode()
    {
        return $this->SystemCode;
    }
    /**
     * This method is responsible for validating the values passed to the setSystemCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSystemCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSystemCodeForArrayConstraintsFromSetSystemCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $systemCodesSystemCodeItem) {
            // validation for constraint: itemType
            if (!$systemCodesSystemCodeItem instanceof \StructType\SystemCode) {
                $invalidValues[] = is_object($systemCodesSystemCodeItem) ? get_class($systemCodesSystemCodeItem) : sprintf('%s(%s)', gettype($systemCodesSystemCodeItem), var_export($systemCodesSystemCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SystemCode property can only contain items of type \StructType\SystemCode, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SystemCode value
     * @throws \InvalidArgumentException
     * @param \StructType\SystemCode[] $systemCode
     * @return \StructType\SystemCodes
     */
    public function setSystemCode(array $systemCode = array())
    {
        // validation for constraint: array
        if ('' !== ($systemCodeArrayErrorMessage = self::validateSystemCodeForArrayConstraintsFromSetSystemCode($systemCode))) {
            throw new \InvalidArgumentException($systemCodeArrayErrorMessage, __LINE__);
        }
        $this->SystemCode = $systemCode;
        return $this;
    }
    /**
     * Add item to SystemCode value
     * @throws \InvalidArgumentException
     * @param \StructType\SystemCode $item
     * @return \StructType\SystemCodes
     */
    public function addToSystemCode(\StructType\SystemCode $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SystemCode) {
            throw new \InvalidArgumentException(sprintf('The SystemCode property can only contain items of type \StructType\SystemCode, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SystemCode[] = $item;
        return $this;
    }
    /**
     * Get SystemCodesInclusive value
     * @return bool|null
     */
    public function getSystemCodesInclusive()
    {
        return $this->SystemCodesInclusive;
    }
    /**
     * Set SystemCodesInclusive value
     * @param bool $systemCodesInclusive
     * @return \StructType\SystemCodes
     */
    public function setSystemCodesInclusive($systemCodesInclusive = null)
    {
        // validation for constraint: boolean
        if (!is_null($systemCodesInclusive) && !is_bool($systemCodesInclusive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($systemCodesInclusive, true), gettype($systemCodesInclusive)), __LINE__);
        }
        $this->SystemCodesInclusive = $systemCodesInclusive;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SystemCodes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
