<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StreetNmbrType StructType
 * Meta information extracted from the WSDL
 * - documentation: Street name; number on street. | Used for Character Strings, length 0 to 64.
 * - base: xs:string
 * - maxLength: 64
 * - minLength: 0
 * @subpackage Structs
 */
class StreetNmbrType extends AbstractStructBase
{
    /**
     * The _
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 0 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 0
     * @var string
     */
    public $_;
    /**
     * The PO_Box
     * Meta information extracted from the WSDL
     * - documentation: Defines a Post Office Box number. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * @var string
     */
    public $PO_Box;
    /**
     * Constructor method for StreetNmbrType
     * @uses StreetNmbrType::set_()
     * @uses StreetNmbrType::setPO_Box()
     * @param string $_
     * @param string $pO_Box
     */
    public function __construct($_ = null, $pO_Box = null)
    {
        $this
            ->set_($_)
            ->setPO_Box($pO_Box);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\StreetNmbrType
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($_) && mb_strlen($_) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($_)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($_) && mb_strlen($_) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get PO_Box value
     * @return string|null
     */
    public function getPO_Box()
    {
        return $this->PO_Box;
    }
    /**
     * Set PO_Box value
     * @param string $pO_Box
     * @return \StructType\StreetNmbrType
     */
    public function setPO_Box($pO_Box = null)
    {
        // validation for constraint: string
        if (!is_null($pO_Box) && !is_string($pO_Box)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pO_Box, true), gettype($pO_Box)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($pO_Box) && mb_strlen($pO_Box) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($pO_Box)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($pO_Box) && mb_strlen($pO_Box) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($pO_Box)), __LINE__);
        }
        $this->PO_Box = $pO_Box;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StreetNmbrType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
