<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StatusApplicationControlType StructType
 * Meta information extracted from the WSDL
 * - documentation: The StatusApplicationControl class is used to indicate to which block codes/rate plans/inventory codes a status should be applied.
 * @subpackage Structs
 */
class StatusApplicationControlType extends AbstractStructBase
{
    /**
     * The DestinationSystemCodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DestinationSystemCodesType
     */
    public $DestinationSystemCodes;
    /**
     * The RateTier
     * Meta information extracted from the WSDL
     * - documentation: Hotel systems often have different tiers for a given rate plan; this attribute is used to designate a specific tier within the rate plan (e.g. high, medium, low). | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $RateTier;
    /**
     * The AllRateCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $AllRateCode;
    /**
     * The AllInvCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $AllInvCode;
    /**
     * The InvBlockCode
     * Meta information extracted from the WSDL
     * - documentation: Code that identifies an inventory block. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $InvBlockCode;
    /**
     * The Override
     * Meta information extracted from the WSDL
     * - documentation: Mechanism to allow the user to override settings at the reservation system and to allow the RMS to replace this overridden values: If value = 0 (No), the reservations system may ignore the settings passed and keep values overridden
     * by the user. If value = 1 (Yes), the reservations system must replace values overridden by the user.
     * - use: optional
     * @var bool
     */
    public $Override;
    /**
     * The QuoteID
     * Meta information extracted from the WSDL
     * - documentation: This identifies a specific quote. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $QuoteID;
    /**
     * The SubBlockCode
     * Meta information extracted from the WSDL
     * - documentation: This is the code defining a subset of the inventory block. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $SubBlockCode;
    /**
     * The WingIdentifier
     * Meta information extracted from the WSDL
     * - documentation: Used to identify the wing of a hotel. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $WingIdentifier;
    /**
     * The Start
     * Meta information extracted from the WSDL
     * - documentation: A construct to validate either a date or a time or a dateTime value.
     * - union: date | dateTime | time
     * @var string
     */
    public $Start;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - documentation: Allows for the specification of a night duration.
     * - union: duration | NightDurationType
     * @var string
     */
    public $Duration;
    /**
     * The End
     * Meta information extracted from the WSDL
     * - documentation: A construct to validate either a date or a time or a dateTime value.
     * - union: date | dateTime | time
     * @var string
     */
    public $End;
    /**
     * The RatePlanType
     * Meta information extracted from the WSDL
     * - documentation: An enumerated type that allows the query to specify a rate category type, and provides major categories for comparison across brands. Refer to OpenTravel Code List Rate Plan Type (RPT). | Used for codes in the OpenTravel Code tables.
     * Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - type: OTA_CodeType
     * - use: optional
     * @var string
     */
    public $RatePlanType;
    /**
     * The RatePlanCode
     * Meta information extracted from the WSDL
     * - documentation: A string value may be used to request a particular code or an ID if the guest qualifies for a specific rate, such as AARP, AAA, a corporate rate, etc., or to specify a negotiated code as a result of a negotiated rate. | Used for
     * Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - type: StringLength1to64
     * - use: optional
     * @var string
     */
    public $RatePlanCode;
    /**
     * The RatePlanID
     * Meta information extracted from the WSDL
     * - documentation: A text field used to indicate a special ID code that is associated with the rate and is essential in the reservation request in order to obtain the rate. Examples are Corporate ID. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - type: StringLength1to64
     * - use: optional
     * @var string
     */
    public $RatePlanID;
    /**
     * The RatePlanQualifier
     * Meta information extracted from the WSDL
     * - documentation: The Rate Plan Qualifier is used to control the sort order of RatePlans. Those Rate Plans that are not qualified will appear first, those that are qualified will appear last.
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $RatePlanQualifier;
    /**
     * The RatePlanCategory
     * Meta information extracted from the WSDL
     * - documentation: Hotel systems often group multiple rate plans into a single category. This refers to that category that is specific to the hotel CRS/ PMS and should not be confused with a GDS rate category. | Used for Character Strings, length 1 to
     * 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - type: StringLength1to64
     * - use: optional
     * @var string
     */
    public $RatePlanCategory;
    /**
     * The PromotionCode
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $PromotionCode;
    /**
     * The PromotionVendorCode
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 8. | List of StringLength1to8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * @var string[]
     */
    public $PromotionVendorCode;
    /**
     * The InvCodeApplication
     * @var string
     */
    public $InvCodeApplication;
    /**
     * The InvCode
     * Meta information extracted from the WSDL
     * - documentation: Code that identifies an inventory item. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - type: StringLength1to16
     * - use: optional
     * @var string
     */
    public $InvCode;
    /**
     * The InvType
     * Meta information extracted from the WSDL
     * - documentation: A value that indicates the type of inventory for which this request is made. If the inventory item is a room, typical values could be double, king, etc. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - type: StringLength1to16
     * - use: optional
     * @var string
     */
    public $InvType;
    /**
     * The InvTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Specific system inventory type code. If the inventory item is a room, typical values could be room type code, e.g.: A1K, A1Q etc. Values may use the OpenTravel Code list or a code specific to the property or hotel brand. | Used for
     * Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - type: StringLength1to16
     * - use: optional
     * @var string
     */
    public $InvTypeCode;
    /**
     * The IsRoom
     * Meta information extracted from the WSDL
     * - documentation: Simple indicator to detect if inventory is a room.
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $IsRoom;
    /**
     * The Mon
     * @var bool
     */
    public $Mon;
    /**
     * The Tue
     * @var bool
     */
    public $Tue;
    /**
     * The Weds
     * @var bool
     */
    public $Weds;
    /**
     * The Thur
     * @var bool
     */
    public $Thur;
    /**
     * The Fri
     * @var bool
     */
    public $Fri;
    /**
     * The Sat
     * @var bool
     */
    public $Sat;
    /**
     * The Sun
     * @var bool
     */
    public $Sun;
    /**
     * The RatePlanCodeType
     * @var string
     */
    public $RatePlanCodeType;
    /**
     * The InvBlockCodeApply
     * @var string
     */
    public $InvBlockCodeApply;
    /**
     * Constructor method for StatusApplicationControlType
     * @uses StatusApplicationControlType::setDestinationSystemCodes()
     * @uses StatusApplicationControlType::setRateTier()
     * @uses StatusApplicationControlType::setAllRateCode()
     * @uses StatusApplicationControlType::setAllInvCode()
     * @uses StatusApplicationControlType::setInvBlockCode()
     * @uses StatusApplicationControlType::setOverride()
     * @uses StatusApplicationControlType::setQuoteID()
     * @uses StatusApplicationControlType::setSubBlockCode()
     * @uses StatusApplicationControlType::setWingIdentifier()
     * @uses StatusApplicationControlType::setStart()
     * @uses StatusApplicationControlType::setDuration()
     * @uses StatusApplicationControlType::setEnd()
     * @uses StatusApplicationControlType::setRatePlanType()
     * @uses StatusApplicationControlType::setRatePlanCode()
     * @uses StatusApplicationControlType::setRatePlanID()
     * @uses StatusApplicationControlType::setRatePlanQualifier()
     * @uses StatusApplicationControlType::setRatePlanCategory()
     * @uses StatusApplicationControlType::setPromotionCode()
     * @uses StatusApplicationControlType::setPromotionVendorCode()
     * @uses StatusApplicationControlType::setInvCodeApplication()
     * @uses StatusApplicationControlType::setInvCode()
     * @uses StatusApplicationControlType::setInvType()
     * @uses StatusApplicationControlType::setInvTypeCode()
     * @uses StatusApplicationControlType::setIsRoom()
     * @uses StatusApplicationControlType::setMon()
     * @uses StatusApplicationControlType::setTue()
     * @uses StatusApplicationControlType::setWeds()
     * @uses StatusApplicationControlType::setThur()
     * @uses StatusApplicationControlType::setFri()
     * @uses StatusApplicationControlType::setSat()
     * @uses StatusApplicationControlType::setSun()
     * @uses StatusApplicationControlType::setRatePlanCodeType()
     * @uses StatusApplicationControlType::setInvBlockCodeApply()
     * @param \StructType\DestinationSystemCodesType $destinationSystemCodes
     * @param string $rateTier
     * @param bool $allRateCode
     * @param bool $allInvCode
     * @param string $invBlockCode
     * @param bool $override
     * @param string $quoteID
     * @param string $subBlockCode
     * @param string $wingIdentifier
     * @param string $start
     * @param string $duration
     * @param string $end
     * @param string $ratePlanType
     * @param string $ratePlanCode
     * @param string $ratePlanID
     * @param bool $ratePlanQualifier
     * @param string $ratePlanCategory
     * @param string $promotionCode
     * @param string[] $promotionVendorCode
     * @param string $invCodeApplication
     * @param string $invCode
     * @param string $invType
     * @param string $invTypeCode
     * @param bool $isRoom
     * @param bool $mon
     * @param bool $tue
     * @param bool $weds
     * @param bool $thur
     * @param bool $fri
     * @param bool $sat
     * @param bool $sun
     * @param string $ratePlanCodeType
     * @param string $invBlockCodeApply
     */
    public function __construct(\StructType\DestinationSystemCodesType $destinationSystemCodes = null, $rateTier = null, $allRateCode = null, $allInvCode = null, $invBlockCode = null, $override = null, $quoteID = null, $subBlockCode = null, $wingIdentifier = null, $start = null, $duration = null, $end = null, $ratePlanType = null, $ratePlanCode = null, $ratePlanID = null, $ratePlanQualifier = null, $ratePlanCategory = null, $promotionCode = null, array $promotionVendorCode = array(), $invCodeApplication = null, $invCode = null, $invType = null, $invTypeCode = null, $isRoom = null, $mon = null, $tue = null, $weds = null, $thur = null, $fri = null, $sat = null, $sun = null, $ratePlanCodeType = null, $invBlockCodeApply = null)
    {
        $this
            ->setDestinationSystemCodes($destinationSystemCodes)
            ->setRateTier($rateTier)
            ->setAllRateCode($allRateCode)
            ->setAllInvCode($allInvCode)
            ->setInvBlockCode($invBlockCode)
            ->setOverride($override)
            ->setQuoteID($quoteID)
            ->setSubBlockCode($subBlockCode)
            ->setWingIdentifier($wingIdentifier)
            ->setStart($start)
            ->setDuration($duration)
            ->setEnd($end)
            ->setRatePlanType($ratePlanType)
            ->setRatePlanCode($ratePlanCode)
            ->setRatePlanID($ratePlanID)
            ->setRatePlanQualifier($ratePlanQualifier)
            ->setRatePlanCategory($ratePlanCategory)
            ->setPromotionCode($promotionCode)
            ->setPromotionVendorCode($promotionVendorCode)
            ->setInvCodeApplication($invCodeApplication)
            ->setInvCode($invCode)
            ->setInvType($invType)
            ->setInvTypeCode($invTypeCode)
            ->setIsRoom($isRoom)
            ->setMon($mon)
            ->setTue($tue)
            ->setWeds($weds)
            ->setThur($thur)
            ->setFri($fri)
            ->setSat($sat)
            ->setSun($sun)
            ->setRatePlanCodeType($ratePlanCodeType)
            ->setInvBlockCodeApply($invBlockCodeApply);
    }
    /**
     * Get DestinationSystemCodes value
     * @return \StructType\DestinationSystemCodesType|null
     */
    public function getDestinationSystemCodes()
    {
        return $this->DestinationSystemCodes;
    }
    /**
     * Set DestinationSystemCodes value
     * @param \StructType\DestinationSystemCodesType $destinationSystemCodes
     * @return \StructType\StatusApplicationControlType
     */
    public function setDestinationSystemCodes(\StructType\DestinationSystemCodesType $destinationSystemCodes = null)
    {
        $this->DestinationSystemCodes = $destinationSystemCodes;
        return $this;
    }
    /**
     * Get RateTier value
     * @return string|null
     */
    public function getRateTier()
    {
        return $this->RateTier;
    }
    /**
     * Set RateTier value
     * @param string $rateTier
     * @return \StructType\StatusApplicationControlType
     */
    public function setRateTier($rateTier = null)
    {
        // validation for constraint: string
        if (!is_null($rateTier) && !is_string($rateTier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rateTier, true), gettype($rateTier)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($rateTier) && mb_strlen($rateTier) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($rateTier)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($rateTier) && mb_strlen($rateTier) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($rateTier)), __LINE__);
        }
        $this->RateTier = $rateTier;
        return $this;
    }
    /**
     * Get AllRateCode value
     * @return bool|null
     */
    public function getAllRateCode()
    {
        return $this->AllRateCode;
    }
    /**
     * Set AllRateCode value
     * @param bool $allRateCode
     * @return \StructType\StatusApplicationControlType
     */
    public function setAllRateCode($allRateCode = null)
    {
        // validation for constraint: boolean
        if (!is_null($allRateCode) && !is_bool($allRateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allRateCode, true), gettype($allRateCode)), __LINE__);
        }
        $this->AllRateCode = $allRateCode;
        return $this;
    }
    /**
     * Get AllInvCode value
     * @return bool|null
     */
    public function getAllInvCode()
    {
        return $this->AllInvCode;
    }
    /**
     * Set AllInvCode value
     * @param bool $allInvCode
     * @return \StructType\StatusApplicationControlType
     */
    public function setAllInvCode($allInvCode = null)
    {
        // validation for constraint: boolean
        if (!is_null($allInvCode) && !is_bool($allInvCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allInvCode, true), gettype($allInvCode)), __LINE__);
        }
        $this->AllInvCode = $allInvCode;
        return $this;
    }
    /**
     * Get InvBlockCode value
     * @return string|null
     */
    public function getInvBlockCode()
    {
        return $this->InvBlockCode;
    }
    /**
     * Set InvBlockCode value
     * @param string $invBlockCode
     * @return \StructType\StatusApplicationControlType
     */
    public function setInvBlockCode($invBlockCode = null)
    {
        // validation for constraint: string
        if (!is_null($invBlockCode) && !is_string($invBlockCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invBlockCode, true), gettype($invBlockCode)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($invBlockCode) && mb_strlen($invBlockCode) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($invBlockCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($invBlockCode) && mb_strlen($invBlockCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($invBlockCode)), __LINE__);
        }
        $this->InvBlockCode = $invBlockCode;
        return $this;
    }
    /**
     * Get Override value
     * @return bool|null
     */
    public function getOverride()
    {
        return $this->Override;
    }
    /**
     * Set Override value
     * @param bool $override
     * @return \StructType\StatusApplicationControlType
     */
    public function setOverride($override = null)
    {
        // validation for constraint: boolean
        if (!is_null($override) && !is_bool($override)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($override, true), gettype($override)), __LINE__);
        }
        $this->Override = $override;
        return $this;
    }
    /**
     * Get QuoteID value
     * @return string|null
     */
    public function getQuoteID()
    {
        return $this->QuoteID;
    }
    /**
     * Set QuoteID value
     * @param string $quoteID
     * @return \StructType\StatusApplicationControlType
     */
    public function setQuoteID($quoteID = null)
    {
        // validation for constraint: string
        if (!is_null($quoteID) && !is_string($quoteID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quoteID, true), gettype($quoteID)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($quoteID) && mb_strlen($quoteID) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($quoteID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($quoteID) && mb_strlen($quoteID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($quoteID)), __LINE__);
        }
        $this->QuoteID = $quoteID;
        return $this;
    }
    /**
     * Get SubBlockCode value
     * @return string|null
     */
    public function getSubBlockCode()
    {
        return $this->SubBlockCode;
    }
    /**
     * Set SubBlockCode value
     * @param string $subBlockCode
     * @return \StructType\StatusApplicationControlType
     */
    public function setSubBlockCode($subBlockCode = null)
    {
        // validation for constraint: string
        if (!is_null($subBlockCode) && !is_string($subBlockCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subBlockCode, true), gettype($subBlockCode)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($subBlockCode) && mb_strlen($subBlockCode) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($subBlockCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($subBlockCode) && mb_strlen($subBlockCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($subBlockCode)), __LINE__);
        }
        $this->SubBlockCode = $subBlockCode;
        return $this;
    }
    /**
     * Get WingIdentifier value
     * @return string|null
     */
    public function getWingIdentifier()
    {
        return $this->WingIdentifier;
    }
    /**
     * Set WingIdentifier value
     * @param string $wingIdentifier
     * @return \StructType\StatusApplicationControlType
     */
    public function setWingIdentifier($wingIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($wingIdentifier) && !is_string($wingIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wingIdentifier, true), gettype($wingIdentifier)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($wingIdentifier) && mb_strlen($wingIdentifier) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($wingIdentifier)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($wingIdentifier) && mb_strlen($wingIdentifier) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($wingIdentifier)), __LINE__);
        }
        $this->WingIdentifier = $wingIdentifier;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * This method is responsible for validating the value passed to the setStart method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStart method
     * This is a set of validation rules based on the union types associated to the property being set by the setStart method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStartForUnionConstraintsFromSetStart($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime, time. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\StatusApplicationControlType
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        // validation for constraint: union(date, dateTime, time)
        if ('' !== ($startUnionErrorMessage = self::validateStartForUnionConstraintsFromSetStart($start))) {
            throw new \InvalidArgumentException($startUnionErrorMessage, __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * This method is responsible for validating the value passed to the setDuration method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDuration method
     * This is a set of validation rules based on the union types associated to the property being set by the setDuration method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDurationForUnionConstraintsFromSetDuration($value)
    {
        $message = '';
        // validation for constraint: pattern(P[0-9]{1,3}N)
        if (!is_null($value) && !preg_match('/P[0-9]{1,3}N/', $value)) {
            $exception0 = new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression P[0-9]{1,3}N', var_export($value, true)), __LINE__);
        }
        if (isset($exception0)) {
            $message = sprintf("The value %s does not match any of the union rules: duration, NightDurationType. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [$exception0])));
        }
        unset($exception0);
        return $message;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\StatusApplicationControlType
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        // validation for constraint: union(duration, NightDurationType)
        if ('' !== ($durationUnionErrorMessage = self::validateDurationForUnionConstraintsFromSetDuration($duration))) {
            throw new \InvalidArgumentException($durationUnionErrorMessage, __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * This method is responsible for validating the value passed to the setEnd method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEnd method
     * This is a set of validation rules based on the union types associated to the property being set by the setEnd method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEndForUnionConstraintsFromSetEnd($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime, time. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\StatusApplicationControlType
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        // validation for constraint: union(date, dateTime, time)
        if ('' !== ($endUnionErrorMessage = self::validateEndForUnionConstraintsFromSetEnd($end))) {
            throw new \InvalidArgumentException($endUnionErrorMessage, __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get RatePlanType value
     * @return string|null
     */
    public function getRatePlanType()
    {
        return $this->RatePlanType;
    }
    /**
     * Set RatePlanType value
     * @param string $ratePlanType
     * @return \StructType\StatusApplicationControlType
     */
    public function setRatePlanType($ratePlanType = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanType) && !is_string($ratePlanType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanType, true), gettype($ratePlanType)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($ratePlanType) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $ratePlanType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($ratePlanType, true)), __LINE__);
        }
        $this->RatePlanType = $ratePlanType;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\StatusApplicationControlType
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCode, true), gettype($ratePlanCode)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ratePlanCode) && mb_strlen($ratePlanCode) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($ratePlanCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($ratePlanCode) && mb_strlen($ratePlanCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Get RatePlanID value
     * @return string|null
     */
    public function getRatePlanID()
    {
        return $this->RatePlanID;
    }
    /**
     * Set RatePlanID value
     * @param string $ratePlanID
     * @return \StructType\StatusApplicationControlType
     */
    public function setRatePlanID($ratePlanID = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanID) && !is_string($ratePlanID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanID, true), gettype($ratePlanID)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ratePlanID) && mb_strlen($ratePlanID) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($ratePlanID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($ratePlanID) && mb_strlen($ratePlanID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($ratePlanID)), __LINE__);
        }
        $this->RatePlanID = $ratePlanID;
        return $this;
    }
    /**
     * Get RatePlanQualifier value
     * @return bool|null
     */
    public function getRatePlanQualifier()
    {
        return $this->RatePlanQualifier;
    }
    /**
     * Set RatePlanQualifier value
     * @param bool $ratePlanQualifier
     * @return \StructType\StatusApplicationControlType
     */
    public function setRatePlanQualifier($ratePlanQualifier = null)
    {
        // validation for constraint: boolean
        if (!is_null($ratePlanQualifier) && !is_bool($ratePlanQualifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ratePlanQualifier, true), gettype($ratePlanQualifier)), __LINE__);
        }
        $this->RatePlanQualifier = $ratePlanQualifier;
        return $this;
    }
    /**
     * Get RatePlanCategory value
     * @return string|null
     */
    public function getRatePlanCategory()
    {
        return $this->RatePlanCategory;
    }
    /**
     * Set RatePlanCategory value
     * @param string $ratePlanCategory
     * @return \StructType\StatusApplicationControlType
     */
    public function setRatePlanCategory($ratePlanCategory = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCategory) && !is_string($ratePlanCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCategory, true), gettype($ratePlanCategory)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ratePlanCategory) && mb_strlen($ratePlanCategory) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($ratePlanCategory)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($ratePlanCategory) && mb_strlen($ratePlanCategory) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($ratePlanCategory)), __LINE__);
        }
        $this->RatePlanCategory = $ratePlanCategory;
        return $this;
    }
    /**
     * Get PromotionCode value
     * @return string|null
     */
    public function getPromotionCode()
    {
        return $this->PromotionCode;
    }
    /**
     * Set PromotionCode value
     * @param string $promotionCode
     * @return \StructType\StatusApplicationControlType
     */
    public function setPromotionCode($promotionCode = null)
    {
        // validation for constraint: string
        if (!is_null($promotionCode) && !is_string($promotionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promotionCode, true), gettype($promotionCode)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($promotionCode) && mb_strlen($promotionCode) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($promotionCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($promotionCode) && mb_strlen($promotionCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($promotionCode)), __LINE__);
        }
        $this->PromotionCode = $promotionCode;
        return $this;
    }
    /**
     * Get PromotionVendorCode value
     * @return string[]|null
     */
    public function getPromotionVendorCode()
    {
        return $this->PromotionVendorCode;
    }
    /**
     * This method is responsible for validating the values passed to the setPromotionVendorCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPromotionVendorCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePromotionVendorCodeForArrayConstraintsFromSetPromotionVendorCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $statusApplicationControlTypePromotionVendorCodeItem) {
            // validation for constraint: itemType
            if (!is_string($statusApplicationControlTypePromotionVendorCodeItem)) {
                $invalidValues[] = is_object($statusApplicationControlTypePromotionVendorCodeItem) ? get_class($statusApplicationControlTypePromotionVendorCodeItem) : sprintf('%s(%s)', gettype($statusApplicationControlTypePromotionVendorCodeItem), var_export($statusApplicationControlTypePromotionVendorCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PromotionVendorCode property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PromotionVendorCode value
     * @param string[] $promotionVendorCode
     * @return \StructType\StatusApplicationControlType
     */
    public function setPromotionVendorCode(array $promotionVendorCode = array())
    {
        // validation for constraint: list
        if ('' !== ($promotionVendorCodeArrayErrorMessage = self::validatePromotionVendorCodeForArrayConstraintsFromSetPromotionVendorCode($promotionVendorCode))) {
            throw new \InvalidArgumentException($promotionVendorCodeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($promotionVendorCode) && mb_strlen($promotionVendorCode) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($promotionVendorCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($promotionVendorCode) && mb_strlen($promotionVendorCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($promotionVendorCode)), __LINE__);
        }
        $this->PromotionVendorCode = is_array($promotionVendorCode) ? implode(' ', $promotionVendorCode) : null;
        return $this;
    }
    /**
     * Get InvCodeApplication value
     * @return string|null
     */
    public function getInvCodeApplication()
    {
        return $this->InvCodeApplication;
    }
    /**
     * Set InvCodeApplication value
     * @param string $invCodeApplication
     * @return \StructType\StatusApplicationControlType
     */
    public function setInvCodeApplication($invCodeApplication = null)
    {
        // validation for constraint: string
        if (!is_null($invCodeApplication) && !is_string($invCodeApplication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invCodeApplication, true), gettype($invCodeApplication)), __LINE__);
        }
        $this->InvCodeApplication = $invCodeApplication;
        return $this;
    }
    /**
     * Get InvCode value
     * @return string|null
     */
    public function getInvCode()
    {
        return $this->InvCode;
    }
    /**
     * Set InvCode value
     * @param string $invCode
     * @return \StructType\StatusApplicationControlType
     */
    public function setInvCode($invCode = null)
    {
        // validation for constraint: string
        if (!is_null($invCode) && !is_string($invCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invCode, true), gettype($invCode)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($invCode) && mb_strlen($invCode) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($invCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($invCode) && mb_strlen($invCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($invCode)), __LINE__);
        }
        $this->InvCode = $invCode;
        return $this;
    }
    /**
     * Get InvType value
     * @return string|null
     */
    public function getInvType()
    {
        return $this->InvType;
    }
    /**
     * Set InvType value
     * @param string $invType
     * @return \StructType\StatusApplicationControlType
     */
    public function setInvType($invType = null)
    {
        // validation for constraint: string
        if (!is_null($invType) && !is_string($invType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invType, true), gettype($invType)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($invType) && mb_strlen($invType) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($invType)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($invType) && mb_strlen($invType) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($invType)), __LINE__);
        }
        $this->InvType = $invType;
        return $this;
    }
    /**
     * Get InvTypeCode value
     * @return string|null
     */
    public function getInvTypeCode()
    {
        return $this->InvTypeCode;
    }
    /**
     * Set InvTypeCode value
     * @param string $invTypeCode
     * @return \StructType\StatusApplicationControlType
     */
    public function setInvTypeCode($invTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($invTypeCode) && !is_string($invTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invTypeCode, true), gettype($invTypeCode)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($invTypeCode) && mb_strlen($invTypeCode) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($invTypeCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($invTypeCode) && mb_strlen($invTypeCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($invTypeCode)), __LINE__);
        }
        $this->InvTypeCode = $invTypeCode;
        return $this;
    }
    /**
     * Get IsRoom value
     * @return bool|null
     */
    public function getIsRoom()
    {
        return $this->IsRoom;
    }
    /**
     * Set IsRoom value
     * @param bool $isRoom
     * @return \StructType\StatusApplicationControlType
     */
    public function setIsRoom($isRoom = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRoom) && !is_bool($isRoom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRoom, true), gettype($isRoom)), __LINE__);
        }
        $this->IsRoom = $isRoom;
        return $this;
    }
    /**
     * Get Mon value
     * @return bool|null
     */
    public function getMon()
    {
        return $this->Mon;
    }
    /**
     * Set Mon value
     * @param bool $mon
     * @return \StructType\StatusApplicationControlType
     */
    public function setMon($mon = null)
    {
        // validation for constraint: boolean
        if (!is_null($mon) && !is_bool($mon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mon, true), gettype($mon)), __LINE__);
        }
        $this->Mon = $mon;
        return $this;
    }
    /**
     * Get Tue value
     * @return bool|null
     */
    public function getTue()
    {
        return $this->Tue;
    }
    /**
     * Set Tue value
     * @param bool $tue
     * @return \StructType\StatusApplicationControlType
     */
    public function setTue($tue = null)
    {
        // validation for constraint: boolean
        if (!is_null($tue) && !is_bool($tue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($tue, true), gettype($tue)), __LINE__);
        }
        $this->Tue = $tue;
        return $this;
    }
    /**
     * Get Weds value
     * @return bool|null
     */
    public function getWeds()
    {
        return $this->Weds;
    }
    /**
     * Set Weds value
     * @param bool $weds
     * @return \StructType\StatusApplicationControlType
     */
    public function setWeds($weds = null)
    {
        // validation for constraint: boolean
        if (!is_null($weds) && !is_bool($weds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($weds, true), gettype($weds)), __LINE__);
        }
        $this->Weds = $weds;
        return $this;
    }
    /**
     * Get Thur value
     * @return bool|null
     */
    public function getThur()
    {
        return $this->Thur;
    }
    /**
     * Set Thur value
     * @param bool $thur
     * @return \StructType\StatusApplicationControlType
     */
    public function setThur($thur = null)
    {
        // validation for constraint: boolean
        if (!is_null($thur) && !is_bool($thur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($thur, true), gettype($thur)), __LINE__);
        }
        $this->Thur = $thur;
        return $this;
    }
    /**
     * Get Fri value
     * @return bool|null
     */
    public function getFri()
    {
        return $this->Fri;
    }
    /**
     * Set Fri value
     * @param bool $fri
     * @return \StructType\StatusApplicationControlType
     */
    public function setFri($fri = null)
    {
        // validation for constraint: boolean
        if (!is_null($fri) && !is_bool($fri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fri, true), gettype($fri)), __LINE__);
        }
        $this->Fri = $fri;
        return $this;
    }
    /**
     * Get Sat value
     * @return bool|null
     */
    public function getSat()
    {
        return $this->Sat;
    }
    /**
     * Set Sat value
     * @param bool $sat
     * @return \StructType\StatusApplicationControlType
     */
    public function setSat($sat = null)
    {
        // validation for constraint: boolean
        if (!is_null($sat) && !is_bool($sat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sat, true), gettype($sat)), __LINE__);
        }
        $this->Sat = $sat;
        return $this;
    }
    /**
     * Get Sun value
     * @return bool|null
     */
    public function getSun()
    {
        return $this->Sun;
    }
    /**
     * Set Sun value
     * @param bool $sun
     * @return \StructType\StatusApplicationControlType
     */
    public function setSun($sun = null)
    {
        // validation for constraint: boolean
        if (!is_null($sun) && !is_bool($sun)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sun, true), gettype($sun)), __LINE__);
        }
        $this->Sun = $sun;
        return $this;
    }
    /**
     * Get RatePlanCodeType value
     * @return string|null
     */
    public function getRatePlanCodeType()
    {
        return $this->RatePlanCodeType;
    }
    /**
     * Set RatePlanCodeType value
     * @param string $ratePlanCodeType
     * @return \StructType\StatusApplicationControlType
     */
    public function setRatePlanCodeType($ratePlanCodeType = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCodeType) && !is_string($ratePlanCodeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCodeType, true), gettype($ratePlanCodeType)), __LINE__);
        }
        $this->RatePlanCodeType = $ratePlanCodeType;
        return $this;
    }
    /**
     * Get InvBlockCodeApply value
     * @return string|null
     */
    public function getInvBlockCodeApply()
    {
        return $this->InvBlockCodeApply;
    }
    /**
     * Set InvBlockCodeApply value
     * @param string $invBlockCodeApply
     * @return \StructType\StatusApplicationControlType
     */
    public function setInvBlockCodeApply($invBlockCodeApply = null)
    {
        // validation for constraint: string
        if (!is_null($invBlockCodeApply) && !is_string($invBlockCodeApply)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invBlockCodeApply, true), gettype($invBlockCodeApply)), __LINE__);
        }
        $this->InvBlockCodeApply = $invBlockCodeApply;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StatusApplicationControlType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
