<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StatisticCodes StructType
 * Meta information extracted from the WSDL
 * - documentation: Collection of StatisticCode elements. Used if data is partitioned/aggregated.
 * @subpackage Structs
 */
class StatisticCodes extends AbstractStructBase
{
    /**
     * The StatisticCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * @var \StructType\StatisticCode[]
     */
    public $StatisticCode;
    /**
     * Constructor method for StatisticCodes
     * @uses StatisticCodes::setStatisticCode()
     * @param \StructType\StatisticCode[] $statisticCode
     */
    public function __construct(array $statisticCode = array())
    {
        $this
            ->setStatisticCode($statisticCode);
    }
    /**
     * Get StatisticCode value
     * @return \StructType\StatisticCode[]|null
     */
    public function getStatisticCode()
    {
        return $this->StatisticCode;
    }
    /**
     * This method is responsible for validating the values passed to the setStatisticCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStatisticCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStatisticCodeForArrayConstraintsFromSetStatisticCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $statisticCodesStatisticCodeItem) {
            // validation for constraint: itemType
            if (!$statisticCodesStatisticCodeItem instanceof \StructType\StatisticCode) {
                $invalidValues[] = is_object($statisticCodesStatisticCodeItem) ? get_class($statisticCodesStatisticCodeItem) : sprintf('%s(%s)', gettype($statisticCodesStatisticCodeItem), var_export($statisticCodesStatisticCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The StatisticCode property can only contain items of type \StructType\StatisticCode, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set StatisticCode value
     * @throws \InvalidArgumentException
     * @param \StructType\StatisticCode[] $statisticCode
     * @return \StructType\StatisticCodes
     */
    public function setStatisticCode(array $statisticCode = array())
    {
        // validation for constraint: array
        if ('' !== ($statisticCodeArrayErrorMessage = self::validateStatisticCodeForArrayConstraintsFromSetStatisticCode($statisticCode))) {
            throw new \InvalidArgumentException($statisticCodeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($statisticCode) && count($statisticCode) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($statisticCode)), __LINE__);
        }
        $this->StatisticCode = $statisticCode;
        return $this;
    }
    /**
     * Add item to StatisticCode value
     * @throws \InvalidArgumentException
     * @param \StructType\StatisticCode $item
     * @return \StructType\StatisticCodes
     */
    public function addToStatisticCode(\StructType\StatisticCode $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StatisticCode) {
            throw new \InvalidArgumentException(sprintf('The StatisticCode property can only contain items of type \StructType\StatisticCode, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->StatisticCode) && count($this->StatisticCode) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->StatisticCode)), __LINE__);
        }
        $this->StatisticCode[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StatisticCodes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
