<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StatisticCode StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines the codes and corresponding categories for which the data in the other elements has been gathered.
 * @subpackage Structs
 */
class StatisticCode extends AbstractStructBase
{
    /**
     * The StatCode
     * Meta information extracted from the WSDL
     * - documentation: Actual code used by the system to collect the statistics (e.g. CORP, RACK if category is Market Segment). | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - type: StringLength1to64
     * - use: optional
     * @var string
     */
    public $StatCode;
    /**
     * The StatCategoryCode
     * Meta information extracted from the WSDL
     * - documentation: Category Code category of StatCode attribute (e.g. Market Segment). Refer to Code List SCC. | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - type: OTA_CodeType
     * - use: optional
     * @var string
     */
    public $StatCategoryCode;
    /**
     * Constructor method for StatisticCode
     * @uses StatisticCode::setStatCode()
     * @uses StatisticCode::setStatCategoryCode()
     * @param string $statCode
     * @param string $statCategoryCode
     */
    public function __construct($statCode = null, $statCategoryCode = null)
    {
        $this
            ->setStatCode($statCode)
            ->setStatCategoryCode($statCategoryCode);
    }
    /**
     * Get StatCode value
     * @return string|null
     */
    public function getStatCode()
    {
        return $this->StatCode;
    }
    /**
     * Set StatCode value
     * @param string $statCode
     * @return \StructType\StatisticCode
     */
    public function setStatCode($statCode = null)
    {
        // validation for constraint: string
        if (!is_null($statCode) && !is_string($statCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statCode, true), gettype($statCode)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($statCode) && mb_strlen($statCode) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($statCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($statCode) && mb_strlen($statCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($statCode)), __LINE__);
        }
        $this->StatCode = $statCode;
        return $this;
    }
    /**
     * Get StatCategoryCode value
     * @return string|null
     */
    public function getStatCategoryCode()
    {
        return $this->StatCategoryCode;
    }
    /**
     * Set StatCategoryCode value
     * @param string $statCategoryCode
     * @return \StructType\StatisticCode
     */
    public function setStatCategoryCode($statCategoryCode = null)
    {
        // validation for constraint: string
        if (!is_null($statCategoryCode) && !is_string($statCategoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statCategoryCode, true), gettype($statCategoryCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($statCategoryCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $statCategoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($statCategoryCode, true)), __LINE__);
        }
        $this->StatCategoryCode = $statCategoryCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StatisticCode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
