<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpecialServiceRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: The birth date of the traveler to whom this SSR applies. | AWG to revisit. | Special Service Requests (SSR) for this booking.
 * @subpackage Structs
 */
class SpecialServiceRequest extends SpecialServiceRequestType
{
    /**
     * The FlightLeg
     * Meta information extracted from the WSDL
     * - documentation: Flight information associated to this special request, used when FlightRefNumberRPHList is not available or is different.
     * - minOccurs: 0
     * @var \StructType\FlightLegType
     */
    public $FlightLeg;
    /**
     * The TravelerRefNumberRPHList
     * Meta information extracted from the WSDL
     * - documentation: One or more travelers to whom this request applies. | The Reference Place Holder (RPH) is an index code used to identify an instance in a collection of like items (e.g. used to assign individual passengers or clients to particular
     * itinerary items). | List of Reference Place Holders.
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string[]
     */
    public $TravelerRefNumberRPHList;
    /**
     * The FlightRefNumberRPHList
     * Meta information extracted from the WSDL
     * - documentation: One or more flights to whom this request applies. | The Reference Place Holder (RPH) is an index code used to identify an instance in a collection of like items (e.g. used to assign individual passengers or clients to particular
     * itinerary items). | List of Reference Place Holders.
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string[]
     */
    public $FlightRefNumberRPHList;
    /**
     * The BirthDate
     * @var string
     */
    public $BirthDate;
    /**
     * Constructor method for SpecialServiceRequest
     * @uses SpecialServiceRequest::setFlightLeg()
     * @uses SpecialServiceRequest::setTravelerRefNumberRPHList()
     * @uses SpecialServiceRequest::setFlightRefNumberRPHList()
     * @uses SpecialServiceRequest::setBirthDate()
     * @param \StructType\FlightLegType $flightLeg
     * @param string[] $travelerRefNumberRPHList
     * @param string[] $flightRefNumberRPHList
     * @param string $birthDate
     */
    public function __construct(\StructType\FlightLegType $flightLeg = null, array $travelerRefNumberRPHList = array(), array $flightRefNumberRPHList = array(), $birthDate = null)
    {
        $this
            ->setFlightLeg($flightLeg)
            ->setTravelerRefNumberRPHList($travelerRefNumberRPHList)
            ->setFlightRefNumberRPHList($flightRefNumberRPHList)
            ->setBirthDate($birthDate);
    }
    /**
     * Get FlightLeg value
     * @return \StructType\FlightLegType|null
     */
    public function getFlightLeg()
    {
        return $this->FlightLeg;
    }
    /**
     * Set FlightLeg value
     * @param \StructType\FlightLegType $flightLeg
     * @return \StructType\SpecialServiceRequest
     */
    public function setFlightLeg(\StructType\FlightLegType $flightLeg = null)
    {
        $this->FlightLeg = $flightLeg;
        return $this;
    }
    /**
     * Get TravelerRefNumberRPHList value
     * @return string[]|null
     */
    public function getTravelerRefNumberRPHList()
    {
        return $this->TravelerRefNumberRPHList;
    }
    /**
     * This method is responsible for validating the values passed to the setTravelerRefNumberRPHList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTravelerRefNumberRPHList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTravelerRefNumberRPHListForArrayConstraintsFromSetTravelerRefNumberRPHList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $specialServiceRequestTravelerRefNumberRPHListItem) {
            // validation for constraint: itemType
            if (!is_string($specialServiceRequestTravelerRefNumberRPHListItem)) {
                $invalidValues[] = is_object($specialServiceRequestTravelerRefNumberRPHListItem) ? get_class($specialServiceRequestTravelerRefNumberRPHListItem) : sprintf('%s(%s)', gettype($specialServiceRequestTravelerRefNumberRPHListItem), var_export($specialServiceRequestTravelerRefNumberRPHListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TravelerRefNumberRPHList property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TravelerRefNumberRPHList value
     * @param string[] $travelerRefNumberRPHList
     * @return \StructType\SpecialServiceRequest
     */
    public function setTravelerRefNumberRPHList(array $travelerRefNumberRPHList = array())
    {
        // validation for constraint: list
        if ('' !== ($travelerRefNumberRPHListArrayErrorMessage = self::validateTravelerRefNumberRPHListForArrayConstraintsFromSetTravelerRefNumberRPHList($travelerRefNumberRPHList))) {
            throw new \InvalidArgumentException($travelerRefNumberRPHListArrayErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($travelerRefNumberRPHList) && !preg_match('/[0-9]{1,8}/', $travelerRefNumberRPHList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($travelerRefNumberRPHList, true)), __LINE__);
        }
        $this->TravelerRefNumberRPHList = is_array($travelerRefNumberRPHList) ? implode(' ', $travelerRefNumberRPHList) : null;
        return $this;
    }
    /**
     * Get FlightRefNumberRPHList value
     * @return string[]|null
     */
    public function getFlightRefNumberRPHList()
    {
        return $this->FlightRefNumberRPHList;
    }
    /**
     * This method is responsible for validating the values passed to the setFlightRefNumberRPHList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFlightRefNumberRPHList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFlightRefNumberRPHListForArrayConstraintsFromSetFlightRefNumberRPHList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $specialServiceRequestFlightRefNumberRPHListItem) {
            // validation for constraint: itemType
            if (!is_string($specialServiceRequestFlightRefNumberRPHListItem)) {
                $invalidValues[] = is_object($specialServiceRequestFlightRefNumberRPHListItem) ? get_class($specialServiceRequestFlightRefNumberRPHListItem) : sprintf('%s(%s)', gettype($specialServiceRequestFlightRefNumberRPHListItem), var_export($specialServiceRequestFlightRefNumberRPHListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FlightRefNumberRPHList property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FlightRefNumberRPHList value
     * @param string[] $flightRefNumberRPHList
     * @return \StructType\SpecialServiceRequest
     */
    public function setFlightRefNumberRPHList(array $flightRefNumberRPHList = array())
    {
        // validation for constraint: list
        if ('' !== ($flightRefNumberRPHListArrayErrorMessage = self::validateFlightRefNumberRPHListForArrayConstraintsFromSetFlightRefNumberRPHList($flightRefNumberRPHList))) {
            throw new \InvalidArgumentException($flightRefNumberRPHListArrayErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($flightRefNumberRPHList) && !preg_match('/[0-9]{1,8}/', $flightRefNumberRPHList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($flightRefNumberRPHList, true)), __LINE__);
        }
        $this->FlightRefNumberRPHList = is_array($flightRefNumberRPHList) ? implode(' ', $flightRefNumberRPHList) : null;
        return $this;
    }
    /**
     * Get BirthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param string $birthDate
     * @return \StructType\SpecialServiceRequest
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthDate, true), gettype($birthDate)), __LINE__);
        }
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SpecialServiceRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
