<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpecialRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: The SpecialRequest object indicates special requests for a particular guest, service or reservation. Each of these may be independent of any that are tied to the profile (see Profile Synchronization standard).
 * @subpackage Structs
 */
class SpecialRequest extends ParagraphType
{
    /**
     * The RequestCode
     * Meta information extracted from the WSDL
     * - documentation: This identifies a special request for this reservation and is typically hotel-specific. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $RequestCode;
    /**
     * The CodeContext
     * Meta information extracted from the WSDL
     * - documentation: Identifies the source authority for the RequestCode. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $CodeContext;
    /**
     * The NumberOfUnits
     * Meta information extracted from the WSDL
     * - documentation: Allows you to pass the number of units that the special request is for (e.g., if 4 rooms are booked you may want 3 with double/double beds and 1 with a king).
     * - use: optional
     * @var int
     */
    public $NumberOfUnits;
    /**
     * Constructor method for SpecialRequest
     * @uses SpecialRequest::setRequestCode()
     * @uses SpecialRequest::setCodeContext()
     * @uses SpecialRequest::setNumberOfUnits()
     * @param string $requestCode
     * @param string $codeContext
     * @param int $numberOfUnits
     */
    public function __construct($requestCode = null, $codeContext = null, $numberOfUnits = null)
    {
        $this
            ->setRequestCode($requestCode)
            ->setCodeContext($codeContext)
            ->setNumberOfUnits($numberOfUnits);
    }
    /**
     * Get RequestCode value
     * @return string|null
     */
    public function getRequestCode()
    {
        return $this->RequestCode;
    }
    /**
     * Set RequestCode value
     * @param string $requestCode
     * @return \StructType\SpecialRequest
     */
    public function setRequestCode($requestCode = null)
    {
        // validation for constraint: string
        if (!is_null($requestCode) && !is_string($requestCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestCode, true), gettype($requestCode)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($requestCode) && mb_strlen($requestCode) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($requestCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($requestCode) && mb_strlen($requestCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($requestCode)), __LINE__);
        }
        $this->RequestCode = $requestCode;
        return $this;
    }
    /**
     * Get CodeContext value
     * @return string|null
     */
    public function getCodeContext()
    {
        return $this->CodeContext;
    }
    /**
     * Set CodeContext value
     * @param string $codeContext
     * @return \StructType\SpecialRequest
     */
    public function setCodeContext($codeContext = null)
    {
        // validation for constraint: string
        if (!is_null($codeContext) && !is_string($codeContext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codeContext, true), gettype($codeContext)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($codeContext) && mb_strlen($codeContext) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($codeContext)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($codeContext) && mb_strlen($codeContext) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($codeContext)), __LINE__);
        }
        $this->CodeContext = $codeContext;
        return $this;
    }
    /**
     * Get NumberOfUnits value
     * @return int|null
     */
    public function getNumberOfUnits()
    {
        return $this->NumberOfUnits;
    }
    /**
     * Set NumberOfUnits value
     * @param int $numberOfUnits
     * @return \StructType\SpecialRequest
     */
    public function setNumberOfUnits($numberOfUnits = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfUnits) && !(is_int($numberOfUnits) || ctype_digit($numberOfUnits))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfUnits, true), gettype($numberOfUnits)), __LINE__);
        }
        $this->NumberOfUnits = $numberOfUnits;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SpecialRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
