<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SourceType StructType
 * Meta information extracted from the WSDL
 * - documentation: Provides information on the source of a request. | Information describing the point of sale.
 * @subpackage Structs
 */
class SourceType extends AbstractStructBase
{
    /**
     * The RequestorID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RequestorID
     */
    public $RequestorID;
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Position
     */
    public $Position;
    /**
     * The BookingChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BookingChannel
     */
    public $BookingChannel;
    /**
     * The AgentSine
     * Meta information extracted from the WSDL
     * - documentation: Identifies the party within the requesting entity. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $AgentSine;
    /**
     * The PseudoCityCode
     * Meta information extracted from the WSDL
     * - documentation: An identification code assigned to an office/agency by a reservation system. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $PseudoCityCode;
    /**
     * The ISOCountry
     * Meta information extracted from the WSDL
     * - documentation: The country code of the requesting party. | Specifies a 2 character country code as defined in ISO3166.
     * - base: xs:string
     * - pattern: [a-zA-Z]{2}
     * - use: optional
     * @var string
     */
    public $ISOCountry;
    /**
     * The ISOCurrency
     * Meta information extracted from the WSDL
     * - documentation: The currency code in which the reservation will be ticketed. | Used for an Alpha String, length exactly 3.
     * - base: xs:string
     * - pattern: [a-zA-Z]{3}
     * - use: optional
     * @var string
     */
    public $ISOCurrency;
    /**
     * The AgentDutyCode
     * Meta information extracted from the WSDL
     * - documentation: An authority code assigned to a requestor. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $AgentDutyCode;
    /**
     * The AirlineVendorID
     * Meta information extracted from the WSDL
     * - documentation: The IATA assigned airline code. | Used for an Upper Alpha String and Numeric, length 2 to 3.
     * - base: xs:string
     * - pattern: [A-Z0-9]{2,3}
     * - use: optional
     * @var string
     */
    public $AirlineVendorID;
    /**
     * The AirportCode
     * Meta information extracted from the WSDL
     * - documentation: The IATA assigned airport code. | Used for an Upper Alpha String and Numeric, length 3 to 5.
     * - base: xs:string
     * - pattern: [A-Z0-9]{3,5}
     * - use: optional
     * @var string
     */
    public $AirportCode;
    /**
     * The FirstDepartPoint
     * Meta information extracted from the WSDL
     * - documentation: The point of first departure in a trip. | Used for Strings, length exactly 3.
     * - base: xs:string
     * - maxLength: 3
     * - minLength: 3
     * - use: optional
     * @var string
     */
    public $FirstDepartPoint;
    /**
     * The ERSP_UserID
     * Meta information extracted from the WSDL
     * - documentation: Electronic Reservation Service Provider (ERSP) assigned identifier used to identify the individual using the ERSP system. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $ERSP_UserID;
    /**
     * The TerminalID
     * Meta information extracted from the WSDL
     * - documentation: This is the electronic address of the device from which information is entered. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $TerminalID;
    /**
     * Constructor method for SourceType
     * @uses SourceType::setRequestorID()
     * @uses SourceType::setPosition()
     * @uses SourceType::setBookingChannel()
     * @uses SourceType::setAgentSine()
     * @uses SourceType::setPseudoCityCode()
     * @uses SourceType::setISOCountry()
     * @uses SourceType::setISOCurrency()
     * @uses SourceType::setAgentDutyCode()
     * @uses SourceType::setAirlineVendorID()
     * @uses SourceType::setAirportCode()
     * @uses SourceType::setFirstDepartPoint()
     * @uses SourceType::setERSP_UserID()
     * @uses SourceType::setTerminalID()
     * @param \StructType\RequestorID $requestorID
     * @param \StructType\Position $position
     * @param \StructType\BookingChannel $bookingChannel
     * @param string $agentSine
     * @param string $pseudoCityCode
     * @param string $iSOCountry
     * @param string $iSOCurrency
     * @param string $agentDutyCode
     * @param string $airlineVendorID
     * @param string $airportCode
     * @param string $firstDepartPoint
     * @param string $eRSP_UserID
     * @param string $terminalID
     */
    public function __construct(\StructType\RequestorID $requestorID = null, \StructType\Position $position = null, \StructType\BookingChannel $bookingChannel = null, $agentSine = null, $pseudoCityCode = null, $iSOCountry = null, $iSOCurrency = null, $agentDutyCode = null, $airlineVendorID = null, $airportCode = null, $firstDepartPoint = null, $eRSP_UserID = null, $terminalID = null)
    {
        $this
            ->setRequestorID($requestorID)
            ->setPosition($position)
            ->setBookingChannel($bookingChannel)
            ->setAgentSine($agentSine)
            ->setPseudoCityCode($pseudoCityCode)
            ->setISOCountry($iSOCountry)
            ->setISOCurrency($iSOCurrency)
            ->setAgentDutyCode($agentDutyCode)
            ->setAirlineVendorID($airlineVendorID)
            ->setAirportCode($airportCode)
            ->setFirstDepartPoint($firstDepartPoint)
            ->setERSP_UserID($eRSP_UserID)
            ->setTerminalID($terminalID);
    }
    /**
     * Get RequestorID value
     * @return \StructType\RequestorID|null
     */
    public function getRequestorID()
    {
        return $this->RequestorID;
    }
    /**
     * Set RequestorID value
     * @param \StructType\RequestorID $requestorID
     * @return \StructType\SourceType
     */
    public function setRequestorID(\StructType\RequestorID $requestorID = null)
    {
        $this->RequestorID = $requestorID;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\Position|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\Position $position
     * @return \StructType\SourceType
     */
    public function setPosition(\StructType\Position $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get BookingChannel value
     * @return \StructType\BookingChannel|null
     */
    public function getBookingChannel()
    {
        return $this->BookingChannel;
    }
    /**
     * Set BookingChannel value
     * @param \StructType\BookingChannel $bookingChannel
     * @return \StructType\SourceType
     */
    public function setBookingChannel(\StructType\BookingChannel $bookingChannel = null)
    {
        $this->BookingChannel = $bookingChannel;
        return $this;
    }
    /**
     * Get AgentSine value
     * @return string|null
     */
    public function getAgentSine()
    {
        return $this->AgentSine;
    }
    /**
     * Set AgentSine value
     * @param string $agentSine
     * @return \StructType\SourceType
     */
    public function setAgentSine($agentSine = null)
    {
        // validation for constraint: string
        if (!is_null($agentSine) && !is_string($agentSine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentSine, true), gettype($agentSine)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($agentSine) && mb_strlen($agentSine) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($agentSine)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($agentSine) && mb_strlen($agentSine) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($agentSine)), __LINE__);
        }
        $this->AgentSine = $agentSine;
        return $this;
    }
    /**
     * Get PseudoCityCode value
     * @return string|null
     */
    public function getPseudoCityCode()
    {
        return $this->PseudoCityCode;
    }
    /**
     * Set PseudoCityCode value
     * @param string $pseudoCityCode
     * @return \StructType\SourceType
     */
    public function setPseudoCityCode($pseudoCityCode = null)
    {
        // validation for constraint: string
        if (!is_null($pseudoCityCode) && !is_string($pseudoCityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pseudoCityCode, true), gettype($pseudoCityCode)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($pseudoCityCode) && mb_strlen($pseudoCityCode) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($pseudoCityCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($pseudoCityCode) && mb_strlen($pseudoCityCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($pseudoCityCode)), __LINE__);
        }
        $this->PseudoCityCode = $pseudoCityCode;
        return $this;
    }
    /**
     * Get ISOCountry value
     * @return string|null
     */
    public function getISOCountry()
    {
        return $this->ISOCountry;
    }
    /**
     * Set ISOCountry value
     * @param string $iSOCountry
     * @return \StructType\SourceType
     */
    public function setISOCountry($iSOCountry = null)
    {
        // validation for constraint: string
        if (!is_null($iSOCountry) && !is_string($iSOCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iSOCountry, true), gettype($iSOCountry)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z]{2})
        if (!is_null($iSOCountry) && !preg_match('/[a-zA-Z]{2}/', $iSOCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z]{2}', var_export($iSOCountry, true)), __LINE__);
        }
        $this->ISOCountry = $iSOCountry;
        return $this;
    }
    /**
     * Get ISOCurrency value
     * @return string|null
     */
    public function getISOCurrency()
    {
        return $this->ISOCurrency;
    }
    /**
     * Set ISOCurrency value
     * @param string $iSOCurrency
     * @return \StructType\SourceType
     */
    public function setISOCurrency($iSOCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($iSOCurrency) && !is_string($iSOCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iSOCurrency, true), gettype($iSOCurrency)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z]{3})
        if (!is_null($iSOCurrency) && !preg_match('/[a-zA-Z]{3}/', $iSOCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z]{3}', var_export($iSOCurrency, true)), __LINE__);
        }
        $this->ISOCurrency = $iSOCurrency;
        return $this;
    }
    /**
     * Get AgentDutyCode value
     * @return string|null
     */
    public function getAgentDutyCode()
    {
        return $this->AgentDutyCode;
    }
    /**
     * Set AgentDutyCode value
     * @param string $agentDutyCode
     * @return \StructType\SourceType
     */
    public function setAgentDutyCode($agentDutyCode = null)
    {
        // validation for constraint: string
        if (!is_null($agentDutyCode) && !is_string($agentDutyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentDutyCode, true), gettype($agentDutyCode)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($agentDutyCode) && mb_strlen($agentDutyCode) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($agentDutyCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($agentDutyCode) && mb_strlen($agentDutyCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($agentDutyCode)), __LINE__);
        }
        $this->AgentDutyCode = $agentDutyCode;
        return $this;
    }
    /**
     * Get AirlineVendorID value
     * @return string|null
     */
    public function getAirlineVendorID()
    {
        return $this->AirlineVendorID;
    }
    /**
     * Set AirlineVendorID value
     * @param string $airlineVendorID
     * @return \StructType\SourceType
     */
    public function setAirlineVendorID($airlineVendorID = null)
    {
        // validation for constraint: string
        if (!is_null($airlineVendorID) && !is_string($airlineVendorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airlineVendorID, true), gettype($airlineVendorID)), __LINE__);
        }
        // validation for constraint: pattern([A-Z0-9]{2,3})
        if (!is_null($airlineVendorID) && !preg_match('/[A-Z0-9]{2,3}/', $airlineVendorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z0-9]{2,3}', var_export($airlineVendorID, true)), __LINE__);
        }
        $this->AirlineVendorID = $airlineVendorID;
        return $this;
    }
    /**
     * Get AirportCode value
     * @return string|null
     */
    public function getAirportCode()
    {
        return $this->AirportCode;
    }
    /**
     * Set AirportCode value
     * @param string $airportCode
     * @return \StructType\SourceType
     */
    public function setAirportCode($airportCode = null)
    {
        // validation for constraint: string
        if (!is_null($airportCode) && !is_string($airportCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airportCode, true), gettype($airportCode)), __LINE__);
        }
        // validation for constraint: pattern([A-Z0-9]{3,5})
        if (!is_null($airportCode) && !preg_match('/[A-Z0-9]{3,5}/', $airportCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z0-9]{3,5}', var_export($airportCode, true)), __LINE__);
        }
        $this->AirportCode = $airportCode;
        return $this;
    }
    /**
     * Get FirstDepartPoint value
     * @return string|null
     */
    public function getFirstDepartPoint()
    {
        return $this->FirstDepartPoint;
    }
    /**
     * Set FirstDepartPoint value
     * @param string $firstDepartPoint
     * @return \StructType\SourceType
     */
    public function setFirstDepartPoint($firstDepartPoint = null)
    {
        // validation for constraint: string
        if (!is_null($firstDepartPoint) && !is_string($firstDepartPoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstDepartPoint, true), gettype($firstDepartPoint)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($firstDepartPoint) && mb_strlen($firstDepartPoint) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($firstDepartPoint)), __LINE__);
        }
        // validation for constraint: minLength(3)
        if (!is_null($firstDepartPoint) && mb_strlen($firstDepartPoint) < 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 3', mb_strlen($firstDepartPoint)), __LINE__);
        }
        $this->FirstDepartPoint = $firstDepartPoint;
        return $this;
    }
    /**
     * Get ERSP_UserID value
     * @return string|null
     */
    public function getERSP_UserID()
    {
        return $this->ERSP_UserID;
    }
    /**
     * Set ERSP_UserID value
     * @param string $eRSP_UserID
     * @return \StructType\SourceType
     */
    public function setERSP_UserID($eRSP_UserID = null)
    {
        // validation for constraint: string
        if (!is_null($eRSP_UserID) && !is_string($eRSP_UserID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eRSP_UserID, true), gettype($eRSP_UserID)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($eRSP_UserID) && mb_strlen($eRSP_UserID) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($eRSP_UserID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($eRSP_UserID) && mb_strlen($eRSP_UserID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($eRSP_UserID)), __LINE__);
        }
        $this->ERSP_UserID = $eRSP_UserID;
        return $this;
    }
    /**
     * Get TerminalID value
     * @return string|null
     */
    public function getTerminalID()
    {
        return $this->TerminalID;
    }
    /**
     * Set TerminalID value
     * @param string $terminalID
     * @return \StructType\SourceType
     */
    public function setTerminalID($terminalID = null)
    {
        // validation for constraint: string
        if (!is_null($terminalID) && !is_string($terminalID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($terminalID, true), gettype($terminalID)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($terminalID) && mb_strlen($terminalID) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($terminalID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($terminalID) && mb_strlen($terminalID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($terminalID)), __LINE__);
        }
        $this->TerminalID = $terminalID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SourceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
