<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceRPH StructType
 * Meta information extracted from the WSDL
 * - documentation: This is a reference placeholder used as an index for a service to be associated with this stay
 * @subpackage Structs
 */
class ServiceRPH extends AbstractStructBase
{
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: Provides a unique reference to the service. | The Reference Place Holder (RPH) is an index code used to identify an instance in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary
     * items).
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The IsPerRoom
     * Meta information extracted from the WSDL
     * - documentation: Defines whether this is for each room of a RoomStay
     * - use: optional
     * @var bool
     */
    public $IsPerRoom;
    /**
     * Constructor method for ServiceRPH
     * @uses ServiceRPH::setRPH()
     * @uses ServiceRPH::setIsPerRoom()
     * @param string $rPH
     * @param bool $isPerRoom
     */
    public function __construct($rPH = null, $isPerRoom = null)
    {
        $this
            ->setRPH($rPH)
            ->setIsPerRoom($isPerRoom);
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\ServiceRPH
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($rPH) && !preg_match('/[0-9]{1,8}/', $rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($rPH, true)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get IsPerRoom value
     * @return bool|null
     */
    public function getIsPerRoom()
    {
        return $this->IsPerRoom;
    }
    /**
     * Set IsPerRoom value
     * @param bool $isPerRoom
     * @return \StructType\ServiceRPH
     */
    public function setIsPerRoom($isPerRoom = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPerRoom) && !is_bool($isPerRoom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPerRoom, true), gettype($isPerRoom)), __LINE__);
        }
        $this->IsPerRoom = $isPerRoom;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServiceRPH
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
