<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SellableProduct StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines the sellable date range for this product. | The individual sellable product. A sellable product may be a guest room, a meeting room or an inventory block. Attributes of SellableProduct are the inventory codes, information on
 * the use, application and sequencing of the inventory information.
 * @subpackage Structs
 */
class SellableProduct extends AbstractStructBase
{
    /**
     * The DestinationSystemCodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DestinationSystemCodes
     */
    public $DestinationSystemCodes;
    /**
     * The GuestRoom
     * Meta information extracted from the WSDL
     * - documentation: Guest room information if this sellable product is a guest room.
     * - choice: GuestRoom | MeetingRooms | InventoryBlock
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\GuestRoomType
     */
    public $GuestRoom;
    /**
     * The MeetingRooms
     * Meta information extracted from the WSDL
     * - documentation: Meeting room information if this sellable product is a meeting room.
     * - choice: GuestRoom | MeetingRooms | InventoryBlock
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\MeetingRoomsType
     */
    public $MeetingRooms;
    /**
     * The InventoryBlock
     * Meta information extracted from the WSDL
     * - choice: GuestRoom | MeetingRooms | InventoryBlock
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\InventoryBlock
     */
    public $InventoryBlock;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Description of the sellable product.
     * - minOccurs: 0
     * @var \StructType\ParagraphType
     */
    public $Description;
    /**
     * The UniqueID
     * Meta information extracted from the WSDL
     * - documentation: The SellableProduct class defines the inventoriable item for this rate plan.
     * - minOccurs: 0
     * @var \StructType\UniqueID_Type
     */
    public $UniqueID;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: This is a reference placeholder, used as an index for this sellable product. | The Reference Place Holder (RPH) is an index code used to identify an instance in a collection of like items (e.g. used to assign individual passengers or
     * clients to particular itinerary items).
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The InvNotifType
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $InvNotifType;
    /**
     * The InvStatusType
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $InvStatusType;
    /**
     * The InvGroupingCode
     * Meta information extracted from the WSDL
     * - documentation: The identification of the inventory grouping. Whether to use the sending/querying or the receiving/responding system's identification depends on which system is doing the translating.
     * - use: optional
     * @var string
     */
    public $InvGroupingCode;
    /**
     * The OrderSequence
     * Meta information extracted from the WSDL
     * - documentation: The order which the items should be acknowledged by the receiving entity. | Used for Numeric values, from 1 to 999 inclusive.
     * - base: xs:integer
     * - maxInclusive: 999
     * - minInclusive: 1
     * - use: optional
     * @var int
     */
    public $OrderSequence;
    /**
     * The InvCodeApplication
     * @var string
     */
    public $InvCodeApplication;
    /**
     * The InvCode
     * Meta information extracted from the WSDL
     * - documentation: Code that identifies an inventory item. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - type: StringLength1to16
     * - use: optional
     * @var string
     */
    public $InvCode;
    /**
     * The InvType
     * Meta information extracted from the WSDL
     * - documentation: A value that indicates the type of inventory for which this request is made. If the inventory item is a room, typical values could be double, king, etc. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - type: StringLength1to16
     * - use: optional
     * @var string
     */
    public $InvType;
    /**
     * The InvTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Specific system inventory type code. If the inventory item is a room, typical values could be room type code, e.g.: A1K, A1Q etc. Values may use the OpenTravel Code list or a code specific to the property or hotel brand. | Used for
     * Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - type: StringLength1to16
     * - use: optional
     * @var string
     */
    public $InvTypeCode;
    /**
     * The IsRoom
     * Meta information extracted from the WSDL
     * - documentation: Simple indicator to detect if inventory is a room.
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $IsRoom;
    /**
     * The Start
     * Meta information extracted from the WSDL
     * - documentation: A construct to validate either a date or a time or a dateTime value.
     * - union: date | dateTime | time
     * @var string
     */
    public $Start;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - documentation: Allows for the specification of a night duration.
     * - union: duration | NightDurationType
     * @var string
     */
    public $Duration;
    /**
     * The End
     * Meta information extracted from the WSDL
     * - documentation: A construct to validate either a date or a time or a dateTime value.
     * - union: date | dateTime | time
     * @var string
     */
    public $End;
    /**
     * Constructor method for SellableProduct
     * @uses SellableProduct::setDestinationSystemCodes()
     * @uses SellableProduct::setGuestRoom()
     * @uses SellableProduct::setMeetingRooms()
     * @uses SellableProduct::setInventoryBlock()
     * @uses SellableProduct::setDescription()
     * @uses SellableProduct::setUniqueID()
     * @uses SellableProduct::setRPH()
     * @uses SellableProduct::setInvNotifType()
     * @uses SellableProduct::setInvStatusType()
     * @uses SellableProduct::setInvGroupingCode()
     * @uses SellableProduct::setOrderSequence()
     * @uses SellableProduct::setInvCodeApplication()
     * @uses SellableProduct::setInvCode()
     * @uses SellableProduct::setInvType()
     * @uses SellableProduct::setInvTypeCode()
     * @uses SellableProduct::setIsRoom()
     * @uses SellableProduct::setStart()
     * @uses SellableProduct::setDuration()
     * @uses SellableProduct::setEnd()
     * @param \StructType\DestinationSystemCodes $destinationSystemCodes
     * @param \StructType\GuestRoomType $guestRoom
     * @param \StructType\MeetingRoomsType $meetingRooms
     * @param \StructType\InventoryBlock $inventoryBlock
     * @param \StructType\ParagraphType $description
     * @param \StructType\UniqueID_Type $uniqueID
     * @param string $rPH
     * @param string $invNotifType
     * @param string $invStatusType
     * @param string $invGroupingCode
     * @param int $orderSequence
     * @param string $invCodeApplication
     * @param string $invCode
     * @param string $invType
     * @param string $invTypeCode
     * @param bool $isRoom
     * @param string $start
     * @param string $duration
     * @param string $end
     */
    public function __construct(\StructType\DestinationSystemCodes $destinationSystemCodes = null, \StructType\GuestRoomType $guestRoom = null, \StructType\MeetingRoomsType $meetingRooms = null, \StructType\InventoryBlock $inventoryBlock = null, \StructType\ParagraphType $description = null, \StructType\UniqueID_Type $uniqueID = null, $rPH = null, $invNotifType = null, $invStatusType = null, $invGroupingCode = null, $orderSequence = null, $invCodeApplication = null, $invCode = null, $invType = null, $invTypeCode = null, $isRoom = null, $start = null, $duration = null, $end = null)
    {
        $this
            ->setDestinationSystemCodes($destinationSystemCodes)
            ->setGuestRoom($guestRoom)
            ->setMeetingRooms($meetingRooms)
            ->setInventoryBlock($inventoryBlock)
            ->setDescription($description)
            ->setUniqueID($uniqueID)
            ->setRPH($rPH)
            ->setInvNotifType($invNotifType)
            ->setInvStatusType($invStatusType)
            ->setInvGroupingCode($invGroupingCode)
            ->setOrderSequence($orderSequence)
            ->setInvCodeApplication($invCodeApplication)
            ->setInvCode($invCode)
            ->setInvType($invType)
            ->setInvTypeCode($invTypeCode)
            ->setIsRoom($isRoom)
            ->setStart($start)
            ->setDuration($duration)
            ->setEnd($end);
    }
    /**
     * Get DestinationSystemCodes value
     * @return \StructType\DestinationSystemCodes|null
     */
    public function getDestinationSystemCodes()
    {
        return $this->DestinationSystemCodes;
    }
    /**
     * Set DestinationSystemCodes value
     * @param \StructType\DestinationSystemCodes $destinationSystemCodes
     * @return \StructType\SellableProduct
     */
    public function setDestinationSystemCodes(\StructType\DestinationSystemCodes $destinationSystemCodes = null)
    {
        $this->DestinationSystemCodes = $destinationSystemCodes;
        return $this;
    }
    /**
     * Get GuestRoom value
     * @return \StructType\GuestRoomType|null
     */
    public function getGuestRoom()
    {
        return isset($this->GuestRoom) ? $this->GuestRoom : null;
    }
    /**
     * This method is responsible for validating the value passed to the setGuestRoom method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGuestRoom method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateGuestRoomForChoiceConstraintsFromSetGuestRoom($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'MeetingRooms',
            'InventoryBlock',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property GuestRoom can\'t be set as the property %s is already set. Only one property must be set among these properties: GuestRoom, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set GuestRoom value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\GuestRoomType $guestRoom
     * @return \StructType\SellableProduct
     */
    public function setGuestRoom(\StructType\GuestRoomType $guestRoom = null)
    {
        // validation for constraint: choice(GuestRoom, MeetingRooms, InventoryBlock)
        if ('' !== ($guestRoomChoiceErrorMessage = self::validateGuestRoomForChoiceConstraintsFromSetGuestRoom($guestRoom))) {
            throw new \InvalidArgumentException($guestRoomChoiceErrorMessage, __LINE__);
        }
        if (is_null($guestRoom) || (is_array($guestRoom) && empty($guestRoom))) {
            unset($this->GuestRoom);
        } else {
            $this->GuestRoom = $guestRoom;
        }
        return $this;
    }
    /**
     * Get MeetingRooms value
     * @return \StructType\MeetingRoomsType|null
     */
    public function getMeetingRooms()
    {
        return isset($this->MeetingRooms) ? $this->MeetingRooms : null;
    }
    /**
     * This method is responsible for validating the value passed to the setMeetingRooms method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMeetingRooms method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateMeetingRoomsForChoiceConstraintsFromSetMeetingRooms($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'GuestRoom',
            'InventoryBlock',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property MeetingRooms can\'t be set as the property %s is already set. Only one property must be set among these properties: MeetingRooms, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set MeetingRooms value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\MeetingRoomsType $meetingRooms
     * @return \StructType\SellableProduct
     */
    public function setMeetingRooms(\StructType\MeetingRoomsType $meetingRooms = null)
    {
        // validation for constraint: choice(GuestRoom, MeetingRooms, InventoryBlock)
        if ('' !== ($meetingRoomsChoiceErrorMessage = self::validateMeetingRoomsForChoiceConstraintsFromSetMeetingRooms($meetingRooms))) {
            throw new \InvalidArgumentException($meetingRoomsChoiceErrorMessage, __LINE__);
        }
        if (is_null($meetingRooms) || (is_array($meetingRooms) && empty($meetingRooms))) {
            unset($this->MeetingRooms);
        } else {
            $this->MeetingRooms = $meetingRooms;
        }
        return $this;
    }
    /**
     * Get InventoryBlock value
     * @return \StructType\InventoryBlock|null
     */
    public function getInventoryBlock()
    {
        return isset($this->InventoryBlock) ? $this->InventoryBlock : null;
    }
    /**
     * This method is responsible for validating the value passed to the setInventoryBlock method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInventoryBlock method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateInventoryBlockForChoiceConstraintsFromSetInventoryBlock($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'GuestRoom',
            'MeetingRooms',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property InventoryBlock can\'t be set as the property %s is already set. Only one property must be set among these properties: InventoryBlock, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set InventoryBlock value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\InventoryBlock $inventoryBlock
     * @return \StructType\SellableProduct
     */
    public function setInventoryBlock(\StructType\InventoryBlock $inventoryBlock = null)
    {
        // validation for constraint: choice(GuestRoom, MeetingRooms, InventoryBlock)
        if ('' !== ($inventoryBlockChoiceErrorMessage = self::validateInventoryBlockForChoiceConstraintsFromSetInventoryBlock($inventoryBlock))) {
            throw new \InvalidArgumentException($inventoryBlockChoiceErrorMessage, __LINE__);
        }
        if (is_null($inventoryBlock) || (is_array($inventoryBlock) && empty($inventoryBlock))) {
            unset($this->InventoryBlock);
        } else {
            $this->InventoryBlock = $inventoryBlock;
        }
        return $this;
    }
    /**
     * Get Description value
     * @return \StructType\ParagraphType|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param \StructType\ParagraphType $description
     * @return \StructType\SellableProduct
     */
    public function setDescription(\StructType\ParagraphType $description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get UniqueID value
     * @return \StructType\UniqueID_Type|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * Set UniqueID value
     * @param \StructType\UniqueID_Type $uniqueID
     * @return \StructType\SellableProduct
     */
    public function setUniqueID(\StructType\UniqueID_Type $uniqueID = null)
    {
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\SellableProduct
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($rPH) && !preg_match('/[0-9]{1,8}/', $rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($rPH, true)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get InvNotifType value
     * @return string|null
     */
    public function getInvNotifType()
    {
        return $this->InvNotifType;
    }
    /**
     * Set InvNotifType value
     * @param string $invNotifType
     * @return \StructType\SellableProduct
     */
    public function setInvNotifType($invNotifType = null)
    {
        // validation for constraint: string
        if (!is_null($invNotifType) && !is_string($invNotifType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invNotifType, true), gettype($invNotifType)), __LINE__);
        }
        $this->InvNotifType = $invNotifType;
        return $this;
    }
    /**
     * Get InvStatusType value
     * @return string|null
     */
    public function getInvStatusType()
    {
        return $this->InvStatusType;
    }
    /**
     * Set InvStatusType value
     * @param string $invStatusType
     * @return \StructType\SellableProduct
     */
    public function setInvStatusType($invStatusType = null)
    {
        // validation for constraint: string
        if (!is_null($invStatusType) && !is_string($invStatusType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invStatusType, true), gettype($invStatusType)), __LINE__);
        }
        $this->InvStatusType = $invStatusType;
        return $this;
    }
    /**
     * Get InvGroupingCode value
     * @return string|null
     */
    public function getInvGroupingCode()
    {
        return $this->InvGroupingCode;
    }
    /**
     * Set InvGroupingCode value
     * @param string $invGroupingCode
     * @return \StructType\SellableProduct
     */
    public function setInvGroupingCode($invGroupingCode = null)
    {
        // validation for constraint: string
        if (!is_null($invGroupingCode) && !is_string($invGroupingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invGroupingCode, true), gettype($invGroupingCode)), __LINE__);
        }
        $this->InvGroupingCode = $invGroupingCode;
        return $this;
    }
    /**
     * Get OrderSequence value
     * @return int|null
     */
    public function getOrderSequence()
    {
        return $this->OrderSequence;
    }
    /**
     * Set OrderSequence value
     * @param int $orderSequence
     * @return \StructType\SellableProduct
     */
    public function setOrderSequence($orderSequence = null)
    {
        // validation for constraint: int
        if (!is_null($orderSequence) && !(is_int($orderSequence) || ctype_digit($orderSequence))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderSequence, true), gettype($orderSequence)), __LINE__);
        }
        // validation for constraint: maxInclusive(999)
        if (!is_null($orderSequence) && $orderSequence > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999', var_export($orderSequence, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($orderSequence) && $orderSequence < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($orderSequence, true)), __LINE__);
        }
        $this->OrderSequence = $orderSequence;
        return $this;
    }
    /**
     * Get InvCodeApplication value
     * @return string|null
     */
    public function getInvCodeApplication()
    {
        return $this->InvCodeApplication;
    }
    /**
     * Set InvCodeApplication value
     * @param string $invCodeApplication
     * @return \StructType\SellableProduct
     */
    public function setInvCodeApplication($invCodeApplication = null)
    {
        // validation for constraint: string
        if (!is_null($invCodeApplication) && !is_string($invCodeApplication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invCodeApplication, true), gettype($invCodeApplication)), __LINE__);
        }
        $this->InvCodeApplication = $invCodeApplication;
        return $this;
    }
    /**
     * Get InvCode value
     * @return string|null
     */
    public function getInvCode()
    {
        return $this->InvCode;
    }
    /**
     * Set InvCode value
     * @param string $invCode
     * @return \StructType\SellableProduct
     */
    public function setInvCode($invCode = null)
    {
        // validation for constraint: string
        if (!is_null($invCode) && !is_string($invCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invCode, true), gettype($invCode)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($invCode) && mb_strlen($invCode) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($invCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($invCode) && mb_strlen($invCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($invCode)), __LINE__);
        }
        $this->InvCode = $invCode;
        return $this;
    }
    /**
     * Get InvType value
     * @return string|null
     */
    public function getInvType()
    {
        return $this->InvType;
    }
    /**
     * Set InvType value
     * @param string $invType
     * @return \StructType\SellableProduct
     */
    public function setInvType($invType = null)
    {
        // validation for constraint: string
        if (!is_null($invType) && !is_string($invType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invType, true), gettype($invType)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($invType) && mb_strlen($invType) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($invType)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($invType) && mb_strlen($invType) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($invType)), __LINE__);
        }
        $this->InvType = $invType;
        return $this;
    }
    /**
     * Get InvTypeCode value
     * @return string|null
     */
    public function getInvTypeCode()
    {
        return $this->InvTypeCode;
    }
    /**
     * Set InvTypeCode value
     * @param string $invTypeCode
     * @return \StructType\SellableProduct
     */
    public function setInvTypeCode($invTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($invTypeCode) && !is_string($invTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invTypeCode, true), gettype($invTypeCode)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($invTypeCode) && mb_strlen($invTypeCode) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($invTypeCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($invTypeCode) && mb_strlen($invTypeCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($invTypeCode)), __LINE__);
        }
        $this->InvTypeCode = $invTypeCode;
        return $this;
    }
    /**
     * Get IsRoom value
     * @return bool|null
     */
    public function getIsRoom()
    {
        return $this->IsRoom;
    }
    /**
     * Set IsRoom value
     * @param bool $isRoom
     * @return \StructType\SellableProduct
     */
    public function setIsRoom($isRoom = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRoom) && !is_bool($isRoom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRoom, true), gettype($isRoom)), __LINE__);
        }
        $this->IsRoom = $isRoom;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * This method is responsible for validating the value passed to the setStart method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStart method
     * This is a set of validation rules based on the union types associated to the property being set by the setStart method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStartForUnionConstraintsFromSetStart($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime, time. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\SellableProduct
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        // validation for constraint: union(date, dateTime, time)
        if ('' !== ($startUnionErrorMessage = self::validateStartForUnionConstraintsFromSetStart($start))) {
            throw new \InvalidArgumentException($startUnionErrorMessage, __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * This method is responsible for validating the value passed to the setDuration method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDuration method
     * This is a set of validation rules based on the union types associated to the property being set by the setDuration method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDurationForUnionConstraintsFromSetDuration($value)
    {
        $message = '';
        // validation for constraint: pattern(P[0-9]{1,3}N)
        if (!is_null($value) && !preg_match('/P[0-9]{1,3}N/', $value)) {
            $exception0 = new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression P[0-9]{1,3}N', var_export($value, true)), __LINE__);
        }
        if (isset($exception0)) {
            $message = sprintf("The value %s does not match any of the union rules: duration, NightDurationType. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [$exception0])));
        }
        unset($exception0);
        return $message;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\SellableProduct
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        // validation for constraint: union(duration, NightDurationType)
        if ('' !== ($durationUnionErrorMessage = self::validateDurationForUnionConstraintsFromSetDuration($duration))) {
            throw new \InvalidArgumentException($durationUnionErrorMessage, __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * This method is responsible for validating the value passed to the setEnd method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEnd method
     * This is a set of validation rules based on the union types associated to the property being set by the setEnd method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEndForUnionConstraintsFromSetEnd($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime, time. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\SellableProduct
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        // validation for constraint: union(date, dateTime, time)
        if ('' !== ($endUnionErrorMessage = self::validateEndForUnionConstraintsFromSetEnd($end))) {
            throw new \InvalidArgumentException($endUnionErrorMessage, __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SellableProduct
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
