<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SecurityTokenReferenceType StructType
 * Meta information extracted from the WSDL
 * - documentation: This type is used reference a security token.
 * @subpackage Structs
 */
class SecurityTokenReferenceType extends AbstractStructBase
{
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - ref: wsu:Id
     * @var string
     */
    public $Id;
    /**
     * The Usage
     * Meta information extracted from the WSDL
     * - documentation: Typedef to allow a list of usages (as URIs).
     * - ref: wsse:Usage
     * @var string[]
     */
    public $Usage;
    /**
     * Constructor method for SecurityTokenReferenceType
     * @uses SecurityTokenReferenceType::setAny()
     * @uses SecurityTokenReferenceType::setId()
     * @uses SecurityTokenReferenceType::setUsage()
     * @param \DOMDocument $any
     * @param string $id
     * @param string[] $usage
     */
    public function __construct(\DOMDocument $any = null, $id = null, array $usage = array())
    {
        $this
            ->setAny($any)
            ->setId($id)
            ->setUsage($usage);
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \StructType\SecurityTokenReferenceType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\SecurityTokenReferenceType
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Usage value
     * @return string[]|null
     */
    public function getUsage()
    {
        return $this->Usage;
    }
    /**
     * This method is responsible for validating the values passed to the setUsage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUsage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUsageForArrayConstraintsFromSetUsage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $securityTokenReferenceTypeUsageItem) {
            // validation for constraint: itemType
            if (!is_string($securityTokenReferenceTypeUsageItem)) {
                $invalidValues[] = is_object($securityTokenReferenceTypeUsageItem) ? get_class($securityTokenReferenceTypeUsageItem) : sprintf('%s(%s)', gettype($securityTokenReferenceTypeUsageItem), var_export($securityTokenReferenceTypeUsageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Usage property can only contain items of type anyURI, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Usage value
     * @param string[] $usage
     * @return \StructType\SecurityTokenReferenceType
     */
    public function setUsage(array $usage = array())
    {
        // validation for constraint: list
        if ('' !== ($usageArrayErrorMessage = self::validateUsageForArrayConstraintsFromSetUsage($usage))) {
            throw new \InvalidArgumentException($usageArrayErrorMessage, __LINE__);
        }
        $this->Usage = is_array($usage) ? implode(' ', $usage) : null;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SecurityTokenReferenceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
