<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatPref StructType
 * Meta information extracted from the WSDL
 * - documentation: Indicates preferred seat characteristics. Refer to OpenTravel Code List Seat Preference (STP) for codes.
 * @subpackage Structs
 */
class SeatPref extends AbstractStructBase
{
    /**
     * The FlightDistanceQualifier
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $FlightDistanceQualifier;
    /**
     * The InternationalIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, indicates an international flight.
     * - use: optional
     * @var bool
     */
    public $InternationalIndicator;
    /**
     * The AirlineVendorPrefRPH
     * Meta information extracted from the WSDL
     * - documentation: Reference to one or more airlines in VendorPref. | The Reference Place Holder (RPH) is an index code used to identify an instance in a collection of like items (e.g. used to assign individual passengers or clients to particular
     * itinerary items). | List of Reference Place Holders.
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string[]
     */
    public $AirlineVendorPrefRPH;
    /**
     * The PassengerTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Code used to indicate the type of traveler (e.g., ADT, CHD, INF, GRP). | Used for an Alpha String, length exactly 3.
     * - base: xs:string
     * - pattern: [a-zA-Z]{3}
     * - use: optional
     * @var string
     */
    public $PassengerTypeCode;
    /**
     * The TransferAction
     * Meta information extracted from the WSDL
     * - documentation: Indicates under what conditions this element will be transfered to the booking.
     * - use: optional
     * @var string
     */
    public $TransferAction;
    /**
     * The PreferLevel
     * @var string
     */
    public $PreferLevel;
    /**
     * The SeatNumber
     * @var string
     */
    public $SeatNumber;
    /**
     * The SeatPreference
     * Meta information extracted from the WSDL
     * - documentation: Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X. | List of OpenTravel Codes.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * @var string[]
     */
    public $SeatPreference;
    /**
     * The DeckNumber
     * Meta information extracted from the WSDL
     * - documentation: Used for Numeric values, from 1 to 99 inclusive.
     * - base: xs:integer
     * - maxInclusive: 99
     * - minInclusive: 1
     * @var int
     */
    public $DeckNumber;
    /**
     * The RowNumber
     * Meta information extracted from the WSDL
     * - documentation: Used for Numeric values, from 1 to 999 inclusive.
     * - base: xs:integer
     * - maxInclusive: 999
     * - minInclusive: 1
     * @var int
     */
    public $RowNumber;
    /**
     * The SeatInRow
     * Meta information extracted from the WSDL
     * - documentation: Used for an Alpha String, length exactly 1.
     * - base: xs:string
     * - pattern: [a-zA-Z]{1}
     * @var string
     */
    public $SeatInRow;
    /**
     * The SmokingAllowed
     * @var bool
     */
    public $SmokingAllowed;
    /**
     * Constructor method for SeatPref
     * @uses SeatPref::setFlightDistanceQualifier()
     * @uses SeatPref::setInternationalIndicator()
     * @uses SeatPref::setAirlineVendorPrefRPH()
     * @uses SeatPref::setPassengerTypeCode()
     * @uses SeatPref::setTransferAction()
     * @uses SeatPref::setPreferLevel()
     * @uses SeatPref::setSeatNumber()
     * @uses SeatPref::setSeatPreference()
     * @uses SeatPref::setDeckNumber()
     * @uses SeatPref::setRowNumber()
     * @uses SeatPref::setSeatInRow()
     * @uses SeatPref::setSmokingAllowed()
     * @param string $flightDistanceQualifier
     * @param bool $internationalIndicator
     * @param string[] $airlineVendorPrefRPH
     * @param string $passengerTypeCode
     * @param string $transferAction
     * @param string $preferLevel
     * @param string $seatNumber
     * @param string[] $seatPreference
     * @param int $deckNumber
     * @param int $rowNumber
     * @param string $seatInRow
     * @param bool $smokingAllowed
     */
    public function __construct($flightDistanceQualifier = null, $internationalIndicator = null, array $airlineVendorPrefRPH = array(), $passengerTypeCode = null, $transferAction = null, $preferLevel = null, $seatNumber = null, array $seatPreference = array(), $deckNumber = null, $rowNumber = null, $seatInRow = null, $smokingAllowed = null)
    {
        $this
            ->setFlightDistanceQualifier($flightDistanceQualifier)
            ->setInternationalIndicator($internationalIndicator)
            ->setAirlineVendorPrefRPH($airlineVendorPrefRPH)
            ->setPassengerTypeCode($passengerTypeCode)
            ->setTransferAction($transferAction)
            ->setPreferLevel($preferLevel)
            ->setSeatNumber($seatNumber)
            ->setSeatPreference($seatPreference)
            ->setDeckNumber($deckNumber)
            ->setRowNumber($rowNumber)
            ->setSeatInRow($seatInRow)
            ->setSmokingAllowed($smokingAllowed);
    }
    /**
     * Get FlightDistanceQualifier value
     * @return string|null
     */
    public function getFlightDistanceQualifier()
    {
        return $this->FlightDistanceQualifier;
    }
    /**
     * Set FlightDistanceQualifier value
     * @param string $flightDistanceQualifier
     * @return \StructType\SeatPref
     */
    public function setFlightDistanceQualifier($flightDistanceQualifier = null)
    {
        // validation for constraint: string
        if (!is_null($flightDistanceQualifier) && !is_string($flightDistanceQualifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flightDistanceQualifier, true), gettype($flightDistanceQualifier)), __LINE__);
        }
        $this->FlightDistanceQualifier = $flightDistanceQualifier;
        return $this;
    }
    /**
     * Get InternationalIndicator value
     * @return bool|null
     */
    public function getInternationalIndicator()
    {
        return $this->InternationalIndicator;
    }
    /**
     * Set InternationalIndicator value
     * @param bool $internationalIndicator
     * @return \StructType\SeatPref
     */
    public function setInternationalIndicator($internationalIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($internationalIndicator) && !is_bool($internationalIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($internationalIndicator, true), gettype($internationalIndicator)), __LINE__);
        }
        $this->InternationalIndicator = $internationalIndicator;
        return $this;
    }
    /**
     * Get AirlineVendorPrefRPH value
     * @return string[]|null
     */
    public function getAirlineVendorPrefRPH()
    {
        return $this->AirlineVendorPrefRPH;
    }
    /**
     * This method is responsible for validating the values passed to the setAirlineVendorPrefRPH method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirlineVendorPrefRPH method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAirlineVendorPrefRPHForArrayConstraintsFromSetAirlineVendorPrefRPH(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatPrefAirlineVendorPrefRPHItem) {
            // validation for constraint: itemType
            if (!is_string($seatPrefAirlineVendorPrefRPHItem)) {
                $invalidValues[] = is_object($seatPrefAirlineVendorPrefRPHItem) ? get_class($seatPrefAirlineVendorPrefRPHItem) : sprintf('%s(%s)', gettype($seatPrefAirlineVendorPrefRPHItem), var_export($seatPrefAirlineVendorPrefRPHItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AirlineVendorPrefRPH property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AirlineVendorPrefRPH value
     * @param string[] $airlineVendorPrefRPH
     * @return \StructType\SeatPref
     */
    public function setAirlineVendorPrefRPH(array $airlineVendorPrefRPH = array())
    {
        // validation for constraint: list
        if ('' !== ($airlineVendorPrefRPHArrayErrorMessage = self::validateAirlineVendorPrefRPHForArrayConstraintsFromSetAirlineVendorPrefRPH($airlineVendorPrefRPH))) {
            throw new \InvalidArgumentException($airlineVendorPrefRPHArrayErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($airlineVendorPrefRPH) && !preg_match('/[0-9]{1,8}/', $airlineVendorPrefRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($airlineVendorPrefRPH, true)), __LINE__);
        }
        $this->AirlineVendorPrefRPH = is_array($airlineVendorPrefRPH) ? implode(' ', $airlineVendorPrefRPH) : null;
        return $this;
    }
    /**
     * Get PassengerTypeCode value
     * @return string|null
     */
    public function getPassengerTypeCode()
    {
        return $this->PassengerTypeCode;
    }
    /**
     * Set PassengerTypeCode value
     * @param string $passengerTypeCode
     * @return \StructType\SeatPref
     */
    public function setPassengerTypeCode($passengerTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($passengerTypeCode) && !is_string($passengerTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passengerTypeCode, true), gettype($passengerTypeCode)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z]{3})
        if (!is_null($passengerTypeCode) && !preg_match('/[a-zA-Z]{3}/', $passengerTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z]{3}', var_export($passengerTypeCode, true)), __LINE__);
        }
        $this->PassengerTypeCode = $passengerTypeCode;
        return $this;
    }
    /**
     * Get TransferAction value
     * @return string|null
     */
    public function getTransferAction()
    {
        return $this->TransferAction;
    }
    /**
     * Set TransferAction value
     * @uses \EnumType\TransferActionType::valueIsValid()
     * @uses \EnumType\TransferActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transferAction
     * @return \StructType\SeatPref
     */
    public function setTransferAction($transferAction = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransferActionType::valueIsValid($transferAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TransferActionType', is_array($transferAction) ? implode(', ', $transferAction) : var_export($transferAction, true), implode(', ', \EnumType\TransferActionType::getValidValues())), __LINE__);
        }
        $this->TransferAction = $transferAction;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \EnumType\PreferLevelType::valueIsValid()
     * @uses \EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \StructType\SeatPref
     */
    public function setPreferLevel($preferLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PreferLevelType', is_array($preferLevel) ? implode(', ', $preferLevel) : var_export($preferLevel, true), implode(', ', \EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Get SeatNumber value
     * @return string|null
     */
    public function getSeatNumber()
    {
        return $this->SeatNumber;
    }
    /**
     * Set SeatNumber value
     * @param string $seatNumber
     * @return \StructType\SeatPref
     */
    public function setSeatNumber($seatNumber = null)
    {
        // validation for constraint: string
        if (!is_null($seatNumber) && !is_string($seatNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatNumber, true), gettype($seatNumber)), __LINE__);
        }
        $this->SeatNumber = $seatNumber;
        return $this;
    }
    /**
     * Get SeatPreference value
     * @return string[]|null
     */
    public function getSeatPreference()
    {
        return $this->SeatPreference;
    }
    /**
     * This method is responsible for validating the values passed to the setSeatPreference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSeatPreference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSeatPreferenceForArrayConstraintsFromSetSeatPreference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatPrefSeatPreferenceItem) {
            // validation for constraint: itemType
            if (!is_string($seatPrefSeatPreferenceItem)) {
                $invalidValues[] = is_object($seatPrefSeatPreferenceItem) ? get_class($seatPrefSeatPreferenceItem) : sprintf('%s(%s)', gettype($seatPrefSeatPreferenceItem), var_export($seatPrefSeatPreferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SeatPreference property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SeatPreference value
     * @param string[] $seatPreference
     * @return \StructType\SeatPref
     */
    public function setSeatPreference(array $seatPreference = array())
    {
        // validation for constraint: list
        if ('' !== ($seatPreferenceArrayErrorMessage = self::validateSeatPreferenceForArrayConstraintsFromSetSeatPreference($seatPreference))) {
            throw new \InvalidArgumentException($seatPreferenceArrayErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($seatPreference) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $seatPreference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($seatPreference, true)), __LINE__);
        }
        $this->SeatPreference = is_array($seatPreference) ? implode(' ', $seatPreference) : null;
        return $this;
    }
    /**
     * Get DeckNumber value
     * @return int|null
     */
    public function getDeckNumber()
    {
        return $this->DeckNumber;
    }
    /**
     * Set DeckNumber value
     * @param int $deckNumber
     * @return \StructType\SeatPref
     */
    public function setDeckNumber($deckNumber = null)
    {
        // validation for constraint: int
        if (!is_null($deckNumber) && !(is_int($deckNumber) || ctype_digit($deckNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deckNumber, true), gettype($deckNumber)), __LINE__);
        }
        // validation for constraint: maxInclusive(99)
        if (!is_null($deckNumber) && $deckNumber > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99', var_export($deckNumber, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($deckNumber) && $deckNumber < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($deckNumber, true)), __LINE__);
        }
        $this->DeckNumber = $deckNumber;
        return $this;
    }
    /**
     * Get RowNumber value
     * @return int|null
     */
    public function getRowNumber()
    {
        return $this->RowNumber;
    }
    /**
     * Set RowNumber value
     * @param int $rowNumber
     * @return \StructType\SeatPref
     */
    public function setRowNumber($rowNumber = null)
    {
        // validation for constraint: int
        if (!is_null($rowNumber) && !(is_int($rowNumber) || ctype_digit($rowNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rowNumber, true), gettype($rowNumber)), __LINE__);
        }
        // validation for constraint: maxInclusive(999)
        if (!is_null($rowNumber) && $rowNumber > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999', var_export($rowNumber, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($rowNumber) && $rowNumber < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($rowNumber, true)), __LINE__);
        }
        $this->RowNumber = $rowNumber;
        return $this;
    }
    /**
     * Get SeatInRow value
     * @return string|null
     */
    public function getSeatInRow()
    {
        return $this->SeatInRow;
    }
    /**
     * Set SeatInRow value
     * @param string $seatInRow
     * @return \StructType\SeatPref
     */
    public function setSeatInRow($seatInRow = null)
    {
        // validation for constraint: string
        if (!is_null($seatInRow) && !is_string($seatInRow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatInRow, true), gettype($seatInRow)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z]{1})
        if (!is_null($seatInRow) && !preg_match('/[a-zA-Z]{1}/', $seatInRow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z]{1}', var_export($seatInRow, true)), __LINE__);
        }
        $this->SeatInRow = $seatInRow;
        return $this;
    }
    /**
     * Get SmokingAllowed value
     * @return bool|null
     */
    public function getSmokingAllowed()
    {
        return $this->SmokingAllowed;
    }
    /**
     * Set SmokingAllowed value
     * @param bool $smokingAllowed
     * @return \StructType\SeatPref
     */
    public function setSmokingAllowed($smokingAllowed = null)
    {
        // validation for constraint: boolean
        if (!is_null($smokingAllowed) && !is_bool($smokingAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($smokingAllowed, true), gettype($smokingAllowed)), __LINE__);
        }
        $this->SmokingAllowed = $smokingAllowed;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SeatPref
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
