<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchValueMatch StructType
 * Meta information extracted from the WSDL
 * - documentation: The string value used to search for a property is returned. The SearchValueMatch element returns the input value and offers systems the ability to generate text in the Warnings that communicate the reason for failure to locate a
 * hotel. For example, a Reference Point search may return the following processing message; "No hotels found within 5 miles of Oswego Regional Airport". | Used for Character Strings, length 1 to 8.
 * - base: xs:string
 * - maxLength: 8
 * - minLength: 1
 * @subpackage Structs
 */
class SearchValueMatch extends AbstractStructBase
{
    /**
     * The Match
     * Meta information extracted from the WSDL
     * - documentation: Indication of whether a match was found. The datatype is Boolean (true | false).
     * - use: required
     * @var bool
     */
    public $Match;
    /**
     * The _
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $_;
    /**
     * The Relevance
     * Meta information extracted from the WSDL
     * - documentation: An optional attribute, expressed as a decimal value, representing a percentage of 100%, used to indicate the degree to which the property identified meets the search criteria. | Used for percentage values.
     * - base: xs:decimal
     * - maxInclusive: 100.00
     * - minInclusive: 0.00
     * - type: Percentage
     * - use: optional
     * @var float
     */
    public $Relevance;
    /**
     * Constructor method for SearchValueMatch
     * @uses SearchValueMatch::setMatch()
     * @uses SearchValueMatch::set_()
     * @uses SearchValueMatch::setRelevance()
     * @param bool $match
     * @param string $_
     * @param float $relevance
     */
    public function __construct($match = null, $_ = null, $relevance = null)
    {
        $this
            ->setMatch($match)
            ->set_($_)
            ->setRelevance($relevance);
    }
    /**
     * Get Match value
     * @return bool
     */
    public function getMatch()
    {
        return $this->Match;
    }
    /**
     * Set Match value
     * @param bool $match
     * @return \StructType\SearchValueMatch
     */
    public function setMatch($match = null)
    {
        // validation for constraint: boolean
        if (!is_null($match) && !is_bool($match)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($match, true), gettype($match)), __LINE__);
        }
        $this->Match = $match;
        return $this;
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\SearchValueMatch
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($_) && mb_strlen($_) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($_)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($_) && mb_strlen($_) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get Relevance value
     * @return float|null
     */
    public function getRelevance()
    {
        return $this->Relevance;
    }
    /**
     * Set Relevance value
     * @param float $relevance
     * @return \StructType\SearchValueMatch
     */
    public function setRelevance($relevance = null)
    {
        // validation for constraint: float
        if (!is_null($relevance) && !(is_float($relevance) || is_numeric($relevance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($relevance, true), gettype($relevance)), __LINE__);
        }
        // validation for constraint: maxInclusive(100.00)
        if (!is_null($relevance) && $relevance > 100.00) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 100.00', var_export($relevance, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.00)
        if (!is_null($relevance) && $relevance < 0.00) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.00', var_export($relevance, true)), __LINE__);
        }
        $this->Relevance = $relevance;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SearchValueMatch
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
