<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SSR_Pref StructType
 * Meta information extracted from the WSDL
 * - documentation: Indicates Special Service Request preference type.
 * @subpackage Structs
 */
class SSR_Pref extends AbstractStructBase
{
    /**
     * The VendorCode
     * Meta information extracted from the WSDL
     * - documentation: Indicates to which airline the element is associated. | Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $VendorCode;
    /**
     * The NumberInParty
     * Meta information extracted from the WSDL
     * - documentation: Number of passengers that will benefit from the request.
     * - use: optional
     * @var int
     */
    public $NumberInParty;
    /**
     * The DefaultStatusCode
     * Meta information extracted from the WSDL
     * - documentation: The default status from the airline. Refer to the OpenTravel Code List named Status (STS). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string
     */
    public $DefaultStatusCode;
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - documentation: Text that description of the service request. | Used for Character Strings, length 1 to 128.
     * - base: xs:string
     * - maxLength: 128
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $Remark;
    /**
     * The LookupKey
     * Meta information extracted from the WSDL
     * - documentation: Database key to retrieve the other part of the card number. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $LookupKey;
    /**
     * The AirlineVendorPrefRPH
     * Meta information extracted from the WSDL
     * - documentation: Reference to one or more airlines in VendorPref. | The Reference Place Holder (RPH) is an index code used to identify an instance in a collection of like items (e.g. used to assign individual passengers or clients to particular
     * itinerary items). | List of Reference Place Holders.
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string[]
     */
    public $AirlineVendorPrefRPH;
    /**
     * The TransferActionType
     * Meta information extracted from the WSDL
     * - documentation: Indicates in what condition the element must be trasnferred to the booking.
     * - use: optional
     * @var string
     */
    public $TransferActionType;
    /**
     * The SSR_Code
     * Meta information extracted from the WSDL
     * - documentation: Code of the special service request to be used for this air travel situation. Refers to standard industry code list. | Used for an Alpha String, length exactly 4.
     * - base: xs:string
     * - pattern: [a-zA-Z]{4}
     * - type: AlphaLength4
     * @var string
     */
    public $SSR_Code;
    /**
     * The PreferLevel
     * @var string
     */
    public $PreferLevel;
    /**
     * Constructor method for SSR_Pref
     * @uses SSR_Pref::setVendorCode()
     * @uses SSR_Pref::setNumberInParty()
     * @uses SSR_Pref::setDefaultStatusCode()
     * @uses SSR_Pref::setRemark()
     * @uses SSR_Pref::setLookupKey()
     * @uses SSR_Pref::setAirlineVendorPrefRPH()
     * @uses SSR_Pref::setTransferActionType()
     * @uses SSR_Pref::setSSR_Code()
     * @uses SSR_Pref::setPreferLevel()
     * @param string $vendorCode
     * @param int $numberInParty
     * @param string $defaultStatusCode
     * @param string $remark
     * @param string $lookupKey
     * @param string[] $airlineVendorPrefRPH
     * @param string $transferActionType
     * @param string $sSR_Code
     * @param string $preferLevel
     */
    public function __construct($vendorCode = null, $numberInParty = null, $defaultStatusCode = null, $remark = null, $lookupKey = null, array $airlineVendorPrefRPH = array(), $transferActionType = null, $sSR_Code = null, $preferLevel = null)
    {
        $this
            ->setVendorCode($vendorCode)
            ->setNumberInParty($numberInParty)
            ->setDefaultStatusCode($defaultStatusCode)
            ->setRemark($remark)
            ->setLookupKey($lookupKey)
            ->setAirlineVendorPrefRPH($airlineVendorPrefRPH)
            ->setTransferActionType($transferActionType)
            ->setSSR_Code($sSR_Code)
            ->setPreferLevel($preferLevel);
    }
    /**
     * Get VendorCode value
     * @return string|null
     */
    public function getVendorCode()
    {
        return $this->VendorCode;
    }
    /**
     * Set VendorCode value
     * @param string $vendorCode
     * @return \StructType\SSR_Pref
     */
    public function setVendorCode($vendorCode = null)
    {
        // validation for constraint: string
        if (!is_null($vendorCode) && !is_string($vendorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorCode, true), gettype($vendorCode)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($vendorCode) && mb_strlen($vendorCode) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($vendorCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($vendorCode) && mb_strlen($vendorCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($vendorCode)), __LINE__);
        }
        $this->VendorCode = $vendorCode;
        return $this;
    }
    /**
     * Get NumberInParty value
     * @return int|null
     */
    public function getNumberInParty()
    {
        return $this->NumberInParty;
    }
    /**
     * Set NumberInParty value
     * @param int $numberInParty
     * @return \StructType\SSR_Pref
     */
    public function setNumberInParty($numberInParty = null)
    {
        // validation for constraint: int
        if (!is_null($numberInParty) && !(is_int($numberInParty) || ctype_digit($numberInParty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberInParty, true), gettype($numberInParty)), __LINE__);
        }
        $this->NumberInParty = $numberInParty;
        return $this;
    }
    /**
     * Get DefaultStatusCode value
     * @return string|null
     */
    public function getDefaultStatusCode()
    {
        return $this->DefaultStatusCode;
    }
    /**
     * Set DefaultStatusCode value
     * @param string $defaultStatusCode
     * @return \StructType\SSR_Pref
     */
    public function setDefaultStatusCode($defaultStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($defaultStatusCode) && !is_string($defaultStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultStatusCode, true), gettype($defaultStatusCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($defaultStatusCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $defaultStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($defaultStatusCode, true)), __LINE__);
        }
        $this->DefaultStatusCode = $defaultStatusCode;
        return $this;
    }
    /**
     * Get Remark value
     * @return string|null
     */
    public function getRemark()
    {
        return $this->Remark;
    }
    /**
     * Set Remark value
     * @param string $remark
     * @return \StructType\SSR_Pref
     */
    public function setRemark($remark = null)
    {
        // validation for constraint: string
        if (!is_null($remark) && !is_string($remark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remark, true), gettype($remark)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($remark) && mb_strlen($remark) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($remark)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($remark) && mb_strlen($remark) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($remark)), __LINE__);
        }
        $this->Remark = $remark;
        return $this;
    }
    /**
     * Get LookupKey value
     * @return string|null
     */
    public function getLookupKey()
    {
        return $this->LookupKey;
    }
    /**
     * Set LookupKey value
     * @param string $lookupKey
     * @return \StructType\SSR_Pref
     */
    public function setLookupKey($lookupKey = null)
    {
        // validation for constraint: string
        if (!is_null($lookupKey) && !is_string($lookupKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lookupKey, true), gettype($lookupKey)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($lookupKey) && mb_strlen($lookupKey) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($lookupKey)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($lookupKey) && mb_strlen($lookupKey) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($lookupKey)), __LINE__);
        }
        $this->LookupKey = $lookupKey;
        return $this;
    }
    /**
     * Get AirlineVendorPrefRPH value
     * @return string[]|null
     */
    public function getAirlineVendorPrefRPH()
    {
        return $this->AirlineVendorPrefRPH;
    }
    /**
     * This method is responsible for validating the values passed to the setAirlineVendorPrefRPH method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirlineVendorPrefRPH method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAirlineVendorPrefRPHForArrayConstraintsFromSetAirlineVendorPrefRPH(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $sSR_PrefAirlineVendorPrefRPHItem) {
            // validation for constraint: itemType
            if (!is_string($sSR_PrefAirlineVendorPrefRPHItem)) {
                $invalidValues[] = is_object($sSR_PrefAirlineVendorPrefRPHItem) ? get_class($sSR_PrefAirlineVendorPrefRPHItem) : sprintf('%s(%s)', gettype($sSR_PrefAirlineVendorPrefRPHItem), var_export($sSR_PrefAirlineVendorPrefRPHItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AirlineVendorPrefRPH property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AirlineVendorPrefRPH value
     * @param string[] $airlineVendorPrefRPH
     * @return \StructType\SSR_Pref
     */
    public function setAirlineVendorPrefRPH(array $airlineVendorPrefRPH = array())
    {
        // validation for constraint: list
        if ('' !== ($airlineVendorPrefRPHArrayErrorMessage = self::validateAirlineVendorPrefRPHForArrayConstraintsFromSetAirlineVendorPrefRPH($airlineVendorPrefRPH))) {
            throw new \InvalidArgumentException($airlineVendorPrefRPHArrayErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($airlineVendorPrefRPH) && !preg_match('/[0-9]{1,8}/', $airlineVendorPrefRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($airlineVendorPrefRPH, true)), __LINE__);
        }
        $this->AirlineVendorPrefRPH = is_array($airlineVendorPrefRPH) ? implode(' ', $airlineVendorPrefRPH) : null;
        return $this;
    }
    /**
     * Get TransferActionType value
     * @return string|null
     */
    public function getTransferActionType()
    {
        return $this->TransferActionType;
    }
    /**
     * Set TransferActionType value
     * @uses \EnumType\TransferActionType::valueIsValid()
     * @uses \EnumType\TransferActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transferActionType
     * @return \StructType\SSR_Pref
     */
    public function setTransferActionType($transferActionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransferActionType::valueIsValid($transferActionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TransferActionType', is_array($transferActionType) ? implode(', ', $transferActionType) : var_export($transferActionType, true), implode(', ', \EnumType\TransferActionType::getValidValues())), __LINE__);
        }
        $this->TransferActionType = $transferActionType;
        return $this;
    }
    /**
     * Get SSR_Code value
     * @return string|null
     */
    public function getSSR_Code()
    {
        return $this->SSR_Code;
    }
    /**
     * Set SSR_Code value
     * @param string $sSR_Code
     * @return \StructType\SSR_Pref
     */
    public function setSSR_Code($sSR_Code = null)
    {
        // validation for constraint: string
        if (!is_null($sSR_Code) && !is_string($sSR_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sSR_Code, true), gettype($sSR_Code)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z]{4})
        if (!is_null($sSR_Code) && !preg_match('/[a-zA-Z]{4}/', $sSR_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z]{4}', var_export($sSR_Code, true)), __LINE__);
        }
        $this->SSR_Code = $sSR_Code;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \EnumType\PreferLevelType::valueIsValid()
     * @uses \EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \StructType\SSR_Pref
     */
    public function setPreferLevel($preferLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PreferLevelType', is_array($preferLevel) ? implode(', ', $preferLevel) : var_export($preferLevel, true), implode(', ', \EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SSR_Pref
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
