<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomSharesType StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of RoomShare.
 * @subpackage Structs
 */
class RoomSharesType extends AbstractStructBase
{
    /**
     * The RoomShare
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\RoomShare[]
     */
    public $RoomShare;
    /**
     * Constructor method for RoomSharesType
     * @uses RoomSharesType::setRoomShare()
     * @param \StructType\RoomShare[] $roomShare
     */
    public function __construct(array $roomShare = array())
    {
        $this
            ->setRoomShare($roomShare);
    }
    /**
     * Get RoomShare value
     * @return \StructType\RoomShare[]|null
     */
    public function getRoomShare()
    {
        return $this->RoomShare;
    }
    /**
     * This method is responsible for validating the values passed to the setRoomShare method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoomShare method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRoomShareForArrayConstraintsFromSetRoomShare(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $roomSharesTypeRoomShareItem) {
            // validation for constraint: itemType
            if (!$roomSharesTypeRoomShareItem instanceof \StructType\RoomShare) {
                $invalidValues[] = is_object($roomSharesTypeRoomShareItem) ? get_class($roomSharesTypeRoomShareItem) : sprintf('%s(%s)', gettype($roomSharesTypeRoomShareItem), var_export($roomSharesTypeRoomShareItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RoomShare property can only contain items of type \StructType\RoomShare, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RoomShare value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomShare[] $roomShare
     * @return \StructType\RoomSharesType
     */
    public function setRoomShare(array $roomShare = array())
    {
        // validation for constraint: array
        if ('' !== ($roomShareArrayErrorMessage = self::validateRoomShareForArrayConstraintsFromSetRoomShare($roomShare))) {
            throw new \InvalidArgumentException($roomShareArrayErrorMessage, __LINE__);
        }
        $this->RoomShare = $roomShare;
        return $this;
    }
    /**
     * Add item to RoomShare value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomShare $item
     * @return \StructType\RoomSharesType
     */
    public function addToRoomShare(\StructType\RoomShare $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RoomShare) {
            throw new \InvalidArgumentException(sprintf('The RoomShare property can only contain items of type \StructType\RoomShare, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RoomShare[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoomSharesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
