<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomRateType StructType
 * Meta information extracted from the WSDL
 * - documentation: Individual rate amount. This rate is valid for a range of number of occupants and an occupant type.
 * @subpackage Structs
 */
class RoomRateType extends AbstractStructBase
{
    /**
     * The Rates
     * Meta information extracted from the WSDL
     * - documentation: Individual rate amount. This rate is valid for a range of number of occupants and an occupant type.
     * - minOccurs: 0
     * @var \StructType\RateType
     */
    public $Rates;
    /**
     * The RoomRateDescription
     * Meta information extracted from the WSDL
     * - documentation: The description or name of a room rate.
     * - maxOccurs: 20
     * - minOccurs: 0
     * @var \StructType\ParagraphType[]
     */
    public $RoomRateDescription;
    /**
     * The Features
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Features
     */
    public $Features;
    /**
     * The Total
     * Meta information extracted from the WSDL
     * - documentation: The total of all rates for this room rate type.
     * - minOccurs: 0
     * @var \StructType\TotalType
     */
    public $Total;
    /**
     * The Availability
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\Availability[]
     */
    public $Availability;
    /**
     * The BookingCode
     * Meta information extracted from the WSDL
     * - documentation: This is used to indicate the item booked and is primarily used to exchange information with GDSs. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $BookingCode;
    /**
     * The RoomTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Specfic system room type code, ex: A1K, A1Q etc. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $RoomTypeCode;
    /**
     * The InvBlockCode
     * Meta information extracted from the WSDL
     * - documentation: Code that identifies an inventory block. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $InvBlockCode;
    /**
     * The NumberOfUnits
     * Meta information extracted from the WSDL
     * - documentation: The number of rooms.
     * - use: optional
     * @var int
     */
    public $NumberOfUnits;
    /**
     * The AvailabilityStatus
     * Meta information extracted from the WSDL
     * - documentation: Used to specify an availability status for the room rate.
     * - use: optional
     * @var string
     */
    public $AvailabilityStatus;
    /**
     * The RoomID
     * Meta information extracted from the WSDL
     * - documentation: A string value representing the unique identification of a room. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $RoomID;
    /**
     * The EffectiveDate
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * @var string
     */
    public $ExpireDate;
    /**
     * The ExpireDateExclusiveIndicator
     * @var bool
     */
    public $ExpireDateExclusiveIndicator;
    /**
     * The RatePlanType
     * Meta information extracted from the WSDL
     * - documentation: An enumerated type that allows the query to specify a rate category type, and provides major categories for comparison across brands. Refer to OpenTravel Code List Rate Plan Type (RPT). | Used for codes in the OpenTravel Code tables.
     * Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - type: OTA_CodeType
     * - use: optional
     * @var string
     */
    public $RatePlanType;
    /**
     * The RatePlanCode
     * Meta information extracted from the WSDL
     * - documentation: A string value may be used to request a particular code or an ID if the guest qualifies for a specific rate, such as AARP, AAA, a corporate rate, etc., or to specify a negotiated code as a result of a negotiated rate. | Used for
     * Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - type: StringLength1to64
     * - use: optional
     * @var string
     */
    public $RatePlanCode;
    /**
     * The RatePlanID
     * Meta information extracted from the WSDL
     * - documentation: A text field used to indicate a special ID code that is associated with the rate and is essential in the reservation request in order to obtain the rate. Examples are Corporate ID. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - type: StringLength1to64
     * - use: optional
     * @var string
     */
    public $RatePlanID;
    /**
     * The RatePlanQualifier
     * Meta information extracted from the WSDL
     * - documentation: The Rate Plan Qualifier is used to control the sort order of RatePlans. Those Rate Plans that are not qualified will appear first, those that are qualified will appear last.
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $RatePlanQualifier;
    /**
     * The RatePlanCategory
     * Meta information extracted from the WSDL
     * - documentation: Hotel systems often group multiple rate plans into a single category. This refers to that category that is specific to the hotel CRS/ PMS and should not be confused with a GDS rate category. | Used for Character Strings, length 1 to
     * 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - type: StringLength1to64
     * - use: optional
     * @var string
     */
    public $RatePlanCategory;
    /**
     * The PromotionCode
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $PromotionCode;
    /**
     * The PromotionVendorCode
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 8. | List of StringLength1to8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * @var string[]
     */
    public $PromotionVendorCode;
    /**
     * Constructor method for RoomRateType
     * @uses RoomRateType::setRates()
     * @uses RoomRateType::setRoomRateDescription()
     * @uses RoomRateType::setFeatures()
     * @uses RoomRateType::setTotal()
     * @uses RoomRateType::setAvailability()
     * @uses RoomRateType::setBookingCode()
     * @uses RoomRateType::setRoomTypeCode()
     * @uses RoomRateType::setInvBlockCode()
     * @uses RoomRateType::setNumberOfUnits()
     * @uses RoomRateType::setAvailabilityStatus()
     * @uses RoomRateType::setRoomID()
     * @uses RoomRateType::setEffectiveDate()
     * @uses RoomRateType::setExpireDate()
     * @uses RoomRateType::setExpireDateExclusiveIndicator()
     * @uses RoomRateType::setRatePlanType()
     * @uses RoomRateType::setRatePlanCode()
     * @uses RoomRateType::setRatePlanID()
     * @uses RoomRateType::setRatePlanQualifier()
     * @uses RoomRateType::setRatePlanCategory()
     * @uses RoomRateType::setPromotionCode()
     * @uses RoomRateType::setPromotionVendorCode()
     * @param \StructType\RateType $rates
     * @param \StructType\ParagraphType[] $roomRateDescription
     * @param \StructType\Features $features
     * @param \StructType\TotalType $total
     * @param \StructType\Availability[] $availability
     * @param string $bookingCode
     * @param string $roomTypeCode
     * @param string $invBlockCode
     * @param int $numberOfUnits
     * @param string $availabilityStatus
     * @param string $roomID
     * @param string $effectiveDate
     * @param string $expireDate
     * @param bool $expireDateExclusiveIndicator
     * @param string $ratePlanType
     * @param string $ratePlanCode
     * @param string $ratePlanID
     * @param bool $ratePlanQualifier
     * @param string $ratePlanCategory
     * @param string $promotionCode
     * @param string[] $promotionVendorCode
     */
    public function __construct(\StructType\RateType $rates = null, array $roomRateDescription = array(), \StructType\Features $features = null, \StructType\TotalType $total = null, array $availability = array(), $bookingCode = null, $roomTypeCode = null, $invBlockCode = null, $numberOfUnits = null, $availabilityStatus = null, $roomID = null, $effectiveDate = null, $expireDate = null, $expireDateExclusiveIndicator = null, $ratePlanType = null, $ratePlanCode = null, $ratePlanID = null, $ratePlanQualifier = null, $ratePlanCategory = null, $promotionCode = null, array $promotionVendorCode = array())
    {
        $this
            ->setRates($rates)
            ->setRoomRateDescription($roomRateDescription)
            ->setFeatures($features)
            ->setTotal($total)
            ->setAvailability($availability)
            ->setBookingCode($bookingCode)
            ->setRoomTypeCode($roomTypeCode)
            ->setInvBlockCode($invBlockCode)
            ->setNumberOfUnits($numberOfUnits)
            ->setAvailabilityStatus($availabilityStatus)
            ->setRoomID($roomID)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate)
            ->setExpireDateExclusiveIndicator($expireDateExclusiveIndicator)
            ->setRatePlanType($ratePlanType)
            ->setRatePlanCode($ratePlanCode)
            ->setRatePlanID($ratePlanID)
            ->setRatePlanQualifier($ratePlanQualifier)
            ->setRatePlanCategory($ratePlanCategory)
            ->setPromotionCode($promotionCode)
            ->setPromotionVendorCode($promotionVendorCode);
    }
    /**
     * Get Rates value
     * @return \StructType\RateType|null
     */
    public function getRates()
    {
        return $this->Rates;
    }
    /**
     * Set Rates value
     * @param \StructType\RateType $rates
     * @return \StructType\RoomRateType
     */
    public function setRates(\StructType\RateType $rates = null)
    {
        $this->Rates = $rates;
        return $this;
    }
    /**
     * Get RoomRateDescription value
     * @return \StructType\ParagraphType[]|null
     */
    public function getRoomRateDescription()
    {
        return $this->RoomRateDescription;
    }
    /**
     * This method is responsible for validating the values passed to the setRoomRateDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoomRateDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRoomRateDescriptionForArrayConstraintsFromSetRoomRateDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $roomRateTypeRoomRateDescriptionItem) {
            // validation for constraint: itemType
            if (!$roomRateTypeRoomRateDescriptionItem instanceof \StructType\ParagraphType) {
                $invalidValues[] = is_object($roomRateTypeRoomRateDescriptionItem) ? get_class($roomRateTypeRoomRateDescriptionItem) : sprintf('%s(%s)', gettype($roomRateTypeRoomRateDescriptionItem), var_export($roomRateTypeRoomRateDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RoomRateDescription property can only contain items of type \StructType\ParagraphType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RoomRateDescription value
     * @throws \InvalidArgumentException
     * @param \StructType\ParagraphType[] $roomRateDescription
     * @return \StructType\RoomRateType
     */
    public function setRoomRateDescription(array $roomRateDescription = array())
    {
        // validation for constraint: array
        if ('' !== ($roomRateDescriptionArrayErrorMessage = self::validateRoomRateDescriptionForArrayConstraintsFromSetRoomRateDescription($roomRateDescription))) {
            throw new \InvalidArgumentException($roomRateDescriptionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(20)
        if (is_array($roomRateDescription) && count($roomRateDescription) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 20', count($roomRateDescription)), __LINE__);
        }
        $this->RoomRateDescription = $roomRateDescription;
        return $this;
    }
    /**
     * Add item to RoomRateDescription value
     * @throws \InvalidArgumentException
     * @param \StructType\ParagraphType $item
     * @return \StructType\RoomRateType
     */
    public function addToRoomRateDescription(\StructType\ParagraphType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ParagraphType) {
            throw new \InvalidArgumentException(sprintf('The RoomRateDescription property can only contain items of type \StructType\ParagraphType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(20)
        if (is_array($this->RoomRateDescription) && count($this->RoomRateDescription) >= 20) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 20', count($this->RoomRateDescription)), __LINE__);
        }
        $this->RoomRateDescription[] = $item;
        return $this;
    }
    /**
     * Get Features value
     * @return \StructType\Features|null
     */
    public function getFeatures()
    {
        return $this->Features;
    }
    /**
     * Set Features value
     * @param \StructType\Features $features
     * @return \StructType\RoomRateType
     */
    public function setFeatures(\StructType\Features $features = null)
    {
        $this->Features = $features;
        return $this;
    }
    /**
     * Get Total value
     * @return \StructType\TotalType|null
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param \StructType\TotalType $total
     * @return \StructType\RoomRateType
     */
    public function setTotal(\StructType\TotalType $total = null)
    {
        $this->Total = $total;
        return $this;
    }
    /**
     * Get Availability value
     * @return \StructType\Availability[]|null
     */
    public function getAvailability()
    {
        return $this->Availability;
    }
    /**
     * This method is responsible for validating the values passed to the setAvailability method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAvailability method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAvailabilityForArrayConstraintsFromSetAvailability(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $roomRateTypeAvailabilityItem) {
            // validation for constraint: itemType
            if (!$roomRateTypeAvailabilityItem instanceof \StructType\Availability) {
                $invalidValues[] = is_object($roomRateTypeAvailabilityItem) ? get_class($roomRateTypeAvailabilityItem) : sprintf('%s(%s)', gettype($roomRateTypeAvailabilityItem), var_export($roomRateTypeAvailabilityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Availability property can only contain items of type \StructType\Availability, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Availability value
     * @throws \InvalidArgumentException
     * @param \StructType\Availability[] $availability
     * @return \StructType\RoomRateType
     */
    public function setAvailability(array $availability = array())
    {
        // validation for constraint: array
        if ('' !== ($availabilityArrayErrorMessage = self::validateAvailabilityForArrayConstraintsFromSetAvailability($availability))) {
            throw new \InvalidArgumentException($availabilityArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($availability) && count($availability) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($availability)), __LINE__);
        }
        $this->Availability = $availability;
        return $this;
    }
    /**
     * Add item to Availability value
     * @throws \InvalidArgumentException
     * @param \StructType\Availability $item
     * @return \StructType\RoomRateType
     */
    public function addToAvailability(\StructType\Availability $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Availability) {
            throw new \InvalidArgumentException(sprintf('The Availability property can only contain items of type \StructType\Availability, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Availability) && count($this->Availability) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Availability)), __LINE__);
        }
        $this->Availability[] = $item;
        return $this;
    }
    /**
     * Get BookingCode value
     * @return string|null
     */
    public function getBookingCode()
    {
        return $this->BookingCode;
    }
    /**
     * Set BookingCode value
     * @param string $bookingCode
     * @return \StructType\RoomRateType
     */
    public function setBookingCode($bookingCode = null)
    {
        // validation for constraint: string
        if (!is_null($bookingCode) && !is_string($bookingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingCode, true), gettype($bookingCode)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($bookingCode) && mb_strlen($bookingCode) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($bookingCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($bookingCode) && mb_strlen($bookingCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($bookingCode)), __LINE__);
        }
        $this->BookingCode = $bookingCode;
        return $this;
    }
    /**
     * Get RoomTypeCode value
     * @return string|null
     */
    public function getRoomTypeCode()
    {
        return $this->RoomTypeCode;
    }
    /**
     * Set RoomTypeCode value
     * @param string $roomTypeCode
     * @return \StructType\RoomRateType
     */
    public function setRoomTypeCode($roomTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomTypeCode) && !is_string($roomTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomTypeCode, true), gettype($roomTypeCode)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($roomTypeCode) && mb_strlen($roomTypeCode) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($roomTypeCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($roomTypeCode) && mb_strlen($roomTypeCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($roomTypeCode)), __LINE__);
        }
        $this->RoomTypeCode = $roomTypeCode;
        return $this;
    }
    /**
     * Get InvBlockCode value
     * @return string|null
     */
    public function getInvBlockCode()
    {
        return $this->InvBlockCode;
    }
    /**
     * Set InvBlockCode value
     * @param string $invBlockCode
     * @return \StructType\RoomRateType
     */
    public function setInvBlockCode($invBlockCode = null)
    {
        // validation for constraint: string
        if (!is_null($invBlockCode) && !is_string($invBlockCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invBlockCode, true), gettype($invBlockCode)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($invBlockCode) && mb_strlen($invBlockCode) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($invBlockCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($invBlockCode) && mb_strlen($invBlockCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($invBlockCode)), __LINE__);
        }
        $this->InvBlockCode = $invBlockCode;
        return $this;
    }
    /**
     * Get NumberOfUnits value
     * @return int|null
     */
    public function getNumberOfUnits()
    {
        return $this->NumberOfUnits;
    }
    /**
     * Set NumberOfUnits value
     * @param int $numberOfUnits
     * @return \StructType\RoomRateType
     */
    public function setNumberOfUnits($numberOfUnits = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfUnits) && !(is_int($numberOfUnits) || ctype_digit($numberOfUnits))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfUnits, true), gettype($numberOfUnits)), __LINE__);
        }
        $this->NumberOfUnits = $numberOfUnits;
        return $this;
    }
    /**
     * Get AvailabilityStatus value
     * @return string|null
     */
    public function getAvailabilityStatus()
    {
        return $this->AvailabilityStatus;
    }
    /**
     * Set AvailabilityStatus value
     * @uses \EnumType\RateIndicatorType::valueIsValid()
     * @uses \EnumType\RateIndicatorType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $availabilityStatus
     * @return \StructType\RoomRateType
     */
    public function setAvailabilityStatus($availabilityStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RateIndicatorType::valueIsValid($availabilityStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RateIndicatorType', is_array($availabilityStatus) ? implode(', ', $availabilityStatus) : var_export($availabilityStatus, true), implode(', ', \EnumType\RateIndicatorType::getValidValues())), __LINE__);
        }
        $this->AvailabilityStatus = $availabilityStatus;
        return $this;
    }
    /**
     * Get RoomID value
     * @return string|null
     */
    public function getRoomID()
    {
        return $this->RoomID;
    }
    /**
     * Set RoomID value
     * @param string $roomID
     * @return \StructType\RoomRateType
     */
    public function setRoomID($roomID = null)
    {
        // validation for constraint: string
        if (!is_null($roomID) && !is_string($roomID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomID, true), gettype($roomID)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($roomID) && mb_strlen($roomID) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($roomID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($roomID) && mb_strlen($roomID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($roomID)), __LINE__);
        }
        $this->RoomID = $roomID;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\RoomRateType
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \StructType\RoomRateType
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expireDate, true), gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get ExpireDateExclusiveIndicator value
     * @return bool|null
     */
    public function getExpireDateExclusiveIndicator()
    {
        return $this->ExpireDateExclusiveIndicator;
    }
    /**
     * Set ExpireDateExclusiveIndicator value
     * @param bool $expireDateExclusiveIndicator
     * @return \StructType\RoomRateType
     */
    public function setExpireDateExclusiveIndicator($expireDateExclusiveIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($expireDateExclusiveIndicator) && !is_bool($expireDateExclusiveIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($expireDateExclusiveIndicator, true), gettype($expireDateExclusiveIndicator)), __LINE__);
        }
        $this->ExpireDateExclusiveIndicator = $expireDateExclusiveIndicator;
        return $this;
    }
    /**
     * Get RatePlanType value
     * @return string|null
     */
    public function getRatePlanType()
    {
        return $this->RatePlanType;
    }
    /**
     * Set RatePlanType value
     * @param string $ratePlanType
     * @return \StructType\RoomRateType
     */
    public function setRatePlanType($ratePlanType = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanType) && !is_string($ratePlanType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanType, true), gettype($ratePlanType)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($ratePlanType) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $ratePlanType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($ratePlanType, true)), __LINE__);
        }
        $this->RatePlanType = $ratePlanType;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\RoomRateType
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCode, true), gettype($ratePlanCode)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ratePlanCode) && mb_strlen($ratePlanCode) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($ratePlanCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($ratePlanCode) && mb_strlen($ratePlanCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Get RatePlanID value
     * @return string|null
     */
    public function getRatePlanID()
    {
        return $this->RatePlanID;
    }
    /**
     * Set RatePlanID value
     * @param string $ratePlanID
     * @return \StructType\RoomRateType
     */
    public function setRatePlanID($ratePlanID = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanID) && !is_string($ratePlanID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanID, true), gettype($ratePlanID)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ratePlanID) && mb_strlen($ratePlanID) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($ratePlanID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($ratePlanID) && mb_strlen($ratePlanID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($ratePlanID)), __LINE__);
        }
        $this->RatePlanID = $ratePlanID;
        return $this;
    }
    /**
     * Get RatePlanQualifier value
     * @return bool|null
     */
    public function getRatePlanQualifier()
    {
        return $this->RatePlanQualifier;
    }
    /**
     * Set RatePlanQualifier value
     * @param bool $ratePlanQualifier
     * @return \StructType\RoomRateType
     */
    public function setRatePlanQualifier($ratePlanQualifier = null)
    {
        // validation for constraint: boolean
        if (!is_null($ratePlanQualifier) && !is_bool($ratePlanQualifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ratePlanQualifier, true), gettype($ratePlanQualifier)), __LINE__);
        }
        $this->RatePlanQualifier = $ratePlanQualifier;
        return $this;
    }
    /**
     * Get RatePlanCategory value
     * @return string|null
     */
    public function getRatePlanCategory()
    {
        return $this->RatePlanCategory;
    }
    /**
     * Set RatePlanCategory value
     * @param string $ratePlanCategory
     * @return \StructType\RoomRateType
     */
    public function setRatePlanCategory($ratePlanCategory = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCategory) && !is_string($ratePlanCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCategory, true), gettype($ratePlanCategory)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ratePlanCategory) && mb_strlen($ratePlanCategory) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($ratePlanCategory)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($ratePlanCategory) && mb_strlen($ratePlanCategory) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($ratePlanCategory)), __LINE__);
        }
        $this->RatePlanCategory = $ratePlanCategory;
        return $this;
    }
    /**
     * Get PromotionCode value
     * @return string|null
     */
    public function getPromotionCode()
    {
        return $this->PromotionCode;
    }
    /**
     * Set PromotionCode value
     * @param string $promotionCode
     * @return \StructType\RoomRateType
     */
    public function setPromotionCode($promotionCode = null)
    {
        // validation for constraint: string
        if (!is_null($promotionCode) && !is_string($promotionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promotionCode, true), gettype($promotionCode)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($promotionCode) && mb_strlen($promotionCode) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($promotionCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($promotionCode) && mb_strlen($promotionCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($promotionCode)), __LINE__);
        }
        $this->PromotionCode = $promotionCode;
        return $this;
    }
    /**
     * Get PromotionVendorCode value
     * @return string[]|null
     */
    public function getPromotionVendorCode()
    {
        return $this->PromotionVendorCode;
    }
    /**
     * This method is responsible for validating the values passed to the setPromotionVendorCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPromotionVendorCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePromotionVendorCodeForArrayConstraintsFromSetPromotionVendorCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $roomRateTypePromotionVendorCodeItem) {
            // validation for constraint: itemType
            if (!is_string($roomRateTypePromotionVendorCodeItem)) {
                $invalidValues[] = is_object($roomRateTypePromotionVendorCodeItem) ? get_class($roomRateTypePromotionVendorCodeItem) : sprintf('%s(%s)', gettype($roomRateTypePromotionVendorCodeItem), var_export($roomRateTypePromotionVendorCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PromotionVendorCode property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PromotionVendorCode value
     * @param string[] $promotionVendorCode
     * @return \StructType\RoomRateType
     */
    public function setPromotionVendorCode(array $promotionVendorCode = array())
    {
        // validation for constraint: list
        if ('' !== ($promotionVendorCodeArrayErrorMessage = self::validatePromotionVendorCodeForArrayConstraintsFromSetPromotionVendorCode($promotionVendorCode))) {
            throw new \InvalidArgumentException($promotionVendorCodeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($promotionVendorCode) && mb_strlen($promotionVendorCode) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($promotionVendorCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($promotionVendorCode) && mb_strlen($promotionVendorCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($promotionVendorCode)), __LINE__);
        }
        $this->PromotionVendorCode = is_array($promotionVendorCode) ? implode(' ', $promotionVendorCode) : null;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoomRateType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
