<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomRateLiteType StructType
 * Meta information extracted from the WSDL
 * - documentation: Summary version of the RoomRateType, initially created for the Travel Itinerary Message set.
 * @subpackage Structs
 */
class RoomRateLiteType extends AbstractStructBase
{
    /**
     * The Rates
     * @var \StructType\RateLiteType
     */
    public $Rates;
    /**
     * The RoomTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Specfic system room type code, ex: A1K, A1Q etc. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $RoomTypeCode;
    /**
     * The InvBlockCode
     * Meta information extracted from the WSDL
     * - documentation: Code that identifies an inventory block. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $InvBlockCode;
    /**
     * The NumberOfUnits
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $NumberOfUnits;
    /**
     * The EffectiveDate
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * @var string
     */
    public $ExpireDate;
    /**
     * The ExpireDateExclusiveIndicator
     * @var bool
     */
    public $ExpireDateExclusiveIndicator;
    /**
     * The RatePlanType
     * Meta information extracted from the WSDL
     * - documentation: An enumerated type that allows the query to specify a rate category type, and provides major categories for comparison across brands. Refer to OpenTravel Code List Rate Plan Type (RPT). | Used for codes in the OpenTravel Code tables.
     * Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - type: OTA_CodeType
     * - use: optional
     * @var string
     */
    public $RatePlanType;
    /**
     * The RatePlanCode
     * Meta information extracted from the WSDL
     * - documentation: A string value may be used to request a particular code or an ID if the guest qualifies for a specific rate, such as AARP, AAA, a corporate rate, etc., or to specify a negotiated code as a result of a negotiated rate. | Used for
     * Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - type: StringLength1to64
     * - use: optional
     * @var string
     */
    public $RatePlanCode;
    /**
     * The RatePlanID
     * Meta information extracted from the WSDL
     * - documentation: A text field used to indicate a special ID code that is associated with the rate and is essential in the reservation request in order to obtain the rate. Examples are Corporate ID. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - type: StringLength1to64
     * - use: optional
     * @var string
     */
    public $RatePlanID;
    /**
     * The RatePlanQualifier
     * Meta information extracted from the WSDL
     * - documentation: The Rate Plan Qualifier is used to control the sort order of RatePlans. Those Rate Plans that are not qualified will appear first, those that are qualified will appear last.
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $RatePlanQualifier;
    /**
     * The RatePlanCategory
     * Meta information extracted from the WSDL
     * - documentation: Hotel systems often group multiple rate plans into a single category. This refers to that category that is specific to the hotel CRS/ PMS and should not be confused with a GDS rate category. | Used for Character Strings, length 1 to
     * 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - type: StringLength1to64
     * - use: optional
     * @var string
     */
    public $RatePlanCategory;
    /**
     * The PromotionCode
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $PromotionCode;
    /**
     * The PromotionVendorCode
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 8. | List of StringLength1to8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * @var string[]
     */
    public $PromotionVendorCode;
    /**
     * Constructor method for RoomRateLiteType
     * @uses RoomRateLiteType::setRates()
     * @uses RoomRateLiteType::setRoomTypeCode()
     * @uses RoomRateLiteType::setInvBlockCode()
     * @uses RoomRateLiteType::setNumberOfUnits()
     * @uses RoomRateLiteType::setEffectiveDate()
     * @uses RoomRateLiteType::setExpireDate()
     * @uses RoomRateLiteType::setExpireDateExclusiveIndicator()
     * @uses RoomRateLiteType::setRatePlanType()
     * @uses RoomRateLiteType::setRatePlanCode()
     * @uses RoomRateLiteType::setRatePlanID()
     * @uses RoomRateLiteType::setRatePlanQualifier()
     * @uses RoomRateLiteType::setRatePlanCategory()
     * @uses RoomRateLiteType::setPromotionCode()
     * @uses RoomRateLiteType::setPromotionVendorCode()
     * @param \StructType\RateLiteType $rates
     * @param string $roomTypeCode
     * @param string $invBlockCode
     * @param int $numberOfUnits
     * @param string $effectiveDate
     * @param string $expireDate
     * @param bool $expireDateExclusiveIndicator
     * @param string $ratePlanType
     * @param string $ratePlanCode
     * @param string $ratePlanID
     * @param bool $ratePlanQualifier
     * @param string $ratePlanCategory
     * @param string $promotionCode
     * @param string[] $promotionVendorCode
     */
    public function __construct(\StructType\RateLiteType $rates = null, $roomTypeCode = null, $invBlockCode = null, $numberOfUnits = null, $effectiveDate = null, $expireDate = null, $expireDateExclusiveIndicator = null, $ratePlanType = null, $ratePlanCode = null, $ratePlanID = null, $ratePlanQualifier = null, $ratePlanCategory = null, $promotionCode = null, array $promotionVendorCode = array())
    {
        $this
            ->setRates($rates)
            ->setRoomTypeCode($roomTypeCode)
            ->setInvBlockCode($invBlockCode)
            ->setNumberOfUnits($numberOfUnits)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate)
            ->setExpireDateExclusiveIndicator($expireDateExclusiveIndicator)
            ->setRatePlanType($ratePlanType)
            ->setRatePlanCode($ratePlanCode)
            ->setRatePlanID($ratePlanID)
            ->setRatePlanQualifier($ratePlanQualifier)
            ->setRatePlanCategory($ratePlanCategory)
            ->setPromotionCode($promotionCode)
            ->setPromotionVendorCode($promotionVendorCode);
    }
    /**
     * Get Rates value
     * @return \StructType\RateLiteType|null
     */
    public function getRates()
    {
        return $this->Rates;
    }
    /**
     * Set Rates value
     * @param \StructType\RateLiteType $rates
     * @return \StructType\RoomRateLiteType
     */
    public function setRates(\StructType\RateLiteType $rates = null)
    {
        $this->Rates = $rates;
        return $this;
    }
    /**
     * Get RoomTypeCode value
     * @return string|null
     */
    public function getRoomTypeCode()
    {
        return $this->RoomTypeCode;
    }
    /**
     * Set RoomTypeCode value
     * @param string $roomTypeCode
     * @return \StructType\RoomRateLiteType
     */
    public function setRoomTypeCode($roomTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomTypeCode) && !is_string($roomTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomTypeCode, true), gettype($roomTypeCode)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($roomTypeCode) && mb_strlen($roomTypeCode) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($roomTypeCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($roomTypeCode) && mb_strlen($roomTypeCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($roomTypeCode)), __LINE__);
        }
        $this->RoomTypeCode = $roomTypeCode;
        return $this;
    }
    /**
     * Get InvBlockCode value
     * @return string|null
     */
    public function getInvBlockCode()
    {
        return $this->InvBlockCode;
    }
    /**
     * Set InvBlockCode value
     * @param string $invBlockCode
     * @return \StructType\RoomRateLiteType
     */
    public function setInvBlockCode($invBlockCode = null)
    {
        // validation for constraint: string
        if (!is_null($invBlockCode) && !is_string($invBlockCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invBlockCode, true), gettype($invBlockCode)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($invBlockCode) && mb_strlen($invBlockCode) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($invBlockCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($invBlockCode) && mb_strlen($invBlockCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($invBlockCode)), __LINE__);
        }
        $this->InvBlockCode = $invBlockCode;
        return $this;
    }
    /**
     * Get NumberOfUnits value
     * @return int|null
     */
    public function getNumberOfUnits()
    {
        return $this->NumberOfUnits;
    }
    /**
     * Set NumberOfUnits value
     * @param int $numberOfUnits
     * @return \StructType\RoomRateLiteType
     */
    public function setNumberOfUnits($numberOfUnits = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfUnits) && !(is_int($numberOfUnits) || ctype_digit($numberOfUnits))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfUnits, true), gettype($numberOfUnits)), __LINE__);
        }
        $this->NumberOfUnits = $numberOfUnits;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\RoomRateLiteType
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \StructType\RoomRateLiteType
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expireDate, true), gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get ExpireDateExclusiveIndicator value
     * @return bool|null
     */
    public function getExpireDateExclusiveIndicator()
    {
        return $this->ExpireDateExclusiveIndicator;
    }
    /**
     * Set ExpireDateExclusiveIndicator value
     * @param bool $expireDateExclusiveIndicator
     * @return \StructType\RoomRateLiteType
     */
    public function setExpireDateExclusiveIndicator($expireDateExclusiveIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($expireDateExclusiveIndicator) && !is_bool($expireDateExclusiveIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($expireDateExclusiveIndicator, true), gettype($expireDateExclusiveIndicator)), __LINE__);
        }
        $this->ExpireDateExclusiveIndicator = $expireDateExclusiveIndicator;
        return $this;
    }
    /**
     * Get RatePlanType value
     * @return string|null
     */
    public function getRatePlanType()
    {
        return $this->RatePlanType;
    }
    /**
     * Set RatePlanType value
     * @param string $ratePlanType
     * @return \StructType\RoomRateLiteType
     */
    public function setRatePlanType($ratePlanType = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanType) && !is_string($ratePlanType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanType, true), gettype($ratePlanType)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($ratePlanType) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $ratePlanType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($ratePlanType, true)), __LINE__);
        }
        $this->RatePlanType = $ratePlanType;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\RoomRateLiteType
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCode, true), gettype($ratePlanCode)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ratePlanCode) && mb_strlen($ratePlanCode) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($ratePlanCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($ratePlanCode) && mb_strlen($ratePlanCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Get RatePlanID value
     * @return string|null
     */
    public function getRatePlanID()
    {
        return $this->RatePlanID;
    }
    /**
     * Set RatePlanID value
     * @param string $ratePlanID
     * @return \StructType\RoomRateLiteType
     */
    public function setRatePlanID($ratePlanID = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanID) && !is_string($ratePlanID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanID, true), gettype($ratePlanID)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ratePlanID) && mb_strlen($ratePlanID) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($ratePlanID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($ratePlanID) && mb_strlen($ratePlanID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($ratePlanID)), __LINE__);
        }
        $this->RatePlanID = $ratePlanID;
        return $this;
    }
    /**
     * Get RatePlanQualifier value
     * @return bool|null
     */
    public function getRatePlanQualifier()
    {
        return $this->RatePlanQualifier;
    }
    /**
     * Set RatePlanQualifier value
     * @param bool $ratePlanQualifier
     * @return \StructType\RoomRateLiteType
     */
    public function setRatePlanQualifier($ratePlanQualifier = null)
    {
        // validation for constraint: boolean
        if (!is_null($ratePlanQualifier) && !is_bool($ratePlanQualifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ratePlanQualifier, true), gettype($ratePlanQualifier)), __LINE__);
        }
        $this->RatePlanQualifier = $ratePlanQualifier;
        return $this;
    }
    /**
     * Get RatePlanCategory value
     * @return string|null
     */
    public function getRatePlanCategory()
    {
        return $this->RatePlanCategory;
    }
    /**
     * Set RatePlanCategory value
     * @param string $ratePlanCategory
     * @return \StructType\RoomRateLiteType
     */
    public function setRatePlanCategory($ratePlanCategory = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCategory) && !is_string($ratePlanCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCategory, true), gettype($ratePlanCategory)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ratePlanCategory) && mb_strlen($ratePlanCategory) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($ratePlanCategory)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($ratePlanCategory) && mb_strlen($ratePlanCategory) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($ratePlanCategory)), __LINE__);
        }
        $this->RatePlanCategory = $ratePlanCategory;
        return $this;
    }
    /**
     * Get PromotionCode value
     * @return string|null
     */
    public function getPromotionCode()
    {
        return $this->PromotionCode;
    }
    /**
     * Set PromotionCode value
     * @param string $promotionCode
     * @return \StructType\RoomRateLiteType
     */
    public function setPromotionCode($promotionCode = null)
    {
        // validation for constraint: string
        if (!is_null($promotionCode) && !is_string($promotionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promotionCode, true), gettype($promotionCode)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($promotionCode) && mb_strlen($promotionCode) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($promotionCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($promotionCode) && mb_strlen($promotionCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($promotionCode)), __LINE__);
        }
        $this->PromotionCode = $promotionCode;
        return $this;
    }
    /**
     * Get PromotionVendorCode value
     * @return string[]|null
     */
    public function getPromotionVendorCode()
    {
        return $this->PromotionVendorCode;
    }
    /**
     * This method is responsible for validating the values passed to the setPromotionVendorCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPromotionVendorCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePromotionVendorCodeForArrayConstraintsFromSetPromotionVendorCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $roomRateLiteTypePromotionVendorCodeItem) {
            // validation for constraint: itemType
            if (!is_string($roomRateLiteTypePromotionVendorCodeItem)) {
                $invalidValues[] = is_object($roomRateLiteTypePromotionVendorCodeItem) ? get_class($roomRateLiteTypePromotionVendorCodeItem) : sprintf('%s(%s)', gettype($roomRateLiteTypePromotionVendorCodeItem), var_export($roomRateLiteTypePromotionVendorCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PromotionVendorCode property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PromotionVendorCode value
     * @param string[] $promotionVendorCode
     * @return \StructType\RoomRateLiteType
     */
    public function setPromotionVendorCode(array $promotionVendorCode = array())
    {
        // validation for constraint: list
        if ('' !== ($promotionVendorCodeArrayErrorMessage = self::validatePromotionVendorCodeForArrayConstraintsFromSetPromotionVendorCode($promotionVendorCode))) {
            throw new \InvalidArgumentException($promotionVendorCodeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($promotionVendorCode) && mb_strlen($promotionVendorCode) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($promotionVendorCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($promotionVendorCode) && mb_strlen($promotionVendorCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($promotionVendorCode)), __LINE__);
        }
        $this->PromotionVendorCode = is_array($promotionVendorCode) ? implode(' ', $promotionVendorCode) : null;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoomRateLiteType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
