<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RevenueCategoryType StructType
 * Meta information extracted from the WSDL
 * - documentation: The classifications of revenue data associated with the StayInfo report. A RevenueCategory provide a way to classify guest financial stay data and analyze guest spending for a certain category (e.g., food and beverage, room, etc.)
 * @subpackage Structs
 */
class RevenueCategoryType extends AbstractStructBase
{
    /**
     * The SummaryAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SummaryAmount
     */
    public $SummaryAmount;
    /**
     * The RevenueDetails
     * Meta information extracted from the WSDL
     * - documentation: A collection of revenue details.
     * - minOccurs: 0
     * @var \StructType\RevenueDetailsType
     */
    public $RevenueDetails;
    /**
     * The RevenueCategoryCode
     * Meta information extracted from the WSDL
     * - documentation: Describes the type of revenue generated. Refer to OpenTravel Code List Revenue Category Code (RCC). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string
     */
    public $RevenueCategoryCode;
    /**
     * Constructor method for RevenueCategoryType
     * @uses RevenueCategoryType::setSummaryAmount()
     * @uses RevenueCategoryType::setRevenueDetails()
     * @uses RevenueCategoryType::setRevenueCategoryCode()
     * @param \StructType\SummaryAmount $summaryAmount
     * @param \StructType\RevenueDetailsType $revenueDetails
     * @param string $revenueCategoryCode
     */
    public function __construct(\StructType\SummaryAmount $summaryAmount = null, \StructType\RevenueDetailsType $revenueDetails = null, $revenueCategoryCode = null)
    {
        $this
            ->setSummaryAmount($summaryAmount)
            ->setRevenueDetails($revenueDetails)
            ->setRevenueCategoryCode($revenueCategoryCode);
    }
    /**
     * Get SummaryAmount value
     * @return \StructType\SummaryAmount|null
     */
    public function getSummaryAmount()
    {
        return $this->SummaryAmount;
    }
    /**
     * Set SummaryAmount value
     * @param \StructType\SummaryAmount $summaryAmount
     * @return \StructType\RevenueCategoryType
     */
    public function setSummaryAmount(\StructType\SummaryAmount $summaryAmount = null)
    {
        $this->SummaryAmount = $summaryAmount;
        return $this;
    }
    /**
     * Get RevenueDetails value
     * @return \StructType\RevenueDetailsType|null
     */
    public function getRevenueDetails()
    {
        return $this->RevenueDetails;
    }
    /**
     * Set RevenueDetails value
     * @param \StructType\RevenueDetailsType $revenueDetails
     * @return \StructType\RevenueCategoryType
     */
    public function setRevenueDetails(\StructType\RevenueDetailsType $revenueDetails = null)
    {
        $this->RevenueDetails = $revenueDetails;
        return $this;
    }
    /**
     * Get RevenueCategoryCode value
     * @return string|null
     */
    public function getRevenueCategoryCode()
    {
        return $this->RevenueCategoryCode;
    }
    /**
     * Set RevenueCategoryCode value
     * @param string $revenueCategoryCode
     * @return \StructType\RevenueCategoryType
     */
    public function setRevenueCategoryCode($revenueCategoryCode = null)
    {
        // validation for constraint: string
        if (!is_null($revenueCategoryCode) && !is_string($revenueCategoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($revenueCategoryCode, true), gettype($revenueCategoryCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($revenueCategoryCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $revenueCategoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($revenueCategoryCode, true)), __LINE__);
        }
        $this->RevenueCategoryCode = $revenueCategoryCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RevenueCategoryType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
