<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RestrictionStatus StructType
 * Meta information extracted from the WSDL
 * - documentation: Used to indicate whether the rate is on request or available. | Availability status assigned to the room rate combination for this booking rule. | Availability status assigned to the room rate combination.
 * @subpackage Structs
 */
class RestrictionStatus extends AbstractStructBase
{
    /**
     * The MaxAdvancedBookingOffset
     * Meta information extracted from the WSDL
     * - documentation: Maximum days before the arrival date for which this rate plan may be booked.
     * - use: optional
     * @var string
     */
    public $MaxAdvancedBookingOffset;
    /**
     * The MinAdvancedBookingOffset
     * Meta information extracted from the WSDL
     * - documentation: Minimum days before the arrival date for which this rate plan may be booked.
     * - use: optional
     * @var string
     */
    public $MinAdvancedBookingOffset;
    /**
     * The Restriction
     * @var string
     */
    public $Restriction;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - type: AvailabilityStatusType
     * - use: optional
     * @var string
     */
    public $Status;
    /**
     * The SellThroughOpenIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, this indicates sell through is open and when false, this indicates sell through is closed. Typically this would be used in conjunction with the Status attribute to indicate that bookings may be allowed based on a trading
     * partner agreement even though one or more days are closed.
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $SellThroughOpenIndicator;
    /**
     * Constructor method for RestrictionStatus
     * @uses RestrictionStatus::setMaxAdvancedBookingOffset()
     * @uses RestrictionStatus::setMinAdvancedBookingOffset()
     * @uses RestrictionStatus::setRestriction()
     * @uses RestrictionStatus::setStatus()
     * @uses RestrictionStatus::setSellThroughOpenIndicator()
     * @param string $maxAdvancedBookingOffset
     * @param string $minAdvancedBookingOffset
     * @param string $restriction
     * @param string $status
     * @param bool $sellThroughOpenIndicator
     */
    public function __construct($maxAdvancedBookingOffset = null, $minAdvancedBookingOffset = null, $restriction = null, $status = null, $sellThroughOpenIndicator = null)
    {
        $this
            ->setMaxAdvancedBookingOffset($maxAdvancedBookingOffset)
            ->setMinAdvancedBookingOffset($minAdvancedBookingOffset)
            ->setRestriction($restriction)
            ->setStatus($status)
            ->setSellThroughOpenIndicator($sellThroughOpenIndicator);
    }
    /**
     * Get MaxAdvancedBookingOffset value
     * @return string|null
     */
    public function getMaxAdvancedBookingOffset()
    {
        return $this->MaxAdvancedBookingOffset;
    }
    /**
     * Set MaxAdvancedBookingOffset value
     * @param string $maxAdvancedBookingOffset
     * @return \StructType\RestrictionStatus
     */
    public function setMaxAdvancedBookingOffset($maxAdvancedBookingOffset = null)
    {
        // validation for constraint: string
        if (!is_null($maxAdvancedBookingOffset) && !is_string($maxAdvancedBookingOffset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maxAdvancedBookingOffset, true), gettype($maxAdvancedBookingOffset)), __LINE__);
        }
        $this->MaxAdvancedBookingOffset = $maxAdvancedBookingOffset;
        return $this;
    }
    /**
     * Get MinAdvancedBookingOffset value
     * @return string|null
     */
    public function getMinAdvancedBookingOffset()
    {
        return $this->MinAdvancedBookingOffset;
    }
    /**
     * Set MinAdvancedBookingOffset value
     * @param string $minAdvancedBookingOffset
     * @return \StructType\RestrictionStatus
     */
    public function setMinAdvancedBookingOffset($minAdvancedBookingOffset = null)
    {
        // validation for constraint: string
        if (!is_null($minAdvancedBookingOffset) && !is_string($minAdvancedBookingOffset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minAdvancedBookingOffset, true), gettype($minAdvancedBookingOffset)), __LINE__);
        }
        $this->MinAdvancedBookingOffset = $minAdvancedBookingOffset;
        return $this;
    }
    /**
     * Get Restriction value
     * @return string|null
     */
    public function getRestriction()
    {
        return $this->Restriction;
    }
    /**
     * Set Restriction value
     * @param string $restriction
     * @return \StructType\RestrictionStatus
     */
    public function setRestriction($restriction = null)
    {
        // validation for constraint: string
        if (!is_null($restriction) && !is_string($restriction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($restriction, true), gettype($restriction)), __LINE__);
        }
        $this->Restriction = $restriction;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\AvailabilityStatusType::valueIsValid()
     * @uses \EnumType\AvailabilityStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\RestrictionStatus
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AvailabilityStatusType::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AvailabilityStatusType', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\AvailabilityStatusType::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get SellThroughOpenIndicator value
     * @return bool|null
     */
    public function getSellThroughOpenIndicator()
    {
        return $this->SellThroughOpenIndicator;
    }
    /**
     * Set SellThroughOpenIndicator value
     * @param bool $sellThroughOpenIndicator
     * @return \StructType\RestrictionStatus
     */
    public function setSellThroughOpenIndicator($sellThroughOpenIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($sellThroughOpenIndicator) && !is_bool($sellThroughOpenIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sellThroughOpenIndicator, true), gettype($sellThroughOpenIndicator)), __LINE__);
        }
        $this->SellThroughOpenIndicator = $sellThroughOpenIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RestrictionStatus
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
