<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Restriction StructType
 * Meta information extracted from the WSDL
 * - documentation: The effective date range for which the restriction applies. | Information on the restriction associated with the RoomRate element. | Restrictions pertaining to the availability.
 * - use: optional
 * @subpackage Structs
 */
class Restriction extends AbstractStructBase
{
    /**
     * The DOW_Restrictions
     * Meta information extracted from the WSDL
     * - documentation: A collection of day of week restrictions.
     * @var \StructType\DOW_RestrictionsType
     */
    public $DOW_Restrictions;
    /**
     * The EffectiveDate
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * @var string
     */
    public $ExpireDate;
    /**
     * The ExpireDateExclusiveIndicator
     * @var bool
     */
    public $ExpireDateExclusiveIndicator;
    /**
     * The RestrictionType
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $RestrictionType;
    /**
     * The Time
     * Meta information extracted from the WSDL
     * - documentation: Used in conjunction with the RestrictionType and the TimeUnit to define the restriction length.
     * - use: optional
     * @var int
     */
    public $Time;
    /**
     * The TimeUnit
     * Meta information extracted from the WSDL
     * - documentation: A time unit used to apply this status message to other inventory, and with more granularity than daily. Values: Year, Month, Week, Day, Hour, Minute, Second.
     * - use: optional
     * @var string
     */
    public $TimeUnit;
    /**
     * Constructor method for Restriction
     * @uses Restriction::setDOW_Restrictions()
     * @uses Restriction::setEffectiveDate()
     * @uses Restriction::setExpireDate()
     * @uses Restriction::setExpireDateExclusiveIndicator()
     * @uses Restriction::setRestrictionType()
     * @uses Restriction::setTime()
     * @uses Restriction::setTimeUnit()
     * @param \StructType\DOW_RestrictionsType $dOW_Restrictions
     * @param string $effectiveDate
     * @param string $expireDate
     * @param bool $expireDateExclusiveIndicator
     * @param string $restrictionType
     * @param int $time
     * @param string $timeUnit
     */
    public function __construct(\StructType\DOW_RestrictionsType $dOW_Restrictions = null, $effectiveDate = null, $expireDate = null, $expireDateExclusiveIndicator = null, $restrictionType = null, $time = null, $timeUnit = null)
    {
        $this
            ->setDOW_Restrictions($dOW_Restrictions)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate)
            ->setExpireDateExclusiveIndicator($expireDateExclusiveIndicator)
            ->setRestrictionType($restrictionType)
            ->setTime($time)
            ->setTimeUnit($timeUnit);
    }
    /**
     * Get DOW_Restrictions value
     * @return \StructType\DOW_RestrictionsType|null
     */
    public function getDOW_Restrictions()
    {
        return $this->DOW_Restrictions;
    }
    /**
     * Set DOW_Restrictions value
     * @param \StructType\DOW_RestrictionsType $dOW_Restrictions
     * @return \StructType\Restriction
     */
    public function setDOW_Restrictions(\StructType\DOW_RestrictionsType $dOW_Restrictions = null)
    {
        $this->DOW_Restrictions = $dOW_Restrictions;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\Restriction
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \StructType\Restriction
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expireDate, true), gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get ExpireDateExclusiveIndicator value
     * @return bool|null
     */
    public function getExpireDateExclusiveIndicator()
    {
        return $this->ExpireDateExclusiveIndicator;
    }
    /**
     * Set ExpireDateExclusiveIndicator value
     * @param bool $expireDateExclusiveIndicator
     * @return \StructType\Restriction
     */
    public function setExpireDateExclusiveIndicator($expireDateExclusiveIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($expireDateExclusiveIndicator) && !is_bool($expireDateExclusiveIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($expireDateExclusiveIndicator, true), gettype($expireDateExclusiveIndicator)), __LINE__);
        }
        $this->ExpireDateExclusiveIndicator = $expireDateExclusiveIndicator;
        return $this;
    }
    /**
     * Get RestrictionType value
     * @return string|null
     */
    public function getRestrictionType()
    {
        return $this->RestrictionType;
    }
    /**
     * Set RestrictionType value
     * @param string $restrictionType
     * @return \StructType\Restriction
     */
    public function setRestrictionType($restrictionType = null)
    {
        // validation for constraint: string
        if (!is_null($restrictionType) && !is_string($restrictionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($restrictionType, true), gettype($restrictionType)), __LINE__);
        }
        $this->RestrictionType = $restrictionType;
        return $this;
    }
    /**
     * Get Time value
     * @return int|null
     */
    public function getTime()
    {
        return $this->Time;
    }
    /**
     * Set Time value
     * @param int $time
     * @return \StructType\Restriction
     */
    public function setTime($time = null)
    {
        // validation for constraint: int
        if (!is_null($time) && !(is_int($time) || ctype_digit($time))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($time, true), gettype($time)), __LINE__);
        }
        $this->Time = $time;
        return $this;
    }
    /**
     * Get TimeUnit value
     * @return string|null
     */
    public function getTimeUnit()
    {
        return $this->TimeUnit;
    }
    /**
     * Set TimeUnit value
     * @uses \EnumType\TimeUnitType::valueIsValid()
     * @uses \EnumType\TimeUnitType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timeUnit
     * @return \StructType\Restriction
     */
    public function setTimeUnit($timeUnit = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TimeUnitType::valueIsValid($timeUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TimeUnitType', is_array($timeUnit) ? implode(', ', $timeUnit) : var_export($timeUnit, true), implode(', ', \EnumType\TimeUnitType::getValidValues())), __LINE__);
        }
        $this->TimeUnit = $timeUnit;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Restriction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
