<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResGuestType StructType
 * Meta information extracted from the WSDL
 * - documentation: The city of origin for this traveler's trip. | A collection of ResGuest objects, identifying the guests associated with this reservation. Which guests are in which room is determined by each RoomStays ResGuestRPHs collection.
 * @subpackage Structs
 */
class ResGuestType extends AbstractStructBase
{
    /**
     * The Profiles
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ProfilesType
     */
    public $Profiles;
    /**
     * The SpecialRequests
     * Meta information extracted from the WSDL
     * - documentation: The SpecialRequest object indicates special requests for a particular guest.
     * - minOccurs: 0
     * @var \StructType\SpecialRequestType
     */
    public $SpecialRequests;
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - documentation: A collection of Comment objects. Comments which apply to one or more guests.
     * - minOccurs: 0
     * @var \StructType\CommentType
     */
    public $Comments;
    /**
     * The ServiceRPHs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ServiceRPHsType
     */
    public $ServiceRPHs;
    /**
     * The ProfileRPHs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ProfileRPHs
     */
    public $ProfileRPHs;
    /**
     * The ArrivalTransport
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TransportInfoType
     */
    public $ArrivalTransport;
    /**
     * The DepartureTransport
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TransportInfoType
     */
    public $DepartureTransport;
    /**
     * The GuestCounts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\GuestCountType
     */
    public $GuestCounts;
    /**
     * The InHouseTimeSpan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DateTimeSpanType
     */
    public $InHouseTimeSpan;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var \StructType\TPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The ResGuestRPH
     * Meta information extracted from the WSDL
     * - documentation: This is a reference placeholder, used as an index for this guest in this reservation. In the ResGuest object it is used like all other RPH attributes to send the delta of a reservation. It is used by the RoomStay and Service objects
     * to indicate which guests are associated with that room stay or service. | The Reference Place Holder (RPH) is an index code used to identify an instance in a collection of like items (e.g. used to assign individual passengers or clients to particular
     * itinerary items).
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string
     */
    public $ResGuestRPH;
    /**
     * The AgeQualifyingCode
     * Meta information extracted from the WSDL
     * - documentation: A code representing a business rule that determines the charges for a guest based upon age rannge (e.g. Adult, Child, Senior, Child With Adult, Child Without Adult). This attribute allows for an increase in rate by occupant class.
     * Refer to OpenTravel Code List Age Qualifying Code (AQC). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string
     */
    public $AgeQualifyingCode;
    /**
     * The ArrivalTime
     * Meta information extracted from the WSDL
     * - documentation: This represents the date and time of the guest's arrival at the hotel. For example, this could be used to indicate a late arrival.
     * - use: optional
     * @var string
     */
    public $ArrivalTime;
    /**
     * The DepartureTime
     * Meta information extracted from the WSDL
     * - documentation: This represents the date and time of the guest's departure from the hotel.
     * - use: optional
     * @var string
     */
    public $DepartureTime;
    /**
     * The GroupEventCode
     * Meta information extracted from the WSDL
     * - documentation: The identification of a group meeting or convention. Used to track a guest who is part of an inventory block (e.g.: group), and can be used for a pick-up when the guest calls in to reserve a room as part of the block. Whether this is
     * taken from inventory depends upon the InventoryBlockCode in the Room Stay class. This code is associated with a group or event as agreed between two parties. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $GroupEventCode;
    /**
     * The VIP
     * Meta information extracted from the WSDL
     * - documentation: Guest is VIP indicator.
     * - use: optional
     * @var bool
     */
    public $VIP;
    /**
     * The PrimaryIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true indicates this is the primary guest.
     * - use: optional
     * @var bool
     */
    public $PrimaryIndicator;
    /**
     * The Age
     * Meta information extracted from the WSDL
     * - documentation: The age of the guest. | Used for Numeric values, from 0 to 999 inclusive.
     * - base: xs:integer
     * - maxInclusive: 999
     * - minInclusive: 0
     * - use: optional
     * @var int
     */
    public $Age;
    /**
     * The Action
     * Meta information extracted from the WSDL
     * - documentation: The action being taken on the guest entry.
     * - use: optional
     * @var string
     */
    public $Action;
    /**
     * The LocationCode
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * @var string
     */
    public $LocationCode;
    /**
     * The CodeContext
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $CodeContext;
    /**
     * Constructor method for ResGuestType
     * @uses ResGuestType::setProfiles()
     * @uses ResGuestType::setSpecialRequests()
     * @uses ResGuestType::setComments()
     * @uses ResGuestType::setServiceRPHs()
     * @uses ResGuestType::setProfileRPHs()
     * @uses ResGuestType::setArrivalTransport()
     * @uses ResGuestType::setDepartureTransport()
     * @uses ResGuestType::setGuestCounts()
     * @uses ResGuestType::setInHouseTimeSpan()
     * @uses ResGuestType::setTPA_Extensions()
     * @uses ResGuestType::setResGuestRPH()
     * @uses ResGuestType::setAgeQualifyingCode()
     * @uses ResGuestType::setArrivalTime()
     * @uses ResGuestType::setDepartureTime()
     * @uses ResGuestType::setGroupEventCode()
     * @uses ResGuestType::setVIP()
     * @uses ResGuestType::setPrimaryIndicator()
     * @uses ResGuestType::setAge()
     * @uses ResGuestType::setAction()
     * @uses ResGuestType::setLocationCode()
     * @uses ResGuestType::setCodeContext()
     * @param \StructType\ProfilesType $profiles
     * @param \StructType\SpecialRequestType $specialRequests
     * @param \StructType\CommentType $comments
     * @param \StructType\ServiceRPHsType $serviceRPHs
     * @param \StructType\ProfileRPHs $profileRPHs
     * @param \StructType\TransportInfoType $arrivalTransport
     * @param \StructType\TransportInfoType $departureTransport
     * @param \StructType\GuestCountType $guestCounts
     * @param \StructType\DateTimeSpanType $inHouseTimeSpan
     * @param \StructType\TPA_ExtensionsType $tPA_Extensions
     * @param string $resGuestRPH
     * @param string $ageQualifyingCode
     * @param string $arrivalTime
     * @param string $departureTime
     * @param string $groupEventCode
     * @param bool $vIP
     * @param bool $primaryIndicator
     * @param int $age
     * @param string $action
     * @param string $locationCode
     * @param string $codeContext
     */
    public function __construct(\StructType\ProfilesType $profiles = null, \StructType\SpecialRequestType $specialRequests = null, \StructType\CommentType $comments = null, \StructType\ServiceRPHsType $serviceRPHs = null, \StructType\ProfileRPHs $profileRPHs = null, \StructType\TransportInfoType $arrivalTransport = null, \StructType\TransportInfoType $departureTransport = null, \StructType\GuestCountType $guestCounts = null, \StructType\DateTimeSpanType $inHouseTimeSpan = null, \StructType\TPA_ExtensionsType $tPA_Extensions = null, $resGuestRPH = null, $ageQualifyingCode = null, $arrivalTime = null, $departureTime = null, $groupEventCode = null, $vIP = null, $primaryIndicator = null, $age = null, $action = null, $locationCode = null, $codeContext = null)
    {
        $this
            ->setProfiles($profiles)
            ->setSpecialRequests($specialRequests)
            ->setComments($comments)
            ->setServiceRPHs($serviceRPHs)
            ->setProfileRPHs($profileRPHs)
            ->setArrivalTransport($arrivalTransport)
            ->setDepartureTransport($departureTransport)
            ->setGuestCounts($guestCounts)
            ->setInHouseTimeSpan($inHouseTimeSpan)
            ->setTPA_Extensions($tPA_Extensions)
            ->setResGuestRPH($resGuestRPH)
            ->setAgeQualifyingCode($ageQualifyingCode)
            ->setArrivalTime($arrivalTime)
            ->setDepartureTime($departureTime)
            ->setGroupEventCode($groupEventCode)
            ->setVIP($vIP)
            ->setPrimaryIndicator($primaryIndicator)
            ->setAge($age)
            ->setAction($action)
            ->setLocationCode($locationCode)
            ->setCodeContext($codeContext);
    }
    /**
     * Get Profiles value
     * @return \StructType\ProfilesType|null
     */
    public function getProfiles()
    {
        return $this->Profiles;
    }
    /**
     * Set Profiles value
     * @param \StructType\ProfilesType $profiles
     * @return \StructType\ResGuestType
     */
    public function setProfiles(\StructType\ProfilesType $profiles = null)
    {
        $this->Profiles = $profiles;
        return $this;
    }
    /**
     * Get SpecialRequests value
     * @return \StructType\SpecialRequestType|null
     */
    public function getSpecialRequests()
    {
        return $this->SpecialRequests;
    }
    /**
     * Set SpecialRequests value
     * @param \StructType\SpecialRequestType $specialRequests
     * @return \StructType\ResGuestType
     */
    public function setSpecialRequests(\StructType\SpecialRequestType $specialRequests = null)
    {
        $this->SpecialRequests = $specialRequests;
        return $this;
    }
    /**
     * Get Comments value
     * @return \StructType\CommentType|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param \StructType\CommentType $comments
     * @return \StructType\ResGuestType
     */
    public function setComments(\StructType\CommentType $comments = null)
    {
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Get ServiceRPHs value
     * @return \StructType\ServiceRPHsType|null
     */
    public function getServiceRPHs()
    {
        return $this->ServiceRPHs;
    }
    /**
     * Set ServiceRPHs value
     * @param \StructType\ServiceRPHsType $serviceRPHs
     * @return \StructType\ResGuestType
     */
    public function setServiceRPHs(\StructType\ServiceRPHsType $serviceRPHs = null)
    {
        $this->ServiceRPHs = $serviceRPHs;
        return $this;
    }
    /**
     * Get ProfileRPHs value
     * @return \StructType\ProfileRPHs|null
     */
    public function getProfileRPHs()
    {
        return $this->ProfileRPHs;
    }
    /**
     * Set ProfileRPHs value
     * @param \StructType\ProfileRPHs $profileRPHs
     * @return \StructType\ResGuestType
     */
    public function setProfileRPHs(\StructType\ProfileRPHs $profileRPHs = null)
    {
        $this->ProfileRPHs = $profileRPHs;
        return $this;
    }
    /**
     * Get ArrivalTransport value
     * @return \StructType\TransportInfoType|null
     */
    public function getArrivalTransport()
    {
        return $this->ArrivalTransport;
    }
    /**
     * Set ArrivalTransport value
     * @param \StructType\TransportInfoType $arrivalTransport
     * @return \StructType\ResGuestType
     */
    public function setArrivalTransport(\StructType\TransportInfoType $arrivalTransport = null)
    {
        $this->ArrivalTransport = $arrivalTransport;
        return $this;
    }
    /**
     * Get DepartureTransport value
     * @return \StructType\TransportInfoType|null
     */
    public function getDepartureTransport()
    {
        return $this->DepartureTransport;
    }
    /**
     * Set DepartureTransport value
     * @param \StructType\TransportInfoType $departureTransport
     * @return \StructType\ResGuestType
     */
    public function setDepartureTransport(\StructType\TransportInfoType $departureTransport = null)
    {
        $this->DepartureTransport = $departureTransport;
        return $this;
    }
    /**
     * Get GuestCounts value
     * @return \StructType\GuestCountType|null
     */
    public function getGuestCounts()
    {
        return $this->GuestCounts;
    }
    /**
     * Set GuestCounts value
     * @param \StructType\GuestCountType $guestCounts
     * @return \StructType\ResGuestType
     */
    public function setGuestCounts(\StructType\GuestCountType $guestCounts = null)
    {
        $this->GuestCounts = $guestCounts;
        return $this;
    }
    /**
     * Get InHouseTimeSpan value
     * @return \StructType\DateTimeSpanType|null
     */
    public function getInHouseTimeSpan()
    {
        return $this->InHouseTimeSpan;
    }
    /**
     * Set InHouseTimeSpan value
     * @param \StructType\DateTimeSpanType $inHouseTimeSpan
     * @return \StructType\ResGuestType
     */
    public function setInHouseTimeSpan(\StructType\DateTimeSpanType $inHouseTimeSpan = null)
    {
        $this->InHouseTimeSpan = $inHouseTimeSpan;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \StructType\TPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \StructType\TPA_ExtensionsType $tPA_Extensions
     * @return \StructType\ResGuestType
     */
    public function setTPA_Extensions(\StructType\TPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get ResGuestRPH value
     * @return string|null
     */
    public function getResGuestRPH()
    {
        return $this->ResGuestRPH;
    }
    /**
     * Set ResGuestRPH value
     * @param string $resGuestRPH
     * @return \StructType\ResGuestType
     */
    public function setResGuestRPH($resGuestRPH = null)
    {
        // validation for constraint: string
        if (!is_null($resGuestRPH) && !is_string($resGuestRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resGuestRPH, true), gettype($resGuestRPH)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($resGuestRPH) && !preg_match('/[0-9]{1,8}/', $resGuestRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($resGuestRPH, true)), __LINE__);
        }
        $this->ResGuestRPH = $resGuestRPH;
        return $this;
    }
    /**
     * Get AgeQualifyingCode value
     * @return string|null
     */
    public function getAgeQualifyingCode()
    {
        return $this->AgeQualifyingCode;
    }
    /**
     * Set AgeQualifyingCode value
     * @param string $ageQualifyingCode
     * @return \StructType\ResGuestType
     */
    public function setAgeQualifyingCode($ageQualifyingCode = null)
    {
        // validation for constraint: string
        if (!is_null($ageQualifyingCode) && !is_string($ageQualifyingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ageQualifyingCode, true), gettype($ageQualifyingCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($ageQualifyingCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $ageQualifyingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($ageQualifyingCode, true)), __LINE__);
        }
        $this->AgeQualifyingCode = $ageQualifyingCode;
        return $this;
    }
    /**
     * Get ArrivalTime value
     * @return string|null
     */
    public function getArrivalTime()
    {
        return $this->ArrivalTime;
    }
    /**
     * Set ArrivalTime value
     * @param string $arrivalTime
     * @return \StructType\ResGuestType
     */
    public function setArrivalTime($arrivalTime = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalTime) && !is_string($arrivalTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalTime, true), gettype($arrivalTime)), __LINE__);
        }
        $this->ArrivalTime = $arrivalTime;
        return $this;
    }
    /**
     * Get DepartureTime value
     * @return string|null
     */
    public function getDepartureTime()
    {
        return $this->DepartureTime;
    }
    /**
     * Set DepartureTime value
     * @param string $departureTime
     * @return \StructType\ResGuestType
     */
    public function setDepartureTime($departureTime = null)
    {
        // validation for constraint: string
        if (!is_null($departureTime) && !is_string($departureTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureTime, true), gettype($departureTime)), __LINE__);
        }
        $this->DepartureTime = $departureTime;
        return $this;
    }
    /**
     * Get GroupEventCode value
     * @return string|null
     */
    public function getGroupEventCode()
    {
        return $this->GroupEventCode;
    }
    /**
     * Set GroupEventCode value
     * @param string $groupEventCode
     * @return \StructType\ResGuestType
     */
    public function setGroupEventCode($groupEventCode = null)
    {
        // validation for constraint: string
        if (!is_null($groupEventCode) && !is_string($groupEventCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupEventCode, true), gettype($groupEventCode)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($groupEventCode) && mb_strlen($groupEventCode) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($groupEventCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($groupEventCode) && mb_strlen($groupEventCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($groupEventCode)), __LINE__);
        }
        $this->GroupEventCode = $groupEventCode;
        return $this;
    }
    /**
     * Get VIP value
     * @return bool|null
     */
    public function getVIP()
    {
        return $this->VIP;
    }
    /**
     * Set VIP value
     * @param bool $vIP
     * @return \StructType\ResGuestType
     */
    public function setVIP($vIP = null)
    {
        // validation for constraint: boolean
        if (!is_null($vIP) && !is_bool($vIP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vIP, true), gettype($vIP)), __LINE__);
        }
        $this->VIP = $vIP;
        return $this;
    }
    /**
     * Get PrimaryIndicator value
     * @return bool|null
     */
    public function getPrimaryIndicator()
    {
        return $this->PrimaryIndicator;
    }
    /**
     * Set PrimaryIndicator value
     * @param bool $primaryIndicator
     * @return \StructType\ResGuestType
     */
    public function setPrimaryIndicator($primaryIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($primaryIndicator) && !is_bool($primaryIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($primaryIndicator, true), gettype($primaryIndicator)), __LINE__);
        }
        $this->PrimaryIndicator = $primaryIndicator;
        return $this;
    }
    /**
     * Get Age value
     * @return int|null
     */
    public function getAge()
    {
        return $this->Age;
    }
    /**
     * Set Age value
     * @param int $age
     * @return \StructType\ResGuestType
     */
    public function setAge($age = null)
    {
        // validation for constraint: int
        if (!is_null($age) && !(is_int($age) || ctype_digit($age))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($age, true), gettype($age)), __LINE__);
        }
        // validation for constraint: maxInclusive(999)
        if (!is_null($age) && $age > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999', var_export($age, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($age) && $age < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($age, true)), __LINE__);
        }
        $this->Age = $age;
        return $this;
    }
    /**
     * Get Action value
     * @return string|null
     */
    public function getAction()
    {
        return $this->Action;
    }
    /**
     * Set Action value
     * @uses \EnumType\ActionType::valueIsValid()
     * @uses \EnumType\ActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return \StructType\ResGuestType
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActionType::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ActionType', is_array($action) ? implode(', ', $action) : var_export($action, true), implode(', ', \EnumType\ActionType::getValidValues())), __LINE__);
        }
        $this->Action = $action;
        return $this;
    }
    /**
     * Get LocationCode value
     * @return string|null
     */
    public function getLocationCode()
    {
        return $this->LocationCode;
    }
    /**
     * Set LocationCode value
     * @param string $locationCode
     * @return \StructType\ResGuestType
     */
    public function setLocationCode($locationCode = null)
    {
        // validation for constraint: string
        if (!is_null($locationCode) && !is_string($locationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locationCode, true), gettype($locationCode)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($locationCode) && mb_strlen($locationCode) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($locationCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($locationCode) && mb_strlen($locationCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($locationCode)), __LINE__);
        }
        $this->LocationCode = $locationCode;
        return $this;
    }
    /**
     * Get CodeContext value
     * @return string|null
     */
    public function getCodeContext()
    {
        return $this->CodeContext;
    }
    /**
     * Set CodeContext value
     * @param string $codeContext
     * @return \StructType\ResGuestType
     */
    public function setCodeContext($codeContext = null)
    {
        // validation for constraint: string
        if (!is_null($codeContext) && !is_string($codeContext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codeContext, true), gettype($codeContext)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($codeContext) && mb_strlen($codeContext) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($codeContext)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($codeContext) && mb_strlen($codeContext) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($codeContext)), __LINE__);
        }
        $this->CodeContext = $codeContext;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ResGuestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
