<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResGlobalInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: ResGlobalInfo is a container for various information that affects the Reservation as a whole. These include global comments, counts, reservation IDs, loyalty programs, and payment methods.
 * @subpackage Structs
 */
class ResGlobalInfoType extends ResCommonDetailType
{
    /**
     * The HotelReservationIDs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\HotelReservationIDsType
     */
    public $HotelReservationIDs;
    /**
     * The RoutingHops
     * Meta information extracted from the WSDL
     * - documentation: A collection of RoutingHop objects. This details the path that the original request or notification traveled.
     * - minOccurs: 0
     * @var \StructType\RoutingHopType
     */
    public $RoutingHops;
    /**
     * The Profiles
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ProfilesType
     */
    public $Profiles;
    /**
     * The BookingRules
     * Meta information extracted from the WSDL
     * - documentation: Provides booking rules for the global reservation.
     * - minOccurs: 0
     * @var \StructType\BookingRulesType
     */
    public $BookingRules;
    /**
     * Constructor method for ResGlobalInfoType
     * @uses ResGlobalInfoType::setHotelReservationIDs()
     * @uses ResGlobalInfoType::setRoutingHops()
     * @uses ResGlobalInfoType::setProfiles()
     * @uses ResGlobalInfoType::setBookingRules()
     * @param \StructType\HotelReservationIDsType $hotelReservationIDs
     * @param \StructType\RoutingHopType $routingHops
     * @param \StructType\ProfilesType $profiles
     * @param \StructType\BookingRulesType $bookingRules
     */
    public function __construct(\StructType\HotelReservationIDsType $hotelReservationIDs = null, \StructType\RoutingHopType $routingHops = null, \StructType\ProfilesType $profiles = null, \StructType\BookingRulesType $bookingRules = null)
    {
        $this
            ->setHotelReservationIDs($hotelReservationIDs)
            ->setRoutingHops($routingHops)
            ->setProfiles($profiles)
            ->setBookingRules($bookingRules);
    }
    /**
     * Get HotelReservationIDs value
     * @return \StructType\HotelReservationIDsType|null
     */
    public function getHotelReservationIDs()
    {
        return $this->HotelReservationIDs;
    }
    /**
     * Set HotelReservationIDs value
     * @param \StructType\HotelReservationIDsType $hotelReservationIDs
     * @return \StructType\ResGlobalInfoType
     */
    public function setHotelReservationIDs(\StructType\HotelReservationIDsType $hotelReservationIDs = null)
    {
        $this->HotelReservationIDs = $hotelReservationIDs;
        return $this;
    }
    /**
     * Get RoutingHops value
     * @return \StructType\RoutingHopType|null
     */
    public function getRoutingHops()
    {
        return $this->RoutingHops;
    }
    /**
     * Set RoutingHops value
     * @param \StructType\RoutingHopType $routingHops
     * @return \StructType\ResGlobalInfoType
     */
    public function setRoutingHops(\StructType\RoutingHopType $routingHops = null)
    {
        $this->RoutingHops = $routingHops;
        return $this;
    }
    /**
     * Get Profiles value
     * @return \StructType\ProfilesType|null
     */
    public function getProfiles()
    {
        return $this->Profiles;
    }
    /**
     * Set Profiles value
     * @param \StructType\ProfilesType $profiles
     * @return \StructType\ResGlobalInfoType
     */
    public function setProfiles(\StructType\ProfilesType $profiles = null)
    {
        $this->Profiles = $profiles;
        return $this;
    }
    /**
     * Get BookingRules value
     * @return \StructType\BookingRulesType|null
     */
    public function getBookingRules()
    {
        return $this->BookingRules;
    }
    /**
     * Set BookingRules value
     * @param \StructType\BookingRulesType $bookingRules
     * @return \StructType\ResGlobalInfoType
     */
    public function setBookingRules(\StructType\BookingRulesType $bookingRules = null)
    {
        $this->BookingRules = $bookingRules;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ResGlobalInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
