<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelativePositionType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines the position of an entity in relation to another entity (e.g. from an airport to a hotel, the relationship is dependant on use). | The RelativePosition object contains information about the direction, distance and travel time
 * to/from a facility (hotel, car rental location, or airport) or to/from a designated location.
 * @subpackage Structs
 */
class RelativePositionType extends TransportationsType
{
    /**
     * The Nearest
     * Meta information extracted from the WSDL
     * - documentation: The indicator for whether this location is nearest.
     * - use: optional
     * @var bool
     */
    public $Nearest;
    /**
     * The IndexPointCode
     * Meta information extracted from the WSDL
     * - documentation: This is the object referred to by the relative position (e.g. cross street, airport). Refer to OpenTravel Code List Index Point Code (IPC). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101,
     * 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string
     */
    public $IndexPointCode;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: This is used to accommodate a city name, rail station name etc. when using the indexPoint attribute. | Used for Character Strings, length 0 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 0
     * - use: optional
     * @var string
     */
    public $Name;
    /**
     * The PrimaryIndicator
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether the reference point is considered the main reference point for the specific type of IndexPointCode (e.g., in Dallas, where IndexPointCode=airport Dallas/Fort Worth airport would be the primary airport even if
     * another airport such as Love Field is closer).
     * - use: optional
     * @var bool
     */
    public $PrimaryIndicator;
    /**
     * The ToFrom
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ToFrom;
    /**
     * The ApproximateDistanceInd
     * Meta information extracted from the WSDL
     * - documentation: When true, the distance information is approximate.
     * - use: optional
     * @var bool
     */
    public $ApproximateDistanceInd;
    /**
     * The Direction
     * Meta information extracted from the WSDL
     * - documentation: Defines the cardinal direction (e.g., north, south, southwest).
     * - type: xs:string
     * - use: optional
     * @var string
     */
    public $Direction;
    /**
     * The Distance
     * Meta information extracted from the WSDL
     * - documentation: Defines the distance between two points.
     * - type: xs:string
     * - use: optional
     * @var string
     */
    public $Distance;
    /**
     * The DistanceUnitName
     * Meta information extracted from the WSDL
     * - documentation: Provides the ability to specify the unit of measure to which the "Distance" attribute is referring. | Candidate for potential removal, usage is not recommended. Deprecation Warning added in 2006A.
     * - type: DistanceUnitNameType
     * - use: optional
     * @var string
     */
    public $DistanceUnitName;
    /**
     * The UnitOfMeasureCode
     * Meta information extracted from the WSDL
     * - documentation: The unit of measure in a code format. Refer to OpenTravel Code List Unit of Measure Code (UOM). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - type: OTA_CodeType
     * - use: optional
     * @var string
     */
    public $UnitOfMeasureCode;
    /**
     * Constructor method for RelativePositionType
     * @uses RelativePositionType::setNearest()
     * @uses RelativePositionType::setIndexPointCode()
     * @uses RelativePositionType::setName()
     * @uses RelativePositionType::setPrimaryIndicator()
     * @uses RelativePositionType::setToFrom()
     * @uses RelativePositionType::setApproximateDistanceInd()
     * @uses RelativePositionType::setDirection()
     * @uses RelativePositionType::setDistance()
     * @uses RelativePositionType::setDistanceUnitName()
     * @uses RelativePositionType::setUnitOfMeasureCode()
     * @param bool $nearest
     * @param string $indexPointCode
     * @param string $name
     * @param bool $primaryIndicator
     * @param string $toFrom
     * @param bool $approximateDistanceInd
     * @param string $direction
     * @param string $distance
     * @param string $distanceUnitName
     * @param string $unitOfMeasureCode
     */
    public function __construct($nearest = null, $indexPointCode = null, $name = null, $primaryIndicator = null, $toFrom = null, $approximateDistanceInd = null, $direction = null, $distance = null, $distanceUnitName = null, $unitOfMeasureCode = null)
    {
        $this
            ->setNearest($nearest)
            ->setIndexPointCode($indexPointCode)
            ->setName($name)
            ->setPrimaryIndicator($primaryIndicator)
            ->setToFrom($toFrom)
            ->setApproximateDistanceInd($approximateDistanceInd)
            ->setDirection($direction)
            ->setDistance($distance)
            ->setDistanceUnitName($distanceUnitName)
            ->setUnitOfMeasureCode($unitOfMeasureCode);
    }
    /**
     * Get Nearest value
     * @return bool|null
     */
    public function getNearest()
    {
        return $this->Nearest;
    }
    /**
     * Set Nearest value
     * @param bool $nearest
     * @return \StructType\RelativePositionType
     */
    public function setNearest($nearest = null)
    {
        // validation for constraint: boolean
        if (!is_null($nearest) && !is_bool($nearest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($nearest, true), gettype($nearest)), __LINE__);
        }
        $this->Nearest = $nearest;
        return $this;
    }
    /**
     * Get IndexPointCode value
     * @return string|null
     */
    public function getIndexPointCode()
    {
        return $this->IndexPointCode;
    }
    /**
     * Set IndexPointCode value
     * @param string $indexPointCode
     * @return \StructType\RelativePositionType
     */
    public function setIndexPointCode($indexPointCode = null)
    {
        // validation for constraint: string
        if (!is_null($indexPointCode) && !is_string($indexPointCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($indexPointCode, true), gettype($indexPointCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($indexPointCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $indexPointCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($indexPointCode, true)), __LINE__);
        }
        $this->IndexPointCode = $indexPointCode;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\RelativePositionType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($name) && mb_strlen($name) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($name)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($name) && mb_strlen($name) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get PrimaryIndicator value
     * @return bool|null
     */
    public function getPrimaryIndicator()
    {
        return $this->PrimaryIndicator;
    }
    /**
     * Set PrimaryIndicator value
     * @param bool $primaryIndicator
     * @return \StructType\RelativePositionType
     */
    public function setPrimaryIndicator($primaryIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($primaryIndicator) && !is_bool($primaryIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($primaryIndicator, true), gettype($primaryIndicator)), __LINE__);
        }
        $this->PrimaryIndicator = $primaryIndicator;
        return $this;
    }
    /**
     * Get ToFrom value
     * @return string|null
     */
    public function getToFrom()
    {
        return $this->ToFrom;
    }
    /**
     * Set ToFrom value
     * @param string $toFrom
     * @return \StructType\RelativePositionType
     */
    public function setToFrom($toFrom = null)
    {
        // validation for constraint: string
        if (!is_null($toFrom) && !is_string($toFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toFrom, true), gettype($toFrom)), __LINE__);
        }
        $this->ToFrom = $toFrom;
        return $this;
    }
    /**
     * Get ApproximateDistanceInd value
     * @return bool|null
     */
    public function getApproximateDistanceInd()
    {
        return $this->ApproximateDistanceInd;
    }
    /**
     * Set ApproximateDistanceInd value
     * @param bool $approximateDistanceInd
     * @return \StructType\RelativePositionType
     */
    public function setApproximateDistanceInd($approximateDistanceInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($approximateDistanceInd) && !is_bool($approximateDistanceInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($approximateDistanceInd, true), gettype($approximateDistanceInd)), __LINE__);
        }
        $this->ApproximateDistanceInd = $approximateDistanceInd;
        return $this;
    }
    /**
     * Get Direction value
     * @return string|null
     */
    public function getDirection()
    {
        return $this->Direction;
    }
    /**
     * Set Direction value
     * @param string $direction
     * @return \StructType\RelativePositionType
     */
    public function setDirection($direction = null)
    {
        // validation for constraint: string
        if (!is_null($direction) && !is_string($direction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($direction, true), gettype($direction)), __LINE__);
        }
        $this->Direction = $direction;
        return $this;
    }
    /**
     * Get Distance value
     * @return string|null
     */
    public function getDistance()
    {
        return $this->Distance;
    }
    /**
     * Set Distance value
     * @param string $distance
     * @return \StructType\RelativePositionType
     */
    public function setDistance($distance = null)
    {
        // validation for constraint: string
        if (!is_null($distance) && !is_string($distance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($distance, true), gettype($distance)), __LINE__);
        }
        $this->Distance = $distance;
        return $this;
    }
    /**
     * Get DistanceUnitName value
     * @return string|null
     */
    public function getDistanceUnitName()
    {
        return $this->DistanceUnitName;
    }
    /**
     * Set DistanceUnitName value
     * @uses \EnumType\DistanceUnitNameType::valueIsValid()
     * @uses \EnumType\DistanceUnitNameType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $distanceUnitName
     * @return \StructType\RelativePositionType
     */
    public function setDistanceUnitName($distanceUnitName = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DistanceUnitNameType::valueIsValid($distanceUnitName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DistanceUnitNameType', is_array($distanceUnitName) ? implode(', ', $distanceUnitName) : var_export($distanceUnitName, true), implode(', ', \EnumType\DistanceUnitNameType::getValidValues())), __LINE__);
        }
        $this->DistanceUnitName = $distanceUnitName;
        return $this;
    }
    /**
     * Get UnitOfMeasureCode value
     * @return string|null
     */
    public function getUnitOfMeasureCode()
    {
        return $this->UnitOfMeasureCode;
    }
    /**
     * Set UnitOfMeasureCode value
     * @param string $unitOfMeasureCode
     * @return \StructType\RelativePositionType
     */
    public function setUnitOfMeasureCode($unitOfMeasureCode = null)
    {
        // validation for constraint: string
        if (!is_null($unitOfMeasureCode) && !is_string($unitOfMeasureCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitOfMeasureCode, true), gettype($unitOfMeasureCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($unitOfMeasureCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $unitOfMeasureCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($unitOfMeasureCode, true)), __LINE__);
        }
        $this->UnitOfMeasureCode = $unitOfMeasureCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RelativePositionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
