<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RateRestrictions StructType
 * Meta information extracted from the WSDL
 * - documentation: Information on restrictions that may be associated with this rate. Additional details on rate restrictions may be found in OTA_VehRateRulesRS.xsd.
 * @subpackage Structs
 */
class RateRestrictions extends AbstractStructBase
{
    /**
     * The ArriveByFlight
     * Meta information extracted from the WSDL
     * - documentation: false | Indicates if this rate is only available to those customers who are flying to the vehicle rental location.
     * - use: optional
     * @var bool
     */
    public $ArriveByFlight;
    /**
     * The MinimumDayInd
     * Meta information extracted from the WSDL
     * - documentation: When true, there is a minimum day requirement.
     * - use: optional
     * @var bool
     */
    public $MinimumDayInd;
    /**
     * The MaximumDayInd
     * Meta information extracted from the WSDL
     * - documentation: When true, there is a maximum day requirement restriction.
     * - use: optional
     * @var bool
     */
    public $MaximumDayInd;
    /**
     * The AdvancedBookingInd
     * Meta information extracted from the WSDL
     * - documentation: When true, this rate requires advanced booking.
     * - use: optional
     * @var bool
     */
    public $AdvancedBookingInd;
    /**
     * The RestrictedMileageInd
     * Meta information extracted from the WSDL
     * - documentation: When true, the mileage is restricted.
     * - use: optional
     * @var bool
     */
    public $RestrictedMileageInd;
    /**
     * The CorporateRateInd
     * Meta information extracted from the WSDL
     * - documentation: When true, this is a negotiated corporate rate.
     * - use: optional
     * @var bool
     */
    public $CorporateRateInd;
    /**
     * The GuaranteeReqInd
     * Meta information extracted from the WSDL
     * - documentation: When true, a guarantee is required.
     * - use: optional
     * @var bool
     */
    public $GuaranteeReqInd;
    /**
     * The MaximumVehiclesAllowed
     * Meta information extracted from the WSDL
     * - documentation: The maximum number of vehicles that can be rented at this rate. | Used for Numeric values, from 1 to 999 inclusive.
     * - base: xs:integer
     * - maxInclusive: 999
     * - minInclusive: 1
     * - use: optional
     * @var int
     */
    public $MaximumVehiclesAllowed;
    /**
     * The OvernightInd
     * Meta information extracted from the WSDL
     * - documentation: When true, an overnight rental is required.
     * - use: optional
     * @var bool
     */
    public $OvernightInd;
    /**
     * The OneWayPolicy
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $OneWayPolicy;
    /**
     * The CancellationPenaltyInd
     * Meta information extracted from the WSDL
     * - documentation: When true indicates a fee applies if a cancellation is requested.
     * - use: optional
     * @var bool
     */
    public $CancellationPenaltyInd;
    /**
     * The ModificationPenaltyInd
     * Meta information extracted from the WSDL
     * - documentation: When true indicates a fee applies if a modification is requested.
     * - use: optional
     * @var bool
     */
    public $ModificationPenaltyInd;
    /**
     * The MinimumAge
     * Meta information extracted from the WSDL
     * - documentation: The minimum age for a driver to rent this vehicle at this rate. | Used for Numeric values, from 1 to 99 inclusive.
     * - base: xs:integer
     * - maxInclusive: 99
     * - minInclusive: 1
     * @var int
     */
    public $MinimumAge;
    /**
     * Constructor method for RateRestrictions
     * @uses RateRestrictions::setArriveByFlight()
     * @uses RateRestrictions::setMinimumDayInd()
     * @uses RateRestrictions::setMaximumDayInd()
     * @uses RateRestrictions::setAdvancedBookingInd()
     * @uses RateRestrictions::setRestrictedMileageInd()
     * @uses RateRestrictions::setCorporateRateInd()
     * @uses RateRestrictions::setGuaranteeReqInd()
     * @uses RateRestrictions::setMaximumVehiclesAllowed()
     * @uses RateRestrictions::setOvernightInd()
     * @uses RateRestrictions::setOneWayPolicy()
     * @uses RateRestrictions::setCancellationPenaltyInd()
     * @uses RateRestrictions::setModificationPenaltyInd()
     * @uses RateRestrictions::setMinimumAge()
     * @param bool $arriveByFlight
     * @param bool $minimumDayInd
     * @param bool $maximumDayInd
     * @param bool $advancedBookingInd
     * @param bool $restrictedMileageInd
     * @param bool $corporateRateInd
     * @param bool $guaranteeReqInd
     * @param int $maximumVehiclesAllowed
     * @param bool $overnightInd
     * @param string $oneWayPolicy
     * @param bool $cancellationPenaltyInd
     * @param bool $modificationPenaltyInd
     * @param int $minimumAge
     */
    public function __construct($arriveByFlight = null, $minimumDayInd = null, $maximumDayInd = null, $advancedBookingInd = null, $restrictedMileageInd = null, $corporateRateInd = null, $guaranteeReqInd = null, $maximumVehiclesAllowed = null, $overnightInd = null, $oneWayPolicy = null, $cancellationPenaltyInd = null, $modificationPenaltyInd = null, $minimumAge = null)
    {
        $this
            ->setArriveByFlight($arriveByFlight)
            ->setMinimumDayInd($minimumDayInd)
            ->setMaximumDayInd($maximumDayInd)
            ->setAdvancedBookingInd($advancedBookingInd)
            ->setRestrictedMileageInd($restrictedMileageInd)
            ->setCorporateRateInd($corporateRateInd)
            ->setGuaranteeReqInd($guaranteeReqInd)
            ->setMaximumVehiclesAllowed($maximumVehiclesAllowed)
            ->setOvernightInd($overnightInd)
            ->setOneWayPolicy($oneWayPolicy)
            ->setCancellationPenaltyInd($cancellationPenaltyInd)
            ->setModificationPenaltyInd($modificationPenaltyInd)
            ->setMinimumAge($minimumAge);
    }
    /**
     * Get ArriveByFlight value
     * @return bool|null
     */
    public function getArriveByFlight()
    {
        return $this->ArriveByFlight;
    }
    /**
     * Set ArriveByFlight value
     * @param bool $arriveByFlight
     * @return \StructType\RateRestrictions
     */
    public function setArriveByFlight($arriveByFlight = null)
    {
        // validation for constraint: boolean
        if (!is_null($arriveByFlight) && !is_bool($arriveByFlight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($arriveByFlight, true), gettype($arriveByFlight)), __LINE__);
        }
        $this->ArriveByFlight = $arriveByFlight;
        return $this;
    }
    /**
     * Get MinimumDayInd value
     * @return bool|null
     */
    public function getMinimumDayInd()
    {
        return $this->MinimumDayInd;
    }
    /**
     * Set MinimumDayInd value
     * @param bool $minimumDayInd
     * @return \StructType\RateRestrictions
     */
    public function setMinimumDayInd($minimumDayInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($minimumDayInd) && !is_bool($minimumDayInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($minimumDayInd, true), gettype($minimumDayInd)), __LINE__);
        }
        $this->MinimumDayInd = $minimumDayInd;
        return $this;
    }
    /**
     * Get MaximumDayInd value
     * @return bool|null
     */
    public function getMaximumDayInd()
    {
        return $this->MaximumDayInd;
    }
    /**
     * Set MaximumDayInd value
     * @param bool $maximumDayInd
     * @return \StructType\RateRestrictions
     */
    public function setMaximumDayInd($maximumDayInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($maximumDayInd) && !is_bool($maximumDayInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($maximumDayInd, true), gettype($maximumDayInd)), __LINE__);
        }
        $this->MaximumDayInd = $maximumDayInd;
        return $this;
    }
    /**
     * Get AdvancedBookingInd value
     * @return bool|null
     */
    public function getAdvancedBookingInd()
    {
        return $this->AdvancedBookingInd;
    }
    /**
     * Set AdvancedBookingInd value
     * @param bool $advancedBookingInd
     * @return \StructType\RateRestrictions
     */
    public function setAdvancedBookingInd($advancedBookingInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($advancedBookingInd) && !is_bool($advancedBookingInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($advancedBookingInd, true), gettype($advancedBookingInd)), __LINE__);
        }
        $this->AdvancedBookingInd = $advancedBookingInd;
        return $this;
    }
    /**
     * Get RestrictedMileageInd value
     * @return bool|null
     */
    public function getRestrictedMileageInd()
    {
        return $this->RestrictedMileageInd;
    }
    /**
     * Set RestrictedMileageInd value
     * @param bool $restrictedMileageInd
     * @return \StructType\RateRestrictions
     */
    public function setRestrictedMileageInd($restrictedMileageInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($restrictedMileageInd) && !is_bool($restrictedMileageInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($restrictedMileageInd, true), gettype($restrictedMileageInd)), __LINE__);
        }
        $this->RestrictedMileageInd = $restrictedMileageInd;
        return $this;
    }
    /**
     * Get CorporateRateInd value
     * @return bool|null
     */
    public function getCorporateRateInd()
    {
        return $this->CorporateRateInd;
    }
    /**
     * Set CorporateRateInd value
     * @param bool $corporateRateInd
     * @return \StructType\RateRestrictions
     */
    public function setCorporateRateInd($corporateRateInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($corporateRateInd) && !is_bool($corporateRateInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($corporateRateInd, true), gettype($corporateRateInd)), __LINE__);
        }
        $this->CorporateRateInd = $corporateRateInd;
        return $this;
    }
    /**
     * Get GuaranteeReqInd value
     * @return bool|null
     */
    public function getGuaranteeReqInd()
    {
        return $this->GuaranteeReqInd;
    }
    /**
     * Set GuaranteeReqInd value
     * @param bool $guaranteeReqInd
     * @return \StructType\RateRestrictions
     */
    public function setGuaranteeReqInd($guaranteeReqInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($guaranteeReqInd) && !is_bool($guaranteeReqInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($guaranteeReqInd, true), gettype($guaranteeReqInd)), __LINE__);
        }
        $this->GuaranteeReqInd = $guaranteeReqInd;
        return $this;
    }
    /**
     * Get MaximumVehiclesAllowed value
     * @return int|null
     */
    public function getMaximumVehiclesAllowed()
    {
        return $this->MaximumVehiclesAllowed;
    }
    /**
     * Set MaximumVehiclesAllowed value
     * @param int $maximumVehiclesAllowed
     * @return \StructType\RateRestrictions
     */
    public function setMaximumVehiclesAllowed($maximumVehiclesAllowed = null)
    {
        // validation for constraint: int
        if (!is_null($maximumVehiclesAllowed) && !(is_int($maximumVehiclesAllowed) || ctype_digit($maximumVehiclesAllowed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maximumVehiclesAllowed, true), gettype($maximumVehiclesAllowed)), __LINE__);
        }
        // validation for constraint: maxInclusive(999)
        if (!is_null($maximumVehiclesAllowed) && $maximumVehiclesAllowed > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999', var_export($maximumVehiclesAllowed, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($maximumVehiclesAllowed) && $maximumVehiclesAllowed < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($maximumVehiclesAllowed, true)), __LINE__);
        }
        $this->MaximumVehiclesAllowed = $maximumVehiclesAllowed;
        return $this;
    }
    /**
     * Get OvernightInd value
     * @return bool|null
     */
    public function getOvernightInd()
    {
        return $this->OvernightInd;
    }
    /**
     * Set OvernightInd value
     * @param bool $overnightInd
     * @return \StructType\RateRestrictions
     */
    public function setOvernightInd($overnightInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($overnightInd) && !is_bool($overnightInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($overnightInd, true), gettype($overnightInd)), __LINE__);
        }
        $this->OvernightInd = $overnightInd;
        return $this;
    }
    /**
     * Get OneWayPolicy value
     * @return string|null
     */
    public function getOneWayPolicy()
    {
        return $this->OneWayPolicy;
    }
    /**
     * Set OneWayPolicy value
     * @param string $oneWayPolicy
     * @return \StructType\RateRestrictions
     */
    public function setOneWayPolicy($oneWayPolicy = null)
    {
        // validation for constraint: string
        if (!is_null($oneWayPolicy) && !is_string($oneWayPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oneWayPolicy, true), gettype($oneWayPolicy)), __LINE__);
        }
        $this->OneWayPolicy = $oneWayPolicy;
        return $this;
    }
    /**
     * Get CancellationPenaltyInd value
     * @return bool|null
     */
    public function getCancellationPenaltyInd()
    {
        return $this->CancellationPenaltyInd;
    }
    /**
     * Set CancellationPenaltyInd value
     * @param bool $cancellationPenaltyInd
     * @return \StructType\RateRestrictions
     */
    public function setCancellationPenaltyInd($cancellationPenaltyInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($cancellationPenaltyInd) && !is_bool($cancellationPenaltyInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cancellationPenaltyInd, true), gettype($cancellationPenaltyInd)), __LINE__);
        }
        $this->CancellationPenaltyInd = $cancellationPenaltyInd;
        return $this;
    }
    /**
     * Get ModificationPenaltyInd value
     * @return bool|null
     */
    public function getModificationPenaltyInd()
    {
        return $this->ModificationPenaltyInd;
    }
    /**
     * Set ModificationPenaltyInd value
     * @param bool $modificationPenaltyInd
     * @return \StructType\RateRestrictions
     */
    public function setModificationPenaltyInd($modificationPenaltyInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($modificationPenaltyInd) && !is_bool($modificationPenaltyInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($modificationPenaltyInd, true), gettype($modificationPenaltyInd)), __LINE__);
        }
        $this->ModificationPenaltyInd = $modificationPenaltyInd;
        return $this;
    }
    /**
     * Get MinimumAge value
     * @return int|null
     */
    public function getMinimumAge()
    {
        return $this->MinimumAge;
    }
    /**
     * Set MinimumAge value
     * @param int $minimumAge
     * @return \StructType\RateRestrictions
     */
    public function setMinimumAge($minimumAge = null)
    {
        // validation for constraint: int
        if (!is_null($minimumAge) && !(is_int($minimumAge) || ctype_digit($minimumAge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minimumAge, true), gettype($minimumAge)), __LINE__);
        }
        // validation for constraint: maxInclusive(99)
        if (!is_null($minimumAge) && $minimumAge > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99', var_export($minimumAge, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($minimumAge) && $minimumAge < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($minimumAge, true)), __LINE__);
        }
        $this->MinimumAge = $minimumAge;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RateRestrictions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
