<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RateRange StructType
 * Meta information extracted from the WSDL
 * - documentation: The minimum and maximum amounts a customer is willing to pay. | Used to provide the minimum and maximum range of rates at this hotel property. | Requested rate or rate range. Repeats to allow the identification of multiple ranges for
 * multiple room stay candidates. | Requested rate or rate range. Repeats to allow the identification of multiple ranges for multiple room stay candidates. *This element is maintained at this level to support those who have implemented this message
 * prior to 2005B. For new implementations consider using this element under HotelSearchCriteria.**
 * @subpackage Structs
 */
class RateRange extends AbstractStructBase
{
    /**
     * The MinRate
     * Meta information extracted from the WSDL
     * - documentation: Specifies an amount, max 3 decimals.
     * - base: xs:decimal
     * - fractionDigits: 3
     * @var float
     */
    public $MinRate;
    /**
     * The MaxRate
     * Meta information extracted from the WSDL
     * - documentation: Specifies an amount, max 3 decimals.
     * - base: xs:decimal
     * - fractionDigits: 3
     * @var float
     */
    public $MaxRate;
    /**
     * The FixedRate
     * Meta information extracted from the WSDL
     * - documentation: Specifies an amount, max 3 decimals.
     * - base: xs:decimal
     * - fractionDigits: 3
     * @var float
     */
    public $FixedRate;
    /**
     * The RateTimeUnit
     * @var string
     */
    public $RateTimeUnit;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - documentation: Used for an Alpha String, length exactly 3.
     * - base: xs:string
     * - pattern: [a-zA-Z]{3}
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DecimalPlaces
     * @var int
     */
    public $DecimalPlaces;
    /**
     * The RoomStayCandidateRPH
     * Meta information extracted from the WSDL
     * - documentation: Used to associate a rate range with a room stay candidate. | The Reference Place Holder (RPH) is an index code used to identify an instance in a collection of like items (e.g. used to assign individual passengers or clients to
     * particular itinerary items).
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string
     */
    public $RoomStayCandidateRPH;
    /**
     * The RateMode
     * Meta information extracted from the WSDL
     * - documentation: This supports returning a type of rate (minimum, maximum, etc.) as an alternative to returning a specific rate. Refer to OpenTravel Code List Rate Mode (RMO). | Used for codes in the OpenTravel Code tables. Possible values of this
     * pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string
     */
    public $RateMode;
    /**
     * The InfoSource
     * Meta information extracted from the WSDL
     * - documentation: Used to provide the source of the rate range. | Used to specify the source of the data being exchanged.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $InfoSource;
    /**
     * The TaxRate
     * Meta information extracted from the WSDL
     * - documentation: The tax rate at this property. | Used for percentage values.
     * - base: xs:decimal
     * - maxInclusive: 100.00
     * - minInclusive: 0.00
     * - type: Percentage
     * - use: optional
     * @var float
     */
    public $TaxRate;
    /**
     * The RateInfoNotAvailableInd
     * Meta information extracted from the WSDL
     * - documentation: When true, rate information is not available.
     * - use: optional
     * @var bool
     */
    public $RateInfoNotAvailableInd;
    /**
     * Constructor method for RateRange
     * @uses RateRange::setMinRate()
     * @uses RateRange::setMaxRate()
     * @uses RateRange::setFixedRate()
     * @uses RateRange::setRateTimeUnit()
     * @uses RateRange::setCurrencyCode()
     * @uses RateRange::setDecimalPlaces()
     * @uses RateRange::setRoomStayCandidateRPH()
     * @uses RateRange::setRateMode()
     * @uses RateRange::setInfoSource()
     * @uses RateRange::setTaxRate()
     * @uses RateRange::setRateInfoNotAvailableInd()
     * @param float $minRate
     * @param float $maxRate
     * @param float $fixedRate
     * @param string $rateTimeUnit
     * @param string $currencyCode
     * @param int $decimalPlaces
     * @param string $roomStayCandidateRPH
     * @param string $rateMode
     * @param string $infoSource
     * @param float $taxRate
     * @param bool $rateInfoNotAvailableInd
     */
    public function __construct($minRate = null, $maxRate = null, $fixedRate = null, $rateTimeUnit = null, $currencyCode = null, $decimalPlaces = null, $roomStayCandidateRPH = null, $rateMode = null, $infoSource = null, $taxRate = null, $rateInfoNotAvailableInd = null)
    {
        $this
            ->setMinRate($minRate)
            ->setMaxRate($maxRate)
            ->setFixedRate($fixedRate)
            ->setRateTimeUnit($rateTimeUnit)
            ->setCurrencyCode($currencyCode)
            ->setDecimalPlaces($decimalPlaces)
            ->setRoomStayCandidateRPH($roomStayCandidateRPH)
            ->setRateMode($rateMode)
            ->setInfoSource($infoSource)
            ->setTaxRate($taxRate)
            ->setRateInfoNotAvailableInd($rateInfoNotAvailableInd);
    }
    /**
     * Get MinRate value
     * @return float|null
     */
    public function getMinRate()
    {
        return $this->MinRate;
    }
    /**
     * Set MinRate value
     * @param float $minRate
     * @return \StructType\RateRange
     */
    public function setMinRate($minRate = null)
    {
        // validation for constraint: float
        if (!is_null($minRate) && !(is_float($minRate) || is_numeric($minRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minRate, true), gettype($minRate)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($minRate) && mb_strlen(mb_substr($minRate, mb_strpos($minRate, '.') + 1)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($minRate, true), mb_strlen(mb_substr($minRate, mb_strpos($minRate, '.') + 1))), __LINE__);
        }
        $this->MinRate = $minRate;
        return $this;
    }
    /**
     * Get MaxRate value
     * @return float|null
     */
    public function getMaxRate()
    {
        return $this->MaxRate;
    }
    /**
     * Set MaxRate value
     * @param float $maxRate
     * @return \StructType\RateRange
     */
    public function setMaxRate($maxRate = null)
    {
        // validation for constraint: float
        if (!is_null($maxRate) && !(is_float($maxRate) || is_numeric($maxRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxRate, true), gettype($maxRate)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($maxRate) && mb_strlen(mb_substr($maxRate, mb_strpos($maxRate, '.') + 1)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($maxRate, true), mb_strlen(mb_substr($maxRate, mb_strpos($maxRate, '.') + 1))), __LINE__);
        }
        $this->MaxRate = $maxRate;
        return $this;
    }
    /**
     * Get FixedRate value
     * @return float|null
     */
    public function getFixedRate()
    {
        return $this->FixedRate;
    }
    /**
     * Set FixedRate value
     * @param float $fixedRate
     * @return \StructType\RateRange
     */
    public function setFixedRate($fixedRate = null)
    {
        // validation for constraint: float
        if (!is_null($fixedRate) && !(is_float($fixedRate) || is_numeric($fixedRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fixedRate, true), gettype($fixedRate)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($fixedRate) && mb_strlen(mb_substr($fixedRate, mb_strpos($fixedRate, '.') + 1)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($fixedRate, true), mb_strlen(mb_substr($fixedRate, mb_strpos($fixedRate, '.') + 1))), __LINE__);
        }
        $this->FixedRate = $fixedRate;
        return $this;
    }
    /**
     * Get RateTimeUnit value
     * @return string|null
     */
    public function getRateTimeUnit()
    {
        return $this->RateTimeUnit;
    }
    /**
     * Set RateTimeUnit value
     * @uses \EnumType\TimeUnitType::valueIsValid()
     * @uses \EnumType\TimeUnitType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rateTimeUnit
     * @return \StructType\RateRange
     */
    public function setRateTimeUnit($rateTimeUnit = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TimeUnitType::valueIsValid($rateTimeUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TimeUnitType', is_array($rateTimeUnit) ? implode(', ', $rateTimeUnit) : var_export($rateTimeUnit, true), implode(', ', \EnumType\TimeUnitType::getValidValues())), __LINE__);
        }
        $this->RateTimeUnit = $rateTimeUnit;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\RateRange
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z]{3})
        if (!is_null($currencyCode) && !preg_match('/[a-zA-Z]{3}/', $currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z]{3}', var_export($currencyCode, true)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get DecimalPlaces value
     * @return int|null
     */
    public function getDecimalPlaces()
    {
        return $this->DecimalPlaces;
    }
    /**
     * Set DecimalPlaces value
     * @param int $decimalPlaces
     * @return \StructType\RateRange
     */
    public function setDecimalPlaces($decimalPlaces = null)
    {
        // validation for constraint: int
        if (!is_null($decimalPlaces) && !(is_int($decimalPlaces) || ctype_digit($decimalPlaces))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($decimalPlaces, true), gettype($decimalPlaces)), __LINE__);
        }
        $this->DecimalPlaces = $decimalPlaces;
        return $this;
    }
    /**
     * Get RoomStayCandidateRPH value
     * @return string|null
     */
    public function getRoomStayCandidateRPH()
    {
        return $this->RoomStayCandidateRPH;
    }
    /**
     * Set RoomStayCandidateRPH value
     * @param string $roomStayCandidateRPH
     * @return \StructType\RateRange
     */
    public function setRoomStayCandidateRPH($roomStayCandidateRPH = null)
    {
        // validation for constraint: string
        if (!is_null($roomStayCandidateRPH) && !is_string($roomStayCandidateRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomStayCandidateRPH, true), gettype($roomStayCandidateRPH)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($roomStayCandidateRPH) && !preg_match('/[0-9]{1,8}/', $roomStayCandidateRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($roomStayCandidateRPH, true)), __LINE__);
        }
        $this->RoomStayCandidateRPH = $roomStayCandidateRPH;
        return $this;
    }
    /**
     * Get RateMode value
     * @return string|null
     */
    public function getRateMode()
    {
        return $this->RateMode;
    }
    /**
     * Set RateMode value
     * @param string $rateMode
     * @return \StructType\RateRange
     */
    public function setRateMode($rateMode = null)
    {
        // validation for constraint: string
        if (!is_null($rateMode) && !is_string($rateMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rateMode, true), gettype($rateMode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($rateMode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $rateMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($rateMode, true)), __LINE__);
        }
        $this->RateMode = $rateMode;
        return $this;
    }
    /**
     * Get InfoSource value
     * @return string|null
     */
    public function getInfoSource()
    {
        return $this->InfoSource;
    }
    /**
     * Set InfoSource value
     * @param string $infoSource
     * @return \StructType\RateRange
     */
    public function setInfoSource($infoSource = null)
    {
        // validation for constraint: string
        if (!is_null($infoSource) && !is_string($infoSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($infoSource, true), gettype($infoSource)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($infoSource) && mb_strlen($infoSource) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($infoSource)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($infoSource) && mb_strlen($infoSource) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($infoSource)), __LINE__);
        }
        $this->InfoSource = $infoSource;
        return $this;
    }
    /**
     * Get TaxRate value
     * @return float|null
     */
    public function getTaxRate()
    {
        return $this->TaxRate;
    }
    /**
     * Set TaxRate value
     * @param float $taxRate
     * @return \StructType\RateRange
     */
    public function setTaxRate($taxRate = null)
    {
        // validation for constraint: float
        if (!is_null($taxRate) && !(is_float($taxRate) || is_numeric($taxRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxRate, true), gettype($taxRate)), __LINE__);
        }
        // validation for constraint: maxInclusive(100.00)
        if (!is_null($taxRate) && $taxRate > 100.00) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 100.00', var_export($taxRate, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.00)
        if (!is_null($taxRate) && $taxRate < 0.00) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.00', var_export($taxRate, true)), __LINE__);
        }
        $this->TaxRate = $taxRate;
        return $this;
    }
    /**
     * Get RateInfoNotAvailableInd value
     * @return bool|null
     */
    public function getRateInfoNotAvailableInd()
    {
        return $this->RateInfoNotAvailableInd;
    }
    /**
     * Set RateInfoNotAvailableInd value
     * @param bool $rateInfoNotAvailableInd
     * @return \StructType\RateRange
     */
    public function setRateInfoNotAvailableInd($rateInfoNotAvailableInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($rateInfoNotAvailableInd) && !is_bool($rateInfoNotAvailableInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($rateInfoNotAvailableInd, true), gettype($rateInfoNotAvailableInd)), __LINE__);
        }
        $this->RateInfoNotAvailableInd = $rateInfoNotAvailableInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RateRange
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
