<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RatePlanType StructType
 * Meta information extracted from the WSDL
 * - documentation: Information significant to defining a rate plan. | Policies and descriptions that apply to a rate plan. | Defines the details of the rate plan as used in the booking process.
 * - type: OTA_CodeType
 * - use: optional
 * @subpackage Structs
 */
class RatePlanType extends AbstractStructBase
{
    /**
     * The Guarantee
     * Meta information extracted from the WSDL
     * - documentation: Guarantee information that applies to the rate plan. A maximum of 5 occurances are available for use depending on the context.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\GuaranteeType[]
     */
    public $Guarantee;
    /**
     * The CancelPenalties
     * Meta information extracted from the WSDL
     * - documentation: Collection of cancellation penalties.
     * - minOccurs: 0
     * @var \StructType\CancelPenaltiesType
     */
    public $CancelPenalties;
    /**
     * The RatePlanDescription
     * Meta information extracted from the WSDL
     * - documentation: Describes the rate plan.
     * - minOccurs: 0
     * @var \StructType\ParagraphType
     */
    public $RatePlanDescription;
    /**
     * The RatePlanInclusions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RatePlanInclusions
     */
    public $RatePlanInclusions;
    /**
     * The Commission
     * Meta information extracted from the WSDL
     * - documentation: Commission associated with the RatePlan. This can be a percentage or a flat amount.
     * - minOccurs: 0
     * @var \StructType\CommissionType
     */
    public $Commission;
    /**
     * The MealsIncluded
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MealsIncluded
     */
    public $MealsIncluded;
    /**
     * The RestrictionStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RestrictionStatus
     */
    public $RestrictionStatus;
    /**
     * The AdditionalDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AdditionalDetailsType
     */
    public $AdditionalDetails;
    /**
     * The BookingCode
     * Meta information extracted from the WSDL
     * - documentation: This is used to indicate the item booked and is primarily used to exchange information with GDSs. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $BookingCode;
    /**
     * The RatePlanCode
     * Meta information extracted from the WSDL
     * - documentation: The RatePlanCode assigned by the receiving system for the inventory item in response to a new rate plan notification. (Implementation Notes: This would only be returned when the notification is of type New and the sender is
     * translating RatePlanCode values. On subsequent transactions for this rate plan, the sender would populate the RatePlanCode attribute with this value returned by the receiver.) | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $RatePlanCode;
    /**
     * The RateIndicator
     * Meta information extracted from the WSDL
     * - documentation: Information pertaining to the availability of the rate plan.
     * - use: optional
     * @var string
     */
    public $RateIndicator;
    /**
     * The RatePlanType
     * Meta information extracted from the WSDL
     * - documentation: An enumerated type that allows the query to specify a rate category type, and provides major categories for comparison across brands. Refer to OpenTravel Code List Rate Plan Type (RPT). | Used for codes in the OpenTravel Code tables.
     * Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string
     */
    public $RatePlanType;
    /**
     * The RatePlanID
     * Meta information extracted from the WSDL
     * - documentation: A text field used to provide a special ID code that is associated with the rate and is required in the reservation request in order to obtain the rate. Examples are a corporate ID number, a promotion code or a membership number. |
     * Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $RatePlanID;
    /**
     * The RatePlanName
     * Meta information extracted from the WSDL
     * - documentation: Provides the name of the rate plan or group. Typically used with RatePlanType to further describe the rate plan. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $RatePlanName;
    /**
     * The MarketCode
     * Meta information extracted from the WSDL
     * - documentation: The code that relates to the market being sold to (e.g., the corporate market, packages). | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $MarketCode;
    /**
     * The AvailabilityStatus
     * Meta information extracted from the WSDL
     * - documentation: Used to specify an availability status for the rate plan.
     * - use: optional
     * @var string
     */
    public $AvailabilityStatus;
    /**
     * The ID_RequiredInd
     * Meta information extracted from the WSDL
     * - documentation: When true, indicates proof of qualification for this rate is required.
     * - use: optional
     * @var bool
     */
    public $ID_RequiredInd;
    /**
     * The PriceViewableInd
     * Meta information extracted from the WSDL
     * - documentation: When true, the price for this rate plan can be viewed by the guest. When false, the guest must contact another entity to obtain price information.
     * - use: optional
     * @var bool
     */
    public $PriceViewableInd;
    /**
     * The QualificationType
     * Meta information extracted from the WSDL
     * - documentation: Indicates the type of document required by the guest to qualify for this rate plan. Refer to OpenTravel Code List Document Type (DOC). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101,
     * 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string
     */
    public $QualificationType;
    /**
     * The AvailableQuantity
     * Meta information extracted from the WSDL
     * - documentation: Provides the number of rooms available within this rate plan.
     * - use: optional
     * @var int
     */
    public $AvailableQuantity;
    /**
     * The PrepaidIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, indicates if the rate is a prepaid rate.
     * - use: optional
     * @var bool
     */
    public $PrepaidIndicator;
    /**
     * The EffectiveDate
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * @var string
     */
    public $ExpireDate;
    /**
     * The ExpireDateExclusiveIndicator
     * @var bool
     */
    public $ExpireDateExclusiveIndicator;
    /**
     * Constructor method for RatePlanType
     * @uses RatePlanType::setGuarantee()
     * @uses RatePlanType::setCancelPenalties()
     * @uses RatePlanType::setRatePlanDescription()
     * @uses RatePlanType::setRatePlanInclusions()
     * @uses RatePlanType::setCommission()
     * @uses RatePlanType::setMealsIncluded()
     * @uses RatePlanType::setRestrictionStatus()
     * @uses RatePlanType::setAdditionalDetails()
     * @uses RatePlanType::setBookingCode()
     * @uses RatePlanType::setRatePlanCode()
     * @uses RatePlanType::setRateIndicator()
     * @uses RatePlanType::setRatePlanType()
     * @uses RatePlanType::setRatePlanID()
     * @uses RatePlanType::setRatePlanName()
     * @uses RatePlanType::setMarketCode()
     * @uses RatePlanType::setAvailabilityStatus()
     * @uses RatePlanType::setID_RequiredInd()
     * @uses RatePlanType::setPriceViewableInd()
     * @uses RatePlanType::setQualificationType()
     * @uses RatePlanType::setAvailableQuantity()
     * @uses RatePlanType::setPrepaidIndicator()
     * @uses RatePlanType::setEffectiveDate()
     * @uses RatePlanType::setExpireDate()
     * @uses RatePlanType::setExpireDateExclusiveIndicator()
     * @param \StructType\GuaranteeType[] $guarantee
     * @param \StructType\CancelPenaltiesType $cancelPenalties
     * @param \StructType\ParagraphType $ratePlanDescription
     * @param \StructType\RatePlanInclusions $ratePlanInclusions
     * @param \StructType\CommissionType $commission
     * @param \StructType\MealsIncluded $mealsIncluded
     * @param \StructType\RestrictionStatus $restrictionStatus
     * @param \StructType\AdditionalDetailsType $additionalDetails
     * @param string $bookingCode
     * @param string $ratePlanCode
     * @param string $rateIndicator
     * @param string $ratePlanType
     * @param string $ratePlanID
     * @param string $ratePlanName
     * @param string $marketCode
     * @param string $availabilityStatus
     * @param bool $iD_RequiredInd
     * @param bool $priceViewableInd
     * @param string $qualificationType
     * @param int $availableQuantity
     * @param bool $prepaidIndicator
     * @param string $effectiveDate
     * @param string $expireDate
     * @param bool $expireDateExclusiveIndicator
     */
    public function __construct(array $guarantee = array(), \StructType\CancelPenaltiesType $cancelPenalties = null, \StructType\ParagraphType $ratePlanDescription = null, \StructType\RatePlanInclusions $ratePlanInclusions = null, \StructType\CommissionType $commission = null, \StructType\MealsIncluded $mealsIncluded = null, \StructType\RestrictionStatus $restrictionStatus = null, \StructType\AdditionalDetailsType $additionalDetails = null, $bookingCode = null, $ratePlanCode = null, $rateIndicator = null, $ratePlanType = null, $ratePlanID = null, $ratePlanName = null, $marketCode = null, $availabilityStatus = null, $iD_RequiredInd = null, $priceViewableInd = null, $qualificationType = null, $availableQuantity = null, $prepaidIndicator = null, $effectiveDate = null, $expireDate = null, $expireDateExclusiveIndicator = null)
    {
        $this
            ->setGuarantee($guarantee)
            ->setCancelPenalties($cancelPenalties)
            ->setRatePlanDescription($ratePlanDescription)
            ->setRatePlanInclusions($ratePlanInclusions)
            ->setCommission($commission)
            ->setMealsIncluded($mealsIncluded)
            ->setRestrictionStatus($restrictionStatus)
            ->setAdditionalDetails($additionalDetails)
            ->setBookingCode($bookingCode)
            ->setRatePlanCode($ratePlanCode)
            ->setRateIndicator($rateIndicator)
            ->setRatePlanType($ratePlanType)
            ->setRatePlanID($ratePlanID)
            ->setRatePlanName($ratePlanName)
            ->setMarketCode($marketCode)
            ->setAvailabilityStatus($availabilityStatus)
            ->setID_RequiredInd($iD_RequiredInd)
            ->setPriceViewableInd($priceViewableInd)
            ->setQualificationType($qualificationType)
            ->setAvailableQuantity($availableQuantity)
            ->setPrepaidIndicator($prepaidIndicator)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate)
            ->setExpireDateExclusiveIndicator($expireDateExclusiveIndicator);
    }
    /**
     * Get Guarantee value
     * @return \StructType\GuaranteeType[]|null
     */
    public function getGuarantee()
    {
        return $this->Guarantee;
    }
    /**
     * This method is responsible for validating the values passed to the setGuarantee method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGuarantee method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGuaranteeForArrayConstraintsFromSetGuarantee(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ratePlanTypeGuaranteeItem) {
            // validation for constraint: itemType
            if (!$ratePlanTypeGuaranteeItem instanceof \StructType\GuaranteeType) {
                $invalidValues[] = is_object($ratePlanTypeGuaranteeItem) ? get_class($ratePlanTypeGuaranteeItem) : sprintf('%s(%s)', gettype($ratePlanTypeGuaranteeItem), var_export($ratePlanTypeGuaranteeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Guarantee property can only contain items of type \StructType\GuaranteeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Guarantee value
     * @throws \InvalidArgumentException
     * @param \StructType\GuaranteeType[] $guarantee
     * @return \StructType\RatePlanType
     */
    public function setGuarantee(array $guarantee = array())
    {
        // validation for constraint: array
        if ('' !== ($guaranteeArrayErrorMessage = self::validateGuaranteeForArrayConstraintsFromSetGuarantee($guarantee))) {
            throw new \InvalidArgumentException($guaranteeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($guarantee) && count($guarantee) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($guarantee)), __LINE__);
        }
        $this->Guarantee = $guarantee;
        return $this;
    }
    /**
     * Add item to Guarantee value
     * @throws \InvalidArgumentException
     * @param \StructType\GuaranteeType $item
     * @return \StructType\RatePlanType
     */
    public function addToGuarantee(\StructType\GuaranteeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GuaranteeType) {
            throw new \InvalidArgumentException(sprintf('The Guarantee property can only contain items of type \StructType\GuaranteeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Guarantee) && count($this->Guarantee) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Guarantee)), __LINE__);
        }
        $this->Guarantee[] = $item;
        return $this;
    }
    /**
     * Get CancelPenalties value
     * @return \StructType\CancelPenaltiesType|null
     */
    public function getCancelPenalties()
    {
        return $this->CancelPenalties;
    }
    /**
     * Set CancelPenalties value
     * @param \StructType\CancelPenaltiesType $cancelPenalties
     * @return \StructType\RatePlanType
     */
    public function setCancelPenalties(\StructType\CancelPenaltiesType $cancelPenalties = null)
    {
        $this->CancelPenalties = $cancelPenalties;
        return $this;
    }
    /**
     * Get RatePlanDescription value
     * @return \StructType\ParagraphType|null
     */
    public function getRatePlanDescription()
    {
        return $this->RatePlanDescription;
    }
    /**
     * Set RatePlanDescription value
     * @param \StructType\ParagraphType $ratePlanDescription
     * @return \StructType\RatePlanType
     */
    public function setRatePlanDescription(\StructType\ParagraphType $ratePlanDescription = null)
    {
        $this->RatePlanDescription = $ratePlanDescription;
        return $this;
    }
    /**
     * Get RatePlanInclusions value
     * @return \StructType\RatePlanInclusions|null
     */
    public function getRatePlanInclusions()
    {
        return $this->RatePlanInclusions;
    }
    /**
     * Set RatePlanInclusions value
     * @param \StructType\RatePlanInclusions $ratePlanInclusions
     * @return \StructType\RatePlanType
     */
    public function setRatePlanInclusions(\StructType\RatePlanInclusions $ratePlanInclusions = null)
    {
        $this->RatePlanInclusions = $ratePlanInclusions;
        return $this;
    }
    /**
     * Get Commission value
     * @return \StructType\CommissionType|null
     */
    public function getCommission()
    {
        return $this->Commission;
    }
    /**
     * Set Commission value
     * @param \StructType\CommissionType $commission
     * @return \StructType\RatePlanType
     */
    public function setCommission(\StructType\CommissionType $commission = null)
    {
        $this->Commission = $commission;
        return $this;
    }
    /**
     * Get MealsIncluded value
     * @return \StructType\MealsIncluded|null
     */
    public function getMealsIncluded()
    {
        return $this->MealsIncluded;
    }
    /**
     * Set MealsIncluded value
     * @param \StructType\MealsIncluded $mealsIncluded
     * @return \StructType\RatePlanType
     */
    public function setMealsIncluded(\StructType\MealsIncluded $mealsIncluded = null)
    {
        $this->MealsIncluded = $mealsIncluded;
        return $this;
    }
    /**
     * Get RestrictionStatus value
     * @return \StructType\RestrictionStatus|null
     */
    public function getRestrictionStatus()
    {
        return $this->RestrictionStatus;
    }
    /**
     * Set RestrictionStatus value
     * @param \StructType\RestrictionStatus $restrictionStatus
     * @return \StructType\RatePlanType
     */
    public function setRestrictionStatus(\StructType\RestrictionStatus $restrictionStatus = null)
    {
        $this->RestrictionStatus = $restrictionStatus;
        return $this;
    }
    /**
     * Get AdditionalDetails value
     * @return \StructType\AdditionalDetailsType|null
     */
    public function getAdditionalDetails()
    {
        return $this->AdditionalDetails;
    }
    /**
     * Set AdditionalDetails value
     * @param \StructType\AdditionalDetailsType $additionalDetails
     * @return \StructType\RatePlanType
     */
    public function setAdditionalDetails(\StructType\AdditionalDetailsType $additionalDetails = null)
    {
        $this->AdditionalDetails = $additionalDetails;
        return $this;
    }
    /**
     * Get BookingCode value
     * @return string|null
     */
    public function getBookingCode()
    {
        return $this->BookingCode;
    }
    /**
     * Set BookingCode value
     * @param string $bookingCode
     * @return \StructType\RatePlanType
     */
    public function setBookingCode($bookingCode = null)
    {
        // validation for constraint: string
        if (!is_null($bookingCode) && !is_string($bookingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingCode, true), gettype($bookingCode)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($bookingCode) && mb_strlen($bookingCode) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($bookingCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($bookingCode) && mb_strlen($bookingCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($bookingCode)), __LINE__);
        }
        $this->BookingCode = $bookingCode;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\RatePlanType
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCode, true), gettype($ratePlanCode)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($ratePlanCode) && mb_strlen($ratePlanCode) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($ratePlanCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($ratePlanCode) && mb_strlen($ratePlanCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Get RateIndicator value
     * @return string|null
     */
    public function getRateIndicator()
    {
        return $this->RateIndicator;
    }
    /**
     * Set RateIndicator value
     * @uses \EnumType\RateIndicatorType::valueIsValid()
     * @uses \EnumType\RateIndicatorType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rateIndicator
     * @return \StructType\RatePlanType
     */
    public function setRateIndicator($rateIndicator = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RateIndicatorType::valueIsValid($rateIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RateIndicatorType', is_array($rateIndicator) ? implode(', ', $rateIndicator) : var_export($rateIndicator, true), implode(', ', \EnumType\RateIndicatorType::getValidValues())), __LINE__);
        }
        $this->RateIndicator = $rateIndicator;
        return $this;
    }
    /**
     * Get RatePlanType value
     * @return string|null
     */
    public function getRatePlanType()
    {
        return $this->RatePlanType;
    }
    /**
     * Set RatePlanType value
     * @param string $ratePlanType
     * @return \StructType\RatePlanType
     */
    public function setRatePlanType($ratePlanType = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanType) && !is_string($ratePlanType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanType, true), gettype($ratePlanType)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($ratePlanType) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $ratePlanType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($ratePlanType, true)), __LINE__);
        }
        $this->RatePlanType = $ratePlanType;
        return $this;
    }
    /**
     * Get RatePlanID value
     * @return string|null
     */
    public function getRatePlanID()
    {
        return $this->RatePlanID;
    }
    /**
     * Set RatePlanID value
     * @param string $ratePlanID
     * @return \StructType\RatePlanType
     */
    public function setRatePlanID($ratePlanID = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanID) && !is_string($ratePlanID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanID, true), gettype($ratePlanID)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ratePlanID) && mb_strlen($ratePlanID) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($ratePlanID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($ratePlanID) && mb_strlen($ratePlanID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($ratePlanID)), __LINE__);
        }
        $this->RatePlanID = $ratePlanID;
        return $this;
    }
    /**
     * Get RatePlanName value
     * @return string|null
     */
    public function getRatePlanName()
    {
        return $this->RatePlanName;
    }
    /**
     * Set RatePlanName value
     * @param string $ratePlanName
     * @return \StructType\RatePlanType
     */
    public function setRatePlanName($ratePlanName = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanName) && !is_string($ratePlanName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanName, true), gettype($ratePlanName)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ratePlanName) && mb_strlen($ratePlanName) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($ratePlanName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($ratePlanName) && mb_strlen($ratePlanName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($ratePlanName)), __LINE__);
        }
        $this->RatePlanName = $ratePlanName;
        return $this;
    }
    /**
     * Get MarketCode value
     * @return string|null
     */
    public function getMarketCode()
    {
        return $this->MarketCode;
    }
    /**
     * Set MarketCode value
     * @param string $marketCode
     * @return \StructType\RatePlanType
     */
    public function setMarketCode($marketCode = null)
    {
        // validation for constraint: string
        if (!is_null($marketCode) && !is_string($marketCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marketCode, true), gettype($marketCode)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($marketCode) && mb_strlen($marketCode) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($marketCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($marketCode) && mb_strlen($marketCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($marketCode)), __LINE__);
        }
        $this->MarketCode = $marketCode;
        return $this;
    }
    /**
     * Get AvailabilityStatus value
     * @return string|null
     */
    public function getAvailabilityStatus()
    {
        return $this->AvailabilityStatus;
    }
    /**
     * Set AvailabilityStatus value
     * @uses \EnumType\RateIndicatorType::valueIsValid()
     * @uses \EnumType\RateIndicatorType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $availabilityStatus
     * @return \StructType\RatePlanType
     */
    public function setAvailabilityStatus($availabilityStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RateIndicatorType::valueIsValid($availabilityStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RateIndicatorType', is_array($availabilityStatus) ? implode(', ', $availabilityStatus) : var_export($availabilityStatus, true), implode(', ', \EnumType\RateIndicatorType::getValidValues())), __LINE__);
        }
        $this->AvailabilityStatus = $availabilityStatus;
        return $this;
    }
    /**
     * Get ID_RequiredInd value
     * @return bool|null
     */
    public function getID_RequiredInd()
    {
        return $this->ID_RequiredInd;
    }
    /**
     * Set ID_RequiredInd value
     * @param bool $iD_RequiredInd
     * @return \StructType\RatePlanType
     */
    public function setID_RequiredInd($iD_RequiredInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($iD_RequiredInd) && !is_bool($iD_RequiredInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($iD_RequiredInd, true), gettype($iD_RequiredInd)), __LINE__);
        }
        $this->ID_RequiredInd = $iD_RequiredInd;
        return $this;
    }
    /**
     * Get PriceViewableInd value
     * @return bool|null
     */
    public function getPriceViewableInd()
    {
        return $this->PriceViewableInd;
    }
    /**
     * Set PriceViewableInd value
     * @param bool $priceViewableInd
     * @return \StructType\RatePlanType
     */
    public function setPriceViewableInd($priceViewableInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($priceViewableInd) && !is_bool($priceViewableInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($priceViewableInd, true), gettype($priceViewableInd)), __LINE__);
        }
        $this->PriceViewableInd = $priceViewableInd;
        return $this;
    }
    /**
     * Get QualificationType value
     * @return string|null
     */
    public function getQualificationType()
    {
        return $this->QualificationType;
    }
    /**
     * Set QualificationType value
     * @param string $qualificationType
     * @return \StructType\RatePlanType
     */
    public function setQualificationType($qualificationType = null)
    {
        // validation for constraint: string
        if (!is_null($qualificationType) && !is_string($qualificationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($qualificationType, true), gettype($qualificationType)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($qualificationType) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $qualificationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($qualificationType, true)), __LINE__);
        }
        $this->QualificationType = $qualificationType;
        return $this;
    }
    /**
     * Get AvailableQuantity value
     * @return int|null
     */
    public function getAvailableQuantity()
    {
        return $this->AvailableQuantity;
    }
    /**
     * Set AvailableQuantity value
     * @param int $availableQuantity
     * @return \StructType\RatePlanType
     */
    public function setAvailableQuantity($availableQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($availableQuantity) && !(is_int($availableQuantity) || ctype_digit($availableQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($availableQuantity, true), gettype($availableQuantity)), __LINE__);
        }
        $this->AvailableQuantity = $availableQuantity;
        return $this;
    }
    /**
     * Get PrepaidIndicator value
     * @return bool|null
     */
    public function getPrepaidIndicator()
    {
        return $this->PrepaidIndicator;
    }
    /**
     * Set PrepaidIndicator value
     * @param bool $prepaidIndicator
     * @return \StructType\RatePlanType
     */
    public function setPrepaidIndicator($prepaidIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($prepaidIndicator) && !is_bool($prepaidIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($prepaidIndicator, true), gettype($prepaidIndicator)), __LINE__);
        }
        $this->PrepaidIndicator = $prepaidIndicator;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\RatePlanType
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \StructType\RatePlanType
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expireDate, true), gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get ExpireDateExclusiveIndicator value
     * @return bool|null
     */
    public function getExpireDateExclusiveIndicator()
    {
        return $this->ExpireDateExclusiveIndicator;
    }
    /**
     * Set ExpireDateExclusiveIndicator value
     * @param bool $expireDateExclusiveIndicator
     * @return \StructType\RatePlanType
     */
    public function setExpireDateExclusiveIndicator($expireDateExclusiveIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($expireDateExclusiveIndicator) && !is_bool($expireDateExclusiveIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($expireDateExclusiveIndicator, true), gettype($expireDateExclusiveIndicator)), __LINE__);
        }
        $this->ExpireDateExclusiveIndicator = $expireDateExclusiveIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RatePlanType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
