<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RatePlanLiteType StructType
 * Meta information extracted from the WSDL
 * - documentation: Summary version of the RoomPlanType, initially created for the Travel Itinerary Message set.
 * @subpackage Structs
 */
class RatePlanLiteType extends AbstractStructBase
{
    /**
     * The Guarantee
     * Meta information extracted from the WSDL
     * - documentation: Guarantee information that applies to the rate plan. A maximum of 5 occurances are available for use depending on the context.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\GuaranteeType[]
     */
    public $Guarantee;
    /**
     * The RatePlanDescription
     * Meta information extracted from the WSDL
     * - documentation: Describes the rate plan.
     * - minOccurs: 0
     * @var \StructType\ParagraphType
     */
    public $RatePlanDescription;
    /**
     * The RatePlanCode
     * Meta information extracted from the WSDL
     * - documentation: The RatePlanCode assigned by the receiving system for the inventory item in response to a new rate plan notification. (Implementation Notes: This would only be returned when the notification is of type New and the sender is
     * translating RatePlanCode values. On subsequent transactions for this rate plan, the sender would populate the RatePlanCode attribute with this value returned by the receiver.) | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * @var string
     */
    public $RatePlanCode;
    /**
     * The RateIndicator
     * Meta information extracted from the WSDL
     * - documentation: Information pertaining to the availability of the rate plan.
     * - use: optional
     * @var string
     */
    public $RateIndicator;
    /**
     * The RatePlanType
     * Meta information extracted from the WSDL
     * - documentation: An enumerated type that allows the query to specify a rate category type, and provides major categories for comparison across brands. Refer to OpenTravel Code List Rate Plan Type (RPT). | Used for codes in the OpenTravel Code tables.
     * Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string
     */
    public $RatePlanType;
    /**
     * The RatePlanID
     * Meta information extracted from the WSDL
     * - documentation: A text field used to indicate a special ID code that is associated with the rate and is required in the reservation request in order to obtain the rate. Examples are Corporate ID and Promotion Code. | Used for Character Strings,
     * length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $RatePlanID;
    /**
     * The EffectiveDate
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * @var string
     */
    public $ExpireDate;
    /**
     * The ExpireDateExclusiveIndicator
     * @var bool
     */
    public $ExpireDateExclusiveIndicator;
    /**
     * Constructor method for RatePlanLiteType
     * @uses RatePlanLiteType::setGuarantee()
     * @uses RatePlanLiteType::setRatePlanDescription()
     * @uses RatePlanLiteType::setRatePlanCode()
     * @uses RatePlanLiteType::setRateIndicator()
     * @uses RatePlanLiteType::setRatePlanType()
     * @uses RatePlanLiteType::setRatePlanID()
     * @uses RatePlanLiteType::setEffectiveDate()
     * @uses RatePlanLiteType::setExpireDate()
     * @uses RatePlanLiteType::setExpireDateExclusiveIndicator()
     * @param \StructType\GuaranteeType[] $guarantee
     * @param \StructType\ParagraphType $ratePlanDescription
     * @param string $ratePlanCode
     * @param string $rateIndicator
     * @param string $ratePlanType
     * @param string $ratePlanID
     * @param string $effectiveDate
     * @param string $expireDate
     * @param bool $expireDateExclusiveIndicator
     */
    public function __construct(array $guarantee = array(), \StructType\ParagraphType $ratePlanDescription = null, $ratePlanCode = null, $rateIndicator = null, $ratePlanType = null, $ratePlanID = null, $effectiveDate = null, $expireDate = null, $expireDateExclusiveIndicator = null)
    {
        $this
            ->setGuarantee($guarantee)
            ->setRatePlanDescription($ratePlanDescription)
            ->setRatePlanCode($ratePlanCode)
            ->setRateIndicator($rateIndicator)
            ->setRatePlanType($ratePlanType)
            ->setRatePlanID($ratePlanID)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate)
            ->setExpireDateExclusiveIndicator($expireDateExclusiveIndicator);
    }
    /**
     * Get Guarantee value
     * @return \StructType\GuaranteeType[]|null
     */
    public function getGuarantee()
    {
        return $this->Guarantee;
    }
    /**
     * This method is responsible for validating the values passed to the setGuarantee method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGuarantee method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGuaranteeForArrayConstraintsFromSetGuarantee(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ratePlanLiteTypeGuaranteeItem) {
            // validation for constraint: itemType
            if (!$ratePlanLiteTypeGuaranteeItem instanceof \StructType\GuaranteeType) {
                $invalidValues[] = is_object($ratePlanLiteTypeGuaranteeItem) ? get_class($ratePlanLiteTypeGuaranteeItem) : sprintf('%s(%s)', gettype($ratePlanLiteTypeGuaranteeItem), var_export($ratePlanLiteTypeGuaranteeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Guarantee property can only contain items of type \StructType\GuaranteeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Guarantee value
     * @throws \InvalidArgumentException
     * @param \StructType\GuaranteeType[] $guarantee
     * @return \StructType\RatePlanLiteType
     */
    public function setGuarantee(array $guarantee = array())
    {
        // validation for constraint: array
        if ('' !== ($guaranteeArrayErrorMessage = self::validateGuaranteeForArrayConstraintsFromSetGuarantee($guarantee))) {
            throw new \InvalidArgumentException($guaranteeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($guarantee) && count($guarantee) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($guarantee)), __LINE__);
        }
        $this->Guarantee = $guarantee;
        return $this;
    }
    /**
     * Add item to Guarantee value
     * @throws \InvalidArgumentException
     * @param \StructType\GuaranteeType $item
     * @return \StructType\RatePlanLiteType
     */
    public function addToGuarantee(\StructType\GuaranteeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GuaranteeType) {
            throw new \InvalidArgumentException(sprintf('The Guarantee property can only contain items of type \StructType\GuaranteeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Guarantee) && count($this->Guarantee) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Guarantee)), __LINE__);
        }
        $this->Guarantee[] = $item;
        return $this;
    }
    /**
     * Get RatePlanDescription value
     * @return \StructType\ParagraphType|null
     */
    public function getRatePlanDescription()
    {
        return $this->RatePlanDescription;
    }
    /**
     * Set RatePlanDescription value
     * @param \StructType\ParagraphType $ratePlanDescription
     * @return \StructType\RatePlanLiteType
     */
    public function setRatePlanDescription(\StructType\ParagraphType $ratePlanDescription = null)
    {
        $this->RatePlanDescription = $ratePlanDescription;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\RatePlanLiteType
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCode, true), gettype($ratePlanCode)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($ratePlanCode) && mb_strlen($ratePlanCode) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($ratePlanCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($ratePlanCode) && mb_strlen($ratePlanCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Get RateIndicator value
     * @return string|null
     */
    public function getRateIndicator()
    {
        return $this->RateIndicator;
    }
    /**
     * Set RateIndicator value
     * @uses \EnumType\RateIndicatorType::valueIsValid()
     * @uses \EnumType\RateIndicatorType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rateIndicator
     * @return \StructType\RatePlanLiteType
     */
    public function setRateIndicator($rateIndicator = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RateIndicatorType::valueIsValid($rateIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RateIndicatorType', is_array($rateIndicator) ? implode(', ', $rateIndicator) : var_export($rateIndicator, true), implode(', ', \EnumType\RateIndicatorType::getValidValues())), __LINE__);
        }
        $this->RateIndicator = $rateIndicator;
        return $this;
    }
    /**
     * Get RatePlanType value
     * @return string|null
     */
    public function getRatePlanType()
    {
        return $this->RatePlanType;
    }
    /**
     * Set RatePlanType value
     * @param string $ratePlanType
     * @return \StructType\RatePlanLiteType
     */
    public function setRatePlanType($ratePlanType = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanType) && !is_string($ratePlanType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanType, true), gettype($ratePlanType)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($ratePlanType) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $ratePlanType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($ratePlanType, true)), __LINE__);
        }
        $this->RatePlanType = $ratePlanType;
        return $this;
    }
    /**
     * Get RatePlanID value
     * @return string|null
     */
    public function getRatePlanID()
    {
        return $this->RatePlanID;
    }
    /**
     * Set RatePlanID value
     * @param string $ratePlanID
     * @return \StructType\RatePlanLiteType
     */
    public function setRatePlanID($ratePlanID = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanID) && !is_string($ratePlanID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanID, true), gettype($ratePlanID)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ratePlanID) && mb_strlen($ratePlanID) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($ratePlanID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($ratePlanID) && mb_strlen($ratePlanID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($ratePlanID)), __LINE__);
        }
        $this->RatePlanID = $ratePlanID;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\RatePlanLiteType
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \StructType\RatePlanLiteType
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expireDate, true), gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get ExpireDateExclusiveIndicator value
     * @return bool|null
     */
    public function getExpireDateExclusiveIndicator()
    {
        return $this->ExpireDateExclusiveIndicator;
    }
    /**
     * Set ExpireDateExclusiveIndicator value
     * @param bool $expireDateExclusiveIndicator
     * @return \StructType\RatePlanLiteType
     */
    public function setExpireDateExclusiveIndicator($expireDateExclusiveIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($expireDateExclusiveIndicator) && !is_bool($expireDateExclusiveIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($expireDateExclusiveIndicator, true), gettype($expireDateExclusiveIndicator)), __LINE__);
        }
        $this->ExpireDateExclusiveIndicator = $expireDateExclusiveIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RatePlanLiteType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
