<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RatePlan StructType
 * Meta information extracted from the WSDL
 * - documentation: This indicates additional special services included in the rate plan (e.g. breakfast included). | This is a specific rate plan defined for a specific room type.
 * @subpackage Structs
 */
class RatePlan extends RateUploadType
{
    /**
     * The MarketCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\MarketCode[]
     */
    public $MarketCode;
    /**
     * The Commission
     * Meta information extracted from the WSDL
     * - documentation: Commission associated with the RatePlan. This can be a percentage or a flat amount.
     * - minOccurs: 0
     * @var \StructType\CommissionType
     */
    public $Commission;
    /**
     * The MethodInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\MethodInfo[]
     */
    public $MethodInfo;
    /**
     * The DaysOfWeeks
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DaysOfWeeks
     */
    public $DaysOfWeeks;
    /**
     * The RatePlanCode
     * Meta information extracted from the WSDL
     * - documentation: The RatePlanCode assigned for the inventory item. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $RatePlanCode;
    /**
     * The BookingCode
     * Meta information extracted from the WSDL
     * - documentation: This is used to indicate the code with which to book the item and is primarily used to exchange information with GDSs or other systems. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $BookingCode;
    /**
     * The UpgradeIndicator
     * Meta information extracted from the WSDL
     * - documentation: Indicator that signifies whether a room block rate plan is available for room type upgrade.
     * - use: optional
     * @var bool
     */
    public $UpgradeIndicator;
    /**
     * The PromotionCode
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $PromotionCode;
    /**
     * The PromotionVendorCode
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 8. | List of StringLength1to8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * @var string[]
     */
    public $PromotionVendorCode;
    /**
     * Constructor method for RatePlan
     * @uses RatePlan::setMarketCode()
     * @uses RatePlan::setCommission()
     * @uses RatePlan::setMethodInfo()
     * @uses RatePlan::setDaysOfWeeks()
     * @uses RatePlan::setRatePlanCode()
     * @uses RatePlan::setBookingCode()
     * @uses RatePlan::setUpgradeIndicator()
     * @uses RatePlan::setPromotionCode()
     * @uses RatePlan::setPromotionVendorCode()
     * @param \StructType\MarketCode[] $marketCode
     * @param \StructType\CommissionType $commission
     * @param \StructType\MethodInfo[] $methodInfo
     * @param \StructType\DaysOfWeeks $daysOfWeeks
     * @param string $ratePlanCode
     * @param string $bookingCode
     * @param bool $upgradeIndicator
     * @param string $promotionCode
     * @param string[] $promotionVendorCode
     */
    public function __construct(array $marketCode = array(), \StructType\CommissionType $commission = null, array $methodInfo = array(), \StructType\DaysOfWeeks $daysOfWeeks = null, $ratePlanCode = null, $bookingCode = null, $upgradeIndicator = null, $promotionCode = null, array $promotionVendorCode = array())
    {
        $this
            ->setMarketCode($marketCode)
            ->setCommission($commission)
            ->setMethodInfo($methodInfo)
            ->setDaysOfWeeks($daysOfWeeks)
            ->setRatePlanCode($ratePlanCode)
            ->setBookingCode($bookingCode)
            ->setUpgradeIndicator($upgradeIndicator)
            ->setPromotionCode($promotionCode)
            ->setPromotionVendorCode($promotionVendorCode);
    }
    /**
     * Get MarketCode value
     * @return \StructType\MarketCode[]|null
     */
    public function getMarketCode()
    {
        return $this->MarketCode;
    }
    /**
     * This method is responsible for validating the values passed to the setMarketCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMarketCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMarketCodeForArrayConstraintsFromSetMarketCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ratePlanMarketCodeItem) {
            // validation for constraint: itemType
            if (!$ratePlanMarketCodeItem instanceof \StructType\MarketCode) {
                $invalidValues[] = is_object($ratePlanMarketCodeItem) ? get_class($ratePlanMarketCodeItem) : sprintf('%s(%s)', gettype($ratePlanMarketCodeItem), var_export($ratePlanMarketCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MarketCode property can only contain items of type \StructType\MarketCode, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MarketCode value
     * @throws \InvalidArgumentException
     * @param \StructType\MarketCode[] $marketCode
     * @return \StructType\RatePlan
     */
    public function setMarketCode(array $marketCode = array())
    {
        // validation for constraint: array
        if ('' !== ($marketCodeArrayErrorMessage = self::validateMarketCodeForArrayConstraintsFromSetMarketCode($marketCode))) {
            throw new \InvalidArgumentException($marketCodeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($marketCode) && count($marketCode) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($marketCode)), __LINE__);
        }
        $this->MarketCode = $marketCode;
        return $this;
    }
    /**
     * Add item to MarketCode value
     * @throws \InvalidArgumentException
     * @param \StructType\MarketCode $item
     * @return \StructType\RatePlan
     */
    public function addToMarketCode(\StructType\MarketCode $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MarketCode) {
            throw new \InvalidArgumentException(sprintf('The MarketCode property can only contain items of type \StructType\MarketCode, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->MarketCode) && count($this->MarketCode) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->MarketCode)), __LINE__);
        }
        $this->MarketCode[] = $item;
        return $this;
    }
    /**
     * Get Commission value
     * @return \StructType\CommissionType|null
     */
    public function getCommission()
    {
        return $this->Commission;
    }
    /**
     * Set Commission value
     * @param \StructType\CommissionType $commission
     * @return \StructType\RatePlan
     */
    public function setCommission(\StructType\CommissionType $commission = null)
    {
        $this->Commission = $commission;
        return $this;
    }
    /**
     * Get MethodInfo value
     * @return \StructType\MethodInfo[]|null
     */
    public function getMethodInfo()
    {
        return $this->MethodInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setMethodInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMethodInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMethodInfoForArrayConstraintsFromSetMethodInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ratePlanMethodInfoItem) {
            // validation for constraint: itemType
            if (!$ratePlanMethodInfoItem instanceof \StructType\MethodInfo) {
                $invalidValues[] = is_object($ratePlanMethodInfoItem) ? get_class($ratePlanMethodInfoItem) : sprintf('%s(%s)', gettype($ratePlanMethodInfoItem), var_export($ratePlanMethodInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MethodInfo property can only contain items of type \StructType\MethodInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MethodInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\MethodInfo[] $methodInfo
     * @return \StructType\RatePlan
     */
    public function setMethodInfo(array $methodInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($methodInfoArrayErrorMessage = self::validateMethodInfoForArrayConstraintsFromSetMethodInfo($methodInfo))) {
            throw new \InvalidArgumentException($methodInfoArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($methodInfo) && count($methodInfo) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($methodInfo)), __LINE__);
        }
        $this->MethodInfo = $methodInfo;
        return $this;
    }
    /**
     * Add item to MethodInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\MethodInfo $item
     * @return \StructType\RatePlan
     */
    public function addToMethodInfo(\StructType\MethodInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MethodInfo) {
            throw new \InvalidArgumentException(sprintf('The MethodInfo property can only contain items of type \StructType\MethodInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->MethodInfo) && count($this->MethodInfo) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->MethodInfo)), __LINE__);
        }
        $this->MethodInfo[] = $item;
        return $this;
    }
    /**
     * Get DaysOfWeeks value
     * @return \StructType\DaysOfWeeks|null
     */
    public function getDaysOfWeeks()
    {
        return $this->DaysOfWeeks;
    }
    /**
     * Set DaysOfWeeks value
     * @param \StructType\DaysOfWeeks $daysOfWeeks
     * @return \StructType\RatePlan
     */
    public function setDaysOfWeeks(\StructType\DaysOfWeeks $daysOfWeeks = null)
    {
        $this->DaysOfWeeks = $daysOfWeeks;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\RatePlan
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCode, true), gettype($ratePlanCode)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($ratePlanCode) && mb_strlen($ratePlanCode) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($ratePlanCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($ratePlanCode) && mb_strlen($ratePlanCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Get BookingCode value
     * @return string|null
     */
    public function getBookingCode()
    {
        return $this->BookingCode;
    }
    /**
     * Set BookingCode value
     * @param string $bookingCode
     * @return \StructType\RatePlan
     */
    public function setBookingCode($bookingCode = null)
    {
        // validation for constraint: string
        if (!is_null($bookingCode) && !is_string($bookingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingCode, true), gettype($bookingCode)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($bookingCode) && mb_strlen($bookingCode) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($bookingCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($bookingCode) && mb_strlen($bookingCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($bookingCode)), __LINE__);
        }
        $this->BookingCode = $bookingCode;
        return $this;
    }
    /**
     * Get UpgradeIndicator value
     * @return bool|null
     */
    public function getUpgradeIndicator()
    {
        return $this->UpgradeIndicator;
    }
    /**
     * Set UpgradeIndicator value
     * @param bool $upgradeIndicator
     * @return \StructType\RatePlan
     */
    public function setUpgradeIndicator($upgradeIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($upgradeIndicator) && !is_bool($upgradeIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($upgradeIndicator, true), gettype($upgradeIndicator)), __LINE__);
        }
        $this->UpgradeIndicator = $upgradeIndicator;
        return $this;
    }
    /**
     * Get PromotionCode value
     * @return string|null
     */
    public function getPromotionCode()
    {
        return $this->PromotionCode;
    }
    /**
     * Set PromotionCode value
     * @param string $promotionCode
     * @return \StructType\RatePlan
     */
    public function setPromotionCode($promotionCode = null)
    {
        // validation for constraint: string
        if (!is_null($promotionCode) && !is_string($promotionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promotionCode, true), gettype($promotionCode)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($promotionCode) && mb_strlen($promotionCode) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($promotionCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($promotionCode) && mb_strlen($promotionCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($promotionCode)), __LINE__);
        }
        $this->PromotionCode = $promotionCode;
        return $this;
    }
    /**
     * Get PromotionVendorCode value
     * @return string[]|null
     */
    public function getPromotionVendorCode()
    {
        return $this->PromotionVendorCode;
    }
    /**
     * This method is responsible for validating the values passed to the setPromotionVendorCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPromotionVendorCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePromotionVendorCodeForArrayConstraintsFromSetPromotionVendorCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ratePlanPromotionVendorCodeItem) {
            // validation for constraint: itemType
            if (!is_string($ratePlanPromotionVendorCodeItem)) {
                $invalidValues[] = is_object($ratePlanPromotionVendorCodeItem) ? get_class($ratePlanPromotionVendorCodeItem) : sprintf('%s(%s)', gettype($ratePlanPromotionVendorCodeItem), var_export($ratePlanPromotionVendorCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PromotionVendorCode property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PromotionVendorCode value
     * @param string[] $promotionVendorCode
     * @return \StructType\RatePlan
     */
    public function setPromotionVendorCode(array $promotionVendorCode = array())
    {
        // validation for constraint: list
        if ('' !== ($promotionVendorCodeArrayErrorMessage = self::validatePromotionVendorCodeForArrayConstraintsFromSetPromotionVendorCode($promotionVendorCode))) {
            throw new \InvalidArgumentException($promotionVendorCodeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($promotionVendorCode) && mb_strlen($promotionVendorCode) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($promotionVendorCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($promotionVendorCode) && mb_strlen($promotionVendorCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($promotionVendorCode)), __LINE__);
        }
        $this->PromotionVendorCode = is_array($promotionVendorCode) ? implode(' ', $promotionVendorCode) : null;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RatePlan
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
