<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RateDistance StructType
 * Meta information extracted from the WSDL
 * - documentation: Information on the distance that a reserved vehicle may be driven as part of the standard rental charge. Such distance may be unlimited, or a quantity of miles or kilometers for a certain period of time. This may be repeated for
 * situations such as an 8 day rental that has 500 miles per week and 100 miles per additional day.
 * @subpackage Structs
 */
class RateDistance extends AbstractStructBase
{
    /**
     * The Unlimited
     * Meta information extracted from the WSDL
     * - documentation: When true there is no mileage/kilometer restriction.
     * - type: xs:boolean
     * - use: required
     * @var bool
     */
    public $Unlimited;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - documentation: Provides the number of miles/kilometers included, typically used when Unlimited is false.
     * - type: xs:nonNegativeInteger
     * - use: optional
     * @var int
     */
    public $Quantity;
    /**
     * The DistUnitName
     * Meta information extracted from the WSDL
     * - documentation: Provides the units in which distance is measured, when applied to the rental of a vehicle (i.e., miles or kilometers).
     * - type: DistanceUnitNameType
     * - use: optional
     * @var string
     */
    public $DistUnitName;
    /**
     * The VehiclePeriodUnitName
     * Meta information extracted from the WSDL
     * - documentation: Provides the period of time associated with the quantity and distance unit name (e.g. day).
     * - type: VehiclePeriodUnitNameType
     * - use: optional
     * @var string
     */
    public $VehiclePeriodUnitName;
    /**
     * Constructor method for RateDistance
     * @uses RateDistance::setUnlimited()
     * @uses RateDistance::setQuantity()
     * @uses RateDistance::setDistUnitName()
     * @uses RateDistance::setVehiclePeriodUnitName()
     * @param bool $unlimited
     * @param int $quantity
     * @param string $distUnitName
     * @param string $vehiclePeriodUnitName
     */
    public function __construct($unlimited = null, $quantity = null, $distUnitName = null, $vehiclePeriodUnitName = null)
    {
        $this
            ->setUnlimited($unlimited)
            ->setQuantity($quantity)
            ->setDistUnitName($distUnitName)
            ->setVehiclePeriodUnitName($vehiclePeriodUnitName);
    }
    /**
     * Get Unlimited value
     * @return bool
     */
    public function getUnlimited()
    {
        return $this->Unlimited;
    }
    /**
     * Set Unlimited value
     * @param bool $unlimited
     * @return \StructType\RateDistance
     */
    public function setUnlimited($unlimited = null)
    {
        // validation for constraint: boolean
        if (!is_null($unlimited) && !is_bool($unlimited)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($unlimited, true), gettype($unlimited)), __LINE__);
        }
        $this->Unlimited = $unlimited;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\RateDistance
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get DistUnitName value
     * @return string|null
     */
    public function getDistUnitName()
    {
        return $this->DistUnitName;
    }
    /**
     * Set DistUnitName value
     * @uses \EnumType\DistanceUnitNameType::valueIsValid()
     * @uses \EnumType\DistanceUnitNameType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $distUnitName
     * @return \StructType\RateDistance
     */
    public function setDistUnitName($distUnitName = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DistanceUnitNameType::valueIsValid($distUnitName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DistanceUnitNameType', is_array($distUnitName) ? implode(', ', $distUnitName) : var_export($distUnitName, true), implode(', ', \EnumType\DistanceUnitNameType::getValidValues())), __LINE__);
        }
        $this->DistUnitName = $distUnitName;
        return $this;
    }
    /**
     * Get VehiclePeriodUnitName value
     * @return string|null
     */
    public function getVehiclePeriodUnitName()
    {
        return $this->VehiclePeriodUnitName;
    }
    /**
     * Set VehiclePeriodUnitName value
     * @uses \EnumType\VehiclePeriodUnitNameType::valueIsValid()
     * @uses \EnumType\VehiclePeriodUnitNameType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vehiclePeriodUnitName
     * @return \StructType\RateDistance
     */
    public function setVehiclePeriodUnitName($vehiclePeriodUnitName = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VehiclePeriodUnitNameType::valueIsValid($vehiclePeriodUnitName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\VehiclePeriodUnitNameType', is_array($vehiclePeriodUnitName) ? implode(', ', $vehiclePeriodUnitName) : var_export($vehiclePeriodUnitName, true), implode(', ', \EnumType\VehiclePeriodUnitNameType::getValidValues())), __LINE__);
        }
        $this->VehiclePeriodUnitName = $vehiclePeriodUnitName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RateDistance
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
