<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Quantities StructType
 * Meta information extracted from the WSDL
 * - documentation: Max rollaways, number of beds.
 * @subpackage Structs
 */
class Quantities extends AbstractStructBase
{
    /**
     * The MaxRollaways
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $MaxRollaways;
    /**
     * The MaxCots
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $MaxCots;
    /**
     * The StandardNumBeds
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $StandardNumBeds;
    /**
     * The MaximumAdditionalGuests
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $MaximumAdditionalGuests;
    /**
     * The MaxBillableGuests
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $MaxBillableGuests;
    /**
     * The MinBillableGuests
     * Meta information extracted from the WSDL
     * - documentation: Indicates the minimum number of guests for which a room charge will be applied, even if there are fewer guests in the room.
     * - use: optional
     * @var int
     */
    public $MinBillableGuests;
    /**
     * Constructor method for Quantities
     * @uses Quantities::setMaxRollaways()
     * @uses Quantities::setMaxCots()
     * @uses Quantities::setStandardNumBeds()
     * @uses Quantities::setMaximumAdditionalGuests()
     * @uses Quantities::setMaxBillableGuests()
     * @uses Quantities::setMinBillableGuests()
     * @param int $maxRollaways
     * @param int $maxCots
     * @param int $standardNumBeds
     * @param int $maximumAdditionalGuests
     * @param int $maxBillableGuests
     * @param int $minBillableGuests
     */
    public function __construct($maxRollaways = null, $maxCots = null, $standardNumBeds = null, $maximumAdditionalGuests = null, $maxBillableGuests = null, $minBillableGuests = null)
    {
        $this
            ->setMaxRollaways($maxRollaways)
            ->setMaxCots($maxCots)
            ->setStandardNumBeds($standardNumBeds)
            ->setMaximumAdditionalGuests($maximumAdditionalGuests)
            ->setMaxBillableGuests($maxBillableGuests)
            ->setMinBillableGuests($minBillableGuests);
    }
    /**
     * Get MaxRollaways value
     * @return int|null
     */
    public function getMaxRollaways()
    {
        return $this->MaxRollaways;
    }
    /**
     * Set MaxRollaways value
     * @param int $maxRollaways
     * @return \StructType\Quantities
     */
    public function setMaxRollaways($maxRollaways = null)
    {
        // validation for constraint: int
        if (!is_null($maxRollaways) && !(is_int($maxRollaways) || ctype_digit($maxRollaways))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxRollaways, true), gettype($maxRollaways)), __LINE__);
        }
        $this->MaxRollaways = $maxRollaways;
        return $this;
    }
    /**
     * Get MaxCots value
     * @return int|null
     */
    public function getMaxCots()
    {
        return $this->MaxCots;
    }
    /**
     * Set MaxCots value
     * @param int $maxCots
     * @return \StructType\Quantities
     */
    public function setMaxCots($maxCots = null)
    {
        // validation for constraint: int
        if (!is_null($maxCots) && !(is_int($maxCots) || ctype_digit($maxCots))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxCots, true), gettype($maxCots)), __LINE__);
        }
        $this->MaxCots = $maxCots;
        return $this;
    }
    /**
     * Get StandardNumBeds value
     * @return int|null
     */
    public function getStandardNumBeds()
    {
        return $this->StandardNumBeds;
    }
    /**
     * Set StandardNumBeds value
     * @param int $standardNumBeds
     * @return \StructType\Quantities
     */
    public function setStandardNumBeds($standardNumBeds = null)
    {
        // validation for constraint: int
        if (!is_null($standardNumBeds) && !(is_int($standardNumBeds) || ctype_digit($standardNumBeds))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($standardNumBeds, true), gettype($standardNumBeds)), __LINE__);
        }
        $this->StandardNumBeds = $standardNumBeds;
        return $this;
    }
    /**
     * Get MaximumAdditionalGuests value
     * @return int|null
     */
    public function getMaximumAdditionalGuests()
    {
        return $this->MaximumAdditionalGuests;
    }
    /**
     * Set MaximumAdditionalGuests value
     * @param int $maximumAdditionalGuests
     * @return \StructType\Quantities
     */
    public function setMaximumAdditionalGuests($maximumAdditionalGuests = null)
    {
        // validation for constraint: int
        if (!is_null($maximumAdditionalGuests) && !(is_int($maximumAdditionalGuests) || ctype_digit($maximumAdditionalGuests))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maximumAdditionalGuests, true), gettype($maximumAdditionalGuests)), __LINE__);
        }
        $this->MaximumAdditionalGuests = $maximumAdditionalGuests;
        return $this;
    }
    /**
     * Get MaxBillableGuests value
     * @return int|null
     */
    public function getMaxBillableGuests()
    {
        return $this->MaxBillableGuests;
    }
    /**
     * Set MaxBillableGuests value
     * @param int $maxBillableGuests
     * @return \StructType\Quantities
     */
    public function setMaxBillableGuests($maxBillableGuests = null)
    {
        // validation for constraint: int
        if (!is_null($maxBillableGuests) && !(is_int($maxBillableGuests) || ctype_digit($maxBillableGuests))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxBillableGuests, true), gettype($maxBillableGuests)), __LINE__);
        }
        $this->MaxBillableGuests = $maxBillableGuests;
        return $this;
    }
    /**
     * Get MinBillableGuests value
     * @return int|null
     */
    public function getMinBillableGuests()
    {
        return $this->MinBillableGuests;
    }
    /**
     * Set MinBillableGuests value
     * @param int $minBillableGuests
     * @return \StructType\Quantities
     */
    public function setMinBillableGuests($minBillableGuests = null)
    {
        // validation for constraint: int
        if (!is_null($minBillableGuests) && !(is_int($minBillableGuests) || ctype_digit($minBillableGuests))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minBillableGuests, true), gettype($minBillableGuests)), __LINE__);
        }
        $this->MinBillableGuests = $minBillableGuests;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Quantities
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
