<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PropertyValueMatchType StructType
 * Meta information extracted from the WSDL
 * - documentation: A property that matches some or all of the search criteria.
 * @subpackage Structs
 */
class PropertyValueMatchType extends BasicPropertyInfoType
{
    /**
     * The SearchValueMatch
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchValueMatch[]
     */
    public $SearchValueMatch;
    /**
     * The Amenities
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Amenities
     */
    public $Amenities;
    /**
     * The RateRange
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RateRange
     */
    public $RateRange;
    /**
     * The MoreDataEchoToken
     * Meta information extracted from the WSDL
     * - documentation: The search response returns this attribute if there were additional items that could not fit within the response. The text value returned should be echoed in the subsequent request in "Criteria/Criterion@MoreDataEchoToken" to
     * indicate where to begin the next block of data. | Used for Character Strings, length 1 to 128.
     * - base: xs:string
     * - maxLength: 128
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $MoreDataEchoToken;
    /**
     * The SameCountryInd
     * Meta information extracted from the WSDL
     * - documentation: When true, this property is in the same country as the requested city's country. When false, indicates this country is not the same as the requested city's country.
     * - use: optional
     * @var bool
     */
    public $SameCountryInd;
    /**
     * The AvailabilityStatus
     * Meta information extracted from the WSDL
     * - documentation: The availability status of the property.
     * - use: optional
     * @var string
     */
    public $AvailabilityStatus;
    /**
     * Constructor method for PropertyValueMatchType
     * @uses PropertyValueMatchType::setSearchValueMatch()
     * @uses PropertyValueMatchType::setAmenities()
     * @uses PropertyValueMatchType::setRateRange()
     * @uses PropertyValueMatchType::setMoreDataEchoToken()
     * @uses PropertyValueMatchType::setSameCountryInd()
     * @uses PropertyValueMatchType::setAvailabilityStatus()
     * @param \StructType\SearchValueMatch[] $searchValueMatch
     * @param \StructType\Amenities $amenities
     * @param \StructType\RateRange $rateRange
     * @param string $moreDataEchoToken
     * @param bool $sameCountryInd
     * @param string $availabilityStatus
     */
    public function __construct(array $searchValueMatch = array(), \StructType\Amenities $amenities = null, \StructType\RateRange $rateRange = null, $moreDataEchoToken = null, $sameCountryInd = null, $availabilityStatus = null)
    {
        $this
            ->setSearchValueMatch($searchValueMatch)
            ->setAmenities($amenities)
            ->setRateRange($rateRange)
            ->setMoreDataEchoToken($moreDataEchoToken)
            ->setSameCountryInd($sameCountryInd)
            ->setAvailabilityStatus($availabilityStatus);
    }
    /**
     * Get SearchValueMatch value
     * @return \StructType\SearchValueMatch[]|null
     */
    public function getSearchValueMatch()
    {
        return $this->SearchValueMatch;
    }
    /**
     * This method is responsible for validating the values passed to the setSearchValueMatch method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSearchValueMatch method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSearchValueMatchForArrayConstraintsFromSetSearchValueMatch(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $propertyValueMatchTypeSearchValueMatchItem) {
            // validation for constraint: itemType
            if (!$propertyValueMatchTypeSearchValueMatchItem instanceof \StructType\SearchValueMatch) {
                $invalidValues[] = is_object($propertyValueMatchTypeSearchValueMatchItem) ? get_class($propertyValueMatchTypeSearchValueMatchItem) : sprintf('%s(%s)', gettype($propertyValueMatchTypeSearchValueMatchItem), var_export($propertyValueMatchTypeSearchValueMatchItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SearchValueMatch property can only contain items of type \StructType\SearchValueMatch, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SearchValueMatch value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchValueMatch[] $searchValueMatch
     * @return \StructType\PropertyValueMatchType
     */
    public function setSearchValueMatch(array $searchValueMatch = array())
    {
        // validation for constraint: array
        if ('' !== ($searchValueMatchArrayErrorMessage = self::validateSearchValueMatchForArrayConstraintsFromSetSearchValueMatch($searchValueMatch))) {
            throw new \InvalidArgumentException($searchValueMatchArrayErrorMessage, __LINE__);
        }
        $this->SearchValueMatch = $searchValueMatch;
        return $this;
    }
    /**
     * Add item to SearchValueMatch value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchValueMatch $item
     * @return \StructType\PropertyValueMatchType
     */
    public function addToSearchValueMatch(\StructType\SearchValueMatch $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchValueMatch) {
            throw new \InvalidArgumentException(sprintf('The SearchValueMatch property can only contain items of type \StructType\SearchValueMatch, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SearchValueMatch[] = $item;
        return $this;
    }
    /**
     * Get Amenities value
     * @return \StructType\Amenities|null
     */
    public function getAmenities()
    {
        return $this->Amenities;
    }
    /**
     * Set Amenities value
     * @param \StructType\Amenities $amenities
     * @return \StructType\PropertyValueMatchType
     */
    public function setAmenities(\StructType\Amenities $amenities = null)
    {
        $this->Amenities = $amenities;
        return $this;
    }
    /**
     * Get RateRange value
     * @return \StructType\RateRange|null
     */
    public function getRateRange()
    {
        return $this->RateRange;
    }
    /**
     * Set RateRange value
     * @param \StructType\RateRange $rateRange
     * @return \StructType\PropertyValueMatchType
     */
    public function setRateRange(\StructType\RateRange $rateRange = null)
    {
        $this->RateRange = $rateRange;
        return $this;
    }
    /**
     * Get MoreDataEchoToken value
     * @return string|null
     */
    public function getMoreDataEchoToken()
    {
        return $this->MoreDataEchoToken;
    }
    /**
     * Set MoreDataEchoToken value
     * @param string $moreDataEchoToken
     * @return \StructType\PropertyValueMatchType
     */
    public function setMoreDataEchoToken($moreDataEchoToken = null)
    {
        // validation for constraint: string
        if (!is_null($moreDataEchoToken) && !is_string($moreDataEchoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($moreDataEchoToken, true), gettype($moreDataEchoToken)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($moreDataEchoToken) && mb_strlen($moreDataEchoToken) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($moreDataEchoToken)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($moreDataEchoToken) && mb_strlen($moreDataEchoToken) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($moreDataEchoToken)), __LINE__);
        }
        $this->MoreDataEchoToken = $moreDataEchoToken;
        return $this;
    }
    /**
     * Get SameCountryInd value
     * @return bool|null
     */
    public function getSameCountryInd()
    {
        return $this->SameCountryInd;
    }
    /**
     * Set SameCountryInd value
     * @param bool $sameCountryInd
     * @return \StructType\PropertyValueMatchType
     */
    public function setSameCountryInd($sameCountryInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($sameCountryInd) && !is_bool($sameCountryInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sameCountryInd, true), gettype($sameCountryInd)), __LINE__);
        }
        $this->SameCountryInd = $sameCountryInd;
        return $this;
    }
    /**
     * Get AvailabilityStatus value
     * @return string|null
     */
    public function getAvailabilityStatus()
    {
        return $this->AvailabilityStatus;
    }
    /**
     * Set AvailabilityStatus value
     * @uses \EnumType\RateIndicatorType::valueIsValid()
     * @uses \EnumType\RateIndicatorType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $availabilityStatus
     * @return \StructType\PropertyValueMatchType
     */
    public function setAvailabilityStatus($availabilityStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RateIndicatorType::valueIsValid($availabilityStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RateIndicatorType', is_array($availabilityStatus) ? implode(', ', $availabilityStatus) : var_export($availabilityStatus, true), implode(', ', \EnumType\RateIndicatorType::getValidValues())), __LINE__);
        }
        $this->AvailabilityStatus = $availabilityStatus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PropertyValueMatchType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
