<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PropertyAmenityPrefType StructType
 * Meta information extracted from the WSDL
 * - documentation: Identifies the customer's level of preference for the hotel property amenity identified. | Indicates preferences for hotel property amenities. | Used for Character Strings, length 1 to 128.
 * - base: xs:string
 * - maxLength: 128
 * - minLength: 1
 * @subpackage Structs
 */
class PropertyAmenityPrefType extends AbstractStructBase
{
    /**
     * The _
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 128.
     * - base: xs:string
     * - maxLength: 128
     * - minLength: 1
     * @var string
     */
    public $_;
    /**
     * The PropertyAmenityType
     * Meta information extracted from the WSDL
     * - documentation: Identifies the amenities offered by the hotel. Refer to OpenTravel Code List Hotel Amenity Code (HAC). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * @var string
     */
    public $PropertyAmenityType;
    /**
     * The PreferLevel
     * @var string
     */
    public $PreferLevel;
    /**
     * Constructor method for PropertyAmenityPrefType
     * @uses PropertyAmenityPrefType::set_()
     * @uses PropertyAmenityPrefType::setPropertyAmenityType()
     * @uses PropertyAmenityPrefType::setPreferLevel()
     * @param string $_
     * @param string $propertyAmenityType
     * @param string $preferLevel
     */
    public function __construct($_ = null, $propertyAmenityType = null, $preferLevel = null)
    {
        $this
            ->set_($_)
            ->setPropertyAmenityType($propertyAmenityType)
            ->setPreferLevel($preferLevel);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\PropertyAmenityPrefType
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($_) && mb_strlen($_) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($_)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($_) && mb_strlen($_) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get PropertyAmenityType value
     * @return string|null
     */
    public function getPropertyAmenityType()
    {
        return $this->PropertyAmenityType;
    }
    /**
     * Set PropertyAmenityType value
     * @param string $propertyAmenityType
     * @return \StructType\PropertyAmenityPrefType
     */
    public function setPropertyAmenityType($propertyAmenityType = null)
    {
        // validation for constraint: string
        if (!is_null($propertyAmenityType) && !is_string($propertyAmenityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($propertyAmenityType, true), gettype($propertyAmenityType)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($propertyAmenityType) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $propertyAmenityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($propertyAmenityType, true)), __LINE__);
        }
        $this->PropertyAmenityType = $propertyAmenityType;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \EnumType\PreferLevelType::valueIsValid()
     * @uses \EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \StructType\PropertyAmenityPrefType
     */
    public function setPreferLevel($preferLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PreferLevelType', is_array($preferLevel) ? implode(', ', $preferLevel) : var_export($preferLevel, true), implode(', ', \EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PropertyAmenityPrefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
