<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProfileType StructType
 * Meta information extracted from the WSDL
 * - documentation: Creation date time, creator ID, last modification date time and last modifier ID. | Used to specify a profile type. | Used to indicate whether information can be shared. | Root element for profile content. | Profile types associated
 * with the viewership, i.e, the types of profiles allowed to view this information. Please refer the OpenTravel Code List PRT.
 * - type: OTA_CodeType
 * - use: optional
 * @subpackage Structs
 */
class ProfileType extends AbstractStructBase
{
    /**
     * The Accesses
     * Meta information extracted from the WSDL
     * - documentation: A collection of actions taken on a record.
     * - minOccurs: 0
     * @var \StructType\AccessesType
     */
    public $Accesses;
    /**
     * The Customer
     * Meta information extracted from the WSDL
     * - documentation: Detailed customer information for this profile.
     * - minOccurs: 0
     * @var \StructType\CustomerType
     */
    public $Customer;
    /**
     * The UserID
     * Meta information extracted from the WSDL
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \StructType\UserID[]
     */
    public $UserID;
    /**
     * The PrefCollections
     * Meta information extracted from the WSDL
     * - documentation: A collection of preference collections.
     * - minOccurs: 0
     * @var \StructType\PreferencesType
     */
    public $PrefCollections;
    /**
     * The CompanyInfo
     * Meta information extracted from the WSDL
     * - documentation: Company information related to the profile.
     * - minOccurs: 0
     * @var \StructType\CompanyInfoType
     */
    public $CompanyInfo;
    /**
     * The Affiliations
     * Meta information extracted from the WSDL
     * - documentation: Affiliation information related to the profile.
     * - minOccurs: 0
     * @var \StructType\AffiliationsType
     */
    public $Affiliations;
    /**
     * The Agreements
     * Meta information extracted from the WSDL
     * - documentation: Agreement information related to the profile.
     * - minOccurs: 0
     * @var \StructType\AgreementsType
     */
    public $Agreements;
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Comments
     */
    public $Comments;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var \StructType\TPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: This is a reference placeholder, used as an index for this guest in this reservation. | The Reference Place Holder (RPH) is an index code used to identify an instance in a collection of like items (e.g. used to assign individual
     * passengers or clients to particular itinerary items).
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - documentation: Status of the profile. Refer to OpenTravel Code List Profile Status Code (PST). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X. | List of OpenTravel Codes.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string[]
     */
    public $StatusCode;
    /**
     * The ShareAllSynchInd
     * @var string
     */
    public $ShareAllSynchInd;
    /**
     * The ShareAllMarketInd
     * @var string
     */
    public $ShareAllMarketInd;
    /**
     * The ProfileType
     * Meta information extracted from the WSDL
     * - documentation: Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * @var string
     */
    public $ProfileType;
    /**
     * The CreateDateTime
     * @var string
     */
    public $CreateDateTime;
    /**
     * The CreatorID
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $CreatorID;
    /**
     * The LastModifyDateTime
     * @var string
     */
    public $LastModifyDateTime;
    /**
     * The LastModifierID
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $LastModifierID;
    /**
     * The PurgeDate
     * @var string
     */
    public $PurgeDate;
    /**
     * Constructor method for ProfileType
     * @uses ProfileType::setAccesses()
     * @uses ProfileType::setCustomer()
     * @uses ProfileType::setUserID()
     * @uses ProfileType::setPrefCollections()
     * @uses ProfileType::setCompanyInfo()
     * @uses ProfileType::setAffiliations()
     * @uses ProfileType::setAgreements()
     * @uses ProfileType::setComments()
     * @uses ProfileType::setTPA_Extensions()
     * @uses ProfileType::setRPH()
     * @uses ProfileType::setStatusCode()
     * @uses ProfileType::setShareAllSynchInd()
     * @uses ProfileType::setShareAllMarketInd()
     * @uses ProfileType::setProfileType()
     * @uses ProfileType::setCreateDateTime()
     * @uses ProfileType::setCreatorID()
     * @uses ProfileType::setLastModifyDateTime()
     * @uses ProfileType::setLastModifierID()
     * @uses ProfileType::setPurgeDate()
     * @param \StructType\AccessesType $accesses
     * @param \StructType\CustomerType $customer
     * @param \StructType\UserID[] $userID
     * @param \StructType\PreferencesType $prefCollections
     * @param \StructType\CompanyInfoType $companyInfo
     * @param \StructType\AffiliationsType $affiliations
     * @param \StructType\AgreementsType $agreements
     * @param \StructType\Comments $comments
     * @param \StructType\TPA_ExtensionsType $tPA_Extensions
     * @param string $rPH
     * @param string[] $statusCode
     * @param string $shareAllSynchInd
     * @param string $shareAllMarketInd
     * @param string $profileType
     * @param string $createDateTime
     * @param string $creatorID
     * @param string $lastModifyDateTime
     * @param string $lastModifierID
     * @param string $purgeDate
     */
    public function __construct(\StructType\AccessesType $accesses = null, \StructType\CustomerType $customer = null, array $userID = array(), \StructType\PreferencesType $prefCollections = null, \StructType\CompanyInfoType $companyInfo = null, \StructType\AffiliationsType $affiliations = null, \StructType\AgreementsType $agreements = null, \StructType\Comments $comments = null, \StructType\TPA_ExtensionsType $tPA_Extensions = null, $rPH = null, array $statusCode = array(), $shareAllSynchInd = null, $shareAllMarketInd = null, $profileType = null, $createDateTime = null, $creatorID = null, $lastModifyDateTime = null, $lastModifierID = null, $purgeDate = null)
    {
        $this
            ->setAccesses($accesses)
            ->setCustomer($customer)
            ->setUserID($userID)
            ->setPrefCollections($prefCollections)
            ->setCompanyInfo($companyInfo)
            ->setAffiliations($affiliations)
            ->setAgreements($agreements)
            ->setComments($comments)
            ->setTPA_Extensions($tPA_Extensions)
            ->setRPH($rPH)
            ->setStatusCode($statusCode)
            ->setShareAllSynchInd($shareAllSynchInd)
            ->setShareAllMarketInd($shareAllMarketInd)
            ->setProfileType($profileType)
            ->setCreateDateTime($createDateTime)
            ->setCreatorID($creatorID)
            ->setLastModifyDateTime($lastModifyDateTime)
            ->setLastModifierID($lastModifierID)
            ->setPurgeDate($purgeDate);
    }
    /**
     * Get Accesses value
     * @return \StructType\AccessesType|null
     */
    public function getAccesses()
    {
        return $this->Accesses;
    }
    /**
     * Set Accesses value
     * @param \StructType\AccessesType $accesses
     * @return \StructType\ProfileType
     */
    public function setAccesses(\StructType\AccessesType $accesses = null)
    {
        $this->Accesses = $accesses;
        return $this;
    }
    /**
     * Get Customer value
     * @return \StructType\CustomerType|null
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \StructType\CustomerType $customer
     * @return \StructType\ProfileType
     */
    public function setCustomer(\StructType\CustomerType $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Get UserID value
     * @return \StructType\UserID[]|null
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * This method is responsible for validating the values passed to the setUserID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUserID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUserIDForArrayConstraintsFromSetUserID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $profileTypeUserIDItem) {
            // validation for constraint: itemType
            if (!$profileTypeUserIDItem instanceof \StructType\UserID) {
                $invalidValues[] = is_object($profileTypeUserIDItem) ? get_class($profileTypeUserIDItem) : sprintf('%s(%s)', gettype($profileTypeUserIDItem), var_export($profileTypeUserIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UserID property can only contain items of type \StructType\UserID, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UserID value
     * @throws \InvalidArgumentException
     * @param \StructType\UserID[] $userID
     * @return \StructType\ProfileType
     */
    public function setUserID(array $userID = array())
    {
        // validation for constraint: array
        if ('' !== ($userIDArrayErrorMessage = self::validateUserIDForArrayConstraintsFromSetUserID($userID))) {
            throw new \InvalidArgumentException($userIDArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($userID) && count($userID) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($userID)), __LINE__);
        }
        $this->UserID = $userID;
        return $this;
    }
    /**
     * Add item to UserID value
     * @throws \InvalidArgumentException
     * @param \StructType\UserID $item
     * @return \StructType\ProfileType
     */
    public function addToUserID(\StructType\UserID $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UserID) {
            throw new \InvalidArgumentException(sprintf('The UserID property can only contain items of type \StructType\UserID, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->UserID) && count($this->UserID) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->UserID)), __LINE__);
        }
        $this->UserID[] = $item;
        return $this;
    }
    /**
     * Get PrefCollections value
     * @return \StructType\PreferencesType|null
     */
    public function getPrefCollections()
    {
        return $this->PrefCollections;
    }
    /**
     * Set PrefCollections value
     * @param \StructType\PreferencesType $prefCollections
     * @return \StructType\ProfileType
     */
    public function setPrefCollections(\StructType\PreferencesType $prefCollections = null)
    {
        $this->PrefCollections = $prefCollections;
        return $this;
    }
    /**
     * Get CompanyInfo value
     * @return \StructType\CompanyInfoType|null
     */
    public function getCompanyInfo()
    {
        return $this->CompanyInfo;
    }
    /**
     * Set CompanyInfo value
     * @param \StructType\CompanyInfoType $companyInfo
     * @return \StructType\ProfileType
     */
    public function setCompanyInfo(\StructType\CompanyInfoType $companyInfo = null)
    {
        $this->CompanyInfo = $companyInfo;
        return $this;
    }
    /**
     * Get Affiliations value
     * @return \StructType\AffiliationsType|null
     */
    public function getAffiliations()
    {
        return $this->Affiliations;
    }
    /**
     * Set Affiliations value
     * @param \StructType\AffiliationsType $affiliations
     * @return \StructType\ProfileType
     */
    public function setAffiliations(\StructType\AffiliationsType $affiliations = null)
    {
        $this->Affiliations = $affiliations;
        return $this;
    }
    /**
     * Get Agreements value
     * @return \StructType\AgreementsType|null
     */
    public function getAgreements()
    {
        return $this->Agreements;
    }
    /**
     * Set Agreements value
     * @param \StructType\AgreementsType $agreements
     * @return \StructType\ProfileType
     */
    public function setAgreements(\StructType\AgreementsType $agreements = null)
    {
        $this->Agreements = $agreements;
        return $this;
    }
    /**
     * Get Comments value
     * @return \StructType\Comments|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param \StructType\Comments $comments
     * @return \StructType\ProfileType
     */
    public function setComments(\StructType\Comments $comments = null)
    {
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \StructType\TPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \StructType\TPA_ExtensionsType $tPA_Extensions
     * @return \StructType\ProfileType
     */
    public function setTPA_Extensions(\StructType\TPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\ProfileType
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($rPH) && !preg_match('/[0-9]{1,8}/', $rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($rPH, true)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return string[]|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * This method is responsible for validating the values passed to the setStatusCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStatusCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStatusCodeForArrayConstraintsFromSetStatusCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $profileTypeStatusCodeItem) {
            // validation for constraint: itemType
            if (!is_string($profileTypeStatusCodeItem)) {
                $invalidValues[] = is_object($profileTypeStatusCodeItem) ? get_class($profileTypeStatusCodeItem) : sprintf('%s(%s)', gettype($profileTypeStatusCodeItem), var_export($profileTypeStatusCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The StatusCode property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set StatusCode value
     * @param string[] $statusCode
     * @return \StructType\ProfileType
     */
    public function setStatusCode(array $statusCode = array())
    {
        // validation for constraint: list
        if ('' !== ($statusCodeArrayErrorMessage = self::validateStatusCodeForArrayConstraintsFromSetStatusCode($statusCode))) {
            throw new \InvalidArgumentException($statusCodeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($statusCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($statusCode, true)), __LINE__);
        }
        $this->StatusCode = is_array($statusCode) ? implode(' ', $statusCode) : null;
        return $this;
    }
    /**
     * Get ShareAllSynchInd value
     * @return string|null
     */
    public function getShareAllSynchInd()
    {
        return $this->ShareAllSynchInd;
    }
    /**
     * Set ShareAllSynchInd value
     * @uses \EnumType\YesNoType::valueIsValid()
     * @uses \EnumType\YesNoType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $shareAllSynchInd
     * @return \StructType\ProfileType
     */
    public function setShareAllSynchInd($shareAllSynchInd = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\YesNoType::valueIsValid($shareAllSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\YesNoType', is_array($shareAllSynchInd) ? implode(', ', $shareAllSynchInd) : var_export($shareAllSynchInd, true), implode(', ', \EnumType\YesNoType::getValidValues())), __LINE__);
        }
        $this->ShareAllSynchInd = $shareAllSynchInd;
        return $this;
    }
    /**
     * Get ShareAllMarketInd value
     * @return string|null
     */
    public function getShareAllMarketInd()
    {
        return $this->ShareAllMarketInd;
    }
    /**
     * Set ShareAllMarketInd value
     * @uses \EnumType\YesNoType::valueIsValid()
     * @uses \EnumType\YesNoType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $shareAllMarketInd
     * @return \StructType\ProfileType
     */
    public function setShareAllMarketInd($shareAllMarketInd = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\YesNoType::valueIsValid($shareAllMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\YesNoType', is_array($shareAllMarketInd) ? implode(', ', $shareAllMarketInd) : var_export($shareAllMarketInd, true), implode(', ', \EnumType\YesNoType::getValidValues())), __LINE__);
        }
        $this->ShareAllMarketInd = $shareAllMarketInd;
        return $this;
    }
    /**
     * Get ProfileType value
     * @return string|null
     */
    public function getProfileType()
    {
        return $this->ProfileType;
    }
    /**
     * Set ProfileType value
     * @param string $profileType
     * @return \StructType\ProfileType
     */
    public function setProfileType($profileType = null)
    {
        // validation for constraint: string
        if (!is_null($profileType) && !is_string($profileType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($profileType, true), gettype($profileType)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($profileType) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $profileType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($profileType, true)), __LINE__);
        }
        $this->ProfileType = $profileType;
        return $this;
    }
    /**
     * Get CreateDateTime value
     * @return string|null
     */
    public function getCreateDateTime()
    {
        return $this->CreateDateTime;
    }
    /**
     * Set CreateDateTime value
     * @param string $createDateTime
     * @return \StructType\ProfileType
     */
    public function setCreateDateTime($createDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($createDateTime) && !is_string($createDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDateTime, true), gettype($createDateTime)), __LINE__);
        }
        $this->CreateDateTime = $createDateTime;
        return $this;
    }
    /**
     * Get CreatorID value
     * @return string|null
     */
    public function getCreatorID()
    {
        return $this->CreatorID;
    }
    /**
     * Set CreatorID value
     * @param string $creatorID
     * @return \StructType\ProfileType
     */
    public function setCreatorID($creatorID = null)
    {
        // validation for constraint: string
        if (!is_null($creatorID) && !is_string($creatorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creatorID, true), gettype($creatorID)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($creatorID) && mb_strlen($creatorID) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($creatorID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($creatorID) && mb_strlen($creatorID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($creatorID)), __LINE__);
        }
        $this->CreatorID = $creatorID;
        return $this;
    }
    /**
     * Get LastModifyDateTime value
     * @return string|null
     */
    public function getLastModifyDateTime()
    {
        return $this->LastModifyDateTime;
    }
    /**
     * Set LastModifyDateTime value
     * @param string $lastModifyDateTime
     * @return \StructType\ProfileType
     */
    public function setLastModifyDateTime($lastModifyDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifyDateTime) && !is_string($lastModifyDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifyDateTime, true), gettype($lastModifyDateTime)), __LINE__);
        }
        $this->LastModifyDateTime = $lastModifyDateTime;
        return $this;
    }
    /**
     * Get LastModifierID value
     * @return string|null
     */
    public function getLastModifierID()
    {
        return $this->LastModifierID;
    }
    /**
     * Set LastModifierID value
     * @param string $lastModifierID
     * @return \StructType\ProfileType
     */
    public function setLastModifierID($lastModifierID = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifierID) && !is_string($lastModifierID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifierID, true), gettype($lastModifierID)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($lastModifierID) && mb_strlen($lastModifierID) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($lastModifierID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($lastModifierID) && mb_strlen($lastModifierID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($lastModifierID)), __LINE__);
        }
        $this->LastModifierID = $lastModifierID;
        return $this;
    }
    /**
     * Get PurgeDate value
     * @return string|null
     */
    public function getPurgeDate()
    {
        return $this->PurgeDate;
    }
    /**
     * Set PurgeDate value
     * @param string $purgeDate
     * @return \StructType\ProfileType
     */
    public function setPurgeDate($purgeDate = null)
    {
        // validation for constraint: string
        if (!is_null($purgeDate) && !is_string($purgeDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purgeDate, true), gettype($purgeDate)), __LINE__);
        }
        $this->PurgeDate = $purgeDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProfileType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
