<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Product StructType
 * Meta information extracted from the WSDL
 * - documentation: The amount related to the specific item (e.g., if the item being purchased is a gift certificate, and only one item is being purchased the full amount is applied to the gift certificate). | The details associated to a specific
 * product.
 * @subpackage Structs
 */
class Product extends AbstractStructBase
{
    /**
     * The ProductIssueDate
     * Meta information extracted from the WSDL
     * - documentation: The date or date and time that the product was issued. | A construct to validate either a date or a dateTime value.
     * - union: date | dateTime
     * - use: optional
     * @var string
     */
    public $ProductIssueDate;
    /**
     * The ProductID
     * Meta information extracted from the WSDL
     * - documentation: An identification number associated to the specific product. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $ProductID;
    /**
     * The ProductType
     * Meta information extracted from the WSDL
     * - documentation: Identifies the type of product being purchased. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $ProductType;
    /**
     * The ProductQuantity
     * Meta information extracted from the WSDL
     * - documentation: The number of the specific product being purchased.
     * - use: optional
     * @var int
     */
    public $ProductQuantity;
    /**
     * The ProductSerialNumber
     * Meta information extracted from the WSDL
     * - documentation: The serial number of the specific product. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $ProductSerialNumber;
    /**
     * The DiscountCode
     * Meta information extracted from the WSDL
     * - documentation: The discount code that applies to the specific product. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $DiscountCode;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Status;
    /**
     * The ListOfRecipientRPH
     * Meta information extracted from the WSDL
     * - documentation: The recipient(s) to whom the product pertains. | The Reference Place Holder (RPH) is an index code used to identify an instance in a collection of like items (e.g. used to assign individual passengers or clients to particular
     * itinerary items). | List of Reference Place Holders.
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string[]
     */
    public $ListOfRecipientRPH;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: A monetary amount. | Specifies an amount, max 3 decimals.
     * - base: xs:decimal
     * - fractionDigits: 3
     * - type: Money
     * - use: optional
     * @var float
     */
    public $Amount;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - documentation: The code specifying a monetary unit. Use ISO 4217, three alpha code. | Used for an Alpha String, length exactly 3.
     * - base: xs:string
     * - pattern: [a-zA-Z]{3}
     * - type: AlphaLength3
     * - use: optional
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DecimalPlaces
     * Meta information extracted from the WSDL
     * - documentation: Indicates the number of decimal places for a particular currency. This is equivalent to the ISO 4217 standard "minor unit". Typically used when the amount provided includes the minor unit of currency without a decimal point (e.g.,
     * USD 8500 needs DecimalPlaces="2" to represent $85).
     * - type: xs:nonNegativeInteger
     * - use: optional
     * @var int
     */
    public $DecimalPlaces;
    /**
     * Constructor method for Product
     * @uses Product::setProductIssueDate()
     * @uses Product::setProductID()
     * @uses Product::setProductType()
     * @uses Product::setProductQuantity()
     * @uses Product::setProductSerialNumber()
     * @uses Product::setDiscountCode()
     * @uses Product::setStatus()
     * @uses Product::setListOfRecipientRPH()
     * @uses Product::setAmount()
     * @uses Product::setCurrencyCode()
     * @uses Product::setDecimalPlaces()
     * @param string $productIssueDate
     * @param string $productID
     * @param string $productType
     * @param int $productQuantity
     * @param string $productSerialNumber
     * @param string $discountCode
     * @param string $status
     * @param string[] $listOfRecipientRPH
     * @param float $amount
     * @param string $currencyCode
     * @param int $decimalPlaces
     */
    public function __construct($productIssueDate = null, $productID = null, $productType = null, $productQuantity = null, $productSerialNumber = null, $discountCode = null, $status = null, array $listOfRecipientRPH = array(), $amount = null, $currencyCode = null, $decimalPlaces = null)
    {
        $this
            ->setProductIssueDate($productIssueDate)
            ->setProductID($productID)
            ->setProductType($productType)
            ->setProductQuantity($productQuantity)
            ->setProductSerialNumber($productSerialNumber)
            ->setDiscountCode($discountCode)
            ->setStatus($status)
            ->setListOfRecipientRPH($listOfRecipientRPH)
            ->setAmount($amount)
            ->setCurrencyCode($currencyCode)
            ->setDecimalPlaces($decimalPlaces);
    }
    /**
     * Get ProductIssueDate value
     * @return string|null
     */
    public function getProductIssueDate()
    {
        return $this->ProductIssueDate;
    }
    /**
     * This method is responsible for validating the value passed to the setProductIssueDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProductIssueDate method
     * This is a set of validation rules based on the union types associated to the property being set by the setProductIssueDate method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProductIssueDateForUnionConstraintsFromSetProductIssueDate($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set ProductIssueDate value
     * @param string $productIssueDate
     * @return \StructType\Product
     */
    public function setProductIssueDate($productIssueDate = null)
    {
        // validation for constraint: string
        if (!is_null($productIssueDate) && !is_string($productIssueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productIssueDate, true), gettype($productIssueDate)), __LINE__);
        }
        // validation for constraint: union(date, dateTime)
        if ('' !== ($productIssueDateUnionErrorMessage = self::validateProductIssueDateForUnionConstraintsFromSetProductIssueDate($productIssueDate))) {
            throw new \InvalidArgumentException($productIssueDateUnionErrorMessage, __LINE__);
        }
        $this->ProductIssueDate = $productIssueDate;
        return $this;
    }
    /**
     * Get ProductID value
     * @return string|null
     */
    public function getProductID()
    {
        return $this->ProductID;
    }
    /**
     * Set ProductID value
     * @param string $productID
     * @return \StructType\Product
     */
    public function setProductID($productID = null)
    {
        // validation for constraint: string
        if (!is_null($productID) && !is_string($productID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productID, true), gettype($productID)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($productID) && mb_strlen($productID) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($productID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($productID) && mb_strlen($productID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($productID)), __LINE__);
        }
        $this->ProductID = $productID;
        return $this;
    }
    /**
     * Get ProductType value
     * @return string|null
     */
    public function getProductType()
    {
        return $this->ProductType;
    }
    /**
     * Set ProductType value
     * @param string $productType
     * @return \StructType\Product
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: string
        if (!is_null($productType) && !is_string($productType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productType, true), gettype($productType)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($productType) && mb_strlen($productType) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($productType)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($productType) && mb_strlen($productType) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($productType)), __LINE__);
        }
        $this->ProductType = $productType;
        return $this;
    }
    /**
     * Get ProductQuantity value
     * @return int|null
     */
    public function getProductQuantity()
    {
        return $this->ProductQuantity;
    }
    /**
     * Set ProductQuantity value
     * @param int $productQuantity
     * @return \StructType\Product
     */
    public function setProductQuantity($productQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($productQuantity) && !(is_int($productQuantity) || ctype_digit($productQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productQuantity, true), gettype($productQuantity)), __LINE__);
        }
        $this->ProductQuantity = $productQuantity;
        return $this;
    }
    /**
     * Get ProductSerialNumber value
     * @return string|null
     */
    public function getProductSerialNumber()
    {
        return $this->ProductSerialNumber;
    }
    /**
     * Set ProductSerialNumber value
     * @param string $productSerialNumber
     * @return \StructType\Product
     */
    public function setProductSerialNumber($productSerialNumber = null)
    {
        // validation for constraint: string
        if (!is_null($productSerialNumber) && !is_string($productSerialNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productSerialNumber, true), gettype($productSerialNumber)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($productSerialNumber) && mb_strlen($productSerialNumber) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($productSerialNumber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($productSerialNumber) && mb_strlen($productSerialNumber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($productSerialNumber)), __LINE__);
        }
        $this->ProductSerialNumber = $productSerialNumber;
        return $this;
    }
    /**
     * Get DiscountCode value
     * @return string|null
     */
    public function getDiscountCode()
    {
        return $this->DiscountCode;
    }
    /**
     * Set DiscountCode value
     * @param string $discountCode
     * @return \StructType\Product
     */
    public function setDiscountCode($discountCode = null)
    {
        // validation for constraint: string
        if (!is_null($discountCode) && !is_string($discountCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discountCode, true), gettype($discountCode)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($discountCode) && mb_strlen($discountCode) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($discountCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($discountCode) && mb_strlen($discountCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($discountCode)), __LINE__);
        }
        $this->DiscountCode = $discountCode;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\Product
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get ListOfRecipientRPH value
     * @return string[]|null
     */
    public function getListOfRecipientRPH()
    {
        return $this->ListOfRecipientRPH;
    }
    /**
     * This method is responsible for validating the values passed to the setListOfRecipientRPH method
     * This method is willingly generated in order to preserve the one-line inline validation within the setListOfRecipientRPH method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateListOfRecipientRPHForArrayConstraintsFromSetListOfRecipientRPH(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productListOfRecipientRPHItem) {
            // validation for constraint: itemType
            if (!is_string($productListOfRecipientRPHItem)) {
                $invalidValues[] = is_object($productListOfRecipientRPHItem) ? get_class($productListOfRecipientRPHItem) : sprintf('%s(%s)', gettype($productListOfRecipientRPHItem), var_export($productListOfRecipientRPHItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ListOfRecipientRPH property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ListOfRecipientRPH value
     * @param string[] $listOfRecipientRPH
     * @return \StructType\Product
     */
    public function setListOfRecipientRPH(array $listOfRecipientRPH = array())
    {
        // validation for constraint: list
        if ('' !== ($listOfRecipientRPHArrayErrorMessage = self::validateListOfRecipientRPHForArrayConstraintsFromSetListOfRecipientRPH($listOfRecipientRPH))) {
            throw new \InvalidArgumentException($listOfRecipientRPHArrayErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($listOfRecipientRPH) && !preg_match('/[0-9]{1,8}/', $listOfRecipientRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($listOfRecipientRPH, true)), __LINE__);
        }
        $this->ListOfRecipientRPH = is_array($listOfRecipientRPH) ? implode(' ', $listOfRecipientRPH) : null;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\Product
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($amount) && mb_strlen(mb_substr($amount, mb_strpos($amount, '.') + 1)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($amount, true), mb_strlen(mb_substr($amount, mb_strpos($amount, '.') + 1))), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\Product
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z]{3})
        if (!is_null($currencyCode) && !preg_match('/[a-zA-Z]{3}/', $currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z]{3}', var_export($currencyCode, true)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get DecimalPlaces value
     * @return int|null
     */
    public function getDecimalPlaces()
    {
        return $this->DecimalPlaces;
    }
    /**
     * Set DecimalPlaces value
     * @param int $decimalPlaces
     * @return \StructType\Product
     */
    public function setDecimalPlaces($decimalPlaces = null)
    {
        // validation for constraint: int
        if (!is_null($decimalPlaces) && !(is_int($decimalPlaces) || ctype_digit($decimalPlaces))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($decimalPlaces, true), gettype($decimalPlaces)), __LINE__);
        }
        $this->DecimalPlaces = $decimalPlaces;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Product
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
