<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PricingIndicator StructType
 * Meta information extracted from the WSDL
 * - documentation: Specific information about the price.
 * @subpackage Structs
 */
class PricingIndicator extends AbstractStructBase
{
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - documentation: Used to specify the type of pricing information. References OpenTravel Code list Pricing Processing Code (PPC). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - type: OTA_CodeType
     * - use: required
     * @var string
     */
    public $Type;
    /**
     * The ExcludeInd
     * Meta information extracted from the WSDL
     * - documentation: When true the information in the type attribute should not be applied to the pricing.
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $ExcludeInd;
    /**
     * The Qualifier
     * Meta information extracted from the WSDL
     * - documentation: Used to give additional information on the pricing preference. Refer to OpenTravel Code List Pricing Qualification Code (PQC). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or
     * 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - type: OTA_CodeType
     * - use: optional
     * @var string
     */
    public $Qualifier;
    /**
     * Constructor method for PricingIndicator
     * @uses PricingIndicator::setType()
     * @uses PricingIndicator::setExcludeInd()
     * @uses PricingIndicator::setQualifier()
     * @param string $type
     * @param bool $excludeInd
     * @param string $qualifier
     */
    public function __construct($type = null, $excludeInd = null, $qualifier = null)
    {
        $this
            ->setType($type)
            ->setExcludeInd($excludeInd)
            ->setQualifier($qualifier);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\PricingIndicator
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($type) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($type, true)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get ExcludeInd value
     * @return bool|null
     */
    public function getExcludeInd()
    {
        return $this->ExcludeInd;
    }
    /**
     * Set ExcludeInd value
     * @param bool $excludeInd
     * @return \StructType\PricingIndicator
     */
    public function setExcludeInd($excludeInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($excludeInd) && !is_bool($excludeInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($excludeInd, true), gettype($excludeInd)), __LINE__);
        }
        $this->ExcludeInd = $excludeInd;
        return $this;
    }
    /**
     * Get Qualifier value
     * @return string|null
     */
    public function getQualifier()
    {
        return $this->Qualifier;
    }
    /**
     * Set Qualifier value
     * @param string $qualifier
     * @return \StructType\PricingIndicator
     */
    public function setQualifier($qualifier = null)
    {
        // validation for constraint: string
        if (!is_null($qualifier) && !is_string($qualifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($qualifier, true), gettype($qualifier)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($qualifier) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $qualifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($qualifier, true)), __LINE__);
        }
        $this->Qualifier = $qualifier;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PricingIndicator
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
