<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PricedItinerary StructType
 * Meta information extracted from the WSDL
 * - documentation: Itinerary with pricing information.
 * @subpackage Structs
 */
class PricedItinerary extends PricedItineraryType
{
    /**
     * The OriginDestinationRefNumber
     * Meta information extracted from the WSDL
     * - documentation: This attribute refers back to origin destination information in the OTA_AirLowFareSearchRQ message. | Used for Numeric values, from 1 to 99 inclusive.
     * - base: xs:integer
     * - maxInclusive: 99
     * - minInclusive: 1
     * - use: optional
     * @var int
     */
    public $OriginDestinationRefNumber;
    /**
     * Constructor method for PricedItinerary
     * @uses PricedItinerary::setOriginDestinationRefNumber()
     * @param int $originDestinationRefNumber
     */
    public function __construct($originDestinationRefNumber = null)
    {
        $this
            ->setOriginDestinationRefNumber($originDestinationRefNumber);
    }
    /**
     * Get OriginDestinationRefNumber value
     * @return int|null
     */
    public function getOriginDestinationRefNumber()
    {
        return $this->OriginDestinationRefNumber;
    }
    /**
     * Set OriginDestinationRefNumber value
     * @param int $originDestinationRefNumber
     * @return \StructType\PricedItinerary
     */
    public function setOriginDestinationRefNumber($originDestinationRefNumber = null)
    {
        // validation for constraint: int
        if (!is_null($originDestinationRefNumber) && !(is_int($originDestinationRefNumber) || ctype_digit($originDestinationRefNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($originDestinationRefNumber, true), gettype($originDestinationRefNumber)), __LINE__);
        }
        // validation for constraint: maxInclusive(99)
        if (!is_null($originDestinationRefNumber) && $originDestinationRefNumber > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99', var_export($originDestinationRefNumber, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($originDestinationRefNumber) && $originDestinationRefNumber < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($originDestinationRefNumber, true)), __LINE__);
        }
        $this->OriginDestinationRefNumber = $originDestinationRefNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PricedItinerary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
