<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PriceRequestInformationType StructType
 * Meta information extracted from the WSDL
 * - documentation: Used to describe a price request. | Identify pricing source, if negotiated fares are requested and if it is a reprice request.
 * @subpackage Structs
 */
class PriceRequestInformationType extends AbstractStructBase
{
    /**
     * The NegotiatedFareCode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NegotiatedFareCode[]
     */
    public $NegotiatedFareCode;
    /**
     * The RebookOption
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\RebookOption[]
     */
    public $RebookOption;
    /**
     * The CabinType
     * Meta information extracted from the WSDL
     * - documentation: Identifies the type of cabin (i.e., first, business, economy) requested.
     * - use: optional
     * @var string
     */
    public $CabinType;
    /**
     * The TicketingCountry
     * Meta information extracted from the WSDL
     * - documentation: The ISO country code where the ticket will be issued. | Specifies a 2 character country code as defined in ISO3166.
     * - base: xs:string
     * - pattern: [a-zA-Z]{2}
     * - use: optional
     * @var string
     */
    public $TicketingCountry;
    /**
     * The OverrideAirlineCode
     * Meta information extracted from the WSDL
     * - documentation: The airline which should be used to override the system selected pricing airline. | Used for Alpha-Numeric Strings, length 1 to 8.
     * - base: xs:string
     * - pattern: [0-9a-zA-Z]{1,8}
     * - use: optional
     * @var string
     */
    public $OverrideAirlineCode;
    /**
     * The FareQualifier
     * @var string
     */
    public $FareQualifier;
    /**
     * The NegotiatedFaresOnly
     * Meta information extracted from the WSDL
     * - documentation: Indicator to identify whether or not the price is applicable only to private fares.
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $NegotiatedFaresOnly;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - documentation: Type of funds preferred for reviewing monetary values, in ISO 4217 codes. | Used for an Alpha String, length exactly 3.
     * - base: xs:string
     * - pattern: [a-zA-Z]{3}
     * - type: AlphaLength3
     * - use: optional
     * @var string
     */
    public $CurrencyCode;
    /**
     * The PricingSource
     * Meta information extracted from the WSDL
     * - documentation: It can be used to indicate whether the fare is public or private.
     * - type: PricingSourceType
     * - use: optional
     * @var string
     */
    public $PricingSource;
    /**
     * The Reprice
     * Meta information extracted from the WSDL
     * - documentation: If true repricing is requested.
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $Reprice;
    /**
     * The ValidatingAirlineCode
     * Meta information extracted from the WSDL
     * - documentation: The code for the validating airline. | Used for Alpha-Numeric Strings, length 1 to 8.
     * - base: xs:string
     * - pattern: [0-9a-zA-Z]{1,8}
     * - type: AlphaNumericStringLength1to8
     * - use: optional
     * @var string
     */
    public $ValidatingAirlineCode;
    /**
     * The RequestedTicketingDate
     * Meta information extracted from the WSDL
     * - documentation: The date on which the customer requests the booking to be ticketed. | A construct to validate either a date or a dateTime value.
     * - type: DateOrDateTimeType
     * - union: date | dateTime
     * - use: optional
     * @var string
     */
    public $RequestedTicketingDate;
    /**
     * The SaleCountry
     * Meta information extracted from the WSDL
     * - documentation: The country in which the booking will be made (sold). | Specifies a 2 character country code as defined in ISO3166.
     * - base: xs:string
     * - pattern: [a-zA-Z]{2}
     * - type: ISO3166
     * - use: optional
     * @var string
     */
    public $SaleCountry;
    /**
     * Constructor method for PriceRequestInformationType
     * @uses PriceRequestInformationType::setNegotiatedFareCode()
     * @uses PriceRequestInformationType::setRebookOption()
     * @uses PriceRequestInformationType::setCabinType()
     * @uses PriceRequestInformationType::setTicketingCountry()
     * @uses PriceRequestInformationType::setOverrideAirlineCode()
     * @uses PriceRequestInformationType::setFareQualifier()
     * @uses PriceRequestInformationType::setNegotiatedFaresOnly()
     * @uses PriceRequestInformationType::setCurrencyCode()
     * @uses PriceRequestInformationType::setPricingSource()
     * @uses PriceRequestInformationType::setReprice()
     * @uses PriceRequestInformationType::setValidatingAirlineCode()
     * @uses PriceRequestInformationType::setRequestedTicketingDate()
     * @uses PriceRequestInformationType::setSaleCountry()
     * @param \StructType\NegotiatedFareCode[] $negotiatedFareCode
     * @param \StructType\RebookOption[] $rebookOption
     * @param string $cabinType
     * @param string $ticketingCountry
     * @param string $overrideAirlineCode
     * @param string $fareQualifier
     * @param bool $negotiatedFaresOnly
     * @param string $currencyCode
     * @param string $pricingSource
     * @param bool $reprice
     * @param string $validatingAirlineCode
     * @param string $requestedTicketingDate
     * @param string $saleCountry
     */
    public function __construct(array $negotiatedFareCode = array(), array $rebookOption = array(), $cabinType = null, $ticketingCountry = null, $overrideAirlineCode = null, $fareQualifier = null, $negotiatedFaresOnly = null, $currencyCode = null, $pricingSource = null, $reprice = null, $validatingAirlineCode = null, $requestedTicketingDate = null, $saleCountry = null)
    {
        $this
            ->setNegotiatedFareCode($negotiatedFareCode)
            ->setRebookOption($rebookOption)
            ->setCabinType($cabinType)
            ->setTicketingCountry($ticketingCountry)
            ->setOverrideAirlineCode($overrideAirlineCode)
            ->setFareQualifier($fareQualifier)
            ->setNegotiatedFaresOnly($negotiatedFaresOnly)
            ->setCurrencyCode($currencyCode)
            ->setPricingSource($pricingSource)
            ->setReprice($reprice)
            ->setValidatingAirlineCode($validatingAirlineCode)
            ->setRequestedTicketingDate($requestedTicketingDate)
            ->setSaleCountry($saleCountry);
    }
    /**
     * Get NegotiatedFareCode value
     * @return \StructType\NegotiatedFareCode[]|null
     */
    public function getNegotiatedFareCode()
    {
        return $this->NegotiatedFareCode;
    }
    /**
     * This method is responsible for validating the values passed to the setNegotiatedFareCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNegotiatedFareCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNegotiatedFareCodeForArrayConstraintsFromSetNegotiatedFareCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $priceRequestInformationTypeNegotiatedFareCodeItem) {
            // validation for constraint: itemType
            if (!$priceRequestInformationTypeNegotiatedFareCodeItem instanceof \StructType\NegotiatedFareCode) {
                $invalidValues[] = is_object($priceRequestInformationTypeNegotiatedFareCodeItem) ? get_class($priceRequestInformationTypeNegotiatedFareCodeItem) : sprintf('%s(%s)', gettype($priceRequestInformationTypeNegotiatedFareCodeItem), var_export($priceRequestInformationTypeNegotiatedFareCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The NegotiatedFareCode property can only contain items of type \StructType\NegotiatedFareCode, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set NegotiatedFareCode value
     * @throws \InvalidArgumentException
     * @param \StructType\NegotiatedFareCode[] $negotiatedFareCode
     * @return \StructType\PriceRequestInformationType
     */
    public function setNegotiatedFareCode(array $negotiatedFareCode = array())
    {
        // validation for constraint: array
        if ('' !== ($negotiatedFareCodeArrayErrorMessage = self::validateNegotiatedFareCodeForArrayConstraintsFromSetNegotiatedFareCode($negotiatedFareCode))) {
            throw new \InvalidArgumentException($negotiatedFareCodeArrayErrorMessage, __LINE__);
        }
        $this->NegotiatedFareCode = $negotiatedFareCode;
        return $this;
    }
    /**
     * Add item to NegotiatedFareCode value
     * @throws \InvalidArgumentException
     * @param \StructType\NegotiatedFareCode $item
     * @return \StructType\PriceRequestInformationType
     */
    public function addToNegotiatedFareCode(\StructType\NegotiatedFareCode $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NegotiatedFareCode) {
            throw new \InvalidArgumentException(sprintf('The NegotiatedFareCode property can only contain items of type \StructType\NegotiatedFareCode, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->NegotiatedFareCode[] = $item;
        return $this;
    }
    /**
     * Get RebookOption value
     * @return \StructType\RebookOption[]|null
     */
    public function getRebookOption()
    {
        return $this->RebookOption;
    }
    /**
     * This method is responsible for validating the values passed to the setRebookOption method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRebookOption method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRebookOptionForArrayConstraintsFromSetRebookOption(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $priceRequestInformationTypeRebookOptionItem) {
            // validation for constraint: itemType
            if (!$priceRequestInformationTypeRebookOptionItem instanceof \StructType\RebookOption) {
                $invalidValues[] = is_object($priceRequestInformationTypeRebookOptionItem) ? get_class($priceRequestInformationTypeRebookOptionItem) : sprintf('%s(%s)', gettype($priceRequestInformationTypeRebookOptionItem), var_export($priceRequestInformationTypeRebookOptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RebookOption property can only contain items of type \StructType\RebookOption, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RebookOption value
     * @throws \InvalidArgumentException
     * @param \StructType\RebookOption[] $rebookOption
     * @return \StructType\PriceRequestInformationType
     */
    public function setRebookOption(array $rebookOption = array())
    {
        // validation for constraint: array
        if ('' !== ($rebookOptionArrayErrorMessage = self::validateRebookOptionForArrayConstraintsFromSetRebookOption($rebookOption))) {
            throw new \InvalidArgumentException($rebookOptionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($rebookOption) && count($rebookOption) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($rebookOption)), __LINE__);
        }
        $this->RebookOption = $rebookOption;
        return $this;
    }
    /**
     * Add item to RebookOption value
     * @throws \InvalidArgumentException
     * @param \StructType\RebookOption $item
     * @return \StructType\PriceRequestInformationType
     */
    public function addToRebookOption(\StructType\RebookOption $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RebookOption) {
            throw new \InvalidArgumentException(sprintf('The RebookOption property can only contain items of type \StructType\RebookOption, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->RebookOption) && count($this->RebookOption) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->RebookOption)), __LINE__);
        }
        $this->RebookOption[] = $item;
        return $this;
    }
    /**
     * Get CabinType value
     * @return string|null
     */
    public function getCabinType()
    {
        return $this->CabinType;
    }
    /**
     * Set CabinType value
     * @uses \EnumType\CabinType::valueIsValid()
     * @uses \EnumType\CabinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cabinType
     * @return \StructType\PriceRequestInformationType
     */
    public function setCabinType($cabinType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CabinType::valueIsValid($cabinType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CabinType', is_array($cabinType) ? implode(', ', $cabinType) : var_export($cabinType, true), implode(', ', \EnumType\CabinType::getValidValues())), __LINE__);
        }
        $this->CabinType = $cabinType;
        return $this;
    }
    /**
     * Get TicketingCountry value
     * @return string|null
     */
    public function getTicketingCountry()
    {
        return $this->TicketingCountry;
    }
    /**
     * Set TicketingCountry value
     * @param string $ticketingCountry
     * @return \StructType\PriceRequestInformationType
     */
    public function setTicketingCountry($ticketingCountry = null)
    {
        // validation for constraint: string
        if (!is_null($ticketingCountry) && !is_string($ticketingCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketingCountry, true), gettype($ticketingCountry)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z]{2})
        if (!is_null($ticketingCountry) && !preg_match('/[a-zA-Z]{2}/', $ticketingCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z]{2}', var_export($ticketingCountry, true)), __LINE__);
        }
        $this->TicketingCountry = $ticketingCountry;
        return $this;
    }
    /**
     * Get OverrideAirlineCode value
     * @return string|null
     */
    public function getOverrideAirlineCode()
    {
        return $this->OverrideAirlineCode;
    }
    /**
     * Set OverrideAirlineCode value
     * @param string $overrideAirlineCode
     * @return \StructType\PriceRequestInformationType
     */
    public function setOverrideAirlineCode($overrideAirlineCode = null)
    {
        // validation for constraint: string
        if (!is_null($overrideAirlineCode) && !is_string($overrideAirlineCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($overrideAirlineCode, true), gettype($overrideAirlineCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-zA-Z]{1,8})
        if (!is_null($overrideAirlineCode) && !preg_match('/[0-9a-zA-Z]{1,8}/', $overrideAirlineCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-zA-Z]{1,8}', var_export($overrideAirlineCode, true)), __LINE__);
        }
        $this->OverrideAirlineCode = $overrideAirlineCode;
        return $this;
    }
    /**
     * Get FareQualifier value
     * @return string|null
     */
    public function getFareQualifier()
    {
        return $this->FareQualifier;
    }
    /**
     * Set FareQualifier value
     * @param string $fareQualifier
     * @return \StructType\PriceRequestInformationType
     */
    public function setFareQualifier($fareQualifier = null)
    {
        // validation for constraint: string
        if (!is_null($fareQualifier) && !is_string($fareQualifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareQualifier, true), gettype($fareQualifier)), __LINE__);
        }
        $this->FareQualifier = $fareQualifier;
        return $this;
    }
    /**
     * Get NegotiatedFaresOnly value
     * @return bool|null
     */
    public function getNegotiatedFaresOnly()
    {
        return $this->NegotiatedFaresOnly;
    }
    /**
     * Set NegotiatedFaresOnly value
     * @param bool $negotiatedFaresOnly
     * @return \StructType\PriceRequestInformationType
     */
    public function setNegotiatedFaresOnly($negotiatedFaresOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($negotiatedFaresOnly) && !is_bool($negotiatedFaresOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($negotiatedFaresOnly, true), gettype($negotiatedFaresOnly)), __LINE__);
        }
        $this->NegotiatedFaresOnly = $negotiatedFaresOnly;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\PriceRequestInformationType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z]{3})
        if (!is_null($currencyCode) && !preg_match('/[a-zA-Z]{3}/', $currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z]{3}', var_export($currencyCode, true)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get PricingSource value
     * @return string|null
     */
    public function getPricingSource()
    {
        return $this->PricingSource;
    }
    /**
     * Set PricingSource value
     * @uses \EnumType\PricingSourceType::valueIsValid()
     * @uses \EnumType\PricingSourceType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pricingSource
     * @return \StructType\PriceRequestInformationType
     */
    public function setPricingSource($pricingSource = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PricingSourceType::valueIsValid($pricingSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PricingSourceType', is_array($pricingSource) ? implode(', ', $pricingSource) : var_export($pricingSource, true), implode(', ', \EnumType\PricingSourceType::getValidValues())), __LINE__);
        }
        $this->PricingSource = $pricingSource;
        return $this;
    }
    /**
     * Get Reprice value
     * @return bool|null
     */
    public function getReprice()
    {
        return $this->Reprice;
    }
    /**
     * Set Reprice value
     * @param bool $reprice
     * @return \StructType\PriceRequestInformationType
     */
    public function setReprice($reprice = null)
    {
        // validation for constraint: boolean
        if (!is_null($reprice) && !is_bool($reprice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($reprice, true), gettype($reprice)), __LINE__);
        }
        $this->Reprice = $reprice;
        return $this;
    }
    /**
     * Get ValidatingAirlineCode value
     * @return string|null
     */
    public function getValidatingAirlineCode()
    {
        return $this->ValidatingAirlineCode;
    }
    /**
     * Set ValidatingAirlineCode value
     * @param string $validatingAirlineCode
     * @return \StructType\PriceRequestInformationType
     */
    public function setValidatingAirlineCode($validatingAirlineCode = null)
    {
        // validation for constraint: string
        if (!is_null($validatingAirlineCode) && !is_string($validatingAirlineCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validatingAirlineCode, true), gettype($validatingAirlineCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-zA-Z]{1,8})
        if (!is_null($validatingAirlineCode) && !preg_match('/[0-9a-zA-Z]{1,8}/', $validatingAirlineCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-zA-Z]{1,8}', var_export($validatingAirlineCode, true)), __LINE__);
        }
        $this->ValidatingAirlineCode = $validatingAirlineCode;
        return $this;
    }
    /**
     * Get RequestedTicketingDate value
     * @return string|null
     */
    public function getRequestedTicketingDate()
    {
        return $this->RequestedTicketingDate;
    }
    /**
     * This method is responsible for validating the value passed to the setRequestedTicketingDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequestedTicketingDate method
     * This is a set of validation rules based on the union types associated to the property being set by the setRequestedTicketingDate method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequestedTicketingDateForUnionConstraintsFromSetRequestedTicketingDate($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set RequestedTicketingDate value
     * @param string $requestedTicketingDate
     * @return \StructType\PriceRequestInformationType
     */
    public function setRequestedTicketingDate($requestedTicketingDate = null)
    {
        // validation for constraint: string
        if (!is_null($requestedTicketingDate) && !is_string($requestedTicketingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestedTicketingDate, true), gettype($requestedTicketingDate)), __LINE__);
        }
        // validation for constraint: union(date, dateTime)
        if ('' !== ($requestedTicketingDateUnionErrorMessage = self::validateRequestedTicketingDateForUnionConstraintsFromSetRequestedTicketingDate($requestedTicketingDate))) {
            throw new \InvalidArgumentException($requestedTicketingDateUnionErrorMessage, __LINE__);
        }
        $this->RequestedTicketingDate = $requestedTicketingDate;
        return $this;
    }
    /**
     * Get SaleCountry value
     * @return string|null
     */
    public function getSaleCountry()
    {
        return $this->SaleCountry;
    }
    /**
     * Set SaleCountry value
     * @param string $saleCountry
     * @return \StructType\PriceRequestInformationType
     */
    public function setSaleCountry($saleCountry = null)
    {
        // validation for constraint: string
        if (!is_null($saleCountry) && !is_string($saleCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleCountry, true), gettype($saleCountry)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z]{2})
        if (!is_null($saleCountry) && !preg_match('/[a-zA-Z]{2}/', $saleCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z]{2}', var_export($saleCountry, true)), __LINE__);
        }
        $this->SaleCountry = $saleCountry;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PriceRequestInformationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
