<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Position StructType
 * Meta information extracted from the WSDL
 * - documentation: Used to specify the geographic coordinates of the source of the request. | Specifies the latitude and longitude of a source. | The geographic coordinates for the search. | The Position element contains three attributes, Latitude,
 * Longitude, and Altitude, used to indicate the geographic location(s) requested by the search, expressed in notation specified by ISO standard 6709. It is likely that only the first two attributes, Latitude and Longitude, would be needed to define a
 * geographic area. | An element that identifies the geographic position of the hotel. The Position element uses the representation defined by ISO Standard 6709 to define a geographic point location.
 * @subpackage Structs
 */
class Position extends AbstractStructBase
{
    /**
     * The Latitude
     * Meta information extracted from the WSDL
     * - documentation: The measure of the angular distance on a meridian north or south of the equator. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - type: StringLength1to16
     * - use: optional
     * @var string
     */
    public $Latitude;
    /**
     * The Longitude
     * Meta information extracted from the WSDL
     * - documentation: The measure of the angular distance on a meridian east or west of the prime meridian. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - type: StringLength1to16
     * - use: optional
     * @var string
     */
    public $Longitude;
    /**
     * The Altitude
     * Meta information extracted from the WSDL
     * - documentation: The height of an item, typically above sea level. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - type: StringLength1to16
     * - use: optional
     * @var string
     */
    public $Altitude;
    /**
     * The AltitudeUnitOfMeasureCode
     * Meta information extracted from the WSDL
     * - documentation: Provides the unit of measure for the altitude (e.g., feet, meters, miles, kilometers). Refer to OpenTravel Code List Unit of Measure Code (UOM). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1,
     * 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - type: OTA_CodeType
     * - use: optional
     * @var string
     */
    public $AltitudeUnitOfMeasureCode;
    /**
     * The PositionAccuracy
     * Meta information extracted from the WSDL
     * - documentation: Indicates the accurancy of the property’s geo-coding, since the property’s longitude and latitude may not always be exact. Refer to OpenTravel Code List Position Accuracy Code (PAC). | Used for codes in the OpenTravel Code
     * tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - type: OTA_CodeType
     * - use: optional
     * @var string
     */
    public $PositionAccuracy;
    /**
     * The MapURL
     * Meta information extracted from the WSDL
     * - documentation: The URL of a map image.
     * - use: optional
     * @var string
     */
    public $MapURL;
    /**
     * Constructor method for Position
     * @uses Position::setLatitude()
     * @uses Position::setLongitude()
     * @uses Position::setAltitude()
     * @uses Position::setAltitudeUnitOfMeasureCode()
     * @uses Position::setPositionAccuracy()
     * @uses Position::setMapURL()
     * @param string $latitude
     * @param string $longitude
     * @param string $altitude
     * @param string $altitudeUnitOfMeasureCode
     * @param string $positionAccuracy
     * @param string $mapURL
     */
    public function __construct($latitude = null, $longitude = null, $altitude = null, $altitudeUnitOfMeasureCode = null, $positionAccuracy = null, $mapURL = null)
    {
        $this
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setAltitude($altitude)
            ->setAltitudeUnitOfMeasureCode($altitudeUnitOfMeasureCode)
            ->setPositionAccuracy($positionAccuracy)
            ->setMapURL($mapURL);
    }
    /**
     * Get Latitude value
     * @return string|null
     */
    public function getLatitude()
    {
        return $this->Latitude;
    }
    /**
     * Set Latitude value
     * @param string $latitude
     * @return \StructType\Position
     */
    public function setLatitude($latitude = null)
    {
        // validation for constraint: string
        if (!is_null($latitude) && !is_string($latitude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($latitude, true), gettype($latitude)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($latitude) && mb_strlen($latitude) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($latitude)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($latitude) && mb_strlen($latitude) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($latitude)), __LINE__);
        }
        $this->Latitude = $latitude;
        return $this;
    }
    /**
     * Get Longitude value
     * @return string|null
     */
    public function getLongitude()
    {
        return $this->Longitude;
    }
    /**
     * Set Longitude value
     * @param string $longitude
     * @return \StructType\Position
     */
    public function setLongitude($longitude = null)
    {
        // validation for constraint: string
        if (!is_null($longitude) && !is_string($longitude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($longitude, true), gettype($longitude)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($longitude) && mb_strlen($longitude) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($longitude)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($longitude) && mb_strlen($longitude) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($longitude)), __LINE__);
        }
        $this->Longitude = $longitude;
        return $this;
    }
    /**
     * Get Altitude value
     * @return string|null
     */
    public function getAltitude()
    {
        return $this->Altitude;
    }
    /**
     * Set Altitude value
     * @param string $altitude
     * @return \StructType\Position
     */
    public function setAltitude($altitude = null)
    {
        // validation for constraint: string
        if (!is_null($altitude) && !is_string($altitude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($altitude, true), gettype($altitude)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($altitude) && mb_strlen($altitude) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($altitude)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($altitude) && mb_strlen($altitude) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($altitude)), __LINE__);
        }
        $this->Altitude = $altitude;
        return $this;
    }
    /**
     * Get AltitudeUnitOfMeasureCode value
     * @return string|null
     */
    public function getAltitudeUnitOfMeasureCode()
    {
        return $this->AltitudeUnitOfMeasureCode;
    }
    /**
     * Set AltitudeUnitOfMeasureCode value
     * @param string $altitudeUnitOfMeasureCode
     * @return \StructType\Position
     */
    public function setAltitudeUnitOfMeasureCode($altitudeUnitOfMeasureCode = null)
    {
        // validation for constraint: string
        if (!is_null($altitudeUnitOfMeasureCode) && !is_string($altitudeUnitOfMeasureCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($altitudeUnitOfMeasureCode, true), gettype($altitudeUnitOfMeasureCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($altitudeUnitOfMeasureCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $altitudeUnitOfMeasureCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($altitudeUnitOfMeasureCode, true)), __LINE__);
        }
        $this->AltitudeUnitOfMeasureCode = $altitudeUnitOfMeasureCode;
        return $this;
    }
    /**
     * Get PositionAccuracy value
     * @return string|null
     */
    public function getPositionAccuracy()
    {
        return $this->PositionAccuracy;
    }
    /**
     * Set PositionAccuracy value
     * @param string $positionAccuracy
     * @return \StructType\Position
     */
    public function setPositionAccuracy($positionAccuracy = null)
    {
        // validation for constraint: string
        if (!is_null($positionAccuracy) && !is_string($positionAccuracy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($positionAccuracy, true), gettype($positionAccuracy)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($positionAccuracy) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $positionAccuracy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($positionAccuracy, true)), __LINE__);
        }
        $this->PositionAccuracy = $positionAccuracy;
        return $this;
    }
    /**
     * Get MapURL value
     * @return string|null
     */
    public function getMapURL()
    {
        return $this->MapURL;
    }
    /**
     * Set MapURL value
     * @param string $mapURL
     * @return \StructType\Position
     */
    public function setMapURL($mapURL = null)
    {
        // validation for constraint: string
        if (!is_null($mapURL) && !is_string($mapURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mapURL, true), gettype($mapURL)), __LINE__);
        }
        $this->MapURL = $mapURL;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Position
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
