<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PTC_FareBreakdowns StructType
 * Meta information extracted from the WSDL
 * - documentation: This is a collection of PTC Fare Breakdowns
 * @subpackage Structs
 */
class PTC_FareBreakdowns extends AbstractStructBase
{
    /**
     * The PTC_FareBreakdown
     * Meta information extracted from the WSDL
     * - documentation: Per passenger type code pricing for a travel itinerary.
     * - maxOccurs: 256
     * @var \StructType\PTCFareBreakdownType[]
     */
    public $PTC_FareBreakdown;
    /**
     * Constructor method for PTC_FareBreakdowns
     * @uses PTC_FareBreakdowns::setPTC_FareBreakdown()
     * @param \StructType\PTCFareBreakdownType[] $pTC_FareBreakdown
     */
    public function __construct(array $pTC_FareBreakdown = array())
    {
        $this
            ->setPTC_FareBreakdown($pTC_FareBreakdown);
    }
    /**
     * Get PTC_FareBreakdown value
     * @return \StructType\PTCFareBreakdownType[]|null
     */
    public function getPTC_FareBreakdown()
    {
        return $this->PTC_FareBreakdown;
    }
    /**
     * This method is responsible for validating the values passed to the setPTC_FareBreakdown method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPTC_FareBreakdown method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePTC_FareBreakdownForArrayConstraintsFromSetPTC_FareBreakdown(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pTC_FareBreakdownsPTC_FareBreakdownItem) {
            // validation for constraint: itemType
            if (!$pTC_FareBreakdownsPTC_FareBreakdownItem instanceof \StructType\PTCFareBreakdownType) {
                $invalidValues[] = is_object($pTC_FareBreakdownsPTC_FareBreakdownItem) ? get_class($pTC_FareBreakdownsPTC_FareBreakdownItem) : sprintf('%s(%s)', gettype($pTC_FareBreakdownsPTC_FareBreakdownItem), var_export($pTC_FareBreakdownsPTC_FareBreakdownItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PTC_FareBreakdown property can only contain items of type \StructType\PTCFareBreakdownType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PTC_FareBreakdown value
     * @throws \InvalidArgumentException
     * @param \StructType\PTCFareBreakdownType[] $pTC_FareBreakdown
     * @return \StructType\PTC_FareBreakdowns
     */
    public function setPTC_FareBreakdown(array $pTC_FareBreakdown = array())
    {
        // validation for constraint: array
        if ('' !== ($pTC_FareBreakdownArrayErrorMessage = self::validatePTC_FareBreakdownForArrayConstraintsFromSetPTC_FareBreakdown($pTC_FareBreakdown))) {
            throw new \InvalidArgumentException($pTC_FareBreakdownArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(256)
        if (is_array($pTC_FareBreakdown) && count($pTC_FareBreakdown) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 256', count($pTC_FareBreakdown)), __LINE__);
        }
        $this->PTC_FareBreakdown = $pTC_FareBreakdown;
        return $this;
    }
    /**
     * Add item to PTC_FareBreakdown value
     * @throws \InvalidArgumentException
     * @param \StructType\PTCFareBreakdownType $item
     * @return \StructType\PTC_FareBreakdowns
     */
    public function addToPTC_FareBreakdown(\StructType\PTCFareBreakdownType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PTCFareBreakdownType) {
            throw new \InvalidArgumentException(sprintf('The PTC_FareBreakdown property can only contain items of type \StructType\PTCFareBreakdownType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(256)
        if (is_array($this->PTC_FareBreakdown) && count($this->PTC_FareBreakdown) >= 256) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 256', count($this->PTC_FareBreakdown)), __LINE__);
        }
        $this->PTC_FareBreakdown[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PTC_FareBreakdowns
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
