<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for POS_Type StructType
 * Meta information extracted from the WSDL
 * - documentation: Point of Sale (POS) identifies the party or connection channel making the request.
 * @subpackage Structs
 */
class POS_Type extends AbstractStructBase
{
    /**
     * The Source
     * Meta information extracted from the WSDL
     * - documentation: This holds the details about the requestor. It may be repeated to also accommodate the delivery systems.
     * - maxOccurs: 10
     * @var \StructType\SourceType[]
     */
    public $Source;
    /**
     * Constructor method for POS_Type
     * @uses POS_Type::setSource()
     * @param \StructType\SourceType[] $source
     */
    public function __construct(array $source = array())
    {
        $this
            ->setSource($source);
    }
    /**
     * Get Source value
     * @return \StructType\SourceType[]|null
     */
    public function getSource()
    {
        return $this->Source;
    }
    /**
     * This method is responsible for validating the values passed to the setSource method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSource method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSourceForArrayConstraintsFromSetSource(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pOS_TypeSourceItem) {
            // validation for constraint: itemType
            if (!$pOS_TypeSourceItem instanceof \StructType\SourceType) {
                $invalidValues[] = is_object($pOS_TypeSourceItem) ? get_class($pOS_TypeSourceItem) : sprintf('%s(%s)', gettype($pOS_TypeSourceItem), var_export($pOS_TypeSourceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Source property can only contain items of type \StructType\SourceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Source value
     * @throws \InvalidArgumentException
     * @param \StructType\SourceType[] $source
     * @return \StructType\POS_Type
     */
    public function setSource(array $source = array())
    {
        // validation for constraint: array
        if ('' !== ($sourceArrayErrorMessage = self::validateSourceForArrayConstraintsFromSetSource($source))) {
            throw new \InvalidArgumentException($sourceArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($source) && count($source) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($source)), __LINE__);
        }
        $this->Source = $source;
        return $this;
    }
    /**
     * Add item to Source value
     * @throws \InvalidArgumentException
     * @param \StructType\SourceType $item
     * @return \StructType\POS_Type
     */
    public function addToSource(\StructType\SourceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SourceType) {
            throw new \InvalidArgumentException(sprintf('The Source property can only contain items of type \StructType\SourceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->Source) && count($this->Source) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->Source)), __LINE__);
        }
        $this->Source[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\POS_Type
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
