<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OriginDestinationOption StructType
 * Meta information extracted from the WSDL
 * - documentation: A container for OriginDestinationOptionType.
 * @subpackage Structs
 */
class OriginDestinationOption extends OriginDestinationOptionType
{
    /**
     * The RefNumber
     * Meta information extracted from the WSDL
     * - documentation: When a PricedItinerary element contains multiple solutions and a single price, this attribute identifies the OriginDestinationPair from the request. | Used for Numeric values, from 1 to 99 inclusive.
     * - base: xs:integer
     * - maxInclusive: 99
     * - minInclusive: 1
     * - use: optional
     * @var int
     */
    public $RefNumber;
    /**
     * Constructor method for OriginDestinationOption
     * @uses OriginDestinationOption::setRefNumber()
     * @param int $refNumber
     */
    public function __construct($refNumber = null)
    {
        $this
            ->setRefNumber($refNumber);
    }
    /**
     * Get RefNumber value
     * @return int|null
     */
    public function getRefNumber()
    {
        return $this->RefNumber;
    }
    /**
     * Set RefNumber value
     * @param int $refNumber
     * @return \StructType\OriginDestinationOption
     */
    public function setRefNumber($refNumber = null)
    {
        // validation for constraint: int
        if (!is_null($refNumber) && !(is_int($refNumber) || ctype_digit($refNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($refNumber, true), gettype($refNumber)), __LINE__);
        }
        // validation for constraint: maxInclusive(99)
        if (!is_null($refNumber) && $refNumber > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99', var_export($refNumber, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($refNumber) && $refNumber < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($refNumber, true)), __LINE__);
        }
        $this->RefNumber = $refNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OriginDestinationOption
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
