<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OperationSchedulesPlusChargeType StructType
 * Meta information extracted from the WSDL
 * - documentation: The OperationSchedule class defines the dates and hours of operation in addition the charges that may apply.
 * @subpackage Structs
 */
class OperationSchedulesPlusChargeType extends AbstractStructBase
{
    /**
     * The OperationSchedule
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OperationSchedule[]
     */
    public $OperationSchedule;
    /**
     * Constructor method for OperationSchedulesPlusChargeType
     * @uses OperationSchedulesPlusChargeType::setOperationSchedule()
     * @param \StructType\OperationSchedule[] $operationSchedule
     */
    public function __construct(array $operationSchedule = array())
    {
        $this
            ->setOperationSchedule($operationSchedule);
    }
    /**
     * Get OperationSchedule value
     * @return \StructType\OperationSchedule[]|null
     */
    public function getOperationSchedule()
    {
        return $this->OperationSchedule;
    }
    /**
     * This method is responsible for validating the values passed to the setOperationSchedule method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOperationSchedule method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOperationScheduleForArrayConstraintsFromSetOperationSchedule(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $operationSchedulesPlusChargeTypeOperationScheduleItem) {
            // validation for constraint: itemType
            if (!$operationSchedulesPlusChargeTypeOperationScheduleItem instanceof \StructType\OperationSchedule) {
                $invalidValues[] = is_object($operationSchedulesPlusChargeTypeOperationScheduleItem) ? get_class($operationSchedulesPlusChargeTypeOperationScheduleItem) : sprintf('%s(%s)', gettype($operationSchedulesPlusChargeTypeOperationScheduleItem), var_export($operationSchedulesPlusChargeTypeOperationScheduleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OperationSchedule property can only contain items of type \StructType\OperationSchedule, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OperationSchedule value
     * @throws \InvalidArgumentException
     * @param \StructType\OperationSchedule[] $operationSchedule
     * @return \StructType\OperationSchedulesPlusChargeType
     */
    public function setOperationSchedule(array $operationSchedule = array())
    {
        // validation for constraint: array
        if ('' !== ($operationScheduleArrayErrorMessage = self::validateOperationScheduleForArrayConstraintsFromSetOperationSchedule($operationSchedule))) {
            throw new \InvalidArgumentException($operationScheduleArrayErrorMessage, __LINE__);
        }
        $this->OperationSchedule = $operationSchedule;
        return $this;
    }
    /**
     * Add item to OperationSchedule value
     * @throws \InvalidArgumentException
     * @param \StructType\OperationSchedule $item
     * @return \StructType\OperationSchedulesPlusChargeType
     */
    public function addToOperationSchedule(\StructType\OperationSchedule $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OperationSchedule) {
            throw new \InvalidArgumentException(sprintf('The OperationSchedule property can only contain items of type \StructType\OperationSchedule, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OperationSchedule[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OperationSchedulesPlusChargeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
