<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OperatingAirlineType StructType
 * Meta information extracted from the WSDL
 * - documentation: Identifies the operating carrier and flight number.
 * @subpackage Structs
 */
class OperatingAirlineType extends CompanyNameType
{
    /**
     * The _
     * @var \StructType\CompanyNameType
     */
    public $_;
    /**
     * The FlightNumber
     * Meta information extracted from the WSDL
     * - documentation: The flight number as assigned by the operating carrier.
     * - use: optional
     * @var string
     */
    public $FlightNumber;
    /**
     * The ResBookDesigCode
     * Meta information extracted from the WSDL
     * - documentation: The reservation booking designator of the operating carrier when different from the marketing carrier. | Used for an Alpha String, length 1 to 2 (for letter codes).
     * - base: xs:string
     * - pattern: [A-Z]{1,2}
     * - use: optional
     * @var string
     */
    public $ResBookDesigCode;
    /**
     * Constructor method for OperatingAirlineType
     * @uses OperatingAirlineType::set_()
     * @uses OperatingAirlineType::setFlightNumber()
     * @uses OperatingAirlineType::setResBookDesigCode()
     * @param \StructType\CompanyNameType $_
     * @param string $flightNumber
     * @param string $resBookDesigCode
     */
    public function __construct(\StructType\CompanyNameType $_ = null, $flightNumber = null, $resBookDesigCode = null)
    {
        $this
            ->set_($_)
            ->setFlightNumber($flightNumber)
            ->setResBookDesigCode($resBookDesigCode);
    }
    /**
     * Get _ value
     * @return \StructType\CompanyNameType|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param \StructType\CompanyNameType $_
     * @return \StructType\OperatingAirlineType
     */
    public function set_(\StructType\CompanyNameType $_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get FlightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->FlightNumber;
    }
    /**
     * Set FlightNumber value
     * @uses \EnumType\FlightNumberType::valueIsValid()
     * @uses \EnumType\FlightNumberType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $flightNumber
     * @return \StructType\OperatingAirlineType
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FlightNumberType::valueIsValid($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\FlightNumberType', is_array($flightNumber) ? implode(', ', $flightNumber) : var_export($flightNumber, true), implode(', ', \EnumType\FlightNumberType::getValidValues())), __LINE__);
        }
        $this->FlightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get ResBookDesigCode value
     * @return string|null
     */
    public function getResBookDesigCode()
    {
        return $this->ResBookDesigCode;
    }
    /**
     * Set ResBookDesigCode value
     * @param string $resBookDesigCode
     * @return \StructType\OperatingAirlineType
     */
    public function setResBookDesigCode($resBookDesigCode = null)
    {
        // validation for constraint: string
        if (!is_null($resBookDesigCode) && !is_string($resBookDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resBookDesigCode, true), gettype($resBookDesigCode)), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{1,2})
        if (!is_null($resBookDesigCode) && !preg_match('/[A-Z]{1,2}/', $resBookDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{1,2}', var_export($resBookDesigCode, true)), __LINE__);
        }
        $this->ResBookDesigCode = $resBookDesigCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OperatingAirlineType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
