<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OneWayDropLocations StructType
 * Meta information extracted from the WSDL
 * - documentation: List of locations where one way drops are allowed based on pick-up location.
 * @subpackage Structs
 */
class OneWayDropLocations extends AbstractStructBase
{
    /**
     * The OneWayDropLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\OneWayDropLocation[]
     */
    public $OneWayDropLocation;
    /**
     * Constructor method for OneWayDropLocations
     * @uses OneWayDropLocations::setOneWayDropLocation()
     * @param \StructType\OneWayDropLocation[] $oneWayDropLocation
     */
    public function __construct(array $oneWayDropLocation = array())
    {
        $this
            ->setOneWayDropLocation($oneWayDropLocation);
    }
    /**
     * Get OneWayDropLocation value
     * @return \StructType\OneWayDropLocation[]|null
     */
    public function getOneWayDropLocation()
    {
        return $this->OneWayDropLocation;
    }
    /**
     * This method is responsible for validating the values passed to the setOneWayDropLocation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOneWayDropLocation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOneWayDropLocationForArrayConstraintsFromSetOneWayDropLocation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $oneWayDropLocationsOneWayDropLocationItem) {
            // validation for constraint: itemType
            if (!$oneWayDropLocationsOneWayDropLocationItem instanceof \StructType\OneWayDropLocation) {
                $invalidValues[] = is_object($oneWayDropLocationsOneWayDropLocationItem) ? get_class($oneWayDropLocationsOneWayDropLocationItem) : sprintf('%s(%s)', gettype($oneWayDropLocationsOneWayDropLocationItem), var_export($oneWayDropLocationsOneWayDropLocationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OneWayDropLocation property can only contain items of type \StructType\OneWayDropLocation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OneWayDropLocation value
     * @throws \InvalidArgumentException
     * @param \StructType\OneWayDropLocation[] $oneWayDropLocation
     * @return \StructType\OneWayDropLocations
     */
    public function setOneWayDropLocation(array $oneWayDropLocation = array())
    {
        // validation for constraint: array
        if ('' !== ($oneWayDropLocationArrayErrorMessage = self::validateOneWayDropLocationForArrayConstraintsFromSetOneWayDropLocation($oneWayDropLocation))) {
            throw new \InvalidArgumentException($oneWayDropLocationArrayErrorMessage, __LINE__);
        }
        $this->OneWayDropLocation = $oneWayDropLocation;
        return $this;
    }
    /**
     * Add item to OneWayDropLocation value
     * @throws \InvalidArgumentException
     * @param \StructType\OneWayDropLocation $item
     * @return \StructType\OneWayDropLocations
     */
    public function addToOneWayDropLocation(\StructType\OneWayDropLocation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OneWayDropLocation) {
            throw new \InvalidArgumentException(sprintf('The OneWayDropLocation property can only contain items of type \StructType\OneWayDropLocation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OneWayDropLocation[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OneWayDropLocations
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
