<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OneWayDropLocation StructType
 * Meta information extracted from the WSDL
 * - documentation: Location where a one way drop is allowed.
 * @subpackage Structs
 */
class OneWayDropLocation extends LocationType
{
    /**
     * The _
     * @var \StructType\LocationType
     */
    public $_;
    /**
     * The ExtendedLocationCode
     * Meta information extracted from the WSDL
     * - documentation: Used for extended OAG code in conjunction with the OAG code which is sent in Code. | Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $ExtendedLocationCode;
    /**
     * Constructor method for OneWayDropLocation
     * @uses OneWayDropLocation::set_()
     * @uses OneWayDropLocation::setExtendedLocationCode()
     * @param \StructType\LocationType $_
     * @param string $extendedLocationCode
     */
    public function __construct(\StructType\LocationType $_ = null, $extendedLocationCode = null)
    {
        $this
            ->set_($_)
            ->setExtendedLocationCode($extendedLocationCode);
    }
    /**
     * Get _ value
     * @return \StructType\LocationType|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param \StructType\LocationType $_
     * @return \StructType\OneWayDropLocation
     */
    public function set_(\StructType\LocationType $_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get ExtendedLocationCode value
     * @return string|null
     */
    public function getExtendedLocationCode()
    {
        return $this->ExtendedLocationCode;
    }
    /**
     * Set ExtendedLocationCode value
     * @param string $extendedLocationCode
     * @return \StructType\OneWayDropLocation
     */
    public function setExtendedLocationCode($extendedLocationCode = null)
    {
        // validation for constraint: string
        if (!is_null($extendedLocationCode) && !is_string($extendedLocationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedLocationCode, true), gettype($extendedLocationCode)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($extendedLocationCode) && mb_strlen($extendedLocationCode) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($extendedLocationCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($extendedLocationCode) && mb_strlen($extendedLocationCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($extendedLocationCode)), __LINE__);
        }
        $this->ExtendedLocationCode = $extendedLocationCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OneWayDropLocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
